/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to update the user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserPoolRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateUserPoolRequest.Builder, UpdateUserPoolRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UpdateUserPoolRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField
            .<UserPoolPolicyType> builder(MarshallingType.SDK_POJO).memberName("Policies")
            .getter(getter(UpdateUserPoolRequest::policies)).setter(setter(Builder::policies))
            .constructor(UserPoolPolicyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaConfigType> builder(MarshallingType.SDK_POJO).memberName("LambdaConfig")
            .getter(getter(UpdateUserPoolRequest::lambdaConfig)).setter(setter(Builder::lambdaConfig))
            .constructor(LambdaConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()).build();

    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoVerifiedAttributes")
            .getter(getter(UpdateUserPoolRequest::autoVerifiedAttributesAsStrings))
            .setter(setter(Builder::autoVerifiedAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsVerificationMessage").getter(getter(UpdateUserPoolRequest::smsVerificationMessage))
            .setter(setter(Builder::smsVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailVerificationMessage").getter(getter(UpdateUserPoolRequest::emailVerificationMessage))
            .setter(setter(Builder::emailVerificationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build())
            .build();

    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailVerificationSubject").getter(getter(UpdateUserPoolRequest::emailVerificationSubject))
            .setter(setter(Builder::emailVerificationSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build())
            .build();

    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField
            .<VerificationMessageTemplateType> builder(MarshallingType.SDK_POJO)
            .memberName("VerificationMessageTemplate")
            .getter(getter(UpdateUserPoolRequest::verificationMessageTemplate))
            .setter(setter(Builder::verificationMessageTemplate))
            .constructor(VerificationMessageTemplateType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate")
                    .build()).build();

    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsAuthenticationMessage").getter(getter(UpdateUserPoolRequest::smsAuthenticationMessage))
            .setter(setter(Builder::smsAuthenticationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build())
            .build();

    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MfaConfiguration").getter(getter(UpdateUserPoolRequest::mfaConfigurationAsString))
            .setter(setter(Builder::mfaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()).build();

    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField
            .<DeviceConfigurationType> builder(MarshallingType.SDK_POJO).memberName("DeviceConfiguration")
            .getter(getter(UpdateUserPoolRequest::deviceConfiguration)).setter(setter(Builder::deviceConfiguration))
            .constructor(DeviceConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build())
            .build();

    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField
            .<EmailConfigurationType> builder(MarshallingType.SDK_POJO).memberName("EmailConfiguration")
            .getter(getter(UpdateUserPoolRequest::emailConfiguration)).setter(setter(Builder::emailConfiguration))
            .constructor(EmailConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build())
            .build();

    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField
            .<SmsConfigurationType> builder(MarshallingType.SDK_POJO).memberName("SmsConfiguration")
            .getter(getter(UpdateUserPoolRequest::smsConfiguration)).setter(setter(Builder::smsConfiguration))
            .constructor(SmsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()).build();

    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserPoolTags")
            .getter(getter(UpdateUserPoolRequest::userPoolTags))
            .setter(setter(Builder::userPoolTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField
            .<AdminCreateUserConfigType> builder(MarshallingType.SDK_POJO).memberName("AdminCreateUserConfig")
            .getter(getter(UpdateUserPoolRequest::adminCreateUserConfig)).setter(setter(Builder::adminCreateUserConfig))
            .constructor(AdminCreateUserConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build())
            .build();

    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField
            .<UserPoolAddOnsType> builder(MarshallingType.SDK_POJO).memberName("UserPoolAddOns")
            .getter(getter(UpdateUserPoolRequest::userPoolAddOns)).setter(setter(Builder::userPoolAddOns))
            .constructor(UserPoolAddOnsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()).build();

    private static final SdkField<AccountRecoverySettingType> ACCOUNT_RECOVERY_SETTING_FIELD = SdkField
            .<AccountRecoverySettingType> builder(MarshallingType.SDK_POJO).memberName("AccountRecoverySetting")
            .getter(getter(UpdateUserPoolRequest::accountRecoverySetting)).setter(setter(Builder::accountRecoverySetting))
            .constructor(AccountRecoverySettingType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountRecoverySetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            POLICIES_FIELD, LAMBDA_CONFIG_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD, SMS_VERIFICATION_MESSAGE_FIELD,
            EMAIL_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_SUBJECT_FIELD, VERIFICATION_MESSAGE_TEMPLATE_FIELD,
            SMS_AUTHENTICATION_MESSAGE_FIELD, MFA_CONFIGURATION_FIELD, DEVICE_CONFIGURATION_FIELD, EMAIL_CONFIGURATION_FIELD,
            SMS_CONFIGURATION_FIELD, USER_POOL_TAGS_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, USER_POOL_ADD_ONS_FIELD,
            ACCOUNT_RECOVERY_SETTING_FIELD));

    private final String userPoolId;

    private final UserPoolPolicyType policies;

    private final LambdaConfigType lambdaConfig;

    private final List<String> autoVerifiedAttributes;

    private final String smsVerificationMessage;

    private final String emailVerificationMessage;

    private final String emailVerificationSubject;

    private final VerificationMessageTemplateType verificationMessageTemplate;

    private final String smsAuthenticationMessage;

    private final String mfaConfiguration;

    private final DeviceConfigurationType deviceConfiguration;

    private final EmailConfigurationType emailConfiguration;

    private final SmsConfigurationType smsConfiguration;

    private final Map<String, String> userPoolTags;

    private final AdminCreateUserConfigType adminCreateUserConfig;

    private final UserPoolAddOnsType userPoolAddOns;

    private final AccountRecoverySettingType accountRecoverySetting;

    private UpdateUserPoolRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.accountRecoverySetting = builder.accountRecoverySetting;
    }

    /**
     * <p>
     * The user pool ID for the user pool you want to update.
     * </p>
     * 
     * @return The user pool ID for the user pool you want to update.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A container with the policies you wish to update in a user pool.
     * </p>
     * 
     * @return A container with the policies you wish to update in a user pool.
     */
    public UserPoolPolicyType policies() {
        return policies;
    }

    /**
     * <p>
     * The AWS Lambda configuration information from the request to update the user pool.
     * </p>
     * 
     * @return The AWS Lambda configuration information from the request to update the user pool.
     */
    public LambdaConfigType lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
     * pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoVerifiedAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes that are automatically verified when the Amazon Cognito service makes a request to update
     *         user pools.
     */
    public List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(autoVerifiedAttributes);
    }

    /**
     * Returns true if the AutoVerifiedAttributes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoVerifiedAttributes() {
        return autoVerifiedAttributes != null && !(autoVerifiedAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
     * pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoVerifiedAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes that are automatically verified when the Amazon Cognito service makes a request to update
     *         user pools.
     */
    public List<String> autoVerifiedAttributesAsStrings() {
        return autoVerifiedAttributes;
    }

    /**
     * <p>
     * A container with information about the SMS verification message.
     * </p>
     * 
     * @return A container with information about the SMS verification message.
     */
    public String smsVerificationMessage() {
        return smsVerificationMessage;
    }

    /**
     * <p>
     * The contents of the email verification message.
     * </p>
     * 
     * @return The contents of the email verification message.
     */
    public String emailVerificationMessage() {
        return emailVerificationMessage;
    }

    /**
     * <p>
     * The subject of the email verification message.
     * </p>
     * 
     * @return The subject of the email verification message.
     */
    public String emailVerificationSubject() {
        return emailVerificationSubject;
    }

    /**
     * <p>
     * The template for verification messages.
     * </p>
     * 
     * @return The template for verification messages.
     */
    public VerificationMessageTemplateType verificationMessageTemplate() {
        return verificationMessageTemplate;
    }

    /**
     * <p>
     * The contents of the SMS authentication message.
     * </p>
     * 
     * @return The contents of the SMS authentication message.
     */
    public String smsAuthenticationMessage() {
        return smsAuthenticationMessage;
    }

    /**
     * <p>
     * Can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are
     * initially creating a user pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when
     *         you are initially creating a user pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(mfaConfiguration);
    }

    /**
     * <p>
     * Can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you are
     * initially creating a user pool.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaConfiguration}
     * will return {@link UserPoolMfaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mfaConfigurationAsString}.
     * </p>
     * 
     * @return Can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when
     *         you are initially creating a user pool.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
     *         </p>
     *         </li>
     * @see UserPoolMfaType
     */
    public String mfaConfigurationAsString() {
        return mfaConfiguration;
    }

    /**
     * <p>
     * Device configuration.
     * </p>
     * 
     * @return Device configuration.
     */
    public DeviceConfigurationType deviceConfiguration() {
        return deviceConfiguration;
    }

    /**
     * <p>
     * Email configuration.
     * </p>
     * 
     * @return Email configuration.
     */
    public EmailConfigurationType emailConfiguration() {
        return emailConfiguration;
    }

    /**
     * <p>
     * SMS configuration.
     * </p>
     * 
     * @return SMS configuration.
     */
    public SmsConfigurationType smsConfiguration() {
        return smsConfiguration;
    }

    /**
     * Returns true if the UserPoolTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserPoolTags() {
        return userPoolTags != null && !(userPoolTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserPoolTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
     *         manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    public Map<String, String> userPoolTags() {
        return userPoolTags;
    }

    /**
     * <p>
     * The configuration for <code>AdminCreateUser</code> requests.
     * </p>
     * 
     * @return The configuration for <code>AdminCreateUser</code> requests.
     */
    public AdminCreateUserConfigType adminCreateUserConfig() {
        return adminCreateUserConfig;
    }

    /**
     * <p>
     * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
     * "AUDIT".
     * </p>
     * 
     * @return Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the
     *         value "AUDIT".
     */
    public UserPoolAddOnsType userPoolAddOns() {
        return userPoolAddOns;
    }

    /**
     * <p>
     * Use this setting to define which verified available method a user can use to recover their password when they
     * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one method
     * available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has
     * SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery
     * method where SMS is preferred over email.
     * </p>
     * 
     * @return Use this setting to define which verified available method a user can use to recover their password when
     *         they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more
     *         than one method available. With this setting, SMS does not qualify for a valid password recovery
     *         mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy
     *         behavior to determine the recovery method where SMS is preferred over email.
     */
    public AccountRecoverySettingType accountRecoverySetting() {
        return accountRecoverySetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoVerifiedAttributes() ? autoVerifiedAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserPoolTags() ? userPoolTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(accountRecoverySetting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolRequest)) {
            return false;
        }
        UpdateUserPoolRequest other = (UpdateUserPoolRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(policies(), other.policies())
                && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && hasAutoVerifiedAttributes() == other.hasAutoVerifiedAttributes()
                && Objects.equals(autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings())
                && Objects.equals(smsVerificationMessage(), other.smsVerificationMessage())
                && Objects.equals(emailVerificationMessage(), other.emailVerificationMessage())
                && Objects.equals(emailVerificationSubject(), other.emailVerificationSubject())
                && Objects.equals(verificationMessageTemplate(), other.verificationMessageTemplate())
                && Objects.equals(smsAuthenticationMessage(), other.smsAuthenticationMessage())
                && Objects.equals(mfaConfigurationAsString(), other.mfaConfigurationAsString())
                && Objects.equals(deviceConfiguration(), other.deviceConfiguration())
                && Objects.equals(emailConfiguration(), other.emailConfiguration())
                && Objects.equals(smsConfiguration(), other.smsConfiguration()) && hasUserPoolTags() == other.hasUserPoolTags()
                && Objects.equals(userPoolTags(), other.userPoolTags())
                && Objects.equals(adminCreateUserConfig(), other.adminCreateUserConfig())
                && Objects.equals(userPoolAddOns(), other.userPoolAddOns())
                && Objects.equals(accountRecoverySetting(), other.accountRecoverySetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserPoolRequest").add("UserPoolId", userPoolId()).add("Policies", policies())
                .add("LambdaConfig", lambdaConfig())
                .add("AutoVerifiedAttributes", hasAutoVerifiedAttributes() ? autoVerifiedAttributesAsStrings() : null)
                .add("SmsVerificationMessage", smsVerificationMessage())
                .add("EmailVerificationMessage", emailVerificationMessage())
                .add("EmailVerificationSubject", emailVerificationSubject())
                .add("VerificationMessageTemplate", verificationMessageTemplate())
                .add("SmsAuthenticationMessage", smsAuthenticationMessage()).add("MfaConfiguration", mfaConfigurationAsString())
                .add("DeviceConfiguration", deviceConfiguration()).add("EmailConfiguration", emailConfiguration())
                .add("SmsConfiguration", smsConfiguration()).add("UserPoolTags", hasUserPoolTags() ? userPoolTags() : null)
                .add("AdminCreateUserConfig", adminCreateUserConfig()).add("UserPoolAddOns", userPoolAddOns())
                .add("AccountRecoverySetting", accountRecoverySetting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "LambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "AutoVerifiedAttributes":
            return Optional.ofNullable(clazz.cast(autoVerifiedAttributesAsStrings()));
        case "SmsVerificationMessage":
            return Optional.ofNullable(clazz.cast(smsVerificationMessage()));
        case "EmailVerificationMessage":
            return Optional.ofNullable(clazz.cast(emailVerificationMessage()));
        case "EmailVerificationSubject":
            return Optional.ofNullable(clazz.cast(emailVerificationSubject()));
        case "VerificationMessageTemplate":
            return Optional.ofNullable(clazz.cast(verificationMessageTemplate()));
        case "SmsAuthenticationMessage":
            return Optional.ofNullable(clazz.cast(smsAuthenticationMessage()));
        case "MfaConfiguration":
            return Optional.ofNullable(clazz.cast(mfaConfigurationAsString()));
        case "DeviceConfiguration":
            return Optional.ofNullable(clazz.cast(deviceConfiguration()));
        case "EmailConfiguration":
            return Optional.ofNullable(clazz.cast(emailConfiguration()));
        case "SmsConfiguration":
            return Optional.ofNullable(clazz.cast(smsConfiguration()));
        case "UserPoolTags":
            return Optional.ofNullable(clazz.cast(userPoolTags()));
        case "AdminCreateUserConfig":
            return Optional.ofNullable(clazz.cast(adminCreateUserConfig()));
        case "UserPoolAddOns":
            return Optional.ofNullable(clazz.cast(userPoolAddOns()));
        case "AccountRecoverySetting":
            return Optional.ofNullable(clazz.cast(accountRecoverySetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserPoolRequest, T> g) {
        return obj -> g.apply((UpdateUserPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserPoolRequest> {
        /**
         * <p>
         * The user pool ID for the user pool you want to update.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A container with the policies you wish to update in a user pool.
         * </p>
         * 
         * @param policies
         *        A container with the policies you wish to update in a user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(UserPoolPolicyType policies);

        /**
         * <p>
         * A container with the policies you wish to update in a user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolPolicyType.Builder} avoiding the need to
         * create one manually via {@link UserPoolPolicyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolPolicyType.Builder#build()} is called immediately and its
         * result is passed to {@link #policies(UserPoolPolicyType)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link UserPoolPolicyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(UserPoolPolicyType)
         */
        default Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return policies(UserPoolPolicyType.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * The AWS Lambda configuration information from the request to update the user pool.
         * </p>
         * 
         * @param lambdaConfig
         *        The AWS Lambda configuration information from the request to update the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaConfigType lambdaConfig);

        /**
         * <p>
         * The AWS Lambda configuration information from the request to update the user pool.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaConfigType.Builder} avoiding the need to
         * create one manually via {@link LambdaConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConfigType.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaConfig(LambdaConfigType)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaConfigType)
         */
        default Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return lambdaConfig(LambdaConfigType.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
         * pools.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that are automatically verified when the Amazon Cognito service makes a request to
         *        update user pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
         * pools.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that are automatically verified when the Amazon Cognito service makes a request to
         *        update user pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
         * pools.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that are automatically verified when the Amazon Cognito service makes a request to
         *        update user pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes);

        /**
         * <p>
         * The attributes that are automatically verified when the Amazon Cognito service makes a request to update user
         * pools.
         * </p>
         * 
         * @param autoVerifiedAttributes
         *        The attributes that are automatically verified when the Amazon Cognito service makes a request to
         *        update user pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes);

        /**
         * <p>
         * A container with information about the SMS verification message.
         * </p>
         * 
         * @param smsVerificationMessage
         *        A container with information about the SMS verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsVerificationMessage(String smsVerificationMessage);

        /**
         * <p>
         * The contents of the email verification message.
         * </p>
         * 
         * @param emailVerificationMessage
         *        The contents of the email verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationMessage(String emailVerificationMessage);

        /**
         * <p>
         * The subject of the email verification message.
         * </p>
         * 
         * @param emailVerificationSubject
         *        The subject of the email verification message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailVerificationSubject(String emailVerificationSubject);

        /**
         * <p>
         * The template for verification messages.
         * </p>
         * 
         * @param verificationMessageTemplate
         *        The template for verification messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate);

        /**
         * <p>
         * The template for verification messages.
         * </p>
         * This is a convenience that creates an instance of the {@link VerificationMessageTemplateType.Builder}
         * avoiding the need to create one manually via {@link VerificationMessageTemplateType#builder()}.
         *
         * When the {@link Consumer} completes, {@link VerificationMessageTemplateType.Builder#build()} is called
         * immediately and its result is passed to {@link #verificationMessageTemplate(VerificationMessageTemplateType)}
         * .
         * 
         * @param verificationMessageTemplate
         *        a consumer that will call methods on {@link VerificationMessageTemplateType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationMessageTemplate(VerificationMessageTemplateType)
         */
        default Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return verificationMessageTemplate(VerificationMessageTemplateType.builder()
                    .applyMutation(verificationMessageTemplate).build());
        }

        /**
         * <p>
         * The contents of the SMS authentication message.
         * </p>
         * 
         * @param smsAuthenticationMessage
         *        The contents of the SMS authentication message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsAuthenticationMessage(String smsAuthenticationMessage);

        /**
         * <p>
         * Can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you
         * are initially creating a user pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        Can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required
         *        when you are initially creating a user pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(String mfaConfiguration);

        /**
         * <p>
         * Can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required when you
         * are initially creating a user pool.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mfaConfiguration
         *        Can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OFF</code> - MFA tokens are not required and cannot be specified during user registration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ON</code> - MFA tokens are required for all user registrations. You can only specify required
         *        when you are initially creating a user pool.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPTIONAL</code> - Users have the option when registering to create an MFA token.
         *        </p>
         *        </li>
         * @see UserPoolMfaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserPoolMfaType
         */
        Builder mfaConfiguration(UserPoolMfaType mfaConfiguration);

        /**
         * <p>
         * Device configuration.
         * </p>
         * 
         * @param deviceConfiguration
         *        Device configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration);

        /**
         * <p>
         * Device configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceConfigurationType.Builder} avoiding the
         * need to create one manually via {@link DeviceConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceConfiguration(DeviceConfigurationType)}.
         * 
         * @param deviceConfiguration
         *        a consumer that will call methods on {@link DeviceConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfiguration(DeviceConfigurationType)
         */
        default Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return deviceConfiguration(DeviceConfigurationType.builder().applyMutation(deviceConfiguration).build());
        }

        /**
         * <p>
         * Email configuration.
         * </p>
         * 
         * @param emailConfiguration
         *        Email configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailConfiguration(EmailConfigurationType emailConfiguration);

        /**
         * <p>
         * Email configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link EmailConfigurationType.Builder} avoiding the
         * need to create one manually via {@link EmailConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EmailConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailConfiguration(EmailConfigurationType)}.
         * 
         * @param emailConfiguration
         *        a consumer that will call methods on {@link EmailConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailConfiguration(EmailConfigurationType)
         */
        default Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return emailConfiguration(EmailConfigurationType.builder().applyMutation(emailConfiguration).build());
        }

        /**
         * <p>
         * SMS configuration.
         * </p>
         * 
         * @param smsConfiguration
         *        SMS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsConfiguration(SmsConfigurationType smsConfiguration);

        /**
         * <p>
         * SMS configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SmsConfigurationType.Builder} avoiding the need
         * to create one manually via {@link SmsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SmsConfigurationType.Builder#build()} is called immediately and
         * its result is passed to {@link #smsConfiguration(SmsConfigurationType)}.
         * 
         * @param smsConfiguration
         *        a consumer that will call methods on {@link SmsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsConfiguration(SmsConfigurationType)
         */
        default Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return smsConfiguration(SmsConfigurationType.builder().applyMutation(smsConfiguration).build());
        }

        /**
         * <p>
         * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and
         * manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * </p>
         * 
         * @param userPoolTags
         *        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize
         *        and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolTags(Map<String, String> userPoolTags);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * 
         * @param adminCreateUserConfig
         *        The configuration for <code>AdminCreateUser</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig);

        /**
         * <p>
         * The configuration for <code>AdminCreateUser</code> requests.
         * </p>
         * This is a convenience that creates an instance of the {@link AdminCreateUserConfigType.Builder} avoiding the
         * need to create one manually via {@link AdminCreateUserConfigType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AdminCreateUserConfigType.Builder#build()} is called immediately
         * and its result is passed to {@link #adminCreateUserConfig(AdminCreateUserConfigType)}.
         * 
         * @param adminCreateUserConfig
         *        a consumer that will call methods on {@link AdminCreateUserConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminCreateUserConfig(AdminCreateUserConfigType)
         */
        default Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return adminCreateUserConfig(AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig).build());
        }

        /**
         * <p>
         * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
         * "AUDIT".
         * </p>
         * 
         * @param userPoolAddOns
         *        Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the
         *        value "AUDIT".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns);

        /**
         * <p>
         * Used to enable advanced security risk detection. Set the key <code>AdvancedSecurityMode</code> to the value
         * "AUDIT".
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolAddOnsType.Builder} avoiding the need to
         * create one manually via {@link UserPoolAddOnsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolAddOnsType.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolAddOns(UserPoolAddOnsType)}.
         * 
         * @param userPoolAddOns
         *        a consumer that will call methods on {@link UserPoolAddOnsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolAddOns(UserPoolAddOnsType)
         */
        default Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return userPoolAddOns(UserPoolAddOnsType.builder().applyMutation(userPoolAddOns).build());
        }

        /**
         * <p>
         * Use this setting to define which verified available method a user can use to recover their password when they
         * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one
         * method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user
         * also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the
         * recovery method where SMS is preferred over email.
         * </p>
         * 
         * @param accountRecoverySetting
         *        Use this setting to define which verified available method a user can use to recover their password
         *        when they call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has
         *        more than one method available. With this setting, SMS does not qualify for a valid password recovery
         *        mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the
         *        legacy behavior to determine the recovery method where SMS is preferred over email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting);

        /**
         * <p>
         * Use this setting to define which verified available method a user can use to recover their password when they
         * call <code>ForgotPassword</code>. It allows you to define a preferred method when a user has more than one
         * method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user
         * also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the
         * recovery method where SMS is preferred over email.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountRecoverySettingType.Builder} avoiding the
         * need to create one manually via {@link AccountRecoverySettingType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountRecoverySettingType.Builder#build()} is called immediately
         * and its result is passed to {@link #accountRecoverySetting(AccountRecoverySettingType)}.
         * 
         * @param accountRecoverySetting
         *        a consumer that will call methods on {@link AccountRecoverySettingType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountRecoverySetting(AccountRecoverySettingType)
         */
        default Builder accountRecoverySetting(Consumer<AccountRecoverySettingType.Builder> accountRecoverySetting) {
            return accountRecoverySetting(AccountRecoverySettingType.builder().applyMutation(accountRecoverySetting).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private UserPoolPolicyType policies;

        private LambdaConfigType lambdaConfig;

        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();

        private String smsVerificationMessage;

        private String emailVerificationMessage;

        private String emailVerificationSubject;

        private VerificationMessageTemplateType verificationMessageTemplate;

        private String smsAuthenticationMessage;

        private String mfaConfiguration;

        private DeviceConfigurationType deviceConfiguration;

        private EmailConfigurationType emailConfiguration;

        private SmsConfigurationType smsConfiguration;

        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private AdminCreateUserConfigType adminCreateUserConfig;

        private UserPoolAddOnsType userPoolAddOns;

        private AccountRecoverySettingType accountRecoverySetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserPoolRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            policies(model.policies);
            lambdaConfig(model.lambdaConfig);
            autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            smsVerificationMessage(model.smsVerificationMessage);
            emailVerificationMessage(model.emailVerificationMessage);
            emailVerificationSubject(model.emailVerificationSubject);
            verificationMessageTemplate(model.verificationMessageTemplate);
            smsAuthenticationMessage(model.smsAuthenticationMessage);
            mfaConfiguration(model.mfaConfiguration);
            deviceConfiguration(model.deviceConfiguration);
            emailConfiguration(model.emailConfiguration);
            smsConfiguration(model.smsConfiguration);
            userPoolTags(model.userPoolTags);
            adminCreateUserConfig(model.adminCreateUserConfig);
            userPoolAddOns(model.userPoolAddOns);
            accountRecoverySetting(model.accountRecoverySetting);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final Collection<String> getAutoVerifiedAttributes() {
            if (autoVerifiedAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return autoVerifiedAttributes;
        }

        @Override
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String... autoVerifiedAttributes) {
            autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType... autoVerifiedAttributes) {
            autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        public final String getSmsVerificationMessage() {
            return smsVerificationMessage;
        }

        @Override
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        public final String getEmailVerificationMessage() {
            return emailVerificationMessage;
        }

        @Override
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        public final String getEmailVerificationSubject() {
            return emailVerificationSubject;
        }

        @Override
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return verificationMessageTemplate != null ? verificationMessageTemplate.toBuilder() : null;
        }

        @Override
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        public final String getSmsAuthenticationMessage() {
            return smsAuthenticationMessage;
        }

        @Override
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        public final String getMfaConfiguration() {
            return mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return deviceConfiguration != null ? deviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return emailConfiguration != null ? emailConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return smsConfiguration != null ? smsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        public final Map<String, String> getUserPoolTags() {
            if (userPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return userPoolTags;
        }

        @Override
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return adminCreateUserConfig != null ? adminCreateUserConfig.toBuilder() : null;
        }

        @Override
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return userPoolAddOns != null ? userPoolAddOns.toBuilder() : null;
        }

        @Override
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        public final AccountRecoverySettingType.Builder getAccountRecoverySetting() {
            return accountRecoverySetting != null ? accountRecoverySetting.toBuilder() : null;
        }

        @Override
        public final Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        public final void setAccountRecoverySetting(AccountRecoverySettingType.BuilderImpl accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting != null ? accountRecoverySetting.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserPoolRequest build() {
            return new UpdateUserPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
