/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to list the user import jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserImportJobsResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListUserImportJobsResponse.Builder, ListUserImportJobsResponse> {
    private static final SdkField<List<UserImportJobType>> USER_IMPORT_JOBS_FIELD = SdkField
            .<List<UserImportJobType>> builder(MarshallingType.LIST)
            .memberName("UserImportJobs")
            .getter(getter(ListUserImportJobsResponse::userImportJobs))
            .setter(setter(Builder::userImportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserImportJobType> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserImportJobType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(ListUserImportJobsResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IMPORT_JOBS_FIELD,
            PAGINATION_TOKEN_FIELD));

    private final List<UserImportJobType> userImportJobs;

    private final String paginationToken;

    private ListUserImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.userImportJobs = builder.userImportJobs;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * Returns true if the UserImportJobs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserImportJobs() {
        return userImportJobs != null && !(userImportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user import jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserImportJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user import jobs.
     */
    public List<UserImportJobType> userImportJobs() {
        return userImportJobs;
    }

    /**
     * <p>
     * An identifier that can be used to return the next set of user import jobs in the list.
     * </p>
     * 
     * @return An identifier that can be used to return the next set of user import jobs in the list.
     */
    public String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserImportJobs() ? userImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserImportJobsResponse)) {
            return false;
        }
        ListUserImportJobsResponse other = (ListUserImportJobsResponse) obj;
        return hasUserImportJobs() == other.hasUserImportJobs() && Objects.equals(userImportJobs(), other.userImportJobs())
                && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUserImportJobsResponse")
                .add("UserImportJobs", hasUserImportJobs() ? userImportJobs() : null).add("PaginationToken", paginationToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserImportJobs":
            return Optional.ofNullable(clazz.cast(userImportJobs()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserImportJobsResponse, T> g) {
        return obj -> g.apply((ListUserImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUserImportJobsResponse> {
        /**
         * <p>
         * The user import jobs.
         * </p>
         * 
         * @param userImportJobs
         *        The user import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userImportJobs(Collection<UserImportJobType> userImportJobs);

        /**
         * <p>
         * The user import jobs.
         * </p>
         * 
         * @param userImportJobs
         *        The user import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userImportJobs(UserImportJobType... userImportJobs);

        /**
         * <p>
         * The user import jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserImportJobType>.Builder} avoiding the
         * need to create one manually via {@link List<UserImportJobType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserImportJobType>.Builder#build()} is called immediately
         * and its result is passed to {@link #userImportJobs(List<UserImportJobType>)}.
         * 
         * @param userImportJobs
         *        a consumer that will call methods on {@link List<UserImportJobType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userImportJobs(List<UserImportJobType>)
         */
        Builder userImportJobs(Consumer<UserImportJobType.Builder>... userImportJobs);

        /**
         * <p>
         * An identifier that can be used to return the next set of user import jobs in the list.
         * </p>
         * 
         * @param paginationToken
         *        An identifier that can be used to return the next set of user import jobs in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<UserImportJobType> userImportJobs = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserImportJobsResponse model) {
            super(model);
            userImportJobs(model.userImportJobs);
            paginationToken(model.paginationToken);
        }

        public final Collection<UserImportJobType.Builder> getUserImportJobs() {
            if (userImportJobs instanceof SdkAutoConstructList) {
                return null;
            }
            return userImportJobs != null ? userImportJobs.stream().map(UserImportJobType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userImportJobs(Collection<UserImportJobType> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copy(userImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(UserImportJobType... userImportJobs) {
            userImportJobs(Arrays.asList(userImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userImportJobs(Consumer<UserImportJobType.Builder>... userImportJobs) {
            userImportJobs(Stream.of(userImportJobs).map(c -> UserImportJobType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserImportJobs(Collection<UserImportJobType.BuilderImpl> userImportJobs) {
            this.userImportJobs = UserImportJobsListTypeCopier.copyFromBuilder(userImportJobs);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public ListUserImportJobsResponse build() {
            return new ListUserImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
