/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The group type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupType implements SdkPojo, Serializable, ToCopyableBuilder<GroupType.Builder, GroupType> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GroupType::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(GroupType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GroupType::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GroupType::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Integer> PRECEDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Precedence").getter(getter(GroupType::precedence)).setter(setter(Builder::precedence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precedence").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(GroupType::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GroupType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            USER_POOL_ID_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PRECEDENCE_FIELD, LAST_MODIFIED_DATE_FIELD,
            CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String userPoolId;

    private final String description;

    private final String roleArn;

    private final Integer precedence;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private GroupType(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.userPoolId = builder.userPoolId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.precedence = builder.precedence;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A string containing the description of the group.
     * </p>
     * 
     * @return A string containing the description of the group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The role ARN for the group.
     * </p>
     * 
     * @return The role ARN for the group.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user
     * can belong to in the user pool. If a user belongs to two or more groups, it is the group with the highest
     * precedence whose role ARN will be used in the <code>cognito:roles</code> and <code>cognito:preferred_role</code>
     * claims in the user's tokens. Groups with higher <code>Precedence</code> values take precedence over groups with
     * lower <code>Precedence</code> values or with null <code>Precedence</code> values.
     * </p>
     * <p>
     * Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence over
     * the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used in the
     * <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have different
     * role ARNs, the <code>cognito:preferred_role</code> claim is not set in users' tokens.
     * </p>
     * <p>
     * The default <code>Precedence</code> value is null.
     * </p>
     * 
     * @return A nonnegative integer value that specifies the precedence of this group relative to the other groups that
     *         a user can belong to in the user pool. If a user belongs to two or more groups, it is the group with the
     *         highest precedence whose role ARN will be used in the <code>cognito:roles</code> and
     *         <code>cognito:preferred_role</code> claims in the user's tokens. Groups with higher
     *         <code>Precedence</code> values take precedence over groups with lower <code>Precedence</code> values or
     *         with null <code>Precedence</code> values.</p>
     *         <p>
     *         Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes
     *         precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN,
     *         that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If
     *         the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set in
     *         users' tokens.
     *         </p>
     *         <p>
     *         The default <code>Precedence</code> value is null.
     */
    public Integer precedence() {
        return precedence;
    }

    /**
     * <p>
     * The date the group was last modified.
     * </p>
     * 
     * @return The date the group was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the group was created.
     * </p>
     * 
     * @return The date the group was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(precedence());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupType)) {
            return false;
        }
        GroupType other = (GroupType) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(precedence(), other.precedence())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GroupType").add("GroupName", groupName()).add("UserPoolId", userPoolId())
                .add("Description", description()).add("RoleArn", roleArn()).add("Precedence", precedence())
                .add("LastModifiedDate", lastModifiedDate()).add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Precedence":
            return Optional.ofNullable(clazz.cast(precedence()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupType, T> g) {
        return obj -> g.apply((GroupType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupType> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A string containing the description of the group.
         * </p>
         * 
         * @param description
         *        A string containing the description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The role ARN for the group.
         * </p>
         * 
         * @param roleArn
         *        The role ARN for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A nonnegative integer value that specifies the precedence of this group relative to the other groups that a
         * user can belong to in the user pool. If a user belongs to two or more groups, it is the group with the
         * highest precedence whose role ARN will be used in the <code>cognito:roles</code> and
         * <code>cognito:preferred_role</code> claims in the user's tokens. Groups with higher <code>Precedence</code>
         * values take precedence over groups with lower <code>Precedence</code> values or with null
         * <code>Precedence</code> values.
         * </p>
         * <p>
         * Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes precedence
         * over the other. If two groups with the same <code>Precedence</code> have the same role ARN, that role is used
         * in the <code>cognito:preferred_role</code> claim in tokens for users in each group. If the two groups have
         * different role ARNs, the <code>cognito:preferred_role</code> claim is not set in users' tokens.
         * </p>
         * <p>
         * The default <code>Precedence</code> value is null.
         * </p>
         * 
         * @param precedence
         *        A nonnegative integer value that specifies the precedence of this group relative to the other groups
         *        that a user can belong to in the user pool. If a user belongs to two or more groups, it is the group
         *        with the highest precedence whose role ARN will be used in the <code>cognito:roles</code> and
         *        <code>cognito:preferred_role</code> claims in the user's tokens. Groups with higher
         *        <code>Precedence</code> values take precedence over groups with lower <code>Precedence</code> values
         *        or with null <code>Precedence</code> values.</p>
         *        <p>
         *        Two groups can have the same <code>Precedence</code> value. If this happens, neither group takes
         *        precedence over the other. If two groups with the same <code>Precedence</code> have the same role ARN,
         *        that role is used in the <code>cognito:preferred_role</code> claim in tokens for users in each group.
         *        If the two groups have different role ARNs, the <code>cognito:preferred_role</code> claim is not set
         *        in users' tokens.
         *        </p>
         *        <p>
         *        The default <code>Precedence</code> value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precedence(Integer precedence);

        /**
         * <p>
         * The date the group was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the group was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the group was created.
         * </p>
         * 
         * @param creationDate
         *        The date the group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String userPoolId;

        private String description;

        private String roleArn;

        private Integer precedence;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupType model) {
            groupName(model.groupName);
            userPoolId(model.userPoolId);
            description(model.description);
            roleArn(model.roleArn);
            precedence(model.precedence);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getPrecedence() {
            return precedence;
        }

        @Override
        public final Builder precedence(Integer precedence) {
            this.precedence = precedence;
            return this;
        }

        public final void setPrecedence(Integer precedence) {
            this.precedence = precedence;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public GroupType build() {
            return new GroupType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
