/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForgotPasswordRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ForgotPasswordRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::clientId)).setter(ForgotPasswordRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> SECRET_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretHash").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::secretHash)).setter(ForgotPasswordRequest.setter(Builder::secretHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretHash").build()}).build();
    private static final SdkField<UserContextDataType> USER_CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserContextData").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::userContextData)).setter(ForgotPasswordRequest.setter(Builder::userContextData)).constructor(UserContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextData").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::username)).setter(ForgotPasswordRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsMetadata").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::analyticsMetadata)).setter(ForgotPasswordRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(ForgotPasswordRequest.getter(ForgotPasswordRequest::clientMetadata)).setter(ForgotPasswordRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, SECRET_HASH_FIELD, USER_CONTEXT_DATA_FIELD, USERNAME_FIELD, ANALYTICS_METADATA_FIELD, CLIENT_METADATA_FIELD));
    private final String clientId;
    private final String secretHash;
    private final UserContextDataType userContextData;
    private final String username;
    private final AnalyticsMetadataType analyticsMetadata;
    private final Map<String, String> clientMetadata;

    private ForgotPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.secretHash = builder.secretHash;
        this.userContextData = builder.userContextData;
        this.username = builder.username;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.clientMetadata = builder.clientMetadata;
    }

    public String clientId() {
        return this.clientId;
    }

    public String secretHash() {
        return this.secretHash;
    }

    public UserContextDataType userContextData() {
        return this.userContextData;
    }

    public String username() {
        return this.username;
    }

    public AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextData());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForgotPasswordRequest)) {
            return false;
        }
        ForgotPasswordRequest other = (ForgotPasswordRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.secretHash(), other.secretHash()) && Objects.equals(this.userContextData(), other.userContextData()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.clientMetadata(), other.clientMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ForgotPasswordRequest").add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretHash", (Object)(this.secretHash() == null ? null : "*** Sensitive Data Redacted ***")).add("UserContextData", (Object)this.userContextData()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("ClientMetadata", this.clientMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "SecretHash": {
                return Optional.ofNullable(clazz.cast(this.secretHash()));
            }
            case "UserContextData": {
                return Optional.ofNullable(clazz.cast(this.userContextData()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForgotPasswordRequest, T> g) {
        return obj -> g.apply((ForgotPasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String secretHash;
        private UserContextDataType userContextData;
        private String username;
        private AnalyticsMetadataType analyticsMetadata;
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ForgotPasswordRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.secretHash(model.secretHash);
            this.userContextData(model.userContextData);
            this.username(model.username);
            this.analyticsMetadata(model.analyticsMetadata);
            this.clientMetadata(model.clientMetadata);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getSecretHash() {
            return this.secretHash;
        }

        @Override
        public final Builder secretHash(String secretHash) {
            this.secretHash = secretHash;
            return this;
        }

        public final void setSecretHash(String secretHash) {
            this.secretHash = secretHash;
        }

        public final UserContextDataType.Builder getUserContextData() {
            return this.userContextData != null ? this.userContextData.toBuilder() : null;
        }

        @Override
        public final Builder userContextData(UserContextDataType userContextData) {
            this.userContextData = userContextData;
            return this;
        }

        public final void setUserContextData(UserContextDataType.BuilderImpl userContextData) {
            this.userContextData = userContextData != null ? userContextData.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        public final Map<String, String> getClientMetadata() {
            return this.clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ForgotPasswordRequest build() {
            return new ForgotPasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ForgotPasswordRequest> {
        public Builder clientId(String var1);

        public Builder secretHash(String var1);

        public Builder userContextData(UserContextDataType var1);

        default public Builder userContextData(Consumer<UserContextDataType.Builder> userContextData) {
            return this.userContextData((UserContextDataType)((UserContextDataType.Builder)UserContextDataType.builder().applyMutation(userContextData)).build());
        }

        public Builder username(String var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder clientMetadata(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

