/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProvidersListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityProvidersResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListIdentityProvidersResponse> {
    private static final SdkField<List<ProviderDescription>> PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Providers").getter(ListIdentityProvidersResponse.getter(ListIdentityProvidersResponse::providers)).setter(ListIdentityProvidersResponse.setter(Builder::providers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Providers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProviderDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentityProvidersResponse.getter(ListIdentityProvidersResponse::nextToken)).setter(ListIdentityProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProviderDescription> providers;
    private final String nextToken;

    private ListIdentityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.providers = builder.providers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasProviders() {
        return this.providers != null && !(this.providers instanceof SdkAutoConstructList);
    }

    public List<ProviderDescription> providers() {
        return this.providers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResponse)) {
            return false;
        }
        ListIdentityProvidersResponse other = (ListIdentityProvidersResponse)((Object)obj);
        return Objects.equals(this.providers(), other.providers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentityProvidersResponse").add("Providers", this.providers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Providers": {
                return Optional.ofNullable(clazz.cast(this.providers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProvidersResponse, T> g) {
        return obj -> g.apply((ListIdentityProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<ProviderDescription> providers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProvidersResponse model) {
            super(model);
            this.providers(model.providers);
            this.nextToken(model.nextToken);
        }

        public final Collection<ProviderDescription.Builder> getProviders() {
            return this.providers != null ? (Collection)this.providers.stream().map(ProviderDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder providers(Collection<ProviderDescription> providers) {
            this.providers = ProvidersListTypeCopier.copy(providers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(ProviderDescription ... providers) {
            this.providers(Arrays.asList(providers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providers(Consumer<ProviderDescription.Builder> ... providers) {
            this.providers(Stream.of(providers).map(c -> (ProviderDescription)((ProviderDescription.Builder)ProviderDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProviders(Collection<ProviderDescription.BuilderImpl> providers) {
            this.providers = ProvidersListTypeCopier.copyFromBuilder(providers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityProvidersResponse> {
        public Builder providers(Collection<ProviderDescription> var1);

        public Builder providers(ProviderDescription ... var1);

        public Builder providers(Consumer<ProviderDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

