/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum value of an attribute that is of the number data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberAttributeConstraintsType implements SdkPojo, Serializable,
        ToCopyableBuilder<NumberAttributeConstraintsType.Builder, NumberAttributeConstraintsType> {
    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinValue").getter(getter(NumberAttributeConstraintsType::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxValue").getter(getter(NumberAttributeConstraintsType::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_VALUE_FIELD,
            MAX_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String minValue;

    private final String maxValue;

    private NumberAttributeConstraintsType(BuilderImpl builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    /**
     * <p>
     * The minimum value of an attribute that is of the number data type.
     * </p>
     * 
     * @return The minimum value of an attribute that is of the number data type.
     */
    public final String minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum value of an attribute that is of the number data type.
     * </p>
     * 
     * @return The maximum value of an attribute that is of the number data type.
     */
    public final String maxValue() {
        return maxValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberAttributeConstraintsType)) {
            return false;
        }
        NumberAttributeConstraintsType other = (NumberAttributeConstraintsType) obj;
        return Objects.equals(minValue(), other.minValue()) && Objects.equals(maxValue(), other.maxValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumberAttributeConstraintsType").add("MinValue", minValue()).add("MaxValue", maxValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumberAttributeConstraintsType, T> g) {
        return obj -> g.apply((NumberAttributeConstraintsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberAttributeConstraintsType> {
        /**
         * <p>
         * The minimum value of an attribute that is of the number data type.
         * </p>
         * 
         * @param minValue
         *        The minimum value of an attribute that is of the number data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(String minValue);

        /**
         * <p>
         * The maximum value of an attribute that is of the number data type.
         * </p>
         * 
         * @param maxValue
         *        The maximum value of an attribute that is of the number data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(String maxValue);
    }

    static final class BuilderImpl implements Builder {
        private String minValue;

        private String maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberAttributeConstraintsType model) {
            minValue(model.minValue);
            maxValue(model.maxValue);
        }

        public final String getMinValue() {
            return minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public final String getMaxValue() {
            return maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public NumberAttributeConstraintsType build() {
            return new NumberAttributeConstraintsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
