/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable;

/**
 * Service client for accessing Amazon Cognito Identity Provider. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Using the Amazon Cognito User Pools API, you can create a user pool to manage directories and users. You can
 * authenticate a user to obtain tokens related to user identity and access policies.
 * </p>
 * <p>
 * This API reference provides information about user pools in Amazon Cognito User Pools.
 * </p>
 * <p>
 * For more information, see the <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/what-is-amazon-cognito.html">Amazon Cognito
 * Documentation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CognitoIdentityProviderClient extends SdkClient {
    String SERVICE_NAME = "cognito-idp";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cognito-idp";

    /**
     * Create a {@link CognitoIdentityProviderClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CognitoIdentityProviderClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CognitoIdentityProviderClient}.
     */
    static CognitoIdentityProviderClientBuilder builder() {
        return new DefaultCognitoIdentityProviderClientBuilder();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return Result of the AddCustomAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AddCustomAttributesResponse addCustomAttributes(AddCustomAttributesRequest addCustomAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserImportInProgressException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCustomAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link AddCustomAttributesRequest#builder()}
     * </p>
     *
     * @param addCustomAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AddCustomAttributesRequest.Builder} to create a
     *        request. Represents the request to add custom attributes.
     * @return Result of the AddCustomAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AddCustomAttributesResponse addCustomAttributes(
            Consumer<AddCustomAttributesRequest.Builder> addCustomAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserImportInProgressException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return addCustomAttributes(AddCustomAttributesRequest.builder().applyMutation(addCustomAttributesRequest).build());
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminAddUserToGroupRequest
     * @return Result of the AdminAddUserToGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminAddUserToGroupResponse adminAddUserToGroup(AdminAddUserToGroupRequest adminAddUserToGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminAddUserToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AdminAddUserToGroupRequest#builder()}
     * </p>
     *
     * @param adminAddUserToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AdminAddUserToGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AdminAddUserToGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminAddUserToGroupResponse adminAddUserToGroup(
            Consumer<AdminAddUserToGroupRequest.Builder> adminAddUserToGroupRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminAddUserToGroup(AdminAddUserToGroupRequest.builder().applyMutation(adminAddUserToGroupRequest).build());
    }

    /**
     * <p>
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        Represents the request to confirm user registration.
     * @return Result of the AdminConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminConfirmSignUpResponse adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminConfirmSignUpRequest.Builder} avoiding the
     * need to create one manually via {@link AdminConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        A {@link Consumer} that will call methods on {@link AdminConfirmSignUpRequest.Builder} to create a
     *        request. Represents the request to confirm user registration.
     * @return Result of the AdminConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminConfirmSignUpResponse adminConfirmSignUp(Consumer<AdminConfirmSignUpRequest.Builder> adminConfirmSignUpRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminConfirmSignUp(AdminConfirmSignUpRequest.builder().applyMutation(adminConfirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> is not set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with “SUPPRESS” for the <code>MessageAction</code>
     * parameter, and Amazon Cognito will not send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <p>
     * <code>AdminCreateUser</code> requires developer credentials.
     * </p>
     *
     * @param adminCreateUserRequest
     *        Represents the request to create a user in the specified user pool.
     * @return Result of the AdminCreateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnsupportedUserStateException
     *         The request failed because the user is in an unsupported state.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminCreateUserResponse adminCreateUser(AdminCreateUserRequest adminCreateUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, UserNotFoundException, UsernameExistsException,
            InvalidPasswordException, CodeDeliveryFailureException, UnexpectedLambdaException, UserLambdaValidationException,
            InvalidLambdaResponseException, PreconditionNotMetException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, TooManyRequestsException, NotAuthorizedException,
            UnsupportedUserStateException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> is not set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with “SUPPRESS” for the <code>MessageAction</code>
     * parameter, and Amazon Cognito will not send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <p>
     * <code>AdminCreateUser</code> requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminCreateUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminCreateUserRequest#builder()}
     * </p>
     *
     * @param adminCreateUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminCreateUserRequest.Builder} to create a request.
     *        Represents the request to create a user in the specified user pool.
     * @return Result of the AdminCreateUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnsupportedUserStateException
     *         The request failed because the user is in an unsupported state.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminCreateUserResponse adminCreateUser(Consumer<AdminCreateUserRequest.Builder> adminCreateUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, UserNotFoundException, UsernameExistsException,
            InvalidPasswordException, CodeDeliveryFailureException, UnexpectedLambdaException, UserLambdaValidationException,
            InvalidLambdaResponseException, PreconditionNotMetException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, TooManyRequestsException, NotAuthorizedException,
            UnsupportedUserStateException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminCreateUser(AdminCreateUserRequest.builder().applyMutation(adminCreateUserRequest).build());
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return Result of the AdminDeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminDeleteUserResponse adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDeleteUserRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDeleteUserRequest.Builder} to create a request.
     *        Represents the request to delete a user as an administrator.
     * @return Result of the AdminDeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminDeleteUserResponse adminDeleteUser(Consumer<AdminDeleteUserRequest.Builder> adminDeleteUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminDeleteUser(AdminDeleteUserRequest.builder().applyMutation(adminDeleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return Result of the AdminDeleteUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminDeleteUserAttributesResponse adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminDeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AdminDeleteUserAttributesRequest.Builder} to create a
     *        request. Represents the request to delete user attributes as an administrator.
     * @return Result of the AdminDeleteUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminDeleteUserAttributesResponse adminDeleteUserAttributes(
            Consumer<AdminDeleteUserAttributesRequest.Builder> adminDeleteUserAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminDeleteUserAttributes(AdminDeleteUserAttributesRequest.builder()
                .applyMutation(adminDeleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to
     * disable is a Cognito User Pools native username + password user, they are not permitted to use their password to
     * sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is
     * removed. The next time the external user (no longer attached to the previously linked
     * <code>DestinationUser</code>) signs in, they must create a new user account. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the
     * <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers.
     * The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was
     * originally linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set
     * to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the subject of the SAML assertion.
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     * @return Result of the AdminDisableProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminDisableProviderForUserResponse adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            AliasExistsException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the user from signing in with the specified external (SAML or social) identity provider. If the user to
     * disable is a Cognito User Pools native username + password user, they are not permitted to use their password to
     * sign-in. If the user to disable is a linked external IdP user, any link between that user and an existing user is
     * removed. The next time the external user (no longer attached to the previously linked
     * <code>DestinationUser</code>) signs in, they must create a new user account. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To disable a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>, with the
     * <code>ProviderAttributeValue</code> being the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social identity providers.
     * The <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was
     * originally linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign-in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set
     * to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the subject of the SAML assertion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableProviderForUserRequest.Builder}
     * avoiding the need to create one manually via {@link AdminDisableProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDisableProviderForUserRequest.Builder} to create
     *        a request.
     * @return Result of the AdminDisableProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminDisableProviderForUserResponse adminDisableProviderForUser(
            Consumer<AdminDisableProviderForUserRequest.Builder> adminDisableProviderForUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, AliasExistsException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminDisableProviderForUser(AdminDisableProviderForUserRequest.builder()
                .applyMutation(adminDisableProviderForUserRequest).build());
    }

    /**
     * <p>
     * Disables the specified user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable the user as an administrator.
     * @return Result of the AdminDisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminDisableUserResponse adminDisableUser(AdminDisableUserRequest adminDisableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDisableUserRequest#builder()}
     * </p>
     *
     * @param adminDisableUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminDisableUserRequest.Builder} to create a request.
     *        Represents the request to disable the user as an administrator.
     * @return Result of the AdminDisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminDisableUserResponse adminDisableUser(Consumer<AdminDisableUserRequest.Builder> adminDisableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminDisableUser(AdminDisableUserRequest.builder().applyMutation(adminDisableUserRequest).build());
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return Result of the AdminEnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminEnableUserResponse adminEnableUser(AdminEnableUserRequest adminEnableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminEnableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminEnableUserRequest#builder()}
     * </p>
     *
     * @param adminEnableUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminEnableUserRequest.Builder} to create a request.
     *        Represents the request that enables the user as an administrator.
     * @return Result of the AdminEnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminEnableUserResponse adminEnableUser(Consumer<AdminEnableUserRequest.Builder> adminEnableUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminEnableUser(AdminEnableUserRequest.builder().applyMutation(adminEnableUserRequest).build());
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return Result of the AdminForgetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminForgetDeviceResponse adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminForgetDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link AdminForgetDeviceRequest#builder()}
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link AdminForgetDeviceRequest.Builder} to create a request.
     *        Sends the forgot device request, as an administrator.
     * @return Result of the AdminForgetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminForgetDeviceResponse adminForgetDevice(Consumer<AdminForgetDeviceRequest.Builder> adminForgetDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return adminForgetDevice(AdminForgetDeviceRequest.builder().applyMutation(adminForgetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return Result of the AdminGetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminGetDeviceResponse adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidUserPoolConfigurationException, TooManyRequestsException, InternalErrorException,
            NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetDeviceRequest#builder()}
     * </p>
     *
     * @param adminGetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link AdminGetDeviceRequest.Builder} to create a request.
     *        Represents the request to get the device, as an administrator.
     * @return Result of the AdminGetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminGetDeviceResponse adminGetDevice(Consumer<AdminGetDeviceRequest.Builder> adminGetDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminGetDevice(AdminGetDeviceRequest.builder().applyMutation(adminGetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return Result of the AdminGetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default AdminGetUserResponse adminGetUser(AdminGetUserRequest adminGetUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetUserRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetUserRequest#builder()}
     * </p>
     *
     * @param adminGetUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminGetUserRequest.Builder} to create a request.
     *        Represents the request to get the specified user as an administrator.
     * @return Result of the AdminGetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default AdminGetUserResponse adminGetUser(Consumer<AdminGetUserRequest.Builder> adminGetUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminGetUser(AdminGetUserRequest.builder().applyMutation(adminGetUserRequest).build());
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return Result of the AdminInitiateAuth operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminInitiateAuthResponse adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, UnexpectedLambdaException, InvalidUserPoolConfigurationException,
            UserLambdaValidationException, InvalidLambdaResponseException, MfaMethodNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminInitiateAuthRequest.Builder} avoiding the need
     * to create one manually via {@link AdminInitiateAuthRequest#builder()}
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        A {@link Consumer} that will call methods on {@link AdminInitiateAuthRequest.Builder} to create a request.
     *        Initiates the authorization request, as an administrator.
     * @return Result of the AdminInitiateAuth operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminInitiateAuthResponse adminInitiateAuth(Consumer<AdminInitiateAuthRequest.Builder> adminInitiateAuthRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, UnexpectedLambdaException, InvalidUserPoolConfigurationException,
            UserLambdaValidationException, InvalidLambdaResponseException, MfaMethodNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminInitiateAuth(AdminInitiateAuthRequest.builder().applyMutation(adminInitiateAuthRequest).build());
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external
     * identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external
     * identity provider. This allows you to create a link from the existing user account to an external federated user
     * identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the
     * existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity, so that when the federated user identity is used, the user signs in as the existing user account.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is 5.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external identity providers and provider attributes that have been
     * trusted by the application owner.
     * </p>
     * </important>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     * @return Result of the AdminLinkProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminLinkProviderForUserResponse adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            AliasExistsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external
     * identity provider (<code>SourceUser</code>) based on a specified attribute name and value from the external
     * identity provider. This allows you to create a link from the existing user account to an external federated user
     * identity that has not yet been used to sign in, so that the federated user identity can be used to sign in as the
     * existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity, so that when the federated user identity is used, the user signs in as the existing user account.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is 5.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external identity providers and provider attributes that have been
     * trusted by the application owner.
     * </p>
     * </important>
     * <p>
     * This action is enabled only for admin access and requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminLinkProviderForUserRequest.Builder} avoiding
     * the need to create one manually via {@link AdminLinkProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminLinkProviderForUserRequest.Builder} to create a
     *        request.
     * @return Result of the AdminLinkProviderForUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminLinkProviderForUserResponse adminLinkProviderForUser(
            Consumer<AdminLinkProviderForUserRequest.Builder> adminLinkProviderForUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            AliasExistsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminLinkProviderForUser(AdminLinkProviderForUserRequest.builder().applyMutation(adminLinkProviderForUserRequest)
                .build());
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return Result of the AdminListDevices operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminListDevicesResponse adminListDevices(AdminListDevicesRequest adminListDevicesRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link AdminListDevicesRequest#builder()}
     * </p>
     *
     * @param adminListDevicesRequest
     *        A {@link Consumer} that will call methods on {@link AdminListDevicesRequest.Builder} to create a request.
     *        Represents the request to list devices, as an administrator.
     * @return Result of the AdminListDevices operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default AdminListDevicesResponse adminListDevices(Consumer<AdminListDevicesRequest.Builder> adminListDevicesRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminListDevices(AdminListDevicesRequest.builder().applyMutation(adminListDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminListGroupsForUserRequest
     * @return Result of the AdminListGroupsForUser operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserResponse adminListGroupsForUser(AdminListGroupsForUserRequest adminListGroupsForUserRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListGroupsForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AdminListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param adminListGroupsForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminListGroupsForUserRequest.Builder} to create a
     *        request.
     * @return Result of the AdminListGroupsForUser operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserResponse adminListGroupsForUser(
            Consumer<AdminListGroupsForUserRequest.Builder> adminListGroupsForUserRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminListGroupsForUser(AdminListGroupsForUserRequest.builder().applyMutation(adminListGroupsForUserRequest)
                .build());
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client.adminListGroupsForUserPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client
     *             .adminListGroupsForUserPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client.adminListGroupsForUserPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation.</b>
     * </p>
     *
     * @param adminListGroupsForUserRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserIterable adminListGroupsForUserPaginator(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups that the user belongs to.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client.adminListGroupsForUserPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client
     *             .adminListGroupsForUserPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable responses = client.adminListGroupsForUserPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListGroupsForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AdminListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param adminListGroupsForUserRequest
     *        A {@link Consumer} that will call methods on {@link AdminListGroupsForUserRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserIterable adminListGroupsForUserPaginator(
            Consumer<AdminListGroupsForUserRequest.Builder> adminListGroupsForUserRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminListGroupsForUserPaginator(AdminListGroupsForUserRequest.builder()
                .applyMutation(adminListGroupsForUserRequest).build());
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     * @return Result of the AdminListUserAuthEvents operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsResponse adminListUserAuthEvents(AdminListUserAuthEventsRequest adminListUserAuthEventsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListUserAuthEventsRequest.Builder} avoiding
     * the need to create one manually via {@link AdminListUserAuthEventsRequest#builder()}
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     *        A {@link Consumer} that will call methods on {@link AdminListUserAuthEventsRequest.Builder} to create a
     *        request.
     * @return Result of the AdminListUserAuthEvents operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsResponse adminListUserAuthEvents(
            Consumer<AdminListUserAuthEventsRequest.Builder> adminListUserAuthEventsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminListUserAuthEvents(AdminListUserAuthEventsRequest.builder().applyMutation(adminListUserAuthEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client.adminListUserAuthEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client
     *             .adminListUserAuthEventsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client.adminListUserAuthEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsIterable adminListUserAuthEventsPaginator(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client.adminListUserAuthEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client
     *             .adminListUserAuthEventsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable responses = client.adminListUserAuthEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListUserAuthEventsRequest.Builder} avoiding
     * the need to create one manually via {@link AdminListUserAuthEventsRequest#builder()}
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     *        A {@link Consumer} that will call methods on {@link AdminListUserAuthEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsIterable adminListUserAuthEventsPaginator(
            Consumer<AdminListUserAuthEventsRequest.Builder> adminListUserAuthEventsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminListUserAuthEventsPaginator(AdminListUserAuthEventsRequest.builder()
                .applyMutation(adminListUserAuthEventsRequest).build());
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return Result of the AdminRemoveUserFromGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminRemoveUserFromGroupResponse adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRemoveUserFromGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AdminRemoveUserFromGroupRequest#builder()}
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     *        A {@link Consumer} that will call methods on {@link AdminRemoveUserFromGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AdminRemoveUserFromGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminRemoveUserFromGroupResponse adminRemoveUserFromGroup(
            Consumer<AdminRemoveUserFromGroupRequest.Builder> adminRemoveUserFromGroupRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest.builder().applyMutation(adminRemoveUserFromGroupRequest)
                .build());
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to
     * sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should
     * direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition,
     * if the user pool has phone verification selected and a verified phone number exists for the user, or if email
     * verification is selected and a verified email exists for the user, calling this API will also result in sending a
     * message to the end user with the code to change their password.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return Result of the AdminResetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminResetUserPasswordResponse adminResetUserPassword(AdminResetUserPasswordRequest adminResetUserPasswordRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException,
            LimitExceededException, UserNotFoundException, InvalidSmsRoleAccessPolicyException,
            InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * When a developer calls this API, the current password is invalidated, so it must be changed. If a user tries to
     * sign in after the API is called, the app will get a PasswordResetRequiredException exception back and should
     * direct the user down the flow to reset the password, which is the same as the forgot password flow. In addition,
     * if the user pool has phone verification selected and a verified phone number exists for the user, or if email
     * verification is selected and a verified email exists for the user, calling this API will also result in sending a
     * message to the end user with the code to change their password.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminResetUserPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link AdminResetUserPasswordRequest#builder()}
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        A {@link Consumer} that will call methods on {@link AdminResetUserPasswordRequest.Builder} to create a
     *        request. Represents the request to reset a user's password as an administrator.
     * @return Result of the AdminResetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminResetUserPasswordResponse adminResetUserPassword(
            Consumer<AdminResetUserPasswordRequest.Builder> adminResetUserPasswordRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminResetUserPassword(AdminResetUserPasswordRequest.builder().applyMutation(adminResetUserPasswordRequest)
                .build());
    }

    /**
     * <p>
     * Responds to an authentication challenge, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return Result of the AdminRespondToAuthChallenge operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminRespondToAuthChallengeResponse adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException,
            UnexpectedLambdaException, InvalidPasswordException, UserLambdaValidationException, InvalidLambdaResponseException,
            TooManyRequestsException, InvalidUserPoolConfigurationException, InternalErrorException, MfaMethodNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AliasExistsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, SoftwareTokenMfaNotFoundException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Responds to an authentication challenge, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRespondToAuthChallengeRequest.Builder}
     * avoiding the need to create one manually via {@link AdminRespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on {@link AdminRespondToAuthChallengeRequest.Builder} to create
     *        a request. The request to respond to the authentication challenge, as an administrator.
     * @return Result of the AdminRespondToAuthChallenge operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminRespondToAuthChallengeResponse adminRespondToAuthChallenge(
            Consumer<AdminRespondToAuthChallengeRequest.Builder> adminRespondToAuthChallengeRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, CodeMismatchException,
            ExpiredCodeException, UnexpectedLambdaException, InvalidPasswordException, UserLambdaValidationException,
            InvalidLambdaResponseException, TooManyRequestsException, InvalidUserPoolConfigurationException,
            InternalErrorException, MfaMethodNotFoundException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, AliasExistsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, SoftwareTokenMfaNotFoundException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest.builder()
                .applyMutation(adminRespondToAuthChallengeRequest).build());
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference, including which MFA options are enabled and if any
     * are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a
     * user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to
     * choose an MFA option will be returned during sign in.
     * </p>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return Result of the AdminSetUserMFAPreference operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserMfaPreferenceResponse adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the user's multi-factor authentication (MFA) preference, including which MFA options are enabled and if any
     * are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a
     * user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to
     * choose an MFA option will be returned during sign in.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserMfaPreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link AdminSetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param adminSetUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on {@link AdminSetUserMFAPreferenceRequest.Builder} to create a
     *        request.
     * @return Result of the AdminSetUserMFAPreference operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserMfaPreferenceResponse adminSetUserMFAPreference(
            Consumer<AdminSetUserMfaPreferenceRequest.Builder> adminSetUserMfaPreferenceRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminSetUserMFAPreference(AdminSetUserMfaPreferenceRequest.builder()
                .applyMutation(adminSetUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * The password can be temporary or permanent. If it is temporary, the user status will be placed into the
     * <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth
     * response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user does not sign in before it
     * expires, the user will not be able to sign in and their password will need to be reset by an administrator.
     * </p>
     * <p>
     * Once the user has set a new password, or the password is permanent, the user status will be set to
     * <code>Confirmed</code>.
     * </p>
     *
     * @param adminSetUserPasswordRequest
     * @return Result of the AdminSetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserPasswordResponse adminSetUserPassword(AdminSetUserPasswordRequest adminSetUserPasswordRequest)
            throws ResourceNotFoundException, NotAuthorizedException, UserNotFoundException, InternalErrorException,
            TooManyRequestsException, InvalidParameterException, InvalidPasswordException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * The password can be temporary or permanent. If it is temporary, the user status will be placed into the
     * <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth
     * response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user does not sign in before it
     * expires, the user will not be able to sign in and their password will need to be reset by an administrator.
     * </p>
     * <p>
     * Once the user has set a new password, or the password is permanent, the user status will be set to
     * <code>Confirmed</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link AdminSetUserPasswordRequest#builder()}
     * </p>
     *
     * @param adminSetUserPasswordRequest
     *        A {@link Consumer} that will call methods on {@link AdminSetUserPasswordRequest.Builder} to create a
     *        request.
     * @return Result of the AdminSetUserPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserPasswordResponse adminSetUserPassword(
            Consumer<AdminSetUserPasswordRequest.Builder> adminSetUserPasswordRequest) throws ResourceNotFoundException,
            NotAuthorizedException, UserNotFoundException, InternalErrorException, TooManyRequestsException,
            InvalidParameterException, InvalidPasswordException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminSetUserPassword(AdminSetUserPasswordRequest.builder().applyMutation(adminSetUserPasswordRequest).build());
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure TOTP software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html"
     * >AdminSetUserMFAPreference</a> instead.
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return Result of the AdminSetUserSettings operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserSettingsResponse adminSetUserSettings(AdminSetUserSettingsRequest adminSetUserSettingsRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure TOTP software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html"
     * >AdminSetUserMFAPreference</a> instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link AdminSetUserSettingsRequest#builder()}
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link AdminSetUserSettingsRequest.Builder} to create a
     *        request. You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return Result of the AdminSetUserSettings operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminSetUserSettingsResponse adminSetUserSettings(
            Consumer<AdminSetUserSettingsRequest.Builder> adminSetUserSettingsRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, UserNotFoundException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminSetUserSettings(AdminSetUserSettingsRequest.builder().applyMutation(adminSetUserSettingsRequest).build());
    }

    /**
     * <p>
     * Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return Result of the AdminUpdateAuthEventFeedback operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateAuthEventFeedbackResponse adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateAuthEventFeedbackRequest.Builder}
     * avoiding the need to create one manually via {@link AdminUpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateAuthEventFeedbackRequest.Builder} to create
     *        a request.
     * @return Result of the AdminUpdateAuthEventFeedback operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateAuthEventFeedbackResponse adminUpdateAuthEventFeedback(
            Consumer<AdminUpdateAuthEventFeedbackRequest.Builder> adminUpdateAuthEventFeedbackRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest.builder()
                .applyMutation(adminUpdateAuthEventFeedbackRequest).build());
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return Result of the AdminUpdateDeviceStatus operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateDeviceStatusResponse adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateDeviceStatusRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateDeviceStatusRequest.Builder} to create a
     *        request. The request to update the device status, as an administrator.
     * @return Result of the AdminUpdateDeviceStatus operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateDeviceStatusResponse adminUpdateDeviceStatus(
            Consumer<AdminUpdateDeviceStatusRequest.Builder> adminUpdateDeviceStatusRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidUserPoolConfigurationException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest.builder().applyMutation(adminUpdateDeviceStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return Result of the AdminUpdateUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateUserAttributesResponse adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException,
            AliasExistsException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link AdminUpdateUserAttributesRequest.Builder} to create a
     *        request. Represents the request to update the user's attributes as an administrator.
     * @return Result of the AdminUpdateUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUpdateUserAttributesResponse adminUpdateUserAttributes(
            Consumer<AdminUpdateUserAttributesRequest.Builder> adminUpdateUserAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, InvalidLambdaResponseException, AliasExistsException, TooManyRequestsException,
            NotAuthorizedException, UserNotFoundException, InternalErrorException, InvalidSmsRoleAccessPolicyException,
            InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return adminUpdateUserAttributes(AdminUpdateUserAttributesRequest.builder()
                .applyMutation(adminUpdateUserAttributesRequest).build());
    }

    /**
     * <p>
     * Signs out users from all devices, as an administrator. It also invalidates all refresh tokens issued to a user.
     * The user's current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour
     * after they are issued.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return Result of the AdminUserGlobalSignOut operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUserGlobalSignOutResponse adminUserGlobalSignOut(AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs out users from all devices, as an administrator. It also invalidates all refresh tokens issued to a user.
     * The user's current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour
     * after they are issued.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUserGlobalSignOutRequest.Builder} avoiding the
     * need to create one manually via {@link AdminUserGlobalSignOutRequest#builder()}
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        A {@link Consumer} that will call methods on {@link AdminUserGlobalSignOutRequest.Builder} to create a
     *        request. The request to sign out of all devices, as an administrator.
     * @return Result of the AdminUserGlobalSignOut operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminUserGlobalSignOutResponse adminUserGlobalSignOut(
            Consumer<AdminUserGlobalSignOutRequest.Builder> adminUserGlobalSignOutRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return adminUserGlobalSignOut(AdminUserGlobalSignOutRequest.builder().applyMutation(adminUserGlobalSignOutRequest)
                .build());
    }

    /**
     * <p>
     * Returns a unique generated shared secret key code for the user account. The request takes an access token or a
     * session string, but not both.
     * </p>
     * <note>
     * <p>
     * Calling AssociateSoftwareToken immediately disassociates the existing software token from the user account. If
     * the user doesn't subsequently verify the software token, their account is essentially set up to authenticate
     * without MFA. If MFA config is set to Optional at the user pool level, the user can then login without MFA.
     * However, if MFA is set to Required for the user pool, the user will be asked to setup a new software token MFA
     * during sign in.
     * </p>
     * </note>
     *
     * @param associateSoftwareTokenRequest
     * @return Result of the AssociateSoftwareToken operation returned by the service.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSoftwareTokenResponse associateSoftwareToken(AssociateSoftwareTokenRequest associateSoftwareTokenRequest)
            throws ConcurrentModificationException, InvalidParameterException, NotAuthorizedException, ResourceNotFoundException,
            InternalErrorException, SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a unique generated shared secret key code for the user account. The request takes an access token or a
     * session string, but not both.
     * </p>
     * <note>
     * <p>
     * Calling AssociateSoftwareToken immediately disassociates the existing software token from the user account. If
     * the user doesn't subsequently verify the software token, their account is essentially set up to authenticate
     * without MFA. If MFA config is set to Optional at the user pool level, the user can then login without MFA.
     * However, if MFA is set to Required for the user pool, the user will be asked to setup a new software token MFA
     * during sign in.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSoftwareTokenRequest#builder()}
     * </p>
     *
     * @param associateSoftwareTokenRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSoftwareTokenRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSoftwareToken operation returned by the service.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSoftwareTokenResponse associateSoftwareToken(
            Consumer<AssociateSoftwareTokenRequest.Builder> associateSoftwareTokenRequest)
            throws ConcurrentModificationException, InvalidParameterException, NotAuthorizedException, ResourceNotFoundException,
            InternalErrorException, SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return associateSoftwareToken(AssociateSoftwareTokenRequest.builder().applyMutation(associateSoftwareTokenRequest)
                .build());
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return Result of the ChangePassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    default ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidPasswordException, NotAuthorizedException, TooManyRequestsException,
            LimitExceededException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangePasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ChangePasswordRequest#builder()}
     * </p>
     *
     * @param changePasswordRequest
     *        A {@link Consumer} that will call methods on {@link ChangePasswordRequest.Builder} to create a request.
     *        Represents the request to change a user password.
     * @return Result of the ChangePassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    default ChangePasswordResponse changePassword(Consumer<ChangePasswordRequest.Builder> changePasswordRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidPasswordException, NotAuthorizedException,
            TooManyRequestsException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return changePassword(ChangePasswordRequest.builder().applyMutation(changePasswordRequest).build());
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     * </p>
     *
     * @param confirmDeviceRequest
     *        Confirms the device request.
     * @return Result of the ConfirmDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ConfirmDeviceResponse confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, InvalidPasswordException, InvalidLambdaResponseException,
            UsernameExistsException, InvalidUserPoolConfigurationException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmDeviceRequest#builder()}
     * </p>
     *
     * @param confirmDeviceRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmDeviceRequest.Builder} to create a request.
     *        Confirms the device request.
     * @return Result of the ConfirmDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ConfirmDeviceResponse confirmDevice(Consumer<ConfirmDeviceRequest.Builder> confirmDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, InvalidPasswordException,
            InvalidLambdaResponseException, UsernameExistsException, InvalidUserPoolConfigurationException,
            TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return confirmDevice(ConfirmDeviceRequest.builder().applyMutation(confirmDeviceRequest).build());
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return Result of the ConfirmForgotPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmForgotPasswordResponse confirmForgotPassword(ConfirmForgotPasswordRequest confirmForgotPasswordRequest)
            throws ResourceNotFoundException, UnexpectedLambdaException, UserLambdaValidationException,
            InvalidParameterException, InvalidPasswordException, NotAuthorizedException, CodeMismatchException,
            ExpiredCodeException, TooManyFailedAttemptsException, InvalidLambdaResponseException, TooManyRequestsException,
            LimitExceededException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmForgotPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmForgotPasswordRequest#builder()}
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmForgotPasswordRequest.Builder} to create a
     *        request. The request representing the confirmation for a password reset.
     * @return Result of the ConfirmForgotPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmForgotPasswordResponse confirmForgotPassword(
            Consumer<ConfirmForgotPasswordRequest.Builder> confirmForgotPasswordRequest) throws ResourceNotFoundException,
            UnexpectedLambdaException, UserLambdaValidationException, InvalidParameterException, InvalidPasswordException,
            NotAuthorizedException, CodeMismatchException, ExpiredCodeException, TooManyFailedAttemptsException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return confirmForgotPassword(ConfirmForgotPasswordRequest.builder().applyMutation(confirmForgotPasswordRequest).build());
    }

    /**
     * <p>
     * Confirms registration of a user and handles the existing alias from a previous user.
     * </p>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return Result of the ConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default ConfirmSignUpResponse confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            TooManyFailedAttemptsException, CodeMismatchException, ExpiredCodeException, InvalidLambdaResponseException,
            AliasExistsException, TooManyRequestsException, LimitExceededException, UserNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms registration of a user and handles the existing alias from a previous user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmSignUpRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param confirmSignUpRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmSignUpRequest.Builder} to create a request.
     *        Represents the request to confirm registration of a user.
     * @return Result of the ConfirmSignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyFailedAttemptsException
     *         This exception is thrown when the user has made too many failed attempts for a given action (e.g., sign
     *         in).
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default ConfirmSignUpResponse confirmSignUp(Consumer<ConfirmSignUpRequest.Builder> confirmSignUpRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException, CodeMismatchException,
            ExpiredCodeException, InvalidLambdaResponseException, AliasExistsException, TooManyRequestsException,
            LimitExceededException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return confirmSignUp(ConfirmSignUpRequest.builder().applyMutation(confirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws GroupExistsException
     *         This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws InvalidParameterException,
            GroupExistsException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException,
            NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws GroupExistsException
     *         This exception is thrown when Amazon Cognito encounters a group that already exists in the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws InvalidParameterException, GroupExistsException, ResourceNotFoundException, TooManyRequestsException,
            LimitExceededException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates an identity provider for a user pool.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws DuplicateProviderException
     *         This exception is thrown when the provider is already supported by the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest)
            throws InvalidParameterException, DuplicateProviderException, ResourceNotFoundException, NotAuthorizedException,
            TooManyRequestsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an identity provider for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param createIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws DuplicateProviderException
     *         This exception is thrown when the provider is already supported by the user pool.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIdentityProviderResponse createIdentityProvider(
            Consumer<CreateIdentityProviderRequest.Builder> createIdentityProviderRequest) throws InvalidParameterException,
            DuplicateProviderException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return createIdentityProvider(CreateIdentityProviderRequest.builder().applyMutation(createIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     * </p>
     *
     * @param createResourceServerRequest
     * @return Result of the CreateResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceServerResponse createResourceServer(CreateResourceServerRequest createResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceServerRequest#builder()}
     * </p>
     *
     * @param createResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceServerResponse createResourceServer(
            Consumer<CreateResourceServerRequest.Builder> createResourceServerRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, LimitExceededException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return createResourceServer(CreateResourceServerRequest.builder().applyMutation(createResourceServerRequest).build());
    }

    /**
     * <p>
     * Creates the user import job.
     * </p>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return Result of the CreateUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserImportJobResponse createUserImportJob(CreateUserImportJobRequest createUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, PreconditionNotMetException,
            NotAuthorizedException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserImportJobRequest#builder()}
     * </p>
     *
     * @param createUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserImportJobRequest.Builder} to create a
     *        request. Represents the request to create the user import job.
     * @return Result of the CreateUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserImportJobResponse createUserImportJob(
            Consumer<CreateUserImportJobRequest.Builder> createUserImportJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, PreconditionNotMetException, NotAuthorizedException,
            LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return createUserImportJob(CreateUserImportJobRequest.builder().applyMutation(createUserImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return Result of the CreateUserPool operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserPoolResponse createUserPool(CreateUserPoolRequest createUserPoolRequest) throws InvalidParameterException,
            TooManyRequestsException, LimitExceededException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, NotAuthorizedException,
            UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserPoolRequest#builder()}
     * </p>
     *
     * @param createUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolRequest.Builder} to create a request.
     *        Represents the request to create a user pool.
     * @return Result of the CreateUserPool operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserPoolResponse createUserPool(Consumer<CreateUserPoolRequest.Builder> createUserPoolRequest)
            throws InvalidParameterException, TooManyRequestsException, LimitExceededException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException,
            NotAuthorizedException, UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return createUserPool(CreateUserPoolRequest.builder().applyMutation(createUserPoolRequest).build());
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <p>
     * When you create a new user pool client, token revocation is automatically enabled. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return Result of the CreateUserPoolClient operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ScopeDoesNotExistException
     *         This exception is thrown when the specified scope does not exist.
     * @throws InvalidOAuthFlowException
     *         This exception is thrown when the specified OAuth flow is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserPoolClientResponse createUserPoolClient(CreateUserPoolClientRequest createUserPoolClientRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException,
            NotAuthorizedException, ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <p>
     * When you create a new user pool client, token revocation is automatically enabled. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param createUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to create a user pool client.
     * @return Result of the CreateUserPoolClient operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ScopeDoesNotExistException
     *         This exception is thrown when the specified scope does not exist.
     * @throws InvalidOAuthFlowException
     *         This exception is thrown when the specified OAuth flow is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserPoolClientResponse createUserPoolClient(
            Consumer<CreateUserPoolClientRequest.Builder> createUserPoolClientRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, LimitExceededException, NotAuthorizedException,
            ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return createUserPoolClient(CreateUserPoolClientRequest.builder().applyMutation(createUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     *
     * @param createUserPoolDomainRequest
     * @return Result of the CreateUserPoolDomain operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserPoolDomainResponse createUserPoolDomain(CreateUserPoolDomainRequest createUserPoolDomainRequest)
            throws InvalidParameterException, NotAuthorizedException, ResourceNotFoundException, LimitExceededException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param createUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserPoolDomain operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserPoolDomainResponse createUserPoolDomain(
            Consumer<CreateUserPoolDomainRequest.Builder> createUserPoolDomainRequest) throws InvalidParameterException,
            NotAuthorizedException, ResourceNotFoundException, LimitExceededException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return createUserPoolDomain(CreateUserPoolDomainRequest.builder().applyMutation(createUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an identity provider for a user pool.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedIdentityProviderException
     *         This exception is thrown when the specified identifier is not supported.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest)
            throws InvalidParameterException, UnsupportedIdentityProviderException, ResourceNotFoundException,
            NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an identity provider for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deleteIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedIdentityProviderException
     *         This exception is thrown when the specified identifier is not supported.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIdentityProviderResponse deleteIdentityProvider(
            Consumer<DeleteIdentityProviderRequest.Builder> deleteIdentityProviderRequest) throws InvalidParameterException,
            UnsupportedIdentityProviderException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return deleteIdentityProvider(DeleteIdentityProviderRequest.builder().applyMutation(deleteIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     *
     * @param deleteResourceServerRequest
     * @return Result of the DeleteResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceServerResponse deleteResourceServer(DeleteResourceServerRequest deleteResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceServerRequest#builder()}
     * </p>
     *
     * @param deleteResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceServerResponse deleteResourceServer(
            Consumer<DeleteResourceServerRequest.Builder> deleteResourceServerRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return deleteResourceServer(DeleteResourceServerRequest.builder().applyMutation(deleteResourceServerRequest).build());
    }

    /**
     * <p>
     * Allows a user to delete himself or herself.
     * </p>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to delete himself or herself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     *        Represents the request to delete a user.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return Result of the DeleteUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserAttributesResponse deleteUserAttributes(DeleteUserAttributesRequest deleteUserAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserAttributesRequest.Builder} to create a
     *        request. Represents the request to delete user attributes.
     * @return Result of the DeleteUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserAttributesResponse deleteUserAttributes(
            Consumer<DeleteUserAttributesRequest.Builder> deleteUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return deleteUserAttributes(DeleteUserAttributesRequest.builder().applyMutation(deleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return Result of the DeleteUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserPoolResponse deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserImportInProgressException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserPoolRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolRequest.Builder} to create a request.
     *        Represents the request to delete a user pool.
     * @return Result of the DeleteUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserPoolResponse deleteUserPool(Consumer<DeleteUserPoolRequest.Builder> deleteUserPoolRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserImportInProgressException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return deleteUserPool(DeleteUserPoolRequest.builder().applyMutation(deleteUserPoolRequest).build());
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return Result of the DeleteUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPoolClientResponse deleteUserPoolClient(DeleteUserPoolClientRequest deleteUserPoolClientRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolClientRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to delete a user pool client.
     * @return Result of the DeleteUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPoolClientResponse deleteUserPoolClient(
            Consumer<DeleteUserPoolClientRequest.Builder> deleteUserPoolClientRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return deleteUserPoolClient(DeleteUserPoolClientRequest.builder().applyMutation(deleteUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return Result of the DeleteUserPoolDomain operation returned by the service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPoolDomainResponse deleteUserPoolDomain(DeleteUserPoolDomainRequest deleteUserPoolDomainRequest)
            throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserPoolDomain operation returned by the service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserPoolDomainResponse deleteUserPoolDomain(
            Consumer<DeleteUserPoolDomainRequest.Builder> deleteUserPoolDomainRequest) throws NotAuthorizedException,
            InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return deleteUserPoolDomain(DeleteUserPoolDomainRequest.builder().applyMutation(deleteUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific identity provider.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return Result of the DescribeIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderResponse describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeIdentityProviderRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderResponse describeIdentityProvider(
            Consumer<DescribeIdentityProviderRequest.Builder> describeIdentityProviderRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return describeIdentityProvider(DescribeIdentityProviderRequest.builder().applyMutation(describeIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return Result of the DescribeResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceServerResponse describeResourceServer(DescribeResourceServerRequest describeResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceServerRequest#builder()}
     * </p>
     *
     * @param describeResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceServerResponse describeResourceServer(
            Consumer<DescribeResourceServerRequest.Builder> describeResourceServerRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return describeResourceServer(DescribeResourceServerRequest.builder().applyMutation(describeResourceServerRequest)
                .build());
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     *
     * @param describeRiskConfigurationRequest
     * @return Result of the DescribeRiskConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRiskConfigurationResponse describeRiskConfiguration(
            DescribeRiskConfigurationRequest describeRiskConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserPoolAddOnNotEnabledException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRiskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRiskConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRiskConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRiskConfigurationResponse describeRiskConfiguration(
            Consumer<DescribeRiskConfigurationRequest.Builder> describeRiskConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return describeRiskConfiguration(DescribeRiskConfigurationRequest.builder()
                .applyMutation(describeRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return Result of the DescribeUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserImportJobResponse describeUserImportJob(DescribeUserImportJobRequest describeUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserImportJobRequest#builder()}
     * </p>
     *
     * @param describeUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserImportJobRequest.Builder} to create a
     *        request. Represents the request to describe the user import job.
     * @return Result of the DescribeUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserImportJobResponse describeUserImportJob(
            Consumer<DescribeUserImportJobRequest.Builder> describeUserImportJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return describeUserImportJob(DescribeUserImportJobRequest.builder().applyMutation(describeUserImportJobRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return Result of the DescribeUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUserPoolResponse describeUserPool(DescribeUserPoolRequest describeUserPoolRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeUserPoolRequest#builder()}
     * </p>
     *
     * @param describeUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolRequest.Builder} to create a request.
     *        Represents the request to describe the user pool.
     * @return Result of the DescribeUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUserPoolResponse describeUserPool(Consumer<DescribeUserPoolRequest.Builder> describeUserPoolRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return describeUserPool(DescribeUserPoolRequest.builder().applyMutation(describeUserPoolRequest).build());
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return Result of the DescribeUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserPoolClientResponse describeUserPoolClient(DescribeUserPoolClientRequest describeUserPoolClientRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolClientRequest#builder()}
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to describe a user pool client.
     * @return Result of the DescribeUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserPoolClientResponse describeUserPoolClient(
            Consumer<DescribeUserPoolClientRequest.Builder> describeUserPoolClientRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return describeUserPoolClient(DescribeUserPoolClientRequest.builder().applyMutation(describeUserPoolClientRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     *
     * @param describeUserPoolDomainRequest
     * @return Result of the DescribeUserPoolDomain operation returned by the service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserPoolDomainResponse describeUserPoolDomain(DescribeUserPoolDomainRequest describeUserPoolDomainRequest)
            throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param describeUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserPoolDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeUserPoolDomain operation returned by the service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserPoolDomainResponse describeUserPoolDomain(
            Consumer<DescribeUserPoolDomainRequest.Builder> describeUserPoolDomainRequest) throws NotAuthorizedException,
            InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return describeUserPoolDomain(DescribeUserPoolDomainRequest.builder().applyMutation(describeUserPoolDomainRequest)
                .build());
    }

    /**
     * <p>
     * Forgets the specified device.
     * </p>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return Result of the ForgetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ForgetDeviceResponse forgetDevice(ForgetDeviceRequest forgetDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InvalidUserPoolConfigurationException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the specified device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ForgetDeviceRequest#builder()}
     * </p>
     *
     * @param forgetDeviceRequest
     *        A {@link Consumer} that will call methods on {@link ForgetDeviceRequest.Builder} to create a request.
     *        Represents the request to forget the device.
     * @return Result of the ForgetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default ForgetDeviceResponse forgetDevice(Consumer<ForgetDeviceRequest.Builder> forgetDeviceRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            InvalidUserPoolConfigurationException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return forgetDevice(ForgetDeviceRequest.builder().applyMutation(forgetDeviceRequest).build());
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method
     * used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering
     * User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. If neither a verified phone number nor a verified
     * email exists, an <code>InvalidParameterException</code> is thrown. To use the confirmation code for resetting the
     * password, call <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html"
     * >ConfirmForgotPassword</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return Result of the ForgotPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    default ForgotPasswordResponse forgotPassword(ForgotPasswordRequest forgotPasswordRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException,
            CodeDeliveryFailureException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method
     * used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering
     * User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. If neither a verified phone number nor a verified
     * email exists, an <code>InvalidParameterException</code> is thrown. To use the confirmation code for resetting the
     * password, call <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html"
     * >ConfirmForgotPassword</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgotPasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ForgotPasswordRequest#builder()}
     * </p>
     *
     * @param forgotPasswordRequest
     *        A {@link Consumer} that will call methods on {@link ForgotPasswordRequest.Builder} to create a request.
     *        Represents the request to reset a user's password.
     * @return Result of the ForgotPassword operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    default ForgotPasswordResponse forgotPassword(Consumer<ForgotPasswordRequest.Builder> forgotPasswordRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException,
            LimitExceededException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return forgotPassword(ForgotPasswordRequest.builder().applyMutation(forgotPasswordRequest).build());
    }

    /**
     * <p>
     * Gets the header information for the .csv file to be used as input for the user import job.
     * </p>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information for the .csv file for the user import job.
     * @return Result of the GetCSVHeader operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCsvHeaderResponse getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the header information for the .csv file to be used as input for the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCsvHeaderRequest.Builder} avoiding the need to
     * create one manually via {@link GetCsvHeaderRequest#builder()}
     * </p>
     *
     * @param getCsvHeaderRequest
     *        A {@link Consumer} that will call methods on {@link GetCSVHeaderRequest.Builder} to create a request.
     *        Represents the request to get the header information for the .csv file for the user import job.
     * @return Result of the GetCSVHeader operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCsvHeaderResponse getCSVHeader(Consumer<GetCsvHeaderRequest.Builder> getCsvHeaderRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getCSVHeader(GetCsvHeaderRequest.builder().applyMutation(getCsvHeaderRequest).build());
    }

    /**
     * <p>
     * Gets the device.
     * </p>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidUserPoolConfigurationException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRequest.Builder} to create a request.
     *        Represents the request to get the device.
     * @return Result of the GetDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidUserPoolConfigurationException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupRequest.Builder} to create a request.
     * @return Result of the GetGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Gets the specified identity provider.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return Result of the GetIdentityProviderByIdentifier operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityProviderByIdentifierResponse getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityProviderByIdentifierRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityProviderByIdentifierRequest#builder()}
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityProviderByIdentifierRequest.Builder} to
     *        create a request.
     * @return Result of the GetIdentityProviderByIdentifier operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityProviderByIdentifierResponse getIdentityProviderByIdentifier(
            Consumer<GetIdentityProviderByIdentifierRequest.Builder> getIdentityProviderByIdentifierRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest.builder()
                .applyMutation(getIdentityProviderByIdentifierRequest).build());
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate.
     * </p>
     *
     * @param getSigningCertificateRequest
     *        Request to get a signing certificate from Cognito.
     * @return Result of the GetSigningCertificate operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSigningCertificateResponse getSigningCertificate(GetSigningCertificateRequest getSigningCertificateRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSigningCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSigningCertificateRequest#builder()}
     * </p>
     *
     * @param getSigningCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetSigningCertificateRequest.Builder} to create a
     *        request. Request to get a signing certificate from Cognito.
     * @return Result of the GetSigningCertificate operation returned by the service.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSigningCertificateResponse getSigningCertificate(
            Consumer<GetSigningCertificateRequest.Builder> getSigningCertificateRequest) throws InternalErrorException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return getSigningCertificate(GetSigningCertificateRequest.builder().applyMutation(getSigningCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing
     * is set for the particular client, but there is an existing pool level customization (app <code>clientId</code>
     * will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return Result of the GetUICustomization operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUiCustomizationResponse getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing
     * is set for the particular client, but there is an existing pool level customization (app <code>clientId</code>
     * will be <code>ALL</code>), then that is returned. If nothing is present, then an empty shape is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link GetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param getUiCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link GetUICustomizationRequest.Builder} to create a
     *        request.
     * @return Result of the GetUICustomization operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUiCustomizationResponse getUICustomization(Consumer<GetUiCustomizationRequest.Builder> getUiCustomizationRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getUICustomization(GetUiCustomizationRequest.builder().applyMutation(getUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return Result of the GetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(GetUserRequest getUserRequest) throws ResourceNotFoundException, InvalidParameterException,
            NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on {@link GetUserRequest.Builder} to create a request.
     *        Represents the request to get information about the user.
     * @return Result of the GetUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUserResponse getUser(Consumer<GetUserRequest.Builder> getUserRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Gets the user attribute verification code for the specified attribute name.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return Result of the GetUserAttributeVerificationCode operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserAttributeVerificationCodeResponse getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UnexpectedLambdaException,
            UserLambdaValidationException, InvalidLambdaResponseException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException,
            LimitExceededException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user attribute verification code for the specified attribute name.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserAttributeVerificationCodeRequest.Builder}
     * avoiding the need to create one manually via {@link GetUserAttributeVerificationCodeRequest#builder()}
     * </p>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        A {@link Consumer} that will call methods on {@link GetUserAttributeVerificationCodeRequest.Builder} to
     *        create a request. Represents the request to get user attribute verification.
     * @return Result of the GetUserAttributeVerificationCode operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserAttributeVerificationCodeResponse getUserAttributeVerificationCode(
            Consumer<GetUserAttributeVerificationCodeRequest.Builder> getUserAttributeVerificationCodeRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException,
            CodeDeliveryFailureException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest.builder()
                .applyMutation(getUserAttributeVerificationCodeRequest).build());
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     * @return Result of the GetUserPoolMfaConfig operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserPoolMfaConfigResponse getUserPoolMfaConfig(GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest)
            throws InvalidParameterException, TooManyRequestsException, ResourceNotFoundException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetUserPoolMfaConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetUserPoolMfaConfig operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserPoolMfaConfigResponse getUserPoolMfaConfig(
            Consumer<GetUserPoolMfaConfigRequest.Builder> getUserPoolMfaConfigRequest) throws InvalidParameterException,
            TooManyRequestsException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return getUserPoolMfaConfig(GetUserPoolMfaConfigRequest.builder().applyMutation(getUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * Signs out users from all devices. It also invalidates all refresh tokens issued to a user. The user's current
     * access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they are issued.
     * </p>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return Result of the GlobalSignOut operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default GlobalSignOutResponse globalSignOut(GlobalSignOutRequest globalSignOutRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs out users from all devices. It also invalidates all refresh tokens issued to a user. The user's current
     * access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they are issued.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GlobalSignOutRequest.Builder} avoiding the need to
     * create one manually via {@link GlobalSignOutRequest#builder()}
     * </p>
     *
     * @param globalSignOutRequest
     *        A {@link Consumer} that will call methods on {@link GlobalSignOutRequest.Builder} to create a request.
     *        Represents the request to sign out all devices.
     * @return Result of the GlobalSignOut operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default GlobalSignOutResponse globalSignOut(Consumer<GlobalSignOutRequest.Builder> globalSignOutRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotConfirmedException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return globalSignOut(GlobalSignOutRequest.builder().applyMutation(globalSignOutRequest).build());
    }

    /**
     * <p>
     * Initiates the authentication flow.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return Result of the InitiateAuth operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default InitiateAuthResponse initiateAuth(InitiateAuthRequest initiateAuthRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, TooManyRequestsException, UnexpectedLambdaException,
            InvalidUserPoolConfigurationException, UserLambdaValidationException, InvalidLambdaResponseException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the authentication flow.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateAuthRequest.Builder} avoiding the need to
     * create one manually via {@link InitiateAuthRequest#builder()}
     * </p>
     *
     * @param initiateAuthRequest
     *        A {@link Consumer} that will call methods on {@link InitiateAuthRequest.Builder} to create a request.
     *        Initiates the authentication request.
     * @return Result of the InitiateAuth operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default InitiateAuthResponse initiateAuth(Consumer<InitiateAuthRequest.Builder> initiateAuthRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException,
            UnexpectedLambdaException, InvalidUserPoolConfigurationException, UserLambdaValidationException,
            InvalidLambdaResponseException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return initiateAuth(InitiateAuthRequest.builder().applyMutation(initiateAuthRequest).build());
    }

    /**
     * <p>
     * Lists the devices.
     * </p>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return Result of the ListDevices operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, InvalidUserPoolConfigurationException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     *        Represents the request to list the devices.
     * @return Result of the ListDevices operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException,
            InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client
     *             .listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client
     *             .listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityProvidersRequest.Builder} to create a
     *        request.
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about all identity providers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityProvidersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     *
     * @param listResourceServersRequest
     * @return Result of the ListResourceServers operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersResponse listResourceServers(ListResourceServersRequest listResourceServersRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceServersRequest#builder()}
     * </p>
     *
     * @param listResourceServersRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceServersRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceServers operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersResponse listResourceServers(
            Consumer<ListResourceServersRequest.Builder> listResourceServersRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listResourceServers(ListResourceServersRequest.builder().applyMutation(listResourceServersRequest).build());
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client.listResourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client
     *             .listResourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client.listResourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersIterable listResourceServersPaginator(ListResourceServersRequest listResourceServersRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client.listResourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client
     *             .listResourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable responses = client.listResourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceServersRequest#builder()}
     * </p>
     *
     * @param listResourceServersRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceServersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersIterable listResourceServersPaginator(
            Consumer<ListResourceServersRequest.Builder> listResourceServersRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listResourceServersPaginator(ListResourceServersRequest.builder().applyMutation(listResourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the user import jobs.
     * </p>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return Result of the ListUserImportJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserImportJobsResponse listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserImportJobsRequest#builder()}
     * </p>
     *
     * @param listUserImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserImportJobsRequest.Builder} to create a
     *        request. Represents the request to list the user import jobs.
     * @return Result of the ListUserImportJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserImportJobsResponse listUserImportJobs(Consumer<ListUserImportJobsRequest.Builder> listUserImportJobsRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUserImportJobs(ListUserImportJobsRequest.builder().applyMutation(listUserImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return Result of the ListUserPoolClients operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsResponse listUserPoolClients(ListUserPoolClientsRequest listUserPoolClientsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolClientsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserPoolClientsRequest#builder()}
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolClientsRequest.Builder} to create a
     *        request. Represents the request to list the user pool clients.
     * @return Result of the ListUserPoolClients operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsResponse listUserPoolClients(
            Consumer<ListUserPoolClientsRequest.Builder> listUserPoolClientsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUserPoolClients(ListUserPoolClientsRequest.builder().applyMutation(listUserPoolClientsRequest).build());
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client.listUserPoolClientsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client
     *             .listUserPoolClientsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client.listUserPoolClientsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsIterable listUserPoolClientsPaginator(ListUserPoolClientsRequest listUserPoolClientsRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client.listUserPoolClientsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client
     *             .listUserPoolClientsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable responses = client.listUserPoolClientsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolClientsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserPoolClientsRequest#builder()}
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolClientsRequest.Builder} to create a
     *        request. Represents the request to list the user pool clients.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsIterable listUserPoolClientsPaginator(
            Consumer<ListUserPoolClientsRequest.Builder> listUserPoolClientsRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUserPoolClientsPaginator(ListUserPoolClientsRequest.builder().applyMutation(listUserPoolClientsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return Result of the ListUserPools operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsResponse listUserPools(ListUserPoolsRequest listUserPoolsRequest) throws InvalidParameterException,
            TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserPoolsRequest#builder()}
     * </p>
     *
     * @param listUserPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolsRequest.Builder} to create a request.
     *        Represents the request to list user pools.
     * @return Result of the ListUserPools operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsResponse listUserPools(Consumer<ListUserPoolsRequest.Builder> listUserPoolsRequest)
            throws InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUserPools(ListUserPoolsRequest.builder().applyMutation(listUserPoolsRequest).build());
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client.listUserPoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client
     *             .listUserPoolsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client.listUserPoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsIterable listUserPoolsPaginator(ListUserPoolsRequest listUserPoolsRequest)
            throws InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user pools associated with an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client.listUserPoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client
     *             .listUserPoolsPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable responses = client.listUserPoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserPoolsRequest#builder()}
     * </p>
     *
     * @param listUserPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserPoolsRequest.Builder} to create a request.
     *        Represents the request to list user pools.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsIterable listUserPoolsPaginator(Consumer<ListUserPoolsRequest.Builder> listUserPoolsRequest)
            throws InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUserPoolsPaginator(ListUserPoolsRequest.builder().applyMutation(listUserPoolsRequest).build());
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     *        Represents the request to list users.
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client
     *             .listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client
     *             .listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     *        Represents the request to list users.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param listUsersInGroupRequest
     * @return Result of the ListUsersInGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupResponse listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersInGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsersInGroupRequest#builder()}
     * </p>
     *
     * @param listUsersInGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersInGroupRequest.Builder} to create a request.
     * @return Result of the ListUsersInGroup operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupResponse listUsersInGroup(Consumer<ListUsersInGroupRequest.Builder> listUsersInGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUsersInGroup(ListUsersInGroupRequest.builder().applyMutation(listUsersInGroupRequest).build());
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client.listUsersInGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client
     *             .listUsersInGroupPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client.listUsersInGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUsersInGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupIterable listUsersInGroupPaginator(ListUsersInGroupRequest listUsersInGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client.listUsersInGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client
     *             .listUsersInGroupPaginator(request);
     *     for (software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable responses = client.listUsersInGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersInGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsersInGroupRequest#builder()}
     * </p>
     *
     * @param listUsersInGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersInGroupRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupIterable listUsersInGroupPaginator(Consumer<ListUsersInGroupRequest.Builder> listUsersInGroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return listUsersInGroupPaginator(ListUsersInGroupRequest.builder().applyMutation(listUsersInGroupRequest).build());
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return Result of the ResendConfirmationCode operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendConfirmationCodeResponse resendConfirmationCode(ResendConfirmationCodeRequest resendConfirmationCodeRequest)
            throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException,
            UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException,
            LimitExceededException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, UserNotFoundException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResendConfirmationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link ResendConfirmationCodeRequest#builder()}
     * </p>
     *
     * @param resendConfirmationCodeRequest
     *        A {@link Consumer} that will call methods on {@link ResendConfirmationCodeRequest.Builder} to create a
     *        request. Represents the request to resend the confirmation code.
     * @return Result of the ResendConfirmationCode operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default ResendConfirmationCodeResponse resendConfirmationCode(
            Consumer<ResendConfirmationCodeRequest.Builder> resendConfirmationCodeRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException,
            CodeDeliveryFailureException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return resendConfirmationCode(ResendConfirmationCodeRequest.builder().applyMutation(resendConfirmationCodeRequest)
                .build());
    }

    /**
     * <p>
     * Responds to the authentication challenge.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return Result of the RespondToAuthChallenge operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default RespondToAuthChallengeResponse respondToAuthChallenge(RespondToAuthChallengeRequest respondToAuthChallengeRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, CodeMismatchException,
            ExpiredCodeException, UnexpectedLambdaException, UserLambdaValidationException, InvalidPasswordException,
            InvalidLambdaResponseException, TooManyRequestsException, InvalidUserPoolConfigurationException,
            MfaMethodNotFoundException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AliasExistsException,
            InternalErrorException, SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Responds to the authentication challenge.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondToAuthChallengeRequest.Builder} avoiding the
     * need to create one manually via {@link RespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param respondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on {@link RespondToAuthChallengeRequest.Builder} to create a
     *        request. The request to respond to an authentication challenge.
     * @return Result of the RespondToAuthChallenge operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws MfaMethodNotFoundException
     *         This exception is thrown when Amazon Cognito cannot find a multi-factor authentication (MFA) method.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default RespondToAuthChallengeResponse respondToAuthChallenge(
            Consumer<RespondToAuthChallengeRequest.Builder> respondToAuthChallengeRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException,
            UnexpectedLambdaException, UserLambdaValidationException, InvalidPasswordException, InvalidLambdaResponseException,
            TooManyRequestsException, InvalidUserPoolConfigurationException, MfaMethodNotFoundException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AliasExistsException,
            InternalErrorException, SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return respondToAuthChallenge(RespondToAuthChallengeRequest.builder().applyMutation(respondToAuthChallengeRequest)
                .build());
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can
     * not use the revoked token to access Cognito authenticated APIs.
     * </p>
     *
     * @param revokeTokenRequest
     * @return Result of the RevokeToken operation returned by the service.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws UnauthorizedException
     *         This exception is thrown when the request is not authorized. This can happen due to an invalid access
     *         token in the request.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedOperationException
     *         This exception is thrown when you attempt to perform an operation that is not enabled for the user pool
     *         client.
     * @throws UnsupportedTokenTypeException
     *         This exception is thrown when an unsupported token is passed to an operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeTokenResponse revokeToken(RevokeTokenRequest revokeTokenRequest) throws TooManyRequestsException,
            InternalErrorException, UnauthorizedException, InvalidParameterException,
            software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException,
            UnsupportedTokenTypeException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can
     * not use the revoked token to access Cognito authenticated APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeTokenRequest.Builder} avoiding the need to
     * create one manually via {@link RevokeTokenRequest#builder()}
     * </p>
     *
     * @param revokeTokenRequest
     *        A {@link Consumer} that will call methods on {@link RevokeTokenRequest.Builder} to create a request.
     * @return Result of the RevokeToken operation returned by the service.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws UnauthorizedException
     *         This exception is thrown when the request is not authorized. This can happen due to an invalid access
     *         token in the request.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedOperationException
     *         This exception is thrown when you attempt to perform an operation that is not enabled for the user pool
     *         client.
     * @throws UnsupportedTokenTypeException
     *         This exception is thrown when an unsupported token is passed to an operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    default RevokeTokenResponse revokeToken(Consumer<RevokeTokenRequest.Builder> revokeTokenRequest)
            throws TooManyRequestsException, InternalErrorException, UnauthorizedException, InvalidParameterException,
            software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException,
            UnsupportedTokenTypeException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return revokeToken(RevokeTokenRequest.builder().applyMutation(revokeTokenRequest).build());
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To enable Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     *
     * @param setRiskConfigurationRequest
     * @return Result of the SetRiskConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRiskConfigurationResponse setRiskConfiguration(SetRiskConfigurationRequest setRiskConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            UserPoolAddOnNotEnabledException, CodeDeliveryFailureException, InvalidEmailRoleAccessPolicyException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To enable Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRiskConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link SetRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param setRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link SetRiskConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the SetRiskConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetRiskConfigurationResponse setRiskConfiguration(
            Consumer<SetRiskConfigurationRequest.Builder> setRiskConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserPoolAddOnNotEnabledException,
            CodeDeliveryFailureException, InvalidEmailRoleAccessPolicyException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return setRiskConfiguration(SetRiskConfigurationRequest.builder().applyMutation(setRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets the UI customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration will be used for every client that has no UI customization set previously. If you specify
     * UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code>
     * configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return Result of the SetUICustomization operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUiCustomizationResponse setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the UI customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration will be used for every client that has no UI customization set previously. If you specify
     * UI customization settings for a particular client, it will no longer fall back to the <code>ALL</code>
     * configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link SetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param setUiCustomizationRequest
     *        A {@link Consumer} that will call methods on {@link SetUICustomizationRequest.Builder} to create a
     *        request.
     * @return Result of the SetUICustomization operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUiCustomizationResponse setUICustomization(Consumer<SetUiCustomizationRequest.Builder> setUiCustomizationRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return setUICustomization(SetUiCustomizationRequest.builder().applyMutation(setUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are enabled and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a
     * challenge to choose an MFA option will be returned during sign in. If an MFA type is enabled for a user, the user
     * will be prompted for MFA during all sign in attempts, unless device tracking is turned on and the device has been
     * trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign in attempts,
     * disable MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     *
     * @param setUserMfaPreferenceRequest
     * @return Result of the SetUserMFAPreference operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUserMfaPreferenceResponse setUserMFAPreference(SetUserMfaPreferenceRequest setUserMfaPreferenceRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are enabled and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a
     * challenge to choose an MFA option will be returned during sign in. If an MFA type is enabled for a user, the user
     * will be prompted for MFA during all sign in attempts, unless device tracking is turned on and the device has been
     * trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign in attempts,
     * disable MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserMfaPreferenceRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param setUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on {@link SetUserMFAPreferenceRequest.Builder} to create a
     *        request.
     * @return Result of the SetUserMFAPreference operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUserMfaPreferenceResponse setUserMFAPreference(
            Consumer<SetUserMfaPreferenceRequest.Builder> setUserMfaPreferenceRequest) throws ResourceNotFoundException,
            InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return setUserMFAPreference(SetUserMfaPreferenceRequest.builder().applyMutation(setUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Set the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param setUserPoolMfaConfigRequest
     * @return Result of the SetUserPoolMfaConfig operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUserPoolMfaConfigResponse setUserPoolMfaConfig(SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest)
            throws InvalidParameterException, TooManyRequestsException, ResourceNotFoundException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param setUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on {@link SetUserPoolMfaConfigRequest.Builder} to create a
     *        request.
     * @return Result of the SetUserPoolMfaConfig operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default SetUserPoolMfaConfigResponse setUserPoolMfaConfig(
            Consumer<SetUserPoolMfaConfigRequest.Builder> setUserPoolMfaConfigRequest) throws InvalidParameterException,
            TooManyRequestsException, ResourceNotFoundException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, NotAuthorizedException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return setUserPoolMfaConfig(SetUserPoolMfaConfigRequest.builder().applyMutation(setUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure TOTP software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html"
     * >SetUserMFAPreference</a> instead.
     * </p>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return Result of the SetUserSettings operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default SetUserSettingsResponse setUserSettings(SetUserSettingsRequest setUserSettingsRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure TOTP software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html"
     * >SetUserMFAPreference</a> instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link SetUserSettingsRequest#builder()}
     * </p>
     *
     * @param setUserSettingsRequest
     *        A {@link Consumer} that will call methods on {@link SetUserSettingsRequest.Builder} to create a request.
     *        Represents the request to set user settings.
     * @return Result of the SetUserSettings operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default SetUserSettingsResponse setUserSettings(Consumer<SetUserSettingsRequest.Builder> setUserSettingsRequest)
            throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return setUserSettings(SetUserSettingsRequest.builder().applyMutation(setUserSettingsRequest).build());
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return Result of the SignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default SignUpResponse signUp(SignUpRequest signUpRequest) throws ResourceNotFoundException, InvalidParameterException,
            UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, InvalidPasswordException,
            InvalidLambdaResponseException, UsernameExistsException, TooManyRequestsException, InternalErrorException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException,
            CodeDeliveryFailureException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignUpRequest.Builder} avoiding the need to create
     * one manually via {@link SignUpRequest#builder()}
     * </p>
     *
     * @param signUpRequest
     *        A {@link Consumer} that will call methods on {@link SignUpRequest.Builder} to create a request. Represents
     *        the request to register a user.
     * @return Result of the SignUp operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidPasswordException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid password.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws UsernameExistsException
     *         This exception is thrown when Amazon Cognito encounters a user name that already exists in the user pool.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default SignUpResponse signUp(Consumer<SignUpRequest.Builder> signUpRequest) throws ResourceNotFoundException,
            InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException,
            InvalidPasswordException, InvalidLambdaResponseException, UsernameExistsException, TooManyRequestsException,
            InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return signUp(SignUpRequest.builder().applyMutation(signUpRequest).build());
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return Result of the StartUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUserImportJobResponse startUserImportJob(StartUserImportJobRequest startUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException,
            PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartUserImportJobRequest#builder()}
     * </p>
     *
     * @param startUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartUserImportJobRequest.Builder} to create a
     *        request. Represents the request to start the user import job.
     * @return Result of the StartUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUserImportJobResponse startUserImportJob(Consumer<StartUserImportJobRequest.Builder> startUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException,
            PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return startUserImportJob(StartUserImportJobRequest.builder().applyMutation(startUserImportJobRequest).build());
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return Result of the StopUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopUserImportJobResponse stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException,
            PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopUserImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopUserImportJobRequest#builder()}
     * </p>
     *
     * @param stopUserImportJobRequest
     *        A {@link Consumer} that will call methods on {@link StopUserImportJobRequest.Builder} to create a request.
     *        Represents the request to stop the user import job.
     * @return Result of the StopUserImportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws PreconditionNotMetException
     *         This exception is thrown when a precondition is not met.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopUserImportJobResponse stopUserImportJob(Consumer<StopUserImportJobRequest.Builder> stopUserImportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException,
            PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return stopUserImportJob(StopUserImportJobRequest.builder().applyMutation(stopUserImportJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an IAM
     * policy, you can constrain permissions for user pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an IAM
     * policy, you can constrain permissions for user pools based on specific tags or tag values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     *
     * @param updateAuthEventFeedbackRequest
     * @return Result of the UpdateAuthEventFeedback operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAuthEventFeedbackResponse updateAuthEventFeedback(UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest)
            throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException,
            UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthEventFeedbackRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param updateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuthEventFeedbackRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAuthEventFeedback operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserPoolAddOnNotEnabledException
     *         This exception is thrown when user pool add-ons are not enabled.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAuthEventFeedbackResponse updateAuthEventFeedback(
            Consumer<UpdateAuthEventFeedbackRequest.Builder> updateAuthEventFeedbackRequest) throws InvalidParameterException,
            ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException,
            UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return updateAuthEventFeedback(UpdateAuthEventFeedbackRequest.builder().applyMutation(updateAuthEventFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates the device status.
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return Result of the UpdateDeviceStatus operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceStatusResponse updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException,
            InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceStatusRequest.Builder} to create a
     *        request. Represents the request to update the device status.
     * @return Result of the UpdateDeviceStatus operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeviceStatusResponse updateDeviceStatus(Consumer<UpdateDeviceStatusRequest.Builder> updateDeviceStatusRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException,
            InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return updateDeviceStatus(UpdateDeviceStatusRequest.builder().applyMutation(updateDeviceStatusRequest).build());
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest)
            throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates identity provider information for a user pool.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedIdentityProviderException
     *         This exception is thrown when the specified identifier is not supported.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest updateIdentityProviderRequest)
            throws InvalidParameterException, UnsupportedIdentityProviderException, ResourceNotFoundException,
            NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates identity provider information for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws UnsupportedIdentityProviderException
     *         This exception is thrown when the specified identifier is not supported.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderResponse updateIdentityProvider(
            Consumer<UpdateIdentityProviderRequest.Builder> updateIdentityProviderRequest) throws InvalidParameterException,
            UnsupportedIdentityProviderException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return updateIdentityProvider(UpdateIdentityProviderRequest.builder().applyMutation(updateIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important>
     *
     * @param updateResourceServerRequest
     * @return Result of the UpdateResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceServerResponse updateResourceServer(UpdateResourceServerRequest updateResourceServerRequest)
            throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceServerRequest#builder()}
     * </p>
     *
     * @param updateResourceServerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourceServer operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceServerResponse updateResourceServer(
            Consumer<UpdateResourceServerRequest.Builder> updateResourceServerRequest) throws InvalidParameterException,
            ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return updateResourceServer(UpdateResourceServerRequest.builder().applyMutation(updateResourceServerRequest).build());
    }

    /**
     * <p>
     * Allows a user to update a specific attribute (one at a time).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return Result of the UpdateUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserAttributesResponse updateUserAttributes(UpdateUserAttributesRequest updateUserAttributesRequest)
            throws ResourceNotFoundException, InvalidParameterException, CodeMismatchException, ExpiredCodeException,
            NotAuthorizedException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException,
            TooManyRequestsException, AliasExistsException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to update a specific attribute (one at a time).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param updateUserAttributesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserAttributesRequest.Builder} to create a
     *        request. Represents the request to update user attributes.
     * @return Result of the UpdateUserAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UnexpectedLambdaException
     *         This exception is thrown when the Amazon Cognito service encounters an unexpected exception with the AWS
     *         Lambda service.
     * @throws UserLambdaValidationException
     *         This exception is thrown when the Amazon Cognito service encounters a user validation exception with the
     *         AWS Lambda service.
     * @throws InvalidLambdaResponseException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid AWS Lambda response.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws AliasExistsException
     *         This exception is thrown when a user tries to confirm the account with an email or phone number that has
     *         already been supplied as an alias from a different account. This exception tells user that an account
     *         with this email or phone already exists.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws CodeDeliveryFailureException
     *         This exception is thrown when a verification code fails to deliver successfully.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserAttributesResponse updateUserAttributes(
            Consumer<UpdateUserAttributesRequest.Builder> updateUserAttributesRequest) throws ResourceNotFoundException,
            InvalidParameterException, CodeMismatchException, ExpiredCodeException, NotAuthorizedException,
            UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException, TooManyRequestsException,
            AliasExistsException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException,
            InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return updateUserAttributes(UpdateUserAttributesRequest.builder().applyMutation(updateUserAttributesRequest).build());
    }

    /**
     * <p>
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool
     * settings using <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a>. If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return Result of the UpdateUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserPoolResponse updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) throws ResourceNotFoundException,
            InvalidParameterException, ConcurrentModificationException, TooManyRequestsException, NotAuthorizedException,
            UserImportInProgressException, InternalErrorException, InvalidSmsRoleAccessPolicyException,
            InvalidSmsRoleTrustRelationshipException, UserPoolTaggingException, InvalidEmailRoleAccessPolicyException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool
     * settings using <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a>. If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you
     * register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Cognito will use the the registered
     * number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other AWS service, Amazon SNS might place
     * your account in SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you’ll have
     * limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment,
     * you can move out of the SMS sandbox and into production. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-sms-userpool-settings.html"
     * > SMS message settings for Cognito User Pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserPoolRequest#builder()}
     * </p>
     *
     * @param updateUserPoolRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolRequest.Builder} to create a request.
     *        Represents the request to update the user pool.
     * @return Result of the UpdateUserPool operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws UserImportInProgressException
     *         This exception is thrown when you are trying to modify a user pool while a user import job is in progress
     *         for that pool.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws InvalidSmsRoleAccessPolicyException
     *         This exception is returned when the role provided for SMS configuration does not have permission to
     *         publish using Amazon SNS.
     * @throws InvalidSmsRoleTrustRelationshipException
     *         This exception is thrown when the trust relationship is invalid for the role provided for SMS
     *         configuration. This can happen if you do not trust <b>cognito-idp.amazonaws.com</b> or the external ID
     *         provided in the role does not match what is provided in the SMS configuration for the user pool.
     * @throws UserPoolTaggingException
     *         This exception is thrown when a user pool tag cannot be set or updated.
     * @throws InvalidEmailRoleAccessPolicyException
     *         This exception is thrown when Amazon Cognito is not allowed to use your email identity. HTTP status code:
     *         400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserPoolResponse updateUserPool(Consumer<UpdateUserPoolRequest.Builder> updateUserPoolRequest)
            throws ResourceNotFoundException, InvalidParameterException, ConcurrentModificationException,
            TooManyRequestsException, NotAuthorizedException, UserImportInProgressException, InternalErrorException,
            InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, UserPoolTaggingException,
            InvalidEmailRoleAccessPolicyException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return updateUserPool(UpdateUserPoolRequest.builder().applyMutation(updateUserPoolRequest).build());
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user
     * pool app client settings using <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html"
     * >DescribeUserPoolClient</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important>
     * <p>
     * You can also use this operation to enable token revocation for user pool clients. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return Result of the UpdateUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ScopeDoesNotExistException
     *         This exception is thrown when the specified scope does not exist.
     * @throws InvalidOAuthFlowException
     *         This exception is thrown when the specified OAuth flow is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserPoolClientResponse updateUserPoolClient(UpdateUserPoolClientRequest updateUserPoolClientRequest)
            throws ResourceNotFoundException, InvalidParameterException, ConcurrentModificationException,
            TooManyRequestsException, NotAuthorizedException, ScopeDoesNotExistException, InvalidOAuthFlowException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user
     * pool app client settings using <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html"
     * >DescribeUserPoolClient</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it will be set to the default value.
     * </p>
     * </important>
     * <p>
     * You can also use this operation to enable token revocation for user pool clients. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolClientRequest.Builder} to create a
     *        request. Represents the request to update the user pool client.
     * @return Result of the UpdateUserPoolClient operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ConcurrentModificationException
     *         This exception is thrown if two or more modifications are happening concurrently.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ScopeDoesNotExistException
     *         This exception is thrown when the specified scope does not exist.
     * @throws InvalidOAuthFlowException
     *         This exception is thrown when the specified OAuth flow is invalid.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserPoolClientResponse updateUserPoolClient(
            Consumer<UpdateUserPoolClientRequest.Builder> updateUserPoolClientRequest) throws ResourceNotFoundException,
            InvalidParameterException, ConcurrentModificationException, TooManyRequestsException, NotAuthorizedException,
            ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return updateUserPoolClient(UpdateUserPoolClientRequest.builder().applyMutation(updateUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * cannot use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with AWS Certificate
     * Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your
     * custom domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the AWS Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     *
     * @param updateUserPoolDomainRequest
     *        The UpdateUserPoolDomain request input.
     * @return Result of the UpdateUserPoolDomain operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserPoolDomainResponse updateUserPoolDomain(UpdateUserPoolDomainRequest updateUserPoolDomainRequest)
            throws InvalidParameterException, NotAuthorizedException, ResourceNotFoundException, TooManyRequestsException,
            InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * cannot use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with AWS Certificate
     * Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your
     * custom domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the AWS Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param updateUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserPoolDomainRequest.Builder} to create a
     *        request. The UpdateUserPoolDomain request input.
     * @return Result of the UpdateUserPoolDomain operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserPoolDomainResponse updateUserPoolDomain(
            Consumer<UpdateUserPoolDomainRequest.Builder> updateUserPoolDomainRequest) throws InvalidParameterException,
            NotAuthorizedException, ResourceNotFoundException, TooManyRequestsException, InternalErrorException,
            AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return updateUserPoolDomain(UpdateUserPoolDomainRequest.builder().applyMutation(updateUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified"
     * if successful. The request takes an access token or a session string, but not both.
     * </p>
     *
     * @param verifySoftwareTokenRequest
     * @return Result of the VerifySoftwareToken operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws EnableSoftwareTokenMfaException
     *         This exception is thrown when there is a code mismatch and the service fails to configure the software
     *         token TOTP multi-factor authentication (MFA).
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifySoftwareTokenResponse verifySoftwareToken(VerifySoftwareTokenRequest verifySoftwareTokenRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException,
            NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, EnableSoftwareTokenMfaException,
            SoftwareTokenMfaNotFoundException, CodeMismatchException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified"
     * if successful. The request takes an access token or a session string, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifySoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link VerifySoftwareTokenRequest#builder()}
     * </p>
     *
     * @param verifySoftwareTokenRequest
     *        A {@link Consumer} that will call methods on {@link VerifySoftwareTokenRequest.Builder} to create a
     *        request.
     * @return Result of the VerifySoftwareToken operation returned by the service.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidUserPoolConfigurationException
     *         This exception is thrown when the user pool configuration is invalid.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws EnableSoftwareTokenMfaException
     *         This exception is thrown when there is a code mismatch and the service fails to configure the software
     *         token TOTP multi-factor authentication (MFA).
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws SoftwareTokenMfaNotFoundException
     *         This exception is thrown when the software token TOTP multi-factor authentication (MFA) is not enabled
     *         for the user pool.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifySoftwareTokenResponse verifySoftwareToken(
            Consumer<VerifySoftwareTokenRequest.Builder> verifySoftwareTokenRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidUserPoolConfigurationException, NotAuthorizedException, TooManyRequestsException,
            PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException,
            EnableSoftwareTokenMfaException, SoftwareTokenMfaNotFoundException, CodeMismatchException, AwsServiceException,
            SdkClientException, CognitoIdentityProviderException {
        return verifySoftwareToken(VerifySoftwareTokenRequest.builder().applyMutation(verifySoftwareTokenRequest).build());
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return Result of the VerifyUserAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifyUserAttributeResponse verifyUserAttribute(VerifyUserAttributeRequest verifyUserAttributeRequest)
            throws ResourceNotFoundException, InvalidParameterException, CodeMismatchException, ExpiredCodeException,
            NotAuthorizedException, TooManyRequestsException, LimitExceededException, PasswordResetRequiredException,
            UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyUserAttributeRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyUserAttributeRequest#builder()}
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        A {@link Consumer} that will call methods on {@link VerifyUserAttributeRequest.Builder} to create a
     *        request. Represents the request to verify user attributes.
     * @return Result of the VerifyUserAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the Amazon Cognito service cannot find the requested resource.
     * @throws InvalidParameterException
     *         This exception is thrown when the Amazon Cognito service encounters an invalid parameter.
     * @throws CodeMismatchException
     *         This exception is thrown if the provided code does not match what the server was expecting.
     * @throws ExpiredCodeException
     *         This exception is thrown if a code has expired.
     * @throws NotAuthorizedException
     *         This exception is thrown when a user is not authorized.
     * @throws TooManyRequestsException
     *         This exception is thrown when the user has made too many requests for a given operation.
     * @throws LimitExceededException
     *         This exception is thrown when a user exceeds the limit for a requested AWS resource.
     * @throws PasswordResetRequiredException
     *         This exception is thrown when a password reset is required.
     * @throws UserNotFoundException
     *         This exception is thrown when a user is not found.
     * @throws UserNotConfirmedException
     *         This exception is thrown when a user is not confirmed successfully.
     * @throws InternalErrorException
     *         This exception is thrown when Amazon Cognito encounters an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CognitoIdentityProviderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CognitoIdentityProviderClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default VerifyUserAttributeResponse verifyUserAttribute(
            Consumer<VerifyUserAttributeRequest.Builder> verifyUserAttributeRequest) throws ResourceNotFoundException,
            InvalidParameterException, CodeMismatchException, ExpiredCodeException, NotAuthorizedException,
            TooManyRequestsException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException,
            UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException,
            CognitoIdentityProviderException {
        return verifyUserAttribute(VerifyUserAttributeRequest.builder().applyMutation(verifyUserAttributeRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
