/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfirmDeviceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ConfirmDeviceRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(ConfirmDeviceRequest.getter(ConfirmDeviceRequest::accessToken)).setter(ConfirmDeviceRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceKey").getter(ConfirmDeviceRequest.getter(ConfirmDeviceRequest::deviceKey)).setter(ConfirmDeviceRequest.setter(Builder::deviceKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()}).build();
    private static final SdkField<DeviceSecretVerifierConfigType> DEVICE_SECRET_VERIFIER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceSecretVerifierConfig").getter(ConfirmDeviceRequest.getter(ConfirmDeviceRequest::deviceSecretVerifierConfig)).setter(ConfirmDeviceRequest.setter(Builder::deviceSecretVerifierConfig)).constructor(DeviceSecretVerifierConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSecretVerifierConfig").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(ConfirmDeviceRequest.getter(ConfirmDeviceRequest::deviceName)).setter(ConfirmDeviceRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, DEVICE_KEY_FIELD, DEVICE_SECRET_VERIFIER_CONFIG_FIELD, DEVICE_NAME_FIELD));
    private final String accessToken;
    private final String deviceKey;
    private final DeviceSecretVerifierConfigType deviceSecretVerifierConfig;
    private final String deviceName;

    private ConfirmDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.deviceKey = builder.deviceKey;
        this.deviceSecretVerifierConfig = builder.deviceSecretVerifierConfig;
        this.deviceName = builder.deviceName;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String deviceKey() {
        return this.deviceKey;
    }

    public final DeviceSecretVerifierConfigType deviceSecretVerifierConfig() {
        return this.deviceSecretVerifierConfig;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSecretVerifierConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmDeviceRequest)) {
            return false;
        }
        ConfirmDeviceRequest other = (ConfirmDeviceRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.deviceKey(), other.deviceKey()) && Objects.equals(this.deviceSecretVerifierConfig(), other.deviceSecretVerifierConfig()) && Objects.equals(this.deviceName(), other.deviceName());
    }

    public final String toString() {
        return ToString.builder((String)"ConfirmDeviceRequest").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceKey", (Object)this.deviceKey()).add("DeviceSecretVerifierConfig", (Object)this.deviceSecretVerifierConfig()).add("DeviceName", (Object)this.deviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "DeviceKey": {
                return Optional.ofNullable(clazz.cast(this.deviceKey()));
            }
            case "DeviceSecretVerifierConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceSecretVerifierConfig()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmDeviceRequest, T> g) {
        return obj -> g.apply((ConfirmDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String deviceKey;
        private DeviceSecretVerifierConfigType deviceSecretVerifierConfig;
        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmDeviceRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.deviceKey(model.deviceKey);
            this.deviceSecretVerifierConfig(model.deviceSecretVerifierConfig);
            this.deviceName(model.deviceName);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getDeviceKey() {
            return this.deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        public final DeviceSecretVerifierConfigType.Builder getDeviceSecretVerifierConfig() {
            return this.deviceSecretVerifierConfig != null ? this.deviceSecretVerifierConfig.toBuilder() : null;
        }

        @Override
        public final Builder deviceSecretVerifierConfig(DeviceSecretVerifierConfigType deviceSecretVerifierConfig) {
            this.deviceSecretVerifierConfig = deviceSecretVerifierConfig;
            return this;
        }

        public final void setDeviceSecretVerifierConfig(DeviceSecretVerifierConfigType.BuilderImpl deviceSecretVerifierConfig) {
            this.deviceSecretVerifierConfig = deviceSecretVerifierConfig != null ? deviceSecretVerifierConfig.build() : null;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmDeviceRequest build() {
            return new ConfirmDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfirmDeviceRequest> {
        public Builder accessToken(String var1);

        public Builder deviceKey(String var1);

        public Builder deviceSecretVerifierConfig(DeviceSecretVerifierConfigType var1);

        default public Builder deviceSecretVerifierConfig(Consumer<DeviceSecretVerifierConfigType.Builder> deviceSecretVerifierConfig) {
            return this.deviceSecretVerifierConfig((DeviceSecretVerifierConfigType)((DeviceSecretVerifierConfigType.Builder)DeviceSecretVerifierConfigType.builder().applyMutation(deviceSecretVerifierConfig)).build());
        }

        public Builder deviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

