/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthenticationResultType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeNameType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RespondToAuthChallengeResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, RespondToAuthChallengeResponse> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeName").getter(RespondToAuthChallengeResponse.getter(RespondToAuthChallengeResponse::challengeNameAsString)).setter(RespondToAuthChallengeResponse.setter(Builder::challengeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()}).build();
    private static final SdkField<String> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Session").getter(RespondToAuthChallengeResponse.getter(RespondToAuthChallengeResponse::session)).setter(RespondToAuthChallengeResponse.setter(Builder::session)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<Map<String, String>> CHALLENGE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ChallengeParameters").getter(RespondToAuthChallengeResponse.getter(RespondToAuthChallengeResponse::challengeParameters)).setter(RespondToAuthChallengeResponse.setter(Builder::challengeParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthenticationResultType> AUTHENTICATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationResult").getter(RespondToAuthChallengeResponse.getter(RespondToAuthChallengeResponse::authenticationResult)).setter(RespondToAuthChallengeResponse.setter(Builder::authenticationResult)).constructor(AuthenticationResultType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD, SESSION_FIELD, CHALLENGE_PARAMETERS_FIELD, AUTHENTICATION_RESULT_FIELD));
    private final String challengeName;
    private final String session;
    private final Map<String, String> challengeParameters;
    private final AuthenticationResultType authenticationResult;

    private RespondToAuthChallengeResponse(BuilderImpl builder) {
        super(builder);
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeParameters = builder.challengeParameters;
        this.authenticationResult = builder.authenticationResult;
    }

    public final ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(this.challengeName);
    }

    public final String challengeNameAsString() {
        return this.challengeName;
    }

    public final String session() {
        return this.session;
    }

    public final boolean hasChallengeParameters() {
        return this.challengeParameters != null && !(this.challengeParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> challengeParameters() {
        return this.challengeParameters;
    }

    public final AuthenticationResultType authenticationResult() {
        return this.authenticationResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChallengeParameters() ? this.challengeParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeResponse)) {
            return false;
        }
        RespondToAuthChallengeResponse other = (RespondToAuthChallengeResponse)((Object)obj);
        return Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.session(), other.session()) && this.hasChallengeParameters() == other.hasChallengeParameters() && Objects.equals(this.challengeParameters(), other.challengeParameters()) && Objects.equals(this.authenticationResult(), other.authenticationResult());
    }

    public final String toString() {
        return ToString.builder((String)"RespondToAuthChallengeResponse").add("ChallengeName", (Object)this.challengeNameAsString()).add("Session", (Object)this.session()).add("ChallengeParameters", this.hasChallengeParameters() ? this.challengeParameters() : null).add("AuthenticationResult", (Object)this.authenticationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "ChallengeParameters": {
                return Optional.ofNullable(clazz.cast(this.challengeParameters()));
            }
            case "AuthenticationResult": {
                return Optional.ofNullable(clazz.cast(this.authenticationResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondToAuthChallengeResponse, T> g) {
        return obj -> g.apply((RespondToAuthChallengeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String challengeName;
        private String session;
        private Map<String, String> challengeParameters = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationResultType authenticationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondToAuthChallengeResponse model) {
            super(model);
            this.challengeName(model.challengeName);
            this.session(model.session);
            this.challengeParameters(model.challengeParameters);
            this.authenticationResult(model.authenticationResult);
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        public final String getSession() {
            return this.session;
        }

        @Override
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        public final Map<String, String> getChallengeParameters() {
            if (this.challengeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.challengeParameters;
        }

        @Override
        public final Builder challengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
            return this;
        }

        public final void setChallengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
        }

        public final AuthenticationResultType.Builder getAuthenticationResult() {
            return this.authenticationResult != null ? this.authenticationResult.toBuilder() : null;
        }

        @Override
        public final Builder authenticationResult(AuthenticationResultType authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public final void setAuthenticationResult(AuthenticationResultType.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        public RespondToAuthChallengeResponse build() {
            return new RespondToAuthChallengeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RespondToAuthChallengeResponse> {
        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeNameType var1);

        public Builder session(String var1);

        public Builder challengeParameters(Map<String, String> var1);

        public Builder authenticationResult(AuthenticationResultType var1);

        default public Builder authenticationResult(Consumer<AuthenticationResultType.Builder> authenticationResult) {
            return this.authenticationResult((AuthenticationResultType)((AuthenticationResultType.Builder)AuthenticationResultType.builder().applyMutation(authenticationResult)).build());
        }
    }
}

