/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminListUserAuthEventsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, AdminListUserAuthEventsResponse> {
    private static final SdkField<List<AuthEventType>> AUTH_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthEvents").getter(AdminListUserAuthEventsResponse.getter(AdminListUserAuthEventsResponse::authEvents)).setter(AdminListUserAuthEventsResponse.setter(Builder::authEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthEventType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(AdminListUserAuthEventsResponse.getter(AdminListUserAuthEventsResponse::nextToken)).setter(AdminListUserAuthEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AuthEventType> authEvents;
    private final String nextToken;

    private AdminListUserAuthEventsResponse(BuilderImpl builder) {
        super(builder);
        this.authEvents = builder.authEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthEvents() {
        return this.authEvents != null && !(this.authEvents instanceof SdkAutoConstructList);
    }

    public final List<AuthEventType> authEvents() {
        return this.authEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthEvents() ? this.authEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListUserAuthEventsResponse)) {
            return false;
        }
        AdminListUserAuthEventsResponse other = (AdminListUserAuthEventsResponse)((Object)obj);
        return this.hasAuthEvents() == other.hasAuthEvents() && Objects.equals(this.authEvents(), other.authEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"AdminListUserAuthEventsResponse").add("AuthEvents", this.hasAuthEvents() ? this.authEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthEvents": {
                return Optional.ofNullable(clazz.cast(this.authEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminListUserAuthEventsResponse, T> g) {
        return obj -> g.apply((AdminListUserAuthEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<AuthEventType> authEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminListUserAuthEventsResponse model) {
            super(model);
            this.authEvents(model.authEvents);
            this.nextToken(model.nextToken);
        }

        public final List<AuthEventType.Builder> getAuthEvents() {
            List<AuthEventType.Builder> result = AuthEventsTypeCopier.copyToBuilder(this.authEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder authEvents(Collection<AuthEventType> authEvents) {
            this.authEvents = AuthEventsTypeCopier.copy(authEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authEvents(AuthEventType ... authEvents) {
            this.authEvents(Arrays.asList(authEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authEvents(Consumer<AuthEventType.Builder> ... authEvents) {
            this.authEvents(Stream.of(authEvents).map(c -> (AuthEventType)((AuthEventType.Builder)AuthEventType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthEvents(Collection<AuthEventType.BuilderImpl> authEvents) {
            this.authEvents = AuthEventsTypeCopier.copyFromBuilder(authEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public AdminListUserAuthEventsResponse build() {
            return new AdminListUserAuthEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminListUserAuthEventsResponse> {
        public Builder authEvents(Collection<AuthEventType> var1);

        public Builder authEvents(AuthEventType ... var1);

        public Builder authEvents(Consumer<AuthEventType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

