/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserType implements SdkPojo, Serializable, ToCopyableBuilder<UserType.Builder, UserType> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UserType::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<List<AttributeType>> ATTRIBUTES_FIELD = SdkField
            .<List<AttributeType>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(UserType::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> USER_CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UserCreateDate").getter(getter(UserType::userCreateDate)).setter(setter(Builder::userCreateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCreateDate").build()).build();

    private static final SdkField<Instant> USER_LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UserLastModifiedDate").getter(getter(UserType::userLastModifiedDate))
            .setter(setter(Builder::userLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserLastModifiedDate").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UserType::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserStatus").getter(getter(UserType::userStatusAsString)).setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()).build();

    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField
            .<List<MFAOptionType>> builder(MarshallingType.LIST)
            .memberName("MFAOptions")
            .getter(getter(UserType::mfaOptions))
            .setter(setter(Builder::mfaOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MFAOptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MFAOptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            ATTRIBUTES_FIELD, USER_CREATE_DATE_FIELD, USER_LAST_MODIFIED_DATE_FIELD, ENABLED_FIELD, USER_STATUS_FIELD,
            MFA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final List<AttributeType> attributes;

    private final Instant userCreateDate;

    private final Instant userLastModifiedDate;

    private final Boolean enabled;

    private final String userStatus;

    private final List<MFAOptionType> mfaOptions;

    private UserType(BuilderImpl builder) {
        this.username = builder.username;
        this.attributes = builder.attributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
    }

    /**
     * <p>
     * The user name of the user you wish to describe.
     * </p>
     * 
     * @return The user name of the user you wish to describe.
     */
    public final String username() {
        return username;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A container with information about the user type attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A container with information about the user type attributes.
     */
    public final List<AttributeType> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The creation date of the user.
     * </p>
     * 
     * @return The creation date of the user.
     */
    public final Instant userCreateDate() {
        return userCreateDate;
    }

    /**
     * <p>
     * The last modified date of the user.
     * </p>
     * 
     * @return The last modified date of the user.
     */
    public final Instant userLastModifiedDate() {
        return userLastModifiedDate;
    }

    /**
     * <p>
     * Specifies whether the user is enabled.
     * </p>
     * 
     * @return Specifies whether the user is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPROMISED - User is disabled due to a potential security threat.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status is not known.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before he or
     * she can sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first
     * sign-in, the user must change his or her password to a new value before doing anything else.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPROMISED - User is disabled due to a potential security threat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status is not known.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before
     *         he or she can sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
     *         first sign-in, the user must change his or her password to a new value before doing anything else.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public final UserStatusType userStatus() {
        return UserStatusType.fromValue(userStatus);
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPROMISED - User is disabled due to a potential security threat.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status is not known.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before he or
     * she can sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first
     * sign-in, the user must change his or her password to a new value before doing anything else.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPROMISED - User is disabled due to a potential security threat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status is not known.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before
     *         he or she can sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
     *         first sign-in, the user must change his or her password to a new value before doing anything else.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public final String userStatusAsString() {
        return userStatus;
    }

    /**
     * Returns true if the MFAOptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMfaOptions() {
        return mfaOptions != null && !(mfaOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MFA options for the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMfaOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The MFA options for the user.
     */
    public final List<MFAOptionType> mfaOptions() {
        return mfaOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMfaOptions() ? mfaOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserType)) {
            return false;
        }
        UserType other = (UserType) obj;
        return Objects.equals(username(), other.username()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(userCreateDate(), other.userCreateDate())
                && Objects.equals(userLastModifiedDate(), other.userLastModifiedDate())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(userStatusAsString(), other.userStatusAsString())
                && hasMfaOptions() == other.hasMfaOptions() && Objects.equals(mfaOptions(), other.mfaOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserType").add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Attributes", hasAttributes() ? attributes() : null).add("UserCreateDate", userCreateDate())
                .add("UserLastModifiedDate", userLastModifiedDate()).add("Enabled", enabled())
                .add("UserStatus", userStatusAsString()).add("MFAOptions", hasMfaOptions() ? mfaOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "UserCreateDate":
            return Optional.ofNullable(clazz.cast(userCreateDate()));
        case "UserLastModifiedDate":
            return Optional.ofNullable(clazz.cast(userLastModifiedDate()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        case "MFAOptions":
            return Optional.ofNullable(clazz.cast(mfaOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserType, T> g) {
        return obj -> g.apply((UserType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserType> {
        /**
         * <p>
         * The user name of the user you wish to describe.
         * </p>
         * 
         * @param username
         *        The user name of the user you wish to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * A container with information about the user type attributes.
         * </p>
         * 
         * @param attributes
         *        A container with information about the user type attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<AttributeType> attributes);

        /**
         * <p>
         * A container with information about the user type attributes.
         * </p>
         * 
         * @param attributes
         *        A container with information about the user type attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AttributeType... attributes);

        /**
         * <p>
         * A container with information about the user type attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeType>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<AttributeType>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<AttributeType>)
         */
        Builder attributes(Consumer<AttributeType.Builder>... attributes);

        /**
         * <p>
         * The creation date of the user.
         * </p>
         * 
         * @param userCreateDate
         *        The creation date of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCreateDate(Instant userCreateDate);

        /**
         * <p>
         * The last modified date of the user.
         * </p>
         * 
         * @param userLastModifiedDate
         *        The last modified date of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userLastModifiedDate(Instant userLastModifiedDate);

        /**
         * <p>
         * Specifies whether the user is enabled.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the user is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPROMISED - User is disabled due to a potential security threat.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status is not known.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before he
         * or she can sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
         * first sign-in, the user must change his or her password to a new value before doing anything else.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPROMISED - User is disabled due to a potential security threat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status is not known.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password
         *        before he or she can sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but
         *        on first sign-in, the user must change his or her password to a new value before doing anything else.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPROMISED - User is disabled due to a potential security threat.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status is not known.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password before he
         * or she can sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
         * first sign-in, the user must change his or her password to a new value before doing anything else.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPROMISED - User is disabled due to a potential security threat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status is not known.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESET_REQUIRED - User is confirmed, but the user must request a code and reset his or her password
         *        before he or she can sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but
         *        on first sign-in, the user must change his or her password to a new value before doing anything else.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(UserStatusType userStatus);

        /**
         * <p>
         * The MFA options for the user.
         * </p>
         * 
         * @param mfaOptions
         *        The MFA options for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(Collection<MFAOptionType> mfaOptions);

        /**
         * <p>
         * The MFA options for the user.
         * </p>
         * 
         * @param mfaOptions
         *        The MFA options for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(MFAOptionType... mfaOptions);

        /**
         * <p>
         * The MFA options for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFAOptionType>.Builder} avoiding the need
         * to create one manually via {@link List<MFAOptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFAOptionType>.Builder#build()} is called immediately and
         * its result is passed to {@link #mfaOptions(List<MFAOptionType>)}.
         * 
         * @param mfaOptions
         *        a consumer that will call methods on {@link List<MFAOptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaOptions(List<MFAOptionType>)
         */
        Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private List<AttributeType> attributes = DefaultSdkAutoConstructList.getInstance();

        private Instant userCreateDate;

        private Instant userLastModifiedDate;

        private Boolean enabled;

        private String userStatus;

        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserType model) {
            username(model.username);
            attributes(model.attributes);
            userCreateDate(model.userCreateDate);
            userLastModifiedDate(model.userLastModifiedDate);
            enabled(model.enabled);
            userStatus(model.userStatus);
            mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final List<AttributeType.Builder> getAttributes() {
            List<AttributeType.Builder> result = AttributeListTypeCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attributes(Collection<AttributeType> attributes) {
            this.attributes = AttributeListTypeCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeType... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeType.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeType.BuilderImpl> attributes) {
            this.attributes = AttributeListTypeCopier.copyFromBuilder(attributes);
        }

        public final Instant getUserCreateDate() {
            return userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final List<MFAOptionType.Builder> getMfaOptions() {
            List<MFAOptionType.Builder> result = MFAOptionListTypeCopier.copyToBuilder(this.mfaOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType... mfaOptions) {
            mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions) {
            mfaOptions(Stream.of(mfaOptions).map(c -> MFAOptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        public UserType build() {
            return new UserType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
