/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server from the request to get information about the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetUserResponse.Builder, GetUserResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(GetUserResponse::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField
            .<List<AttributeType>> builder(MarshallingType.LIST)
            .memberName("UserAttributes")
            .getter(getter(GetUserResponse::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField
            .<List<MFAOptionType>> builder(MarshallingType.LIST)
            .memberName("MFAOptions")
            .getter(getter(GetUserResponse::mfaOptions))
            .setter(setter(Builder::mfaOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MFAOptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MFAOptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredMfaSetting").getter(getter(GetUserResponse::preferredMfaSetting))
            .setter(setter(Builder::preferredMfaSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build())
            .build();

    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserMFASettingList")
            .getter(getter(GetUserResponse::userMFASettingList))
            .setter(setter(Builder::userMFASettingList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            USER_ATTRIBUTES_FIELD, MFA_OPTIONS_FIELD, PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD));

    private final String username;

    private final List<AttributeType> userAttributes;

    private final List<MFAOptionType> mfaOptions;

    private final String preferredMfaSetting;

    private final List<String> userMFASettingList;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.mfaOptions = builder.mfaOptions;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
    }

    /**
     * <p>
     * The user name of the user you wish to retrieve from the get user request.
     * </p>
     * 
     * @return The user name of the user you wish to retrieve from the get user request.
     */
    public final String username() {
        return username;
    }

    /**
     * Returns true if the UserAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of name-value pairs representing user attributes.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of name-value pairs representing user attributes.</p>
     *         <p>
     *         For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     */
    public final List<AttributeType> userAttributes() {
        return userAttributes;
    }

    /**
     * Returns true if the MFAOptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMfaOptions() {
        return mfaOptions != null && !(mfaOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations.
     * It doesn't provide information about TOTP software token MFA configurations. To look up information about either
     * type of MFA configuration, use UserMFASettingList instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMfaOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
     *         configurations. It doesn't provide information about TOTP software token MFA configurations. To look up
     *         information about either type of MFA configuration, use UserMFASettingList instead.
     */
    public final List<MFAOptionType> mfaOptions() {
        return mfaOptions;
    }

    /**
     * <p>
     * The user's preferred MFA setting.
     * </p>
     * 
     * @return The user's preferred MFA setting.
     */
    public final String preferredMfaSetting() {
        return preferredMfaSetting;
    }

    /**
     * Returns true if the UserMFASettingList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUserMFASettingList() {
        return userMFASettingList != null && !(userMFASettingList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code> and
     * <code>SOFTWARE_TOKEN_MFA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserMFASettingList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code>
     *         and <code>SOFTWARE_TOKEN_MFA</code>.
     */
    public final List<String> userMFASettingList() {
        return userMFASettingList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAttributes() ? userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMfaOptions() ? mfaOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMFASettingList() ? userMFASettingList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse) obj;
        return Objects.equals(username(), other.username()) && hasUserAttributes() == other.hasUserAttributes()
                && Objects.equals(userAttributes(), other.userAttributes()) && hasMfaOptions() == other.hasMfaOptions()
                && Objects.equals(mfaOptions(), other.mfaOptions())
                && Objects.equals(preferredMfaSetting(), other.preferredMfaSetting())
                && hasUserMFASettingList() == other.hasUserMFASettingList()
                && Objects.equals(userMFASettingList(), other.userMFASettingList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserResponse").add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserAttributes", hasUserAttributes() ? userAttributes() : null)
                .add("MFAOptions", hasMfaOptions() ? mfaOptions() : null).add("PreferredMfaSetting", preferredMfaSetting())
                .add("UserMFASettingList", hasUserMFASettingList() ? userMFASettingList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "MFAOptions":
            return Optional.ofNullable(clazz.cast(mfaOptions()));
        case "PreferredMfaSetting":
            return Optional.ofNullable(clazz.cast(preferredMfaSetting()));
        case "UserMFASettingList":
            return Optional.ofNullable(clazz.cast(userMFASettingList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserResponse, T> g) {
        return obj -> g.apply((GetUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserResponse> {
        /**
         * <p>
         * The user name of the user you wish to retrieve from the get user request.
         * </p>
         * 
         * @param username
         *        The user name of the user you wish to retrieve from the get user request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * <p>
         * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.</p>
         *        <p>
         *        For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Collection<AttributeType> userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * <p>
         * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.</p>
         *        <p>
         *        For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(AttributeType... userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * <p>
         * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeType>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #userAttributes(List<AttributeType>)}.
         * 
         * @param userAttributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributes(List<AttributeType>)
         */
        Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about TOTP software token MFA configurations. To look up
         * information about either type of MFA configuration, use UserMFASettingList instead.
         * </p>
         * 
         * @param mfaOptions
         *        <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         *        configurations. It doesn't provide information about TOTP software token MFA configurations. To look
         *        up information about either type of MFA configuration, use UserMFASettingList instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(Collection<MFAOptionType> mfaOptions);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about TOTP software token MFA configurations. To look up
         * information about either type of MFA configuration, use UserMFASettingList instead.
         * </p>
         * 
         * @param mfaOptions
         *        <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         *        configurations. It doesn't provide information about TOTP software token MFA configurations. To look
         *        up information about either type of MFA configuration, use UserMFASettingList instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(MFAOptionType... mfaOptions);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about TOTP software token MFA configurations. To look up
         * information about either type of MFA configuration, use UserMFASettingList instead.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFAOptionType>.Builder} avoiding the need
         * to create one manually via {@link List<MFAOptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFAOptionType>.Builder#build()} is called immediately and
         * its result is passed to {@link #mfaOptions(List<MFAOptionType>)}.
         * 
         * @param mfaOptions
         *        a consumer that will call methods on {@link List<MFAOptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaOptions(List<MFAOptionType>)
         */
        Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions);

        /**
         * <p>
         * The user's preferred MFA setting.
         * </p>
         * 
         * @param preferredMfaSetting
         *        The user's preferred MFA setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMfaSetting(String preferredMfaSetting);

        /**
         * <p>
         * The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code> and
         * <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are enabled for the user. The possible values in this list are
         *        <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(Collection<String> userMFASettingList);

        /**
         * <p>
         * The MFA options that are enabled for the user. The possible values in this list are <code>SMS_MFA</code> and
         * <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are enabled for the user. The possible values in this list are
         *        <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(String... userMFASettingList);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String username;

        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private String preferredMfaSetting;

        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            username(model.username);
            userAttributes(model.userAttributes);
            mfaOptions(model.mfaOptions);
            preferredMfaSetting(model.preferredMfaSetting);
            userMFASettingList(model.userMFASettingList);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final List<AttributeType.Builder> getUserAttributes() {
            List<AttributeType.Builder> result = AttributeListTypeCopier.copyToBuilder(this.userAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType... userAttributes) {
            userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes) {
            userAttributes(Stream.of(userAttributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final List<MFAOptionType.Builder> getMfaOptions() {
            List<MFAOptionType.Builder> result = MFAOptionListTypeCopier.copyToBuilder(this.mfaOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType... mfaOptions) {
            mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions) {
            mfaOptions(Stream.of(mfaOptions).map(c -> MFAOptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        public final String getPreferredMfaSetting() {
            return preferredMfaSetting;
        }

        @Override
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        public final Collection<String> getUserMFASettingList() {
            if (userMFASettingList instanceof SdkAutoConstructList) {
                return null;
            }
            return userMFASettingList;
        }

        @Override
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMFASettingList(String... userMFASettingList) {
            userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
