/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user pool client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolClientType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolClientType.Builder, UserPoolClientType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UserPoolClientType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> CLIENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientName").getter(getter(UserPoolClientType::clientName)).setter(setter(Builder::clientName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientName").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(UserPoolClientType::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSecret").getter(getter(UserPoolClientType::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(UserPoolClientType::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(UserPoolClientType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Integer> REFRESH_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RefreshTokenValidity").getter(getter(UserPoolClientType::refreshTokenValidity))
            .setter(setter(Builder::refreshTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshTokenValidity").build())
            .build();

    private static final SdkField<Integer> ACCESS_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AccessTokenValidity").getter(getter(UserPoolClientType::accessTokenValidity))
            .setter(setter(Builder::accessTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTokenValidity").build())
            .build();

    private static final SdkField<Integer> ID_TOKEN_VALIDITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdTokenValidity").getter(getter(UserPoolClientType::idTokenValidity))
            .setter(setter(Builder::idTokenValidity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdTokenValidity").build()).build();

    private static final SdkField<TokenValidityUnitsType> TOKEN_VALIDITY_UNITS_FIELD = SdkField
            .<TokenValidityUnitsType> builder(MarshallingType.SDK_POJO).memberName("TokenValidityUnits")
            .getter(getter(UserPoolClientType::tokenValidityUnits)).setter(setter(Builder::tokenValidityUnits))
            .constructor(TokenValidityUnitsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValidityUnits").build())
            .build();

    private static final SdkField<List<String>> READ_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadAttributes")
            .getter(getter(UserPoolClientType::readAttributes))
            .setter(setter(Builder::readAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WRITE_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WriteAttributes")
            .getter(getter(UserPoolClientType::writeAttributes))
            .setter(setter(Builder::writeAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPLICIT_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExplicitAuthFlows")
            .getter(getter(UserPoolClientType::explicitAuthFlowsAsStrings))
            .setter(setter(Builder::explicitAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplicitAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_IDENTITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedIdentityProviders")
            .getter(getter(UserPoolClientType::supportedIdentityProviders))
            .setter(setter(Builder::supportedIdentityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedIdentityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CALLBACK_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CallbackURLs")
            .getter(getter(UserPoolClientType::callbackURLs))
            .setter(setter(Builder::callbackURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOGOUT_UR_LS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogoutURLs")
            .getter(getter(UserPoolClientType::logoutURLs))
            .setter(setter(Builder::logoutURLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutURLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultRedirectURI").getter(getter(UserPoolClientType::defaultRedirectURI))
            .setter(setter(Builder::defaultRedirectURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRedirectURI").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_FLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOAuthFlows")
            .getter(getter(UserPoolClientType::allowedOAuthFlowsAsStrings))
            .setter(setter(Builder::allowedOAuthFlowsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedOAuthScopes")
            .getter(getter(UserPoolClientType::allowedOAuthScopes))
            .setter(setter(Builder::allowedOAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowedOAuthFlowsUserPoolClient")
            .getter(getter(UserPoolClientType::allowedOAuthFlowsUserPoolClient))
            .setter(setter(Builder::allowedOAuthFlowsUserPoolClient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOAuthFlowsUserPoolClient")
                    .build()).build();

    private static final SdkField<AnalyticsConfigurationType> ANALYTICS_CONFIGURATION_FIELD = SdkField
            .<AnalyticsConfigurationType> builder(MarshallingType.SDK_POJO).memberName("AnalyticsConfiguration")
            .getter(getter(UserPoolClientType::analyticsConfiguration)).setter(setter(Builder::analyticsConfiguration))
            .constructor(AnalyticsConfigurationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsConfiguration").build())
            .build();

    private static final SdkField<String> PREVENT_USER_EXISTENCE_ERRORS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreventUserExistenceErrors")
            .getter(getter(UserPoolClientType::preventUserExistenceErrorsAsString))
            .setter(setter(Builder::preventUserExistenceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreventUserExistenceErrors").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TOKEN_REVOCATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableTokenRevocation").getter(getter(UserPoolClientType::enableTokenRevocation))
            .setter(setter(Builder::enableTokenRevocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTokenRevocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CLIENT_NAME_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD,
            REFRESH_TOKEN_VALIDITY_FIELD, ACCESS_TOKEN_VALIDITY_FIELD, ID_TOKEN_VALIDITY_FIELD, TOKEN_VALIDITY_UNITS_FIELD,
            READ_ATTRIBUTES_FIELD, WRITE_ATTRIBUTES_FIELD, EXPLICIT_AUTH_FLOWS_FIELD, SUPPORTED_IDENTITY_PROVIDERS_FIELD,
            CALLBACK_UR_LS_FIELD, LOGOUT_UR_LS_FIELD, DEFAULT_REDIRECT_URI_FIELD, ALLOWED_O_AUTH_FLOWS_FIELD,
            ALLOWED_O_AUTH_SCOPES_FIELD, ALLOWED_O_AUTH_FLOWS_USER_POOL_CLIENT_FIELD, ANALYTICS_CONFIGURATION_FIELD,
            PREVENT_USER_EXISTENCE_ERRORS_FIELD, ENABLE_TOKEN_REVOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPoolId;

    private final String clientName;

    private final String clientId;

    private final String clientSecret;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final Integer refreshTokenValidity;

    private final Integer accessTokenValidity;

    private final Integer idTokenValidity;

    private final TokenValidityUnitsType tokenValidityUnits;

    private final List<String> readAttributes;

    private final List<String> writeAttributes;

    private final List<String> explicitAuthFlows;

    private final List<String> supportedIdentityProviders;

    private final List<String> callbackURLs;

    private final List<String> logoutURLs;

    private final String defaultRedirectURI;

    private final List<String> allowedOAuthFlows;

    private final List<String> allowedOAuthScopes;

    private final Boolean allowedOAuthFlowsUserPoolClient;

    private final AnalyticsConfigurationType analyticsConfiguration;

    private final String preventUserExistenceErrors;

    private final Boolean enableTokenRevocation;

    private UserPoolClientType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.accessTokenValidity = builder.accessTokenValidity;
        this.idTokenValidity = builder.idTokenValidity;
        this.tokenValidityUnits = builder.tokenValidityUnits;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
        this.analyticsConfiguration = builder.analyticsConfiguration;
        this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
        this.enableTokenRevocation = builder.enableTokenRevocation;
    }

    /**
     * <p>
     * The user pool ID for the user pool client.
     * </p>
     * 
     * @return The user pool ID for the user pool client.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The client name from the user pool request of the client type.
     * </p>
     * 
     * @return The client name from the user pool request of the client type.
     */
    public final String clientName() {
        return clientName;
    }

    /**
     * <p>
     * The ID of the client associated with the user pool.
     * </p>
     * 
     * @return The ID of the client associated with the user pool.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret from the user pool request of the client type.
     * </p>
     * 
     * @return The client secret from the user pool request of the client type.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The date the user pool client was last modified.
     * </p>
     * 
     * @return The date the user pool client was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the user pool client was created.
     * </p>
     * 
     * @return The date the user pool client was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time limit, in days, after which the refresh token is no longer valid and cannot be used.
     * </p>
     * 
     * @return The time limit, in days, after which the refresh token is no longer valid and cannot be used.
     */
    public final Integer refreshTokenValidity() {
        return refreshTokenValidity;
    }

    /**
     * <p>
     * The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no longer
     * valid and cannot be used.
     * </p>
     * 
     * @return The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no
     *         longer valid and cannot be used.
     */
    public final Integer accessTokenValidity() {
        return accessTokenValidity;
    }

    /**
     * <p>
     * The time limit, specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no longer
     * valid and cannot be used.
     * </p>
     * 
     * @return The time limit, specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no
     *         longer valid and cannot be used.
     */
    public final Integer idTokenValidity() {
        return idTokenValidity;
    }

    /**
     * <p>
     * The time units used to specify the token validity times of their respective token.
     * </p>
     * 
     * @return The time units used to specify the token validity times of their respective token.
     */
    public final TokenValidityUnitsType tokenValidityUnits() {
        return tokenValidityUnits;
    }

    /**
     * Returns true if the ReadAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReadAttributes() {
        return readAttributes != null && !(readAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Read-only attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReadAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Read-only attributes.
     */
    public final List<String> readAttributes() {
        return readAttributes;
    }

    /**
     * Returns true if the WriteAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasWriteAttributes() {
        return writeAttributes != null && !(writeAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The writeable attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWriteAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The writeable attributes.
     */
    public final List<String> writeAttributes() {
        return writeAttributes;
    }

    /**
     * <p>
     * The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code>
     * prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with
     * <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote
     * Password protocol) protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives
     * the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExplicitAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authentication flows that are supported by the user pool clients. Flow names without the
     *         <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
     *         that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
     *         prefix.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, Cognito receives the password in the request instead of using the SRP
     *         (Secure Remote Password protocol) protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
     *         receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     */
    public final List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return ExplicitAuthFlowsListTypeCopier.copyStringToEnum(explicitAuthFlows);
    }

    /**
     * Returns true if the ExplicitAuthFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExplicitAuthFlows() {
        return explicitAuthFlows != null && !(explicitAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authentication flows that are supported by the user pool clients. Flow names without the <code>ALLOW_</code>
     * prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note that values with
     * <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code> prefix.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
     * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure Remote
     * Password protocol) protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito receives
     * the password in the request instead of using the SRP protocol to verify passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExplicitAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authentication flows that are supported by the user pool clients. Flow names without the
     *         <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
     *         that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
     *         prefix.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
     *         <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting.
     *         With this authentication flow, Cognito receives the password in the request instead of using the SRP
     *         (Secure Remote Password protocol) protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
     *         receives the password in the request instead of using the SRP protocol to verify passwords.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
     *         </p>
     *         </li>
     */
    public final List<String> explicitAuthFlowsAsStrings() {
        return explicitAuthFlows;
    }

    /**
     * Returns true if the SupportedIdentityProviders property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasSupportedIdentityProviders() {
        return supportedIdentityProviders != null && !(supportedIdentityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of provider names for the identity providers that are supported on this client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedIdentityProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of provider names for the identity providers that are supported on this client.
     */
    public final List<String> supportedIdentityProviders() {
        return supportedIdentityProviders;
    }

    /**
     * Returns true if the CallbackURLs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCallbackURLs() {
        return callbackURLs != null && !(callbackURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed redirect (callback) URLs for the identity providers.
     * </p>
     * <p>
     * A redirect URI must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Be an absolute URI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Be registered with the authorization server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not include a fragment component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     * </p>
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * </p>
     * <p>
     * App callback URLs such as myapp://example are also supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCallbackURLs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of allowed redirect (callback) URLs for the identity providers.</p>
     *         <p>
     *         A redirect URI must:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Be an absolute URI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be registered with the authorization server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not include a fragment component.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     *         </p>
     *         <p>
     *         Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *         </p>
     *         <p>
     *         App callback URLs such as myapp://example are also supported.
     */
    public final List<String> callbackURLs() {
        return callbackURLs;
    }

    /**
     * Returns true if the LogoutURLs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogoutURLs() {
        return logoutURLs != null && !(logoutURLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of allowed logout URLs for the identity providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogoutURLs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of allowed logout URLs for the identity providers.
     */
    public final List<String> logoutURLs() {
        return logoutURLs;
    }

    /**
     * <p>
     * The default redirect URI. Must be in the <code>CallbackURLs</code> list.
     * </p>
     * <p>
     * A redirect URI must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Be an absolute URI.
     * </p>
     * </li>
     * <li>
     * <p>
     * Be registered with the authorization server.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not include a fragment component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     * </p>
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * </p>
     * <p>
     * App callback URLs such as myapp://example are also supported.
     * </p>
     * 
     * @return The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
     *         <p>
     *         A redirect URI must:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Be an absolute URI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be registered with the authorization server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not include a fragment component.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
     *         </p>
     *         <p>
     *         Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *         </p>
     *         <p>
     *         App callback URLs such as myapp://example are also supported.
     */
    public final String defaultRedirectURI() {
        return defaultRedirectURI;
    }

    /**
     * <p>
     * The allowed OAuth flows.
     * </p>
     * <p>
     * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
     * This code can be exchanged for access tokens with the token endpoint.
     * </p>
     * <p>
     * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token,
     * based on scopes) directly.
     * </p>
     * <p>
     * Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally,
     * ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed OAuth flows.</p>
     *         <p>
     *         Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
     *         response. This code can be exchanged for access tokens with the token endpoint.
     *         </p>
     *         <p>
     *         Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
     *         token, based on scopes) directly.
     *         </p>
     *         <p>
     *         Set to <code>client_credentials</code> to specify that the client should get the access token (and,
     *         optionally, ID token, based on scopes) from the token endpoint using a combination of client and
     *         client_secret.
     */
    public final List<OAuthFlowType> allowedOAuthFlows() {
        return OAuthFlowsTypeCopier.copyStringToEnum(allowedOAuthFlows);
    }

    /**
     * Returns true if the AllowedOAuthFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAllowedOAuthFlows() {
        return allowedOAuthFlows != null && !(allowedOAuthFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed OAuth flows.
     * </p>
     * <p>
     * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
     * This code can be exchanged for access tokens with the token endpoint.
     * </p>
     * <p>
     * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token,
     * based on scopes) directly.
     * </p>
     * <p>
     * Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally,
     * ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed OAuth flows.</p>
     *         <p>
     *         Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
     *         response. This code can be exchanged for access tokens with the token endpoint.
     *         </p>
     *         <p>
     *         Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
     *         token, based on scopes) directly.
     *         </p>
     *         <p>
     *         Set to <code>client_credentials</code> to specify that the client should get the access token (and,
     *         optionally, ID token, based on scopes) from the token endpoint using a combination of client and
     *         client_secret.
     */
    public final List<String> allowedOAuthFlowsAsStrings() {
        return allowedOAuthFlows;
    }

    /**
     * Returns true if the AllowedOAuthScopes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAllowedOAuthScopes() {
        return allowedOAuthScopes != null && !(allowedOAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>,
     * <code>openid</code>, and <code>profile</code>. Possible values provided by AWS are:
     * <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedOAuthScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>,
     *         <code>openid</code>, and <code>profile</code>. Possible values provided by AWS are:
     *         <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.
     */
    public final List<String> allowedOAuthScopes() {
        return allowedOAuthScopes;
    }

    /**
     * <p>
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
     * </p>
     * 
     * @return Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user
     *         pools.
     */
    public final Boolean allowedOAuthFlowsUserPoolClient() {
        return allowedOAuthFlowsUserPoolClient;
    }

    /**
     * <p>
     * The Amazon Pinpoint analytics configuration for the user pool client.
     * </p>
     * <note>
     * <p>
     * Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia)
     * us-east-1 Region, regardless of the region in which the user pool resides.
     * </p>
     * </note>
     * 
     * @return The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
     *         <p>
     *         Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia)
     *         us-east-1 Region, regardless of the region in which the user pool resides.
     *         </p>
     */
    public final AnalyticsConfigurationType analyticsConfiguration() {
        return analyticsConfiguration;
    }

    /**
     * <p>
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account
     * confirmation, and password recovery when the user does not exist in the user pool. When set to
     * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username
     * or password was incorrect, and account confirmation and password recovery return a response indicating a code was
     * sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a
     * <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - This prevents user existence-related errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
     * prevented.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     * <code>ENABLED</code> for newly created user pool clients if no value is provided.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
     *         account confirmation, and password recovery when the user does not exist in the user pool. When set to
     *         <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
     *         username or password was incorrect, and account confirmation and password recovery return a response
     *         indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
     *         return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - This prevents user existence-related errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are
     *         not prevented.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     *         <code>ENABLED</code> for newly created user pool clients if no value is provided.
     *         </p>
     * @see PreventUserExistenceErrorTypes
     */
    public final PreventUserExistenceErrorTypes preventUserExistenceErrors() {
        return PreventUserExistenceErrorTypes.fromValue(preventUserExistenceErrors);
    }

    /**
     * <p>
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account
     * confirmation, and password recovery when the user does not exist in the user pool. When set to
     * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username
     * or password was incorrect, and account confirmation and password recovery return a response indicating a code was
     * sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will return a
     * <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - This prevents user existence-related errors.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
     * prevented.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     * <code>ENABLED</code> for newly created user pool clients if no value is provided.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #preventUserExistenceErrors} will return {@link PreventUserExistenceErrorTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #preventUserExistenceErrorsAsString}.
     * </p>
     * 
     * @return Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
     *         account confirmation, and password recovery when the user does not exist in the user pool. When set to
     *         <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
     *         username or password was incorrect, and account confirmation and password recovery return a response
     *         indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
     *         return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - This prevents user existence-related errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are
     *         not prevented.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
     *         <code>ENABLED</code> for newly created user pool clients if no value is provided.
     *         </p>
     * @see PreventUserExistenceErrorTypes
     */
    public final String preventUserExistenceErrorsAsString() {
        return preventUserExistenceErrors;
    }

    /**
     * <p>
     * Indicates whether token revocation is enabled for the user pool client. When you create a new user pool client,
     * token revocation is enabled by default. For more information about revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * 
     * @return Indicates whether token revocation is enabled for the user pool client. When you create a new user pool
     *         client, token revocation is enabled by default. For more information about revoking tokens, see <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     *         >RevokeToken</a>.
     */
    public final Boolean enableTokenRevocation() {
        return enableTokenRevocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientName());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(accessTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(idTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(tokenValidityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadAttributes() ? readAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWriteAttributes() ? writeAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExplicitAuthFlows() ? explicitAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedIdentityProviders() ? supportedIdentityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCallbackURLs() ? callbackURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogoutURLs() ? logoutURLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOAuthFlows() ? allowedOAuthFlowsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOAuthScopes() ? allowedOAuthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedOAuthFlowsUserPoolClient());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preventUserExistenceErrorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableTokenRevocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolClientType)) {
            return false;
        }
        UserPoolClientType other = (UserPoolClientType) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(clientName(), other.clientName())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(refreshTokenValidity(), other.refreshTokenValidity())
                && Objects.equals(accessTokenValidity(), other.accessTokenValidity())
                && Objects.equals(idTokenValidity(), other.idTokenValidity())
                && Objects.equals(tokenValidityUnits(), other.tokenValidityUnits())
                && hasReadAttributes() == other.hasReadAttributes() && Objects.equals(readAttributes(), other.readAttributes())
                && hasWriteAttributes() == other.hasWriteAttributes()
                && Objects.equals(writeAttributes(), other.writeAttributes())
                && hasExplicitAuthFlows() == other.hasExplicitAuthFlows()
                && Objects.equals(explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings())
                && hasSupportedIdentityProviders() == other.hasSupportedIdentityProviders()
                && Objects.equals(supportedIdentityProviders(), other.supportedIdentityProviders())
                && hasCallbackURLs() == other.hasCallbackURLs() && Objects.equals(callbackURLs(), other.callbackURLs())
                && hasLogoutURLs() == other.hasLogoutURLs() && Objects.equals(logoutURLs(), other.logoutURLs())
                && Objects.equals(defaultRedirectURI(), other.defaultRedirectURI())
                && hasAllowedOAuthFlows() == other.hasAllowedOAuthFlows()
                && Objects.equals(allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings())
                && hasAllowedOAuthScopes() == other.hasAllowedOAuthScopes()
                && Objects.equals(allowedOAuthScopes(), other.allowedOAuthScopes())
                && Objects.equals(allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient())
                && Objects.equals(analyticsConfiguration(), other.analyticsConfiguration())
                && Objects.equals(preventUserExistenceErrorsAsString(), other.preventUserExistenceErrorsAsString())
                && Objects.equals(enableTokenRevocation(), other.enableTokenRevocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPoolClientType").add("UserPoolId", userPoolId()).add("ClientName", clientName())
                .add("ClientId", clientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastModifiedDate", lastModifiedDate()).add("CreationDate", creationDate())
                .add("RefreshTokenValidity", refreshTokenValidity()).add("AccessTokenValidity", accessTokenValidity())
                .add("IdTokenValidity", idTokenValidity()).add("TokenValidityUnits", tokenValidityUnits())
                .add("ReadAttributes", hasReadAttributes() ? readAttributes() : null)
                .add("WriteAttributes", hasWriteAttributes() ? writeAttributes() : null)
                .add("ExplicitAuthFlows", hasExplicitAuthFlows() ? explicitAuthFlowsAsStrings() : null)
                .add("SupportedIdentityProviders", hasSupportedIdentityProviders() ? supportedIdentityProviders() : null)
                .add("CallbackURLs", hasCallbackURLs() ? callbackURLs() : null)
                .add("LogoutURLs", hasLogoutURLs() ? logoutURLs() : null).add("DefaultRedirectURI", defaultRedirectURI())
                .add("AllowedOAuthFlows", hasAllowedOAuthFlows() ? allowedOAuthFlowsAsStrings() : null)
                .add("AllowedOAuthScopes", hasAllowedOAuthScopes() ? allowedOAuthScopes() : null)
                .add("AllowedOAuthFlowsUserPoolClient", allowedOAuthFlowsUserPoolClient())
                .add("AnalyticsConfiguration", analyticsConfiguration())
                .add("PreventUserExistenceErrors", preventUserExistenceErrorsAsString())
                .add("EnableTokenRevocation", enableTokenRevocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ClientName":
            return Optional.ofNullable(clazz.cast(clientName()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "RefreshTokenValidity":
            return Optional.ofNullable(clazz.cast(refreshTokenValidity()));
        case "AccessTokenValidity":
            return Optional.ofNullable(clazz.cast(accessTokenValidity()));
        case "IdTokenValidity":
            return Optional.ofNullable(clazz.cast(idTokenValidity()));
        case "TokenValidityUnits":
            return Optional.ofNullable(clazz.cast(tokenValidityUnits()));
        case "ReadAttributes":
            return Optional.ofNullable(clazz.cast(readAttributes()));
        case "WriteAttributes":
            return Optional.ofNullable(clazz.cast(writeAttributes()));
        case "ExplicitAuthFlows":
            return Optional.ofNullable(clazz.cast(explicitAuthFlowsAsStrings()));
        case "SupportedIdentityProviders":
            return Optional.ofNullable(clazz.cast(supportedIdentityProviders()));
        case "CallbackURLs":
            return Optional.ofNullable(clazz.cast(callbackURLs()));
        case "LogoutURLs":
            return Optional.ofNullable(clazz.cast(logoutURLs()));
        case "DefaultRedirectURI":
            return Optional.ofNullable(clazz.cast(defaultRedirectURI()));
        case "AllowedOAuthFlows":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsAsStrings()));
        case "AllowedOAuthScopes":
            return Optional.ofNullable(clazz.cast(allowedOAuthScopes()));
        case "AllowedOAuthFlowsUserPoolClient":
            return Optional.ofNullable(clazz.cast(allowedOAuthFlowsUserPoolClient()));
        case "AnalyticsConfiguration":
            return Optional.ofNullable(clazz.cast(analyticsConfiguration()));
        case "PreventUserExistenceErrors":
            return Optional.ofNullable(clazz.cast(preventUserExistenceErrorsAsString()));
        case "EnableTokenRevocation":
            return Optional.ofNullable(clazz.cast(enableTokenRevocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolClientType, T> g) {
        return obj -> g.apply((UserPoolClientType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolClientType> {
        /**
         * <p>
         * The user pool ID for the user pool client.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The client name from the user pool request of the client type.
         * </p>
         * 
         * @param clientName
         *        The client name from the user pool request of the client type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientName(String clientName);

        /**
         * <p>
         * The ID of the client associated with the user pool.
         * </p>
         * 
         * @param clientId
         *        The ID of the client associated with the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret from the user pool request of the client type.
         * </p>
         * 
         * @param clientSecret
         *        The client secret from the user pool request of the client type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The date the user pool client was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the user pool client was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the user pool client was created.
         * </p>
         * 
         * @param creationDate
         *        The date the user pool client was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time limit, in days, after which the refresh token is no longer valid and cannot be used.
         * </p>
         * 
         * @param refreshTokenValidity
         *        The time limit, in days, after which the refresh token is no longer valid and cannot be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenValidity(Integer refreshTokenValidity);

        /**
         * <p>
         * The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is no
         * longer valid and cannot be used.
         * </p>
         * 
         * @param accessTokenValidity
         *        The time limit, specified by tokenValidityUnits, defaulting to hours, after which the access token is
         *        no longer valid and cannot be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTokenValidity(Integer accessTokenValidity);

        /**
         * <p>
         * The time limit, specified by tokenValidityUnits, defaulting to hours, after which the refresh token is no
         * longer valid and cannot be used.
         * </p>
         * 
         * @param idTokenValidity
         *        The time limit, specified by tokenValidityUnits, defaulting to hours, after which the refresh token is
         *        no longer valid and cannot be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idTokenValidity(Integer idTokenValidity);

        /**
         * <p>
         * The time units used to specify the token validity times of their respective token.
         * </p>
         * 
         * @param tokenValidityUnits
         *        The time units used to specify the token validity times of their respective token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits);

        /**
         * <p>
         * The time units used to specify the token validity times of their respective token.
         * </p>
         * This is a convenience that creates an instance of the {@link TokenValidityUnitsType.Builder} avoiding the
         * need to create one manually via {@link TokenValidityUnitsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link TokenValidityUnitsType.Builder#build()} is called immediately and
         * its result is passed to {@link #tokenValidityUnits(TokenValidityUnitsType)}.
         * 
         * @param tokenValidityUnits
         *        a consumer that will call methods on {@link TokenValidityUnitsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenValidityUnits(TokenValidityUnitsType)
         */
        default Builder tokenValidityUnits(Consumer<TokenValidityUnitsType.Builder> tokenValidityUnits) {
            return tokenValidityUnits(TokenValidityUnitsType.builder().applyMutation(tokenValidityUnits).build());
        }

        /**
         * <p>
         * The Read-only attributes.
         * </p>
         * 
         * @param readAttributes
         *        The Read-only attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(Collection<String> readAttributes);

        /**
         * <p>
         * The Read-only attributes.
         * </p>
         * 
         * @param readAttributes
         *        The Read-only attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAttributes(String... readAttributes);

        /**
         * <p>
         * The writeable attributes.
         * </p>
         * 
         * @param writeAttributes
         *        The writeable attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(Collection<String> writeAttributes);

        /**
         * <p>
         * The writeable attributes.
         * </p>
         * 
         * @param writeAttributes
         *        The writeable attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeAttributes(String... writeAttributes);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows);

        /**
         * <p>
         * The authentication flows that are supported by the user pool clients. Flow names without the
         * <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix. Note
         * that values with <code>ALLOW_</code> prefix cannot be used along with values without <code>ALLOW_</code>
         * prefix.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         * <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With
         * this authentication flow, Cognito receives the password in the request instead of using the SRP (Secure
         * Remote Password protocol) protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow, Cognito
         * receives the password in the request instead of using the SRP protocol to verify passwords.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param explicitAuthFlows
         *        The authentication flows that are supported by the user pool clients. Flow names without the
         *        <code>ALLOW_</code> prefix are deprecated in favor of new names with the <code>ALLOW_</code> prefix.
         *        Note that values with <code>ALLOW_</code> prefix cannot be used along with values without
         *        <code>ALLOW_</code> prefix.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code>: Enable admin based user password authentication flow
         *        <code>ADMIN_USER_PASSWORD_AUTH</code>. This setting replaces the <code>ADMIN_NO_SRP_AUTH</code>
         *        setting. With this authentication flow, Cognito receives the password in the request instead of using
         *        the SRP (Secure Remote Password protocol) protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_CUSTOM_AUTH</code>: Enable Lambda trigger based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_PASSWORD_AUTH</code>: Enable user password-based authentication. In this flow,
         *        Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_USER_SRP_AUTH</code>: Enable SRP based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALLOW_REFRESH_TOKEN_AUTH</code>: Enable authflow to refresh tokens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows);

        /**
         * <p>
         * A list of provider names for the identity providers that are supported on this client.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers that are supported on this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders);

        /**
         * <p>
         * A list of provider names for the identity providers that are supported on this client.
         * </p>
         * 
         * @param supportedIdentityProviders
         *        A list of provider names for the identity providers that are supported on this client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedIdentityProviders(String... supportedIdentityProviders);

        /**
         * <p>
         * A list of allowed redirect (callback) URLs for the identity providers.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect (callback) URLs for the identity providers.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(Collection<String> callbackURLs);

        /**
         * <p>
         * A list of allowed redirect (callback) URLs for the identity providers.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param callbackURLs
         *        A list of allowed redirect (callback) URLs for the identity providers.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackURLs(String... callbackURLs);

        /**
         * <p>
         * A list of allowed logout URLs for the identity providers.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for the identity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(Collection<String> logoutURLs);

        /**
         * <p>
         * A list of allowed logout URLs for the identity providers.
         * </p>
         * 
         * @param logoutURLs
         *        A list of allowed logout URLs for the identity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutURLs(String... logoutURLs);

        /**
         * <p>
         * The default redirect URI. Must be in the <code>CallbackURLs</code> list.
         * </p>
         * <p>
         * A redirect URI must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Be an absolute URI.
         * </p>
         * </li>
         * <li>
         * <p>
         * Be registered with the authorization server.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not include a fragment component.
         * </p>
         * </li>
         * </ul>
         * <p>
         * See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         * </p>
         * <p>
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         * </p>
         * <p>
         * App callback URLs such as myapp://example are also supported.
         * </p>
         * 
         * @param defaultRedirectURI
         *        The default redirect URI. Must be in the <code>CallbackURLs</code> list.</p>
         *        <p>
         *        A redirect URI must:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Be an absolute URI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be registered with the authorization server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not include a fragment component.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        See <a href="https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a>.
         *        </p>
         *        <p>
         *        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *        </p>
         *        <p>
         *        App callback URLs such as myapp://example are also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRedirectURI(String defaultRedirectURI);

        /**
         * <p>
         * The allowed OAuth flows.
         * </p>
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
         * token, based on scopes) directly.
         * </p>
         * <p>
         * Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         * optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         * client_secret.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        The allowed OAuth flows.</p>
         *        <p>
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.
         *        </p>
         *        <p>
         *        Set to <code>implicit</code> to specify that the client should get the access token (and, optionally,
         *        ID token, based on scopes) directly.
         *        </p>
         *        <p>
         *        Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         *        optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         *        client_secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows);

        /**
         * <p>
         * The allowed OAuth flows.
         * </p>
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
         * token, based on scopes) directly.
         * </p>
         * <p>
         * Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         * optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         * client_secret.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        The allowed OAuth flows.</p>
         *        <p>
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.
         *        </p>
         *        <p>
         *        Set to <code>implicit</code> to specify that the client should get the access token (and, optionally,
         *        ID token, based on scopes) directly.
         *        </p>
         *        <p>
         *        Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         *        optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         *        client_secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows);

        /**
         * <p>
         * The allowed OAuth flows.
         * </p>
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
         * token, based on scopes) directly.
         * </p>
         * <p>
         * Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         * optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         * client_secret.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        The allowed OAuth flows.</p>
         *        <p>
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.
         *        </p>
         *        <p>
         *        Set to <code>implicit</code> to specify that the client should get the access token (and, optionally,
         *        ID token, based on scopes) directly.
         *        </p>
         *        <p>
         *        Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         *        optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         *        client_secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows);

        /**
         * <p>
         * The allowed OAuth flows.
         * </p>
         * <p>
         * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response.
         * This code can be exchanged for access tokens with the token endpoint.
         * </p>
         * <p>
         * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID
         * token, based on scopes) directly.
         * </p>
         * <p>
         * Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         * optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         * client_secret.
         * </p>
         * 
         * @param allowedOAuthFlows
         *        The allowed OAuth flows.</p>
         *        <p>
         *        Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the
         *        response. This code can be exchanged for access tokens with the token endpoint.
         *        </p>
         *        <p>
         *        Set to <code>implicit</code> to specify that the client should get the access token (and, optionally,
         *        ID token, based on scopes) directly.
         *        </p>
         *        <p>
         *        Set to <code>client_credentials</code> to specify that the client should get the access token (and,
         *        optionally, ID token, based on scopes) from the token endpoint using a combination of client and
         *        client_secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows);

        /**
         * <p>
         * The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>,
         * <code>openid</code>, and <code>profile</code>. Possible values provided by AWS are:
         * <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>,
         *        <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by AWS
         *        are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes);

        /**
         * <p>
         * The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>, <code>email</code>,
         * <code>openid</code>, and <code>profile</code>. Possible values provided by AWS are:
         * <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also supported.
         * </p>
         * 
         * @param allowedOAuthScopes
         *        The allowed OAuth scopes. Possible values provided by OAuth are: <code>phone</code>,
         *        <code>email</code>, <code>openid</code>, and <code>profile</code>. Possible values provided by AWS
         *        are: <code>aws.cognito.signin.user.admin</code>. Custom scopes created in Resource Servers are also
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthScopes(String... allowedOAuthScopes);

        /**
         * <p>
         * Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
         * </p>
         * 
         * @param allowedOAuthFlowsUserPoolClient
         *        Set to true if the client is allowed to follow the OAuth protocol when interacting with Cognito user
         *        pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient);

        /**
         * <p>
         * The Amazon Pinpoint analytics configuration for the user pool client.
         * </p>
         * <note>
         * <p>
         * Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia)
         * us-east-1 Region, regardless of the region in which the user pool resides.
         * </p>
         * </note>
         * 
         * @param analyticsConfiguration
         *        The Amazon Pinpoint analytics configuration for the user pool client.</p> <note>
         *        <p>
         *        Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N.
         *        Virginia) us-east-1 Region, regardless of the region in which the user pool resides.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration);

        /**
         * <p>
         * The Amazon Pinpoint analytics configuration for the user pool client.
         * </p>
         * <note>
         * <p>
         * Cognito User Pools only supports sending events to Amazon Pinpoint projects in the US East (N. Virginia)
         * us-east-1 Region, regardless of the region in which the user pool resides.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link AnalyticsConfigurationType.Builder}
         * avoiding the need to create one manually via {@link AnalyticsConfigurationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsConfigurationType.Builder#build()} is called immediately
         * and its result is passed to {@link #analyticsConfiguration(AnalyticsConfigurationType)}.
         * 
         * @param analyticsConfiguration
         *        a consumer that will call methods on {@link AnalyticsConfigurationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyticsConfiguration(AnalyticsConfigurationType)
         */
        default Builder analyticsConfiguration(Consumer<AnalyticsConfigurationType.Builder> analyticsConfiguration) {
            return analyticsConfiguration(AnalyticsConfigurationType.builder().applyMutation(analyticsConfiguration).build());
        }

        /**
         * <p>
         * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
         * account confirmation, and password recovery when the user does not exist in the user pool. When set to
         * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
         * username or password was incorrect, and account confirmation and password recovery return a response
         * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
         * return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - This prevents user existence-related errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
         * prevented.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         * <code>ENABLED</code> for newly created user pool clients if no value is provided.
         * </p>
         * </note>
         * 
         * @param preventUserExistenceErrors
         *        Use this setting to choose which errors and responses are returned by Cognito APIs during
         *        authentication, account confirmation, and password recovery when the user does not exist in the user
         *        pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error
         *        indicating either the username or password was incorrect, and account confirmation and password
         *        recovery return a response indicating a code was sent to a simulated destination. When set to
         *        <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user
         *        does not exist in the user pool.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - This prevents user existence-related errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors
         *        are not prevented.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         *        <code>ENABLED</code> for newly created user pool clients if no value is provided.
         *        </p>
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(String preventUserExistenceErrors);

        /**
         * <p>
         * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication,
         * account confirmation, and password recovery when the user does not exist in the user pool. When set to
         * <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the
         * username or password was incorrect, and account confirmation and password recovery return a response
         * indicating a code was sent to a simulated destination. When set to <code>LEGACY</code>, those APIs will
         * return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - This prevents user existence-related errors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors are not
         * prevented.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         * <code>ENABLED</code> for newly created user pool clients if no value is provided.
         * </p>
         * </note>
         * 
         * @param preventUserExistenceErrors
         *        Use this setting to choose which errors and responses are returned by Cognito APIs during
         *        authentication, account confirmation, and password recovery when the user does not exist in the user
         *        pool. When set to <code>ENABLED</code> and the user does not exist, authentication returns an error
         *        indicating either the username or password was incorrect, and account confirmation and password
         *        recovery return a response indicating a code was sent to a simulated destination. When set to
         *        <code>LEGACY</code>, those APIs will return a <code>UserNotFoundException</code> exception if the user
         *        does not exist in the user pool.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - This prevents user existence-related errors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEGACY</code> - This represents the old behavior of Cognito where user existence related errors
         *        are not prevented.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        After February 15th 2020, the value of <code>PreventUserExistenceErrors</code> will default to
         *        <code>ENABLED</code> for newly created user pool clients if no value is provided.
         *        </p>
         * @see PreventUserExistenceErrorTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreventUserExistenceErrorTypes
         */
        Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors);

        /**
         * <p>
         * Indicates whether token revocation is enabled for the user pool client. When you create a new user pool
         * client, token revocation is enabled by default. For more information about revoking tokens, see <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
         * >RevokeToken</a>.
         * </p>
         * 
         * @param enableTokenRevocation
         *        Indicates whether token revocation is enabled for the user pool client. When you create a new user
         *        pool client, token revocation is enabled by default. For more information about revoking tokens, see
         *        <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
         *        >RevokeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTokenRevocation(Boolean enableTokenRevocation);
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String clientName;

        private String clientId;

        private String clientSecret;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private Integer refreshTokenValidity;

        private Integer accessTokenValidity;

        private Integer idTokenValidity;

        private TokenValidityUnitsType tokenValidityUnits;

        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();

        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();

        private String defaultRedirectURI;

        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowedOAuthFlowsUserPoolClient;

        private AnalyticsConfigurationType analyticsConfiguration;

        private String preventUserExistenceErrors;

        private Boolean enableTokenRevocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolClientType model) {
            userPoolId(model.userPoolId);
            clientName(model.clientName);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            refreshTokenValidity(model.refreshTokenValidity);
            accessTokenValidity(model.accessTokenValidity);
            idTokenValidity(model.idTokenValidity);
            tokenValidityUnits(model.tokenValidityUnits);
            readAttributes(model.readAttributes);
            writeAttributes(model.writeAttributes);
            explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            supportedIdentityProviders(model.supportedIdentityProviders);
            callbackURLs(model.callbackURLs);
            logoutURLs(model.logoutURLs);
            defaultRedirectURI(model.defaultRedirectURI);
            allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            allowedOAuthScopes(model.allowedOAuthScopes);
            allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
            analyticsConfiguration(model.analyticsConfiguration);
            preventUserExistenceErrors(model.preventUserExistenceErrors);
            enableTokenRevocation(model.enableTokenRevocation);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientName() {
            return clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Integer getRefreshTokenValidity() {
            return refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        public final Integer getAccessTokenValidity() {
            return accessTokenValidity;
        }

        @Override
        public final Builder accessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final void setAccessTokenValidity(Integer accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        public final Integer getIdTokenValidity() {
            return idTokenValidity;
        }

        @Override
        public final Builder idTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        public final void setIdTokenValidity(Integer idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
        }

        public final TokenValidityUnitsType.Builder getTokenValidityUnits() {
            return tokenValidityUnits != null ? tokenValidityUnits.toBuilder() : null;
        }

        @Override
        public final Builder tokenValidityUnits(TokenValidityUnitsType tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        public final void setTokenValidityUnits(TokenValidityUnitsType.BuilderImpl tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits != null ? tokenValidityUnits.build() : null;
        }

        public final Collection<String> getReadAttributes() {
            if (readAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return readAttributes;
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String... readAttributes) {
            readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        public final Collection<String> getWriteAttributes() {
            if (writeAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return writeAttributes;
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String... writeAttributes) {
            writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        public final Collection<String> getExplicitAuthFlows() {
            if (explicitAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return explicitAuthFlows;
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String... explicitAuthFlows) {
            explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType... explicitAuthFlows) {
            explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final void setExplicitAuthFlows(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        public final Collection<String> getSupportedIdentityProviders() {
            if (supportedIdentityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedIdentityProviders;
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String... supportedIdentityProviders) {
            supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        public final Collection<String> getCallbackURLs() {
            if (callbackURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return callbackURLs;
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String... callbackURLs) {
            callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        public final Collection<String> getLogoutURLs() {
            if (logoutURLs instanceof SdkAutoConstructList) {
                return null;
            }
            return logoutURLs;
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String... logoutURLs) {
            logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        public final String getDefaultRedirectURI() {
            return defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        public final Collection<String> getAllowedOAuthFlows() {
            if (allowedOAuthFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOAuthFlows;
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String... allowedOAuthFlows) {
            allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType... allowedOAuthFlows) {
            allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final void setAllowedOAuthFlows(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        public final Collection<String> getAllowedOAuthScopes() {
            if (allowedOAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOAuthScopes;
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String... allowedOAuthScopes) {
            allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        public final AnalyticsConfigurationType.Builder getAnalyticsConfiguration() {
            return analyticsConfiguration != null ? analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfigurationType analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfigurationType.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        public final String getPreventUserExistenceErrors() {
            return preventUserExistenceErrors;
        }

        @Override
        public final Builder preventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        @Override
        public final Builder preventUserExistenceErrors(PreventUserExistenceErrorTypes preventUserExistenceErrors) {
            this.preventUserExistenceErrors(preventUserExistenceErrors == null ? null : preventUserExistenceErrors.toString());
            return this;
        }

        public final void setPreventUserExistenceErrors(String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
        }

        public final Boolean getEnableTokenRevocation() {
            return enableTokenRevocation;
        }

        @Override
        public final Builder enableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
            return this;
        }

        public final void setEnableTokenRevocation(Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
        }

        @Override
        public UserPoolClientType build() {
            return new UserPoolClientType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
