/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceServerRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateResourceServerRequest.Builder, CreateResourceServerRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(CreateResourceServerRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(CreateResourceServerRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateResourceServerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ResourceServerScopeType>> SCOPES_FIELD = SdkField
            .<List<ResourceServerScopeType>> builder(MarshallingType.LIST)
            .memberName("Scopes")
            .getter(getter(CreateResourceServerRequest::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceServerScopeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceServerScopeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            IDENTIFIER_FIELD, NAME_FIELD, SCOPES_FIELD));

    private final String userPoolId;

    private final String identifier;

    private final String name;

    private final List<ResourceServerScopeType> scopes;

    private CreateResourceServerRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.scopes = builder.scopes;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the resource
     * server is located. For example, <code>https://my-weather-api.example.com</code>.
     * </p>
     * 
     * @return A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the
     *         resource server is located. For example, <code>https://my-weather-api.example.com</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A friendly name for the resource server.
     * </p>
     * 
     * @return A friendly name for the resource server.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Scopes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.
     */
    public final List<ResourceServerScopeType> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceServerRequest)) {
            return false;
        }
        CreateResourceServerRequest other = (CreateResourceServerRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(name(), other.name()) && hasScopes() == other.hasScopes()
                && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceServerRequest").add("UserPoolId", userPoolId()).add("Identifier", identifier())
                .add("Name", name()).add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceServerRequest, T> g) {
        return obj -> g.apply((CreateResourceServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceServerRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the
         * resource server is located. For example, <code>https://my-weather-api.example.com</code>.
         * </p>
         * 
         * @param identifier
         *        A unique resource server identifier for the resource server. This could be an HTTPS endpoint where the
         *        resource server is located. For example, <code>https://my-weather-api.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A friendly name for the resource server.
         * </p>
         * 
         * @param name
         *        A friendly name for the resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.
         * </p>
         * 
         * @param scopes
         *        A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<ResourceServerScopeType> scopes);

        /**
         * <p>
         * A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.
         * </p>
         * 
         * @param scopes
         *        A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(ResourceServerScopeType... scopes);

        /**
         * <p>
         * A list of scopes. Each scope is map, where the keys are <code>name</code> and <code>description</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceServerScopeType>.Builder} avoiding
         * the need to create one manually via {@link List<ResourceServerScopeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceServerScopeType>.Builder#build()} is called
         * immediately and its result is passed to {@link #scopes(List<ResourceServerScopeType>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on {@link List<ResourceServerScopeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(List<ResourceServerScopeType>)
         */
        Builder scopes(Consumer<ResourceServerScopeType.Builder>... scopes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String identifier;

        private String name;

        private List<ResourceServerScopeType> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceServerRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            identifier(model.identifier);
            name(model.name);
            scopes(model.scopes);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourceServerScopeType.Builder> getScopes() {
            List<ResourceServerScopeType.Builder> result = ResourceServerScopeListTypeCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ResourceServerScopeType.BuilderImpl> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copyFromBuilder(scopes);
        }

        @Override
        @Transient
        public final Builder scopes(Collection<ResourceServerScopeType> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copy(scopes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scopes(ResourceServerScopeType... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scopes(Consumer<ResourceServerScopeType.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> ResourceServerScopeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceServerRequest build() {
            return new CreateResourceServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
