/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSoftwareTokenResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AssociateSoftwareTokenResponse.Builder, AssociateSoftwareTokenResponse> {
    private static final SdkField<String> SECRET_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretCode").getter(getter(AssociateSoftwareTokenResponse::secretCode))
            .setter(setter(Builder::secretCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretCode").build()).build();

    private static final SdkField<String> SESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Session")
            .getter(getter(AssociateSoftwareTokenResponse::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_CODE_FIELD,
            SESSION_FIELD));

    private final String secretCode;

    private final String session;

    private AssociateSoftwareTokenResponse(BuilderImpl builder) {
        super(builder);
        this.secretCode = builder.secretCode;
        this.session = builder.session;
    }

    /**
     * <p>
     * A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to
     * generate a one-time code.
     * </p>
     * 
     * @return A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm
     *         to generate a one-time code.
     */
    public final String secretCode() {
        return secretCode;
    }

    /**
     * <p>
     * The session that should be passed both ways in challenge-response calls to the service. This allows
     * authentication of the user as part of the MFA setup process.
     * </p>
     * 
     * @return The session that should be passed both ways in challenge-response calls to the service. This allows
     *         authentication of the user as part of the MFA setup process.
     */
    public final String session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretCode());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSoftwareTokenResponse)) {
            return false;
        }
        AssociateSoftwareTokenResponse other = (AssociateSoftwareTokenResponse) obj;
        return Objects.equals(secretCode(), other.secretCode()) && Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSoftwareTokenResponse")
                .add("SecretCode", secretCode() == null ? null : "*** Sensitive Data Redacted ***").add("Session", session())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretCode":
            return Optional.ofNullable(clazz.cast(secretCode()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSoftwareTokenResponse, T> g) {
        return obj -> g.apply((AssociateSoftwareTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSoftwareTokenResponse> {
        /**
         * <p>
         * A unique generated shared secret code that is used in the time-based one-time password (TOTP) algorithm to
         * generate a one-time code.
         * </p>
         * 
         * @param secretCode
         *        A unique generated shared secret code that is used in the time-based one-time password (TOTP)
         *        algorithm to generate a one-time code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretCode(String secretCode);

        /**
         * <p>
         * The session that should be passed both ways in challenge-response calls to the service. This allows
         * authentication of the user as part of the MFA setup process.
         * </p>
         * 
         * @param session
         *        The session that should be passed both ways in challenge-response calls to the service. This allows
         *        authentication of the user as part of the MFA setup process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(String session);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String secretCode;

        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSoftwareTokenResponse model) {
            super(model);
            secretCode(model.secretCode);
            session(model.session);
        }

        public final String getSecretCode() {
            return secretCode;
        }

        public final void setSecretCode(String secretCode) {
            this.secretCode = secretCode;
        }

        @Override
        @Transient
        public final Builder secretCode(String secretCode) {
            this.secretCode = secretCode;
            return this;
        }

        public final String getSession() {
            return session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        @Transient
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        @Override
        public AssociateSoftwareTokenResponse build() {
            return new AssociateSoftwareTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
