/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication event type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthEventType implements SdkPojo, Serializable, ToCopyableBuilder<AuthEventType.Builder, AuthEventType> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(AuthEventType::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(AuthEventType::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(AuthEventType::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> EVENT_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventResponse").getter(getter(AuthEventType::eventResponseAsString))
            .setter(setter(Builder::eventResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResponse").build()).build();

    private static final SdkField<EventRiskType> EVENT_RISK_FIELD = SdkField.<EventRiskType> builder(MarshallingType.SDK_POJO)
            .memberName("EventRisk").getter(getter(AuthEventType::eventRisk)).setter(setter(Builder::eventRisk))
            .constructor(EventRiskType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventRisk").build()).build();

    private static final SdkField<List<ChallengeResponseType>> CHALLENGE_RESPONSES_FIELD = SdkField
            .<List<ChallengeResponseType>> builder(MarshallingType.LIST)
            .memberName("ChallengeResponses")
            .getter(getter(AuthEventType::challengeResponses))
            .setter(setter(Builder::challengeResponses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChallengeResponseType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChallengeResponseType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EventContextDataType> EVENT_CONTEXT_DATA_FIELD = SdkField
            .<EventContextDataType> builder(MarshallingType.SDK_POJO).memberName("EventContextData")
            .getter(getter(AuthEventType::eventContextData)).setter(setter(Builder::eventContextData))
            .constructor(EventContextDataType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventContextData").build()).build();

    private static final SdkField<EventFeedbackType> EVENT_FEEDBACK_FIELD = SdkField
            .<EventFeedbackType> builder(MarshallingType.SDK_POJO).memberName("EventFeedback")
            .getter(getter(AuthEventType::eventFeedback)).setter(setter(Builder::eventFeedback))
            .constructor(EventFeedbackType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_FIELD, CREATION_DATE_FIELD, EVENT_RESPONSE_FIELD, EVENT_RISK_FIELD, CHALLENGE_RESPONSES_FIELD,
            EVENT_CONTEXT_DATA_FIELD, EVENT_FEEDBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String eventType;

    private final Instant creationDate;

    private final String eventResponse;

    private final EventRiskType eventRisk;

    private final List<ChallengeResponseType> challengeResponses;

    private final EventContextDataType eventContextData;

    private final EventFeedbackType eventFeedback;

    private AuthEventType(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.creationDate = builder.creationDate;
        this.eventResponse = builder.eventResponse;
        this.eventRisk = builder.eventRisk;
        this.challengeResponses = builder.challengeResponses;
        this.eventContextData = builder.eventContextData;
        this.eventFeedback = builder.eventFeedback;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The creation date
     * </p>
     * 
     * @return The creation date
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The event response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventResponse}
     * will return {@link EventResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventResponseAsString}.
     * </p>
     * 
     * @return The event response.
     * @see EventResponseType
     */
    public final EventResponseType eventResponse() {
        return EventResponseType.fromValue(eventResponse);
    }

    /**
     * <p>
     * The event response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventResponse}
     * will return {@link EventResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventResponseAsString}.
     * </p>
     * 
     * @return The event response.
     * @see EventResponseType
     */
    public final String eventResponseAsString() {
        return eventResponse;
    }

    /**
     * <p>
     * The event risk.
     * </p>
     * 
     * @return The event risk.
     */
    public final EventRiskType eventRisk() {
        return eventRisk;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChallengeResponses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChallengeResponses() {
        return challengeResponses != null && !(challengeResponses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The challenge responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChallengeResponses} method.
     * </p>
     * 
     * @return The challenge responses.
     */
    public final List<ChallengeResponseType> challengeResponses() {
        return challengeResponses;
    }

    /**
     * <p>
     * The user context data captured at the time of an event request. This value provides additional information about
     * the client from which event the request is received.
     * </p>
     * 
     * @return The user context data captured at the time of an event request. This value provides additional
     *         information about the client from which event the request is received.
     */
    public final EventContextDataType eventContextData() {
        return eventContextData;
    }

    /**
     * <p>
     * A flag specifying the user feedback captured at the time of an event request is good or bad.
     * </p>
     * 
     * @return A flag specifying the user feedback captured at the time of an event request is good or bad.
     */
    public final EventFeedbackType eventFeedback() {
        return eventFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(eventResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventRisk());
        hashCode = 31 * hashCode + Objects.hashCode(hasChallengeResponses() ? challengeResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventContextData());
        hashCode = 31 * hashCode + Objects.hashCode(eventFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthEventType)) {
            return false;
        }
        AuthEventType other = (AuthEventType) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(eventResponseAsString(), other.eventResponseAsString())
                && Objects.equals(eventRisk(), other.eventRisk()) && hasChallengeResponses() == other.hasChallengeResponses()
                && Objects.equals(challengeResponses(), other.challengeResponses())
                && Objects.equals(eventContextData(), other.eventContextData())
                && Objects.equals(eventFeedback(), other.eventFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthEventType").add("EventId", eventId()).add("EventType", eventTypeAsString())
                .add("CreationDate", creationDate()).add("EventResponse", eventResponseAsString()).add("EventRisk", eventRisk())
                .add("ChallengeResponses", hasChallengeResponses() ? challengeResponses() : null)
                .add("EventContextData", eventContextData()).add("EventFeedback", eventFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "EventResponse":
            return Optional.ofNullable(clazz.cast(eventResponseAsString()));
        case "EventRisk":
            return Optional.ofNullable(clazz.cast(eventRisk()));
        case "ChallengeResponses":
            return Optional.ofNullable(clazz.cast(challengeResponses()));
        case "EventContextData":
            return Optional.ofNullable(clazz.cast(eventContextData()));
        case "EventFeedback":
            return Optional.ofNullable(clazz.cast(eventFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthEventType, T> g) {
        return obj -> g.apply((AuthEventType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthEventType> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventType
         *        The event type.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventType
         *        The event type.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The creation date
         * </p>
         * 
         * @param creationDate
         *        The creation date
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The event response.
         * </p>
         * 
         * @param eventResponse
         *        The event response.
         * @see EventResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventResponseType
         */
        Builder eventResponse(String eventResponse);

        /**
         * <p>
         * The event response.
         * </p>
         * 
         * @param eventResponse
         *        The event response.
         * @see EventResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventResponseType
         */
        Builder eventResponse(EventResponseType eventResponse);

        /**
         * <p>
         * The event risk.
         * </p>
         * 
         * @param eventRisk
         *        The event risk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventRisk(EventRiskType eventRisk);

        /**
         * <p>
         * The event risk.
         * </p>
         * This is a convenience that creates an instance of the {@link EventRiskType.Builder} avoiding the need to
         * create one manually via {@link EventRiskType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventRiskType.Builder#build()} is called immediately and its
         * result is passed to {@link #eventRisk(EventRiskType)}.
         * 
         * @param eventRisk
         *        a consumer that will call methods on {@link EventRiskType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventRisk(EventRiskType)
         */
        default Builder eventRisk(Consumer<EventRiskType.Builder> eventRisk) {
            return eventRisk(EventRiskType.builder().applyMutation(eventRisk).build());
        }

        /**
         * <p>
         * The challenge responses.
         * </p>
         * 
         * @param challengeResponses
         *        The challenge responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeResponses(Collection<ChallengeResponseType> challengeResponses);

        /**
         * <p>
         * The challenge responses.
         * </p>
         * 
         * @param challengeResponses
         *        The challenge responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeResponses(ChallengeResponseType... challengeResponses);

        /**
         * <p>
         * The challenge responses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChallengeResponseType>.Builder} avoiding
         * the need to create one manually via {@link List<ChallengeResponseType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChallengeResponseType>.Builder#build()} is called
         * immediately and its result is passed to {@link #challengeResponses(List<ChallengeResponseType>)}.
         * 
         * @param challengeResponses
         *        a consumer that will call methods on {@link List<ChallengeResponseType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challengeResponses(List<ChallengeResponseType>)
         */
        Builder challengeResponses(Consumer<ChallengeResponseType.Builder>... challengeResponses);

        /**
         * <p>
         * The user context data captured at the time of an event request. This value provides additional information
         * about the client from which event the request is received.
         * </p>
         * 
         * @param eventContextData
         *        The user context data captured at the time of an event request. This value provides additional
         *        information about the client from which event the request is received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventContextData(EventContextDataType eventContextData);

        /**
         * <p>
         * The user context data captured at the time of an event request. This value provides additional information
         * about the client from which event the request is received.
         * </p>
         * This is a convenience that creates an instance of the {@link EventContextDataType.Builder} avoiding the need
         * to create one manually via {@link EventContextDataType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventContextDataType.Builder#build()} is called immediately and
         * its result is passed to {@link #eventContextData(EventContextDataType)}.
         * 
         * @param eventContextData
         *        a consumer that will call methods on {@link EventContextDataType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventContextData(EventContextDataType)
         */
        default Builder eventContextData(Consumer<EventContextDataType.Builder> eventContextData) {
            return eventContextData(EventContextDataType.builder().applyMutation(eventContextData).build());
        }

        /**
         * <p>
         * A flag specifying the user feedback captured at the time of an event request is good or bad.
         * </p>
         * 
         * @param eventFeedback
         *        A flag specifying the user feedback captured at the time of an event request is good or bad.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFeedback(EventFeedbackType eventFeedback);

        /**
         * <p>
         * A flag specifying the user feedback captured at the time of an event request is good or bad.
         * </p>
         * This is a convenience that creates an instance of the {@link EventFeedbackType.Builder} avoiding the need to
         * create one manually via {@link EventFeedbackType#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventFeedbackType.Builder#build()} is called immediately and its
         * result is passed to {@link #eventFeedback(EventFeedbackType)}.
         * 
         * @param eventFeedback
         *        a consumer that will call methods on {@link EventFeedbackType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFeedback(EventFeedbackType)
         */
        default Builder eventFeedback(Consumer<EventFeedbackType.Builder> eventFeedback) {
            return eventFeedback(EventFeedbackType.builder().applyMutation(eventFeedback).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String eventType;

        private Instant creationDate;

        private String eventResponse;

        private EventRiskType eventRisk;

        private List<ChallengeResponseType> challengeResponses = DefaultSdkAutoConstructList.getInstance();

        private EventContextDataType eventContextData;

        private EventFeedbackType eventFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthEventType model) {
            eventId(model.eventId);
            eventType(model.eventType);
            creationDate(model.creationDate);
            eventResponse(model.eventResponse);
            eventRisk(model.eventRisk);
            challengeResponses(model.challengeResponses);
            eventContextData(model.eventContextData);
            eventFeedback(model.eventFeedback);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        @Transient
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @Transient
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getEventResponse() {
            return eventResponse;
        }

        public final void setEventResponse(String eventResponse) {
            this.eventResponse = eventResponse;
        }

        @Override
        @Transient
        public final Builder eventResponse(String eventResponse) {
            this.eventResponse = eventResponse;
            return this;
        }

        @Override
        @Transient
        public final Builder eventResponse(EventResponseType eventResponse) {
            this.eventResponse(eventResponse == null ? null : eventResponse.toString());
            return this;
        }

        public final EventRiskType.Builder getEventRisk() {
            return eventRisk != null ? eventRisk.toBuilder() : null;
        }

        public final void setEventRisk(EventRiskType.BuilderImpl eventRisk) {
            this.eventRisk = eventRisk != null ? eventRisk.build() : null;
        }

        @Override
        @Transient
        public final Builder eventRisk(EventRiskType eventRisk) {
            this.eventRisk = eventRisk;
            return this;
        }

        public final List<ChallengeResponseType.Builder> getChallengeResponses() {
            List<ChallengeResponseType.Builder> result = ChallengeResponseListTypeCopier.copyToBuilder(this.challengeResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChallengeResponses(Collection<ChallengeResponseType.BuilderImpl> challengeResponses) {
            this.challengeResponses = ChallengeResponseListTypeCopier.copyFromBuilder(challengeResponses);
        }

        @Override
        @Transient
        public final Builder challengeResponses(Collection<ChallengeResponseType> challengeResponses) {
            this.challengeResponses = ChallengeResponseListTypeCopier.copy(challengeResponses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder challengeResponses(ChallengeResponseType... challengeResponses) {
            challengeResponses(Arrays.asList(challengeResponses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder challengeResponses(Consumer<ChallengeResponseType.Builder>... challengeResponses) {
            challengeResponses(Stream.of(challengeResponses).map(c -> ChallengeResponseType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EventContextDataType.Builder getEventContextData() {
            return eventContextData != null ? eventContextData.toBuilder() : null;
        }

        public final void setEventContextData(EventContextDataType.BuilderImpl eventContextData) {
            this.eventContextData = eventContextData != null ? eventContextData.build() : null;
        }

        @Override
        @Transient
        public final Builder eventContextData(EventContextDataType eventContextData) {
            this.eventContextData = eventContextData;
            return this;
        }

        public final EventFeedbackType.Builder getEventFeedback() {
            return eventFeedback != null ? eventFeedback.toBuilder() : null;
        }

        public final void setEventFeedback(EventFeedbackType.BuilderImpl eventFeedback) {
            this.eventFeedback = eventFeedback != null ? eventFeedback.build() : null;
        }

        @Override
        @Transient
        public final Builder eventFeedback(EventFeedbackType eventFeedback) {
            this.eventFeedback = eventFeedback;
            return this;
        }

        @Override
        public AuthEventType build() {
            return new AuthEventType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
