/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The compromised credentials actions type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompromisedCredentialsActionsType implements SdkPojo, Serializable,
        ToCopyableBuilder<CompromisedCredentialsActionsType.Builder, CompromisedCredentialsActionsType> {
    private static final SdkField<String> EVENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventAction").getter(getter(CompromisedCredentialsActionsType::eventActionAsString))
            .setter(setter(Builder::eventAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventAction;

    private CompromisedCredentialsActionsType(BuilderImpl builder) {
        this.eventAction = builder.eventAction;
    }

    /**
     * <p>
     * The event action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventAction} will
     * return {@link CompromisedCredentialsEventActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #eventActionAsString}.
     * </p>
     * 
     * @return The event action.
     * @see CompromisedCredentialsEventActionType
     */
    public final CompromisedCredentialsEventActionType eventAction() {
        return CompromisedCredentialsEventActionType.fromValue(eventAction);
    }

    /**
     * <p>
     * The event action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventAction} will
     * return {@link CompromisedCredentialsEventActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #eventActionAsString}.
     * </p>
     * 
     * @return The event action.
     * @see CompromisedCredentialsEventActionType
     */
    public final String eventActionAsString() {
        return eventAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompromisedCredentialsActionsType)) {
            return false;
        }
        CompromisedCredentialsActionsType other = (CompromisedCredentialsActionsType) obj;
        return Objects.equals(eventActionAsString(), other.eventActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompromisedCredentialsActionsType").add("EventAction", eventActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventAction":
            return Optional.ofNullable(clazz.cast(eventActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompromisedCredentialsActionsType, T> g) {
        return obj -> g.apply((CompromisedCredentialsActionsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompromisedCredentialsActionsType> {
        /**
         * <p>
         * The event action.
         * </p>
         * 
         * @param eventAction
         *        The event action.
         * @see CompromisedCredentialsEventActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompromisedCredentialsEventActionType
         */
        Builder eventAction(String eventAction);

        /**
         * <p>
         * The event action.
         * </p>
         * 
         * @param eventAction
         *        The event action.
         * @see CompromisedCredentialsEventActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompromisedCredentialsEventActionType
         */
        Builder eventAction(CompromisedCredentialsEventActionType eventAction);
    }

    static final class BuilderImpl implements Builder {
        private String eventAction;

        private BuilderImpl() {
        }

        private BuilderImpl(CompromisedCredentialsActionsType model) {
            eventAction(model.eventAction);
        }

        public final String getEventAction() {
            return eventAction;
        }

        public final void setEventAction(String eventAction) {
            this.eventAction = eventAction;
        }

        @Override
        @Transient
        public final Builder eventAction(String eventAction) {
            this.eventAction = eventAction;
            return this;
        }

        @Override
        @Transient
        public final Builder eventAction(CompromisedCredentialsEventActionType eventAction) {
            this.eventAction(eventAction == null ? null : eventAction.toString());
            return this;
        }

        @Override
        public CompromisedCredentialsActionsType build() {
            return new CompromisedCredentialsActionsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
