/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to respond to the authentication challenge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RespondToAuthChallengeResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<RespondToAuthChallengeResponse.Builder, RespondToAuthChallengeResponse> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeName").getter(getter(RespondToAuthChallengeResponse::challengeNameAsString))
            .setter(setter(Builder::challengeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()).build();

    private static final SdkField<String> SESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Session")
            .getter(getter(RespondToAuthChallengeResponse::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final SdkField<Map<String, String>> CHALLENGE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ChallengeParameters")
            .getter(getter(RespondToAuthChallengeResponse::challengeParameters))
            .setter(setter(Builder::challengeParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthenticationResultType> AUTHENTICATION_RESULT_FIELD = SdkField
            .<AuthenticationResultType> builder(MarshallingType.SDK_POJO).memberName("AuthenticationResult")
            .getter(getter(RespondToAuthChallengeResponse::authenticationResult)).setter(setter(Builder::authenticationResult))
            .constructor(AuthenticationResultType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD,
            SESSION_FIELD, CHALLENGE_PARAMETERS_FIELD, AUTHENTICATION_RESULT_FIELD));

    private final String challengeName;

    private final String session;

    private final Map<String, String> challengeParameters;

    private final AuthenticationResultType authenticationResult;

    private RespondToAuthChallengeResponse(BuilderImpl builder) {
        super(builder);
        this.challengeName = builder.challengeName;
        this.session = builder.session;
        this.challengeParameters = builder.challengeParameters;
        this.authenticationResult = builder.authenticationResult;
    }

    /**
     * <p>
     * The challenge name. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     * >InitiateAuth</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeNameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The challenge name. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     *         >InitiateAuth</a>.
     * @see ChallengeNameType
     */
    public final ChallengeNameType challengeName() {
        return ChallengeNameType.fromValue(challengeName);
    }

    /**
     * <p>
     * The challenge name. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     * >InitiateAuth</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #challengeName}
     * will return {@link ChallengeNameType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #challengeNameAsString}.
     * </p>
     * 
     * @return The challenge name. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     *         >InitiateAuth</a>.
     * @see ChallengeNameType
     */
    public final String challengeNameAsString() {
        return challengeName;
    }

    /**
     * <p>
     * The session that should be passed both ways in challenge-response calls to the service. If the caller must pass
     * another challenge, they return a session with other challenge parameters. This session should be passed as it is
     * to the next <code>RespondToAuthChallenge</code> API call.
     * </p>
     * 
     * @return The session that should be passed both ways in challenge-response calls to the service. If the caller
     *         must pass another challenge, they return a session with other challenge parameters. This session should
     *         be passed as it is to the next <code>RespondToAuthChallenge</code> API call.
     */
    public final String session() {
        return session;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChallengeParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChallengeParameters() {
        return challengeParameters != null && !(challengeParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The challenge parameters. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     * >InitiateAuth</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChallengeParameters} method.
     * </p>
     * 
     * @return The challenge parameters. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
     *         >InitiateAuth</a>.
     */
    public final Map<String, String> challengeParameters() {
        return challengeParameters;
    }

    /**
     * <p>
     * The result returned by the server in response to the request to respond to the authentication challenge.
     * </p>
     * 
     * @return The result returned by the server in response to the request to respond to the authentication challenge.
     */
    public final AuthenticationResultType authenticationResult() {
        return authenticationResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        hashCode = 31 * hashCode + Objects.hashCode(hasChallengeParameters() ? challengeParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondToAuthChallengeResponse)) {
            return false;
        }
        RespondToAuthChallengeResponse other = (RespondToAuthChallengeResponse) obj;
        return Objects.equals(challengeNameAsString(), other.challengeNameAsString())
                && Objects.equals(session(), other.session()) && hasChallengeParameters() == other.hasChallengeParameters()
                && Objects.equals(challengeParameters(), other.challengeParameters())
                && Objects.equals(authenticationResult(), other.authenticationResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RespondToAuthChallengeResponse").add("ChallengeName", challengeNameAsString())
                .add("Session", session()).add("ChallengeParameters", hasChallengeParameters() ? challengeParameters() : null)
                .add("AuthenticationResult", authenticationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChallengeName":
            return Optional.ofNullable(clazz.cast(challengeNameAsString()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        case "ChallengeParameters":
            return Optional.ofNullable(clazz.cast(challengeParameters()));
        case "AuthenticationResult":
            return Optional.ofNullable(clazz.cast(authenticationResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RespondToAuthChallengeResponse, T> g) {
        return obj -> g.apply((RespondToAuthChallengeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RespondToAuthChallengeResponse> {
        /**
         * <p>
         * The challenge name. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         * >InitiateAuth</a>.
         * </p>
         * 
         * @param challengeName
         *        The challenge name. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         *        >InitiateAuth</a>.
         * @see ChallengeNameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeNameType
         */
        Builder challengeName(String challengeName);

        /**
         * <p>
         * The challenge name. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         * >InitiateAuth</a>.
         * </p>
         * 
         * @param challengeName
         *        The challenge name. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         *        >InitiateAuth</a>.
         * @see ChallengeNameType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChallengeNameType
         */
        Builder challengeName(ChallengeNameType challengeName);

        /**
         * <p>
         * The session that should be passed both ways in challenge-response calls to the service. If the caller must
         * pass another challenge, they return a session with other challenge parameters. This session should be passed
         * as it is to the next <code>RespondToAuthChallenge</code> API call.
         * </p>
         * 
         * @param session
         *        The session that should be passed both ways in challenge-response calls to the service. If the caller
         *        must pass another challenge, they return a session with other challenge parameters. This session
         *        should be passed as it is to the next <code>RespondToAuthChallenge</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(String session);

        /**
         * <p>
         * The challenge parameters. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         * >InitiateAuth</a>.
         * </p>
         * 
         * @param challengeParameters
         *        The challenge parameters. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html"
         *        >InitiateAuth</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeParameters(Map<String, String> challengeParameters);

        /**
         * <p>
         * The result returned by the server in response to the request to respond to the authentication challenge.
         * </p>
         * 
         * @param authenticationResult
         *        The result returned by the server in response to the request to respond to the authentication
         *        challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationResult(AuthenticationResultType authenticationResult);

        /**
         * <p>
         * The result returned by the server in response to the request to respond to the authentication challenge.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthenticationResultType.Builder} avoiding the
         * need to create one manually via {@link AuthenticationResultType#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticationResultType.Builder#build()} is called immediately
         * and its result is passed to {@link #authenticationResult(AuthenticationResultType)}.
         * 
         * @param authenticationResult
         *        a consumer that will call methods on {@link AuthenticationResultType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationResult(AuthenticationResultType)
         */
        default Builder authenticationResult(Consumer<AuthenticationResultType.Builder> authenticationResult) {
            return authenticationResult(AuthenticationResultType.builder().applyMutation(authenticationResult).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String challengeName;

        private String session;

        private Map<String, String> challengeParameters = DefaultSdkAutoConstructMap.getInstance();

        private AuthenticationResultType authenticationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RespondToAuthChallengeResponse model) {
            super(model);
            challengeName(model.challengeName);
            session(model.session);
            challengeParameters(model.challengeParameters);
            authenticationResult(model.authenticationResult);
        }

        public final String getChallengeName() {
            return challengeName;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        @Override
        @Transient
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        @Transient
        public final Builder challengeName(ChallengeNameType challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final String getSession() {
            return session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        @Transient
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final Map<String, String> getChallengeParameters() {
            if (challengeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return challengeParameters;
        }

        public final void setChallengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
        }

        @Override
        @Transient
        public final Builder challengeParameters(Map<String, String> challengeParameters) {
            this.challengeParameters = ChallengeParametersTypeCopier.copy(challengeParameters);
            return this;
        }

        public final AuthenticationResultType.Builder getAuthenticationResult() {
            return authenticationResult != null ? authenticationResult.toBuilder() : null;
        }

        public final void setAuthenticationResult(AuthenticationResultType.BuilderImpl authenticationResult) {
            this.authenticationResult = authenticationResult != null ? authenticationResult.build() : null;
        }

        @Override
        @Transient
        public final Builder authenticationResult(AuthenticationResultType authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        @Override
        public RespondToAuthChallengeResponse build() {
            return new RespondToAuthChallengeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
