/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server from the request to get the specified user as an administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminGetUserResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminGetUserResponse.Builder, AdminGetUserResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(AdminGetUserResponse::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField
            .<List<AttributeType>> builder(MarshallingType.LIST)
            .memberName("UserAttributes")
            .getter(getter(AdminGetUserResponse::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> USER_CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UserCreateDate").getter(getter(AdminGetUserResponse::userCreateDate))
            .setter(setter(Builder::userCreateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCreateDate").build()).build();

    private static final SdkField<Instant> USER_LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UserLastModifiedDate").getter(getter(AdminGetUserResponse::userLastModifiedDate))
            .setter(setter(Builder::userLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserLastModifiedDate").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AdminGetUserResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserStatus").getter(getter(AdminGetUserResponse::userStatusAsString))
            .setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()).build();

    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField
            .<List<MFAOptionType>> builder(MarshallingType.LIST)
            .memberName("MFAOptions")
            .getter(getter(AdminGetUserResponse::mfaOptions))
            .setter(setter(Builder::mfaOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MFAOptionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(MFAOptionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredMfaSetting").getter(getter(AdminGetUserResponse::preferredMfaSetting))
            .setter(setter(Builder::preferredMfaSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build())
            .build();

    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserMFASettingList")
            .getter(getter(AdminGetUserResponse::userMFASettingList))
            .setter(setter(Builder::userMFASettingList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            USER_ATTRIBUTES_FIELD, USER_CREATE_DATE_FIELD, USER_LAST_MODIFIED_DATE_FIELD, ENABLED_FIELD, USER_STATUS_FIELD,
            MFA_OPTIONS_FIELD, PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD));

    private final String username;

    private final List<AttributeType> userAttributes;

    private final Instant userCreateDate;

    private final Instant userLastModifiedDate;

    private final Boolean enabled;

    private final String userStatus;

    private final List<MFAOptionType> mfaOptions;

    private final String preferredMfaSetting;

    private final List<String> userMFASettingList;

    private AdminGetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
    }

    /**
     * <p>
     * The user name of the user about whom you're receiving information.
     * </p>
     * 
     * @return The user name of the user about whom you're receiving information.
     */
    public final String username() {
        return username;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of name-value pairs representing user attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAttributes} method.
     * </p>
     * 
     * @return An array of name-value pairs representing user attributes.
     */
    public final List<AttributeType> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The date the user was created.
     * </p>
     * 
     * @return The date the user was created.
     */
    public final Instant userCreateDate() {
        return userCreateDate;
    }

    /**
     * <p>
     * The date the user was last modified.
     * </p>
     * 
     * @return The date the user was last modified.
     */
    public final Instant userLastModifiedDate() {
        return userLastModifiedDate;
    }

    /**
     * <p>
     * Indicates that the status is <code>enabled</code>.
     * </p>
     * 
     * @return Indicates that the status is <code>enabled</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status isn't known.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can
     * sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first
     * sign-in, the user must change their password to a new value before doing anything else.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status isn't known.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they
     *         can sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
     *         first sign-in, the user must change their password to a new value before doing anything else.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public final UserStatusType userStatus() {
        return UserStatusType.fromValue(userStatus);
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status isn't known.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can
     * sign in.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first
     * sign-in, the user must change their password to a new value before doing anything else.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status isn't known.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they
     *         can sign in.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
     *         first sign-in, the user must change their password to a new value before doing anything else.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public final String userStatusAsString() {
        return userStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the MFAOptions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMfaOptions() {
        return mfaOptions != null && !(mfaOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA configurations.
     * It doesn't provide information about time-based one-time password (TOTP) software token MFA configurations. To
     * look up information about either type of MFA configuration, use UserMFASettingList instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMfaOptions} method.
     * </p>
     * 
     * @return <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
     *         configurations. It doesn't provide information about time-based one-time password (TOTP) software token
     *         MFA configurations. To look up information about either type of MFA configuration, use UserMFASettingList
     *         instead.
     */
    public final List<MFAOptionType> mfaOptions() {
        return mfaOptions;
    }

    /**
     * <p>
     * The user's preferred MFA setting.
     * </p>
     * 
     * @return The user's preferred MFA setting.
     */
    public final String preferredMfaSetting() {
        return preferredMfaSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMFASettingList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMFASettingList() {
        return userMFASettingList != null && !(userMFASettingList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code> and
     * <code>SOFTWARE_TOKEN_MFA</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMFASettingList} method.
     * </p>
     * 
     * @return The MFA options that are activated for the user. The possible values in this list are
     *         <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.
     */
    public final List<String> userMFASettingList() {
        return userMFASettingList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAttributes() ? userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMfaOptions() ? mfaOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMFASettingList() ? userMFASettingList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetUserResponse)) {
            return false;
        }
        AdminGetUserResponse other = (AdminGetUserResponse) obj;
        return Objects.equals(username(), other.username()) && hasUserAttributes() == other.hasUserAttributes()
                && Objects.equals(userAttributes(), other.userAttributes())
                && Objects.equals(userCreateDate(), other.userCreateDate())
                && Objects.equals(userLastModifiedDate(), other.userLastModifiedDate())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(userStatusAsString(), other.userStatusAsString())
                && hasMfaOptions() == other.hasMfaOptions() && Objects.equals(mfaOptions(), other.mfaOptions())
                && Objects.equals(preferredMfaSetting(), other.preferredMfaSetting())
                && hasUserMFASettingList() == other.hasUserMFASettingList()
                && Objects.equals(userMFASettingList(), other.userMFASettingList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminGetUserResponse")
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserAttributes", hasUserAttributes() ? userAttributes() : null).add("UserCreateDate", userCreateDate())
                .add("UserLastModifiedDate", userLastModifiedDate()).add("Enabled", enabled())
                .add("UserStatus", userStatusAsString()).add("MFAOptions", hasMfaOptions() ? mfaOptions() : null)
                .add("PreferredMfaSetting", preferredMfaSetting())
                .add("UserMFASettingList", hasUserMFASettingList() ? userMFASettingList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "UserCreateDate":
            return Optional.ofNullable(clazz.cast(userCreateDate()));
        case "UserLastModifiedDate":
            return Optional.ofNullable(clazz.cast(userLastModifiedDate()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        case "MFAOptions":
            return Optional.ofNullable(clazz.cast(mfaOptions()));
        case "PreferredMfaSetting":
            return Optional.ofNullable(clazz.cast(preferredMfaSetting()));
        case "UserMFASettingList":
            return Optional.ofNullable(clazz.cast(userMFASettingList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminGetUserResponse, T> g) {
        return obj -> g.apply((AdminGetUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminGetUserResponse> {
        /**
         * <p>
         * The user name of the user about whom you're receiving information.
         * </p>
         * 
         * @param username
         *        The user name of the user about whom you're receiving information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Collection<AttributeType> userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(AttributeType... userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeType>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #userAttributes(List<AttributeType>)}.
         * 
         * @param userAttributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributes(List<AttributeType>)
         */
        Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes);

        /**
         * <p>
         * The date the user was created.
         * </p>
         * 
         * @param userCreateDate
         *        The date the user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCreateDate(Instant userCreateDate);

        /**
         * <p>
         * The date the user was last modified.
         * </p>
         * 
         * @param userLastModifiedDate
         *        The date the user was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userLastModifiedDate(Instant userLastModifiedDate);

        /**
         * <p>
         * Indicates that the status is <code>enabled</code>.
         * </p>
         * 
         * @param enabled
         *        Indicates that the status is <code>enabled</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status isn't known.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can
         * sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
         * first sign-in, the user must change their password to a new value before doing anything else.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status isn't known.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before
         *        they can sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but
         *        on first sign-in, the user must change their password to a new value before doing anything else.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status isn't known.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can
         * sign in.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on
         * first sign-in, the user must change their password to a new value before doing anything else.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status isn't known.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before
         *        they can sign in.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but
         *        on first sign-in, the user must change their password to a new value before doing anything else.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(UserStatusType userStatus);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA
         * configurations. To look up information about either type of MFA configuration, use UserMFASettingList
         * instead.
         * </p>
         * 
         * @param mfaOptions
         *        <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         *        configurations. It doesn't provide information about time-based one-time password (TOTP) software
         *        token MFA configurations. To look up information about either type of MFA configuration, use
         *        UserMFASettingList instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(Collection<MFAOptionType> mfaOptions);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA
         * configurations. To look up information about either type of MFA configuration, use UserMFASettingList
         * instead.
         * </p>
         * 
         * @param mfaOptions
         *        <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         *        configurations. It doesn't provide information about time-based one-time password (TOTP) software
         *        token MFA configurations. To look up information about either type of MFA configuration, use
         *        UserMFASettingList instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(MFAOptionType... mfaOptions);

        /**
         * <p>
         * <i>This response parameter is no longer supported.</i> It provides information only about SMS MFA
         * configurations. It doesn't provide information about time-based one-time password (TOTP) software token MFA
         * configurations. To look up information about either type of MFA configuration, use UserMFASettingList
         * instead.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFAOptionType>.Builder} avoiding the need
         * to create one manually via {@link List<MFAOptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFAOptionType>.Builder#build()} is called immediately and
         * its result is passed to {@link #mfaOptions(List<MFAOptionType>)}.
         * 
         * @param mfaOptions
         *        a consumer that will call methods on {@link List<MFAOptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaOptions(List<MFAOptionType>)
         */
        Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions);

        /**
         * <p>
         * The user's preferred MFA setting.
         * </p>
         * 
         * @param preferredMfaSetting
         *        The user's preferred MFA setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMfaSetting(String preferredMfaSetting);

        /**
         * <p>
         * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code>
         * and <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are activated for the user. The possible values in this list are
         *        <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(Collection<String> userMFASettingList);

        /**
         * <p>
         * The MFA options that are activated for the user. The possible values in this list are <code>SMS_MFA</code>
         * and <code>SOFTWARE_TOKEN_MFA</code>.
         * </p>
         * 
         * @param userMFASettingList
         *        The MFA options that are activated for the user. The possible values in this list are
         *        <code>SMS_MFA</code> and <code>SOFTWARE_TOKEN_MFA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMFASettingList(String... userMFASettingList);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String username;

        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant userCreateDate;

        private Instant userLastModifiedDate;

        private Boolean enabled;

        private String userStatus;

        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private String preferredMfaSetting;

        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminGetUserResponse model) {
            super(model);
            username(model.username);
            userAttributes(model.userAttributes);
            userCreateDate(model.userCreateDate);
            userLastModifiedDate(model.userLastModifiedDate);
            enabled(model.enabled);
            userStatus(model.userStatus);
            mfaOptions(model.mfaOptions);
            preferredMfaSetting(model.preferredMfaSetting);
            userMFASettingList(model.userMFASettingList);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final List<AttributeType.Builder> getUserAttributes() {
            List<AttributeType.Builder> result = AttributeListTypeCopier.copyToBuilder(this.userAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        @Override
        @Transient
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userAttributes(AttributeType... userAttributes) {
            userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes) {
            userAttributes(Stream.of(userAttributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getUserCreateDate() {
            return userCreateDate;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        @Override
        @Transient
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final Instant getUserLastModifiedDate() {
            return userLastModifiedDate;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        @Override
        @Transient
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        @Transient
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        public final List<MFAOptionType.Builder> getMfaOptions() {
            List<MFAOptionType.Builder> result = MFAOptionListTypeCopier.copyToBuilder(this.mfaOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        @Transient
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType... mfaOptions) {
            mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions) {
            mfaOptions(Stream.of(mfaOptions).map(c -> MFAOptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPreferredMfaSetting() {
            return preferredMfaSetting;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        @Override
        @Transient
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final Collection<String> getUserMFASettingList() {
            if (userMFASettingList instanceof SdkAutoConstructList) {
                return null;
            }
            return userMFASettingList;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        @Transient
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userMFASettingList(String... userMFASettingList) {
            userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        @Override
        public AdminGetUserResponse build() {
            return new AdminGetUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
