/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to create the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminCreateUserResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminCreateUserResponse.Builder, AdminCreateUserResponse> {
    private static final SdkField<UserType> USER_FIELD = SdkField.<UserType> builder(MarshallingType.SDK_POJO).memberName("User")
            .getter(getter(AdminCreateUserResponse::user)).setter(setter(Builder::user)).constructor(UserType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD));

    private final UserType user;

    private AdminCreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.user = builder.user;
    }

    /**
     * <p>
     * The newly created user.
     * </p>
     * 
     * @return The newly created user.
     */
    public final UserType user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserResponse)) {
            return false;
        }
        AdminCreateUserResponse other = (AdminCreateUserResponse) obj;
        return Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminCreateUserResponse").add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminCreateUserResponse, T> g) {
        return obj -> g.apply((AdminCreateUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminCreateUserResponse> {
        /**
         * <p>
         * The newly created user.
         * </p>
         * 
         * @param user
         *        The newly created user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(UserType user);

        /**
         * <p>
         * The newly created user.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserType.Builder} avoiding the need to
         * create one manually via {@link UserType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserType.Builder#build()} is called immediately and its result is
         * passed to {@link #user(UserType)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link UserType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(UserType)
         */
        default Builder user(Consumer<UserType.Builder> user) {
            return user(UserType.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UserType user;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminCreateUserResponse model) {
            super(model);
            user(model.user);
        }

        public final UserType.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(UserType.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        @Transient
        public final Builder user(UserType user) {
            this.user = user;
            return this;
        }

        @Override
        public AdminCreateUserResponse build() {
            return new AdminCreateUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
