/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminDisableProviderForUserRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminDisableProviderForUserRequest.Builder, AdminDisableProviderForUserRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(AdminDisableProviderForUserRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<ProviderUserIdentifierType> USER_FIELD = SdkField
            .<ProviderUserIdentifierType> builder(MarshallingType.SDK_POJO).memberName("User")
            .getter(getter(AdminDisableProviderForUserRequest::user)).setter(setter(Builder::user))
            .constructor(ProviderUserIdentifierType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_POOL_ID_FIELD, USER_FIELD));

    private final String userPoolId;

    private final ProviderUserIdentifierType user;

    private AdminDisableProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.user = builder.user;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The user to be disabled.
     * </p>
     * 
     * @return The user to be disabled.
     */
    public final ProviderUserIdentifierType user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminDisableProviderForUserRequest)) {
            return false;
        }
        AdminDisableProviderForUserRequest other = (AdminDisableProviderForUserRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminDisableProviderForUserRequest").add("UserPoolId", userPoolId()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminDisableProviderForUserRequest, T> g) {
        return obj -> g.apply((AdminDisableProviderForUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminDisableProviderForUserRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The user to be disabled.
         * </p>
         * 
         * @param user
         *        The user to be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(ProviderUserIdentifierType user);

        /**
         * <p>
         * The user to be disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderUserIdentifierType.Builder}
         * avoiding the need to create one manually via {@link ProviderUserIdentifierType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProviderUserIdentifierType.Builder#build()} is called immediately
         * and its result is passed to {@link #user(ProviderUserIdentifierType)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link ProviderUserIdentifierType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(ProviderUserIdentifierType)
         */
        default Builder user(Consumer<ProviderUserIdentifierType.Builder> user) {
            return user(ProviderUserIdentifierType.builder().applyMutation(user).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private ProviderUserIdentifierType user;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminDisableProviderForUserRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            user(model.user);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final ProviderUserIdentifierType.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(ProviderUserIdentifierType.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        @Transient
        public final Builder user(ProviderUserIdentifierType user) {
            this.user = user;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminDisableProviderForUserRequest build() {
            return new AdminDisableProviderForUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
