/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserPoolDomainResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeUserPoolDomainResponse.Builder, DescribeUserPoolDomainResponse> {
    private static final SdkField<DomainDescriptionType> DOMAIN_DESCRIPTION_FIELD = SdkField
            .<DomainDescriptionType> builder(MarshallingType.SDK_POJO).memberName("DomainDescription")
            .getter(getter(DescribeUserPoolDomainResponse::domainDescription)).setter(setter(Builder::domainDescription))
            .constructor(DomainDescriptionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_DESCRIPTION_FIELD));

    private final DomainDescriptionType domainDescription;

    private DescribeUserPoolDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainDescription = builder.domainDescription;
    }

    /**
     * <p>
     * A domain description object containing information about the domain.
     * </p>
     * 
     * @return A domain description object containing information about the domain.
     */
    public final DomainDescriptionType domainDescription() {
        return domainDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserPoolDomainResponse)) {
            return false;
        }
        DescribeUserPoolDomainResponse other = (DescribeUserPoolDomainResponse) obj;
        return Objects.equals(domainDescription(), other.domainDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserPoolDomainResponse").add("DomainDescription", domainDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainDescription":
            return Optional.ofNullable(clazz.cast(domainDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserPoolDomainResponse, T> g) {
        return obj -> g.apply((DescribeUserPoolDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserPoolDomainResponse> {
        /**
         * <p>
         * A domain description object containing information about the domain.
         * </p>
         * 
         * @param domainDescription
         *        A domain description object containing information about the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDescription(DomainDescriptionType domainDescription);

        /**
         * <p>
         * A domain description object containing information about the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainDescriptionType.Builder} avoiding
         * the need to create one manually via {@link DomainDescriptionType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainDescriptionType.Builder#build()} is called immediately and
         * its result is passed to {@link #domainDescription(DomainDescriptionType)}.
         * 
         * @param domainDescription
         *        a consumer that will call methods on {@link DomainDescriptionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDescription(DomainDescriptionType)
         */
        default Builder domainDescription(Consumer<DomainDescriptionType.Builder> domainDescription) {
            return domainDescription(DomainDescriptionType.builder().applyMutation(domainDescription).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private DomainDescriptionType domainDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserPoolDomainResponse model) {
            super(model);
            domainDescription(model.domainDescription);
        }

        public final DomainDescriptionType.Builder getDomainDescription() {
            return domainDescription != null ? domainDescription.toBuilder() : null;
        }

        public final void setDomainDescription(DomainDescriptionType.BuilderImpl domainDescription) {
            this.domainDescription = domainDescription != null ? domainDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder domainDescription(DomainDescriptionType domainDescription) {
            this.domainDescription = domainDescription;
            return this;
        }

        @Override
        public DescribeUserPoolDomainResponse build() {
            return new DescribeUserPoolDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
