/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityProvidersResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ListIdentityProvidersResponse.Builder, ListIdentityProvidersResponse> {
    private static final SdkField<List<ProviderDescription>> PROVIDERS_FIELD = SdkField
            .<List<ProviderDescription>> builder(MarshallingType.LIST)
            .memberName("Providers")
            .getter(getter(ListIdentityProvidersResponse::providers))
            .setter(setter(Builder::providers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Providers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProviderDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProviderDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentityProvidersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProviderDescription> providers;

    private final String nextToken;

    private ListIdentityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.providers = builder.providers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Providers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProviders() {
        return providers != null && !(providers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identity provider objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviders} method.
     * </p>
     * 
     * @return A list of identity provider objects.
     */
    public final List<ProviderDescription> providers() {
        return providers;
    }

    /**
     * <p>
     * A pagination token.
     * </p>
     * 
     * @return A pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProviders() ? providers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResponse)) {
            return false;
        }
        ListIdentityProvidersResponse other = (ListIdentityProvidersResponse) obj;
        return hasProviders() == other.hasProviders() && Objects.equals(providers(), other.providers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentityProvidersResponse").add("Providers", hasProviders() ? providers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Providers":
            return Optional.ofNullable(clazz.cast(providers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProvidersResponse, T> g) {
        return obj -> g.apply((ListIdentityProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentityProvidersResponse> {
        /**
         * <p>
         * A list of identity provider objects.
         * </p>
         * 
         * @param providers
         *        A list of identity provider objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(Collection<ProviderDescription> providers);

        /**
         * <p>
         * A list of identity provider objects.
         * </p>
         * 
         * @param providers
         *        A list of identity provider objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providers(ProviderDescription... providers);

        /**
         * <p>
         * A list of identity provider objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProviderDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ProviderDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProviderDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #providers(List<ProviderDescription>)}.
         * 
         * @param providers
         *        a consumer that will call methods on {@link List<ProviderDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providers(List<ProviderDescription>)
         */
        Builder providers(Consumer<ProviderDescription.Builder>... providers);

        /**
         * <p>
         * A pagination token.
         * </p>
         * 
         * @param nextToken
         *        A pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<ProviderDescription> providers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProvidersResponse model) {
            super(model);
            providers(model.providers);
            nextToken(model.nextToken);
        }

        public final List<ProviderDescription.Builder> getProviders() {
            List<ProviderDescription.Builder> result = ProvidersListTypeCopier.copyToBuilder(this.providers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviders(Collection<ProviderDescription.BuilderImpl> providers) {
            this.providers = ProvidersListTypeCopier.copyFromBuilder(providers);
        }

        @Override
        @Transient
        public final Builder providers(Collection<ProviderDescription> providers) {
            this.providers = ProvidersListTypeCopier.copy(providers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providers(ProviderDescription... providers) {
            providers(Arrays.asList(providers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providers(Consumer<ProviderDescription.Builder>... providers) {
            providers(Stream.of(providers).map(c -> ProviderDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
