/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The notify email type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyEmailType implements SdkPojo, Serializable, ToCopyableBuilder<NotifyEmailType.Builder, NotifyEmailType> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(NotifyEmailType::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> HTML_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HtmlBody").getter(getter(NotifyEmailType::htmlBody)).setter(setter(Builder::htmlBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlBody").build()).build();

    private static final SdkField<String> TEXT_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextBody").getter(getter(NotifyEmailType::textBody)).setter(setter(Builder::textBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD,
            HTML_BODY_FIELD, TEXT_BODY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subject;

    private final String htmlBody;

    private final String textBody;

    private NotifyEmailType(BuilderImpl builder) {
        this.subject = builder.subject;
        this.htmlBody = builder.htmlBody;
        this.textBody = builder.textBody;
    }

    /**
     * <p>
     * The email subject.
     * </p>
     * 
     * @return The email subject.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The email HTML body.
     * </p>
     * 
     * @return The email HTML body.
     */
    public final String htmlBody() {
        return htmlBody;
    }

    /**
     * <p>
     * The email text body.
     * </p>
     * 
     * @return The email text body.
     */
    public final String textBody() {
        return textBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(htmlBody());
        hashCode = 31 * hashCode + Objects.hashCode(textBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyEmailType)) {
            return false;
        }
        NotifyEmailType other = (NotifyEmailType) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(htmlBody(), other.htmlBody())
                && Objects.equals(textBody(), other.textBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyEmailType").add("Subject", subject()).add("HtmlBody", htmlBody())
                .add("TextBody", textBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "HtmlBody":
            return Optional.ofNullable(clazz.cast(htmlBody()));
        case "TextBody":
            return Optional.ofNullable(clazz.cast(textBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyEmailType, T> g) {
        return obj -> g.apply((NotifyEmailType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotifyEmailType> {
        /**
         * <p>
         * The email subject.
         * </p>
         * 
         * @param subject
         *        The email subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The email HTML body.
         * </p>
         * 
         * @param htmlBody
         *        The email HTML body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlBody(String htmlBody);

        /**
         * <p>
         * The email text body.
         * </p>
         * 
         * @param textBody
         *        The email text body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBody(String textBody);
    }

    static final class BuilderImpl implements Builder {
        private String subject;

        private String htmlBody;

        private String textBody;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyEmailType model) {
            subject(model.subject);
            htmlBody(model.htmlBody);
            textBody(model.textBody);
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        @Transient
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getHtmlBody() {
            return htmlBody;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        @Override
        @Transient
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final String getTextBody() {
            return textBody;
        }

        public final void setTextBody(String textBody) {
            this.textBody = textBody;
        }

        @Override
        @Transient
        public final Builder textBody(String textBody) {
            this.textBody = textBody;
            return this;
        }

        @Override
        public NotifyEmailType build() {
            return new NotifyEmailType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
