/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the server when Amazon Cognito makes the request to resend a confirmation code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResendConfirmationCodeResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<ResendConfirmationCodeResponse.Builder, ResendConfirmationCodeResponse> {
    private static final SdkField<CodeDeliveryDetailsType> CODE_DELIVERY_DETAILS_FIELD = SdkField
            .<CodeDeliveryDetailsType> builder(MarshallingType.SDK_POJO).memberName("CodeDeliveryDetails")
            .getter(getter(ResendConfirmationCodeResponse::codeDeliveryDetails)).setter(setter(Builder::codeDeliveryDetails))
            .constructor(CodeDeliveryDetailsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeliveryDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_DELIVERY_DETAILS_FIELD));

    private final CodeDeliveryDetailsType codeDeliveryDetails;

    private ResendConfirmationCodeResponse(BuilderImpl builder) {
        super(builder);
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
    }

    /**
     * <p>
     * The code delivery details returned by the server in response to the request to resend the confirmation code.
     * </p>
     * 
     * @return The code delivery details returned by the server in response to the request to resend the confirmation
     *         code.
     */
    public final CodeDeliveryDetailsType codeDeliveryDetails() {
        return codeDeliveryDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeDeliveryDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendConfirmationCodeResponse)) {
            return false;
        }
        ResendConfirmationCodeResponse other = (ResendConfirmationCodeResponse) obj;
        return Objects.equals(codeDeliveryDetails(), other.codeDeliveryDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResendConfirmationCodeResponse").add("CodeDeliveryDetails", codeDeliveryDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeDeliveryDetails":
            return Optional.ofNullable(clazz.cast(codeDeliveryDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResendConfirmationCodeResponse, T> g) {
        return obj -> g.apply((ResendConfirmationCodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ResendConfirmationCodeResponse> {
        /**
         * <p>
         * The code delivery details returned by the server in response to the request to resend the confirmation code.
         * </p>
         * 
         * @param codeDeliveryDetails
         *        The code delivery details returned by the server in response to the request to resend the confirmation
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails);

        /**
         * <p>
         * The code delivery details returned by the server in response to the request to resend the confirmation code.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeDeliveryDetailsType.Builder} avoiding
         * the need to create one manually via {@link CodeDeliveryDetailsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeDeliveryDetailsType.Builder#build()} is called immediately
         * and its result is passed to {@link #codeDeliveryDetails(CodeDeliveryDetailsType)}.
         * 
         * @param codeDeliveryDetails
         *        a consumer that will call methods on {@link CodeDeliveryDetailsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeliveryDetails(CodeDeliveryDetailsType)
         */
        default Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return codeDeliveryDetails(CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private CodeDeliveryDetailsType codeDeliveryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendConfirmationCodeResponse model) {
            super(model);
            codeDeliveryDetails(model.codeDeliveryDetails);
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return codeDeliveryDetails != null ? codeDeliveryDetails.toBuilder() : null;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        @Override
        public ResendConfirmationCodeResponse build() {
            return new ResendConfirmationCodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
