/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response from the server for a registration request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignUpResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<SignUpResponse.Builder, SignUpResponse> {
    private static final SdkField<Boolean> USER_CONFIRMED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserConfirmed").getter(getter(SignUpResponse::userConfirmed)).setter(setter(Builder::userConfirmed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfirmed").build()).build();

    private static final SdkField<CodeDeliveryDetailsType> CODE_DELIVERY_DETAILS_FIELD = SdkField
            .<CodeDeliveryDetailsType> builder(MarshallingType.SDK_POJO).memberName("CodeDeliveryDetails")
            .getter(getter(SignUpResponse::codeDeliveryDetails)).setter(setter(Builder::codeDeliveryDetails))
            .constructor(CodeDeliveryDetailsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeliveryDetails").build())
            .build();

    private static final SdkField<String> USER_SUB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserSub").getter(getter(SignUpResponse::userSub)).setter(setter(Builder::userSub))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSub").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_CONFIRMED_FIELD,
            CODE_DELIVERY_DETAILS_FIELD, USER_SUB_FIELD));

    private final Boolean userConfirmed;

    private final CodeDeliveryDetailsType codeDeliveryDetails;

    private final String userSub;

    private SignUpResponse(BuilderImpl builder) {
        super(builder);
        this.userConfirmed = builder.userConfirmed;
        this.codeDeliveryDetails = builder.codeDeliveryDetails;
        this.userSub = builder.userSub;
    }

    /**
     * <p>
     * A response from the server indicating that a user registration has been confirmed.
     * </p>
     * 
     * @return A response from the server indicating that a user registration has been confirmed.
     */
    public final Boolean userConfirmed() {
        return userConfirmed;
    }

    /**
     * <p>
     * The code delivery details returned by the server response to the user registration request.
     * </p>
     * 
     * @return The code delivery details returned by the server response to the user registration request.
     */
    public final CodeDeliveryDetailsType codeDeliveryDetails() {
        return codeDeliveryDetails;
    }

    /**
     * <p>
     * The UUID of the authenticated user. This isn't the same as <code>username</code>.
     * </p>
     * 
     * @return The UUID of the authenticated user. This isn't the same as <code>username</code>.
     */
    public final String userSub() {
        return userSub;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userConfirmed());
        hashCode = 31 * hashCode + Objects.hashCode(codeDeliveryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(userSub());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignUpResponse)) {
            return false;
        }
        SignUpResponse other = (SignUpResponse) obj;
        return Objects.equals(userConfirmed(), other.userConfirmed())
                && Objects.equals(codeDeliveryDetails(), other.codeDeliveryDetails())
                && Objects.equals(userSub(), other.userSub());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignUpResponse").add("UserConfirmed", userConfirmed())
                .add("CodeDeliveryDetails", codeDeliveryDetails()).add("UserSub", userSub()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserConfirmed":
            return Optional.ofNullable(clazz.cast(userConfirmed()));
        case "CodeDeliveryDetails":
            return Optional.ofNullable(clazz.cast(codeDeliveryDetails()));
        case "UserSub":
            return Optional.ofNullable(clazz.cast(userSub()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignUpResponse, T> g) {
        return obj -> g.apply((SignUpResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo, CopyableBuilder<Builder, SignUpResponse> {
        /**
         * <p>
         * A response from the server indicating that a user registration has been confirmed.
         * </p>
         * 
         * @param userConfirmed
         *        A response from the server indicating that a user registration has been confirmed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userConfirmed(Boolean userConfirmed);

        /**
         * <p>
         * The code delivery details returned by the server response to the user registration request.
         * </p>
         * 
         * @param codeDeliveryDetails
         *        The code delivery details returned by the server response to the user registration request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails);

        /**
         * <p>
         * The code delivery details returned by the server response to the user registration request.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeDeliveryDetailsType.Builder} avoiding
         * the need to create one manually via {@link CodeDeliveryDetailsType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeDeliveryDetailsType.Builder#build()} is called immediately
         * and its result is passed to {@link #codeDeliveryDetails(CodeDeliveryDetailsType)}.
         * 
         * @param codeDeliveryDetails
         *        a consumer that will call methods on {@link CodeDeliveryDetailsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeliveryDetails(CodeDeliveryDetailsType)
         */
        default Builder codeDeliveryDetails(Consumer<CodeDeliveryDetailsType.Builder> codeDeliveryDetails) {
            return codeDeliveryDetails(CodeDeliveryDetailsType.builder().applyMutation(codeDeliveryDetails).build());
        }

        /**
         * <p>
         * The UUID of the authenticated user. This isn't the same as <code>username</code>.
         * </p>
         * 
         * @param userSub
         *        The UUID of the authenticated user. This isn't the same as <code>username</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSub(String userSub);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private Boolean userConfirmed;

        private CodeDeliveryDetailsType codeDeliveryDetails;

        private String userSub;

        private BuilderImpl() {
        }

        private BuilderImpl(SignUpResponse model) {
            super(model);
            userConfirmed(model.userConfirmed);
            codeDeliveryDetails(model.codeDeliveryDetails);
            userSub(model.userSub);
        }

        public final Boolean getUserConfirmed() {
            return userConfirmed;
        }

        public final void setUserConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
        }

        @Override
        public final Builder userConfirmed(Boolean userConfirmed) {
            this.userConfirmed = userConfirmed;
            return this;
        }

        public final CodeDeliveryDetailsType.Builder getCodeDeliveryDetails() {
            return codeDeliveryDetails != null ? codeDeliveryDetails.toBuilder() : null;
        }

        public final void setCodeDeliveryDetails(CodeDeliveryDetailsType.BuilderImpl codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails != null ? codeDeliveryDetails.build() : null;
        }

        @Override
        public final Builder codeDeliveryDetails(CodeDeliveryDetailsType codeDeliveryDetails) {
            this.codeDeliveryDetails = codeDeliveryDetails;
            return this;
        }

        public final String getUserSub() {
            return userSub;
        }

        public final void setUserSub(String userSub) {
            this.userSub = userSub;
        }

        @Override
        public final Builder userSub(String userSub) {
            this.userSub = userSub;
            return this;
        }

        @Override
        public SignUpResponse build() {
            return new SignUpResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
