/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The template for verification messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerificationMessageTemplateType implements SdkPojo, Serializable,
        ToCopyableBuilder<VerificationMessageTemplateType.Builder, VerificationMessageTemplateType> {
    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsMessage").getter(getter(VerificationMessageTemplateType::smsMessage))
            .setter(setter(Builder::smsMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMessage").build()).build();

    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailMessage").getter(getter(VerificationMessageTemplateType::emailMessage))
            .setter(setter(Builder::emailMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<String> EMAIL_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailSubject").getter(getter(VerificationMessageTemplateType::emailSubject))
            .setter(setter(Builder::emailSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSubject").build()).build();

    private static final SdkField<String> EMAIL_MESSAGE_BY_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailMessageByLink").getter(getter(VerificationMessageTemplateType::emailMessageByLink))
            .setter(setter(Builder::emailMessageByLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessageByLink").build())
            .build();

    private static final SdkField<String> EMAIL_SUBJECT_BY_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailSubjectByLink").getter(getter(VerificationMessageTemplateType::emailSubjectByLink))
            .setter(setter(Builder::emailSubjectByLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSubjectByLink").build())
            .build();

    private static final SdkField<String> DEFAULT_EMAIL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultEmailOption").getter(getter(VerificationMessageTemplateType::defaultEmailOptionAsString))
            .setter(setter(Builder::defaultEmailOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEmailOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MESSAGE_FIELD,
            EMAIL_MESSAGE_FIELD, EMAIL_SUBJECT_FIELD, EMAIL_MESSAGE_BY_LINK_FIELD, EMAIL_SUBJECT_BY_LINK_FIELD,
            DEFAULT_EMAIL_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String smsMessage;

    private final String emailMessage;

    private final String emailSubject;

    private final String emailMessageByLink;

    private final String emailSubjectByLink;

    private final String defaultEmailOption;

    private VerificationMessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
        this.emailMessageByLink = builder.emailMessageByLink;
        this.emailSubjectByLink = builder.emailSubjectByLink;
        this.defaultEmailOption = builder.defaultEmailOption;
    }

    /**
     * <p>
     * The SMS message template.
     * </p>
     * 
     * @return The SMS message template.
     */
    public final String smsMessage() {
        return smsMessage;
    }

    /**
     * <p>
     * The email message template. EmailMessage is allowed only if <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     * > EmailSendingAccount</a> is DEVELOPER.
     * </p>
     * 
     * @return The email message template. EmailMessage is allowed only if <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     *         > EmailSendingAccount</a> is DEVELOPER.
     */
    public final String emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The subject line for the email message template. EmailSubject is allowed only if <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     * >EmailSendingAccount</a> is DEVELOPER.
     * </p>
     * 
     * @return The subject line for the email message template. EmailSubject is allowed only if <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     *         >EmailSendingAccount</a> is DEVELOPER.
     */
    public final String emailSubject() {
        return emailSubject;
    }

    /**
     * <p>
     * The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if <a
     * href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     * > EmailSendingAccount</a> is DEVELOPER.
     * </p>
     * 
     * @return The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed
     *         only if <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     *         > EmailSendingAccount</a> is DEVELOPER.
     */
    public final String emailMessageByLink() {
        return emailMessageByLink;
    }

    /**
     * <p>
     * The subject line for the email message template for sending a confirmation link to the user. EmailSubjectByLink
     * is allowed only <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     * > EmailSendingAccount</a> is DEVELOPER.
     * </p>
     * 
     * @return The subject line for the email message template for sending a confirmation link to the user.
     *         EmailSubjectByLink is allowed only <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
     *         > EmailSendingAccount</a> is DEVELOPER.
     */
    public final String emailSubjectByLink() {
        return emailSubjectByLink;
    }

    /**
     * <p>
     * The default email option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultEmailOption} will return {@link DefaultEmailOptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultEmailOptionAsString}.
     * </p>
     * 
     * @return The default email option.
     * @see DefaultEmailOptionType
     */
    public final DefaultEmailOptionType defaultEmailOption() {
        return DefaultEmailOptionType.fromValue(defaultEmailOption);
    }

    /**
     * <p>
     * The default email option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultEmailOption} will return {@link DefaultEmailOptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #defaultEmailOptionAsString}.
     * </p>
     * 
     * @return The default email option.
     * @see DefaultEmailOptionType
     */
    public final String defaultEmailOptionAsString() {
        return defaultEmailOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubject());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessageByLink());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubjectByLink());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEmailOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationMessageTemplateType)) {
            return false;
        }
        VerificationMessageTemplateType other = (VerificationMessageTemplateType) obj;
        return Objects.equals(smsMessage(), other.smsMessage()) && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(emailSubject(), other.emailSubject())
                && Objects.equals(emailMessageByLink(), other.emailMessageByLink())
                && Objects.equals(emailSubjectByLink(), other.emailSubjectByLink())
                && Objects.equals(defaultEmailOptionAsString(), other.defaultEmailOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerificationMessageTemplateType").add("SmsMessage", smsMessage())
                .add("EmailMessage", emailMessage()).add("EmailSubject", emailSubject())
                .add("EmailMessageByLink", emailMessageByLink()).add("EmailSubjectByLink", emailSubjectByLink())
                .add("DefaultEmailOption", defaultEmailOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "EmailSubject":
            return Optional.ofNullable(clazz.cast(emailSubject()));
        case "EmailMessageByLink":
            return Optional.ofNullable(clazz.cast(emailMessageByLink()));
        case "EmailSubjectByLink":
            return Optional.ofNullable(clazz.cast(emailSubjectByLink()));
        case "DefaultEmailOption":
            return Optional.ofNullable(clazz.cast(defaultEmailOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerificationMessageTemplateType, T> g) {
        return obj -> g.apply((VerificationMessageTemplateType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerificationMessageTemplateType> {
        /**
         * <p>
         * The SMS message template.
         * </p>
         * 
         * @param smsMessage
         *        The SMS message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(String smsMessage);

        /**
         * <p>
         * The email message template. EmailMessage is allowed only if <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         * > EmailSendingAccount</a> is DEVELOPER.
         * </p>
         * 
         * @param emailMessage
         *        The email message template. EmailMessage is allowed only if <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         *        > EmailSendingAccount</a> is DEVELOPER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(String emailMessage);

        /**
         * <p>
         * The subject line for the email message template. EmailSubject is allowed only if <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         * >EmailSendingAccount</a> is DEVELOPER.
         * </p>
         * 
         * @param emailSubject
         *        The subject line for the email message template. EmailSubject is allowed only if <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         *        >EmailSendingAccount</a> is DEVELOPER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubject(String emailSubject);

        /**
         * <p>
         * The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed only if
         * <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         * > EmailSendingAccount</a> is DEVELOPER.
         * </p>
         * 
         * @param emailMessageByLink
         *        The email message template for sending a confirmation link to the user. EmailMessageByLink is allowed
         *        only if <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         *        > EmailSendingAccount</a> is DEVELOPER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessageByLink(String emailMessageByLink);

        /**
         * <p>
         * The subject line for the email message template for sending a confirmation link to the user.
         * EmailSubjectByLink is allowed only <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         * > EmailSendingAccount</a> is DEVELOPER.
         * </p>
         * 
         * @param emailSubjectByLink
         *        The subject line for the email message template for sending a confirmation link to the user.
         *        EmailSubjectByLink is allowed only <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount"
         *        > EmailSendingAccount</a> is DEVELOPER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubjectByLink(String emailSubjectByLink);

        /**
         * <p>
         * The default email option.
         * </p>
         * 
         * @param defaultEmailOption
         *        The default email option.
         * @see DefaultEmailOptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultEmailOptionType
         */
        Builder defaultEmailOption(String defaultEmailOption);

        /**
         * <p>
         * The default email option.
         * </p>
         * 
         * @param defaultEmailOption
         *        The default email option.
         * @see DefaultEmailOptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultEmailOptionType
         */
        Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption);
    }

    static final class BuilderImpl implements Builder {
        private String smsMessage;

        private String emailMessage;

        private String emailSubject;

        private String emailMessageByLink;

        private String emailSubjectByLink;

        private String defaultEmailOption;

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationMessageTemplateType model) {
            smsMessage(model.smsMessage);
            emailMessage(model.emailMessage);
            emailSubject(model.emailSubject);
            emailMessageByLink(model.emailMessageByLink);
            emailSubjectByLink(model.emailSubjectByLink);
            defaultEmailOption(model.defaultEmailOption);
        }

        public final String getSmsMessage() {
            return smsMessage;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final String getEmailMessage() {
            return emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getEmailSubject() {
            return emailSubject;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final String getEmailMessageByLink() {
            return emailMessageByLink;
        }

        public final void setEmailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
        }

        @Override
        public final Builder emailMessageByLink(String emailMessageByLink) {
            this.emailMessageByLink = emailMessageByLink;
            return this;
        }

        public final String getEmailSubjectByLink() {
            return emailSubjectByLink;
        }

        public final void setEmailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
        }

        @Override
        public final Builder emailSubjectByLink(String emailSubjectByLink) {
            this.emailSubjectByLink = emailSubjectByLink;
            return this;
        }

        public final String getDefaultEmailOption() {
            return defaultEmailOption;
        }

        public final void setDefaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
        }

        @Override
        public final Builder defaultEmailOption(String defaultEmailOption) {
            this.defaultEmailOption = defaultEmailOption;
            return this;
        }

        @Override
        public final Builder defaultEmailOption(DefaultEmailOptionType defaultEmailOption) {
            this.defaultEmailOption(defaultEmailOption == null ? null : defaultEmailOption.toString());
            return this;
        }

        @Override
        public VerificationMessageTemplateType build() {
            return new VerificationMessageTemplateType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
