/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class UserImportJobsListTypeCopier {
    static List<UserImportJobType> copy(Collection<? extends UserImportJobType> userImportJobsListTypeParam) {
        List<UserImportJobType> list;
        if (userImportJobsListTypeParam == null || userImportJobsListTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UserImportJobType> modifiableList = new ArrayList<>();
            userImportJobsListTypeParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UserImportJobType> copyFromBuilder(Collection<? extends UserImportJobType.Builder> userImportJobsListTypeParam) {
        List<UserImportJobType> list;
        if (userImportJobsListTypeParam == null || userImportJobsListTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UserImportJobType> modifiableList = new ArrayList<>();
            userImportJobsListTypeParam.forEach(entry -> {
                UserImportJobType member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UserImportJobType.Builder> copyToBuilder(Collection<? extends UserImportJobType> userImportJobsListTypeParam) {
        List<UserImportJobType.Builder> list;
        if (userImportJobsListTypeParam == null || userImportJobsListTypeParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UserImportJobType.Builder> modifiableList = new ArrayList<>();
            userImportJobsListTypeParam.forEach(entry -> {
                UserImportJobType.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
