/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of an
 * unexpected event by Amazon Cognito advanced security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserContextDataType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserContextDataType.Builder, UserContextDataType> {
    private static final SdkField<String> ENCODED_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodedData").getter(getter(UserContextDataType::encodedData)).setter(setter(Builder::encodedData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODED_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encodedData;

    private UserContextDataType(BuilderImpl builder) {
        this.encodedData = builder.encodedData;
    }

    /**
     * <p>
     * Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk of
     * an unexpected event by Amazon Cognito advanced security.
     * </p>
     * 
     * @return Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the
     *         risk of an unexpected event by Amazon Cognito advanced security.
     */
    public final String encodedData() {
        return encodedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encodedData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContextDataType)) {
            return false;
        }
        UserContextDataType other = (UserContextDataType) obj;
        return Objects.equals(encodedData(), other.encodedData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserContextDataType").add("EncodedData", encodedData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncodedData":
            return Optional.ofNullable(clazz.cast(encodedData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserContextDataType, T> g) {
        return obj -> g.apply((UserContextDataType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserContextDataType> {
        /**
         * <p>
         * Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating the risk
         * of an unexpected event by Amazon Cognito advanced security.
         * </p>
         * 
         * @param encodedData
         *        Contextual data, such as the user's device fingerprint, IP address, or location, used for evaluating
         *        the risk of an unexpected event by Amazon Cognito advanced security.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedData(String encodedData);
    }

    static final class BuilderImpl implements Builder {
        private String encodedData;

        private BuilderImpl() {
        }

        private BuilderImpl(UserContextDataType model) {
            encodedData(model.encodedData);
        }

        public final String getEncodedData() {
            return encodedData;
        }

        public final void setEncodedData(String encodedData) {
            this.encodedData = encodedData;
        }

        @Override
        public final Builder encodedData(String encodedData) {
            this.encodedData = encodedData;
            return this;
        }

        @Override
        public UserContextDataType build() {
            return new UserContextDataType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
