/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityProviderByIdentifierResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetIdentityProviderByIdentifierResponse.Builder, GetIdentityProviderByIdentifierResponse> {
    private static final SdkField<IdentityProviderType> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProviderType> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(GetIdentityProviderByIdentifierResponse::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProviderType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD));

    private final IdentityProviderType identityProvider;

    private GetIdentityProviderByIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.identityProvider = builder.identityProvider;
    }

    /**
     * <p>
     * The identity provider object.
     * </p>
     * 
     * @return The identity provider object.
     */
    public final IdentityProviderType identityProvider() {
        return identityProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityProviderByIdentifierResponse)) {
            return false;
        }
        GetIdentityProviderByIdentifierResponse other = (GetIdentityProviderByIdentifierResponse) obj;
        return Objects.equals(identityProvider(), other.identityProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityProviderByIdentifierResponse").add("IdentityProvider", identityProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityProviderByIdentifierResponse, T> g) {
        return obj -> g.apply((GetIdentityProviderByIdentifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityProviderByIdentifierResponse> {
        /**
         * <p>
         * The identity provider object.
         * </p>
         * 
         * @param identityProvider
         *        The identity provider object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProviderType identityProvider);

        /**
         * <p>
         * The identity provider object.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderType.Builder} avoiding
         * the need to create one manually via {@link IdentityProviderType#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityProviderType.Builder#build()} is called immediately and
         * its result is passed to {@link #identityProvider(IdentityProviderType)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProviderType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProviderType)
         */
        default Builder identityProvider(Consumer<IdentityProviderType.Builder> identityProvider) {
            return identityProvider(IdentityProviderType.builder().applyMutation(identityProvider).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private IdentityProviderType identityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityProviderByIdentifierResponse model) {
            super(model);
            identityProvider(model.identityProvider);
        }

        public final IdentityProviderType.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProviderType.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProviderType identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        @Override
        public GetIdentityProviderByIdentifierResponse build() {
            return new GetIdentityProviderByIdentifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
