/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSoftwareTokenRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AssociateSoftwareTokenRequest.Builder, AssociateSoftwareTokenRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(AssociateSoftwareTokenRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> SESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Session")
            .getter(getter(AssociateSoftwareTokenRequest::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            SESSION_FIELD));

    private final String accessToken;

    private final String session;

    private AssociateSoftwareTokenRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.session = builder.session;
    }

    /**
     * <p>
     * The access token.
     * </p>
     * 
     * @return The access token.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The session which should be passed both ways in challenge-response calls to the service. This allows
     * authentication of the user as part of the MFA setup process.
     * </p>
     * 
     * @return The session which should be passed both ways in challenge-response calls to the service. This allows
     *         authentication of the user as part of the MFA setup process.
     */
    public final String session() {
        return session;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSoftwareTokenRequest)) {
            return false;
        }
        AssociateSoftwareTokenRequest other = (AssociateSoftwareTokenRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(session(), other.session());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSoftwareTokenRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").add("Session", session())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSoftwareTokenRequest, T> g) {
        return obj -> g.apply((AssociateSoftwareTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSoftwareTokenRequest> {
        /**
         * <p>
         * The access token.
         * </p>
         * 
         * @param accessToken
         *        The access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The session which should be passed both ways in challenge-response calls to the service. This allows
         * authentication of the user as part of the MFA setup process.
         * </p>
         * 
         * @param session
         *        The session which should be passed both ways in challenge-response calls to the service. This allows
         *        authentication of the user as part of the MFA setup process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(String session);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String session;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSoftwareTokenRequest model) {
            super(model);
            accessToken(model.accessToken);
            session(model.session);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        @Transient
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getSession() {
            return session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        @Transient
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSoftwareTokenRequest build() {
            return new AssociateSoftwareTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
