/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifySoftwareTokenRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<VerifySoftwareTokenRequest.Builder, VerifySoftwareTokenRequest> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(VerifySoftwareTokenRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> SESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Session")
            .getter(getter(VerifySoftwareTokenRequest::session)).setter(setter(Builder::session))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()).build();

    private static final SdkField<String> USER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserCode").getter(getter(VerifySoftwareTokenRequest::userCode)).setter(setter(Builder::userCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCode").build()).build();

    private static final SdkField<String> FRIENDLY_DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FriendlyDeviceName").getter(getter(VerifySoftwareTokenRequest::friendlyDeviceName))
            .setter(setter(Builder::friendlyDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyDeviceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            SESSION_FIELD, USER_CODE_FIELD, FRIENDLY_DEVICE_NAME_FIELD));

    private final String accessToken;

    private final String session;

    private final String userCode;

    private final String friendlyDeviceName;

    private VerifySoftwareTokenRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.session = builder.session;
        this.userCode = builder.userCode;
        this.friendlyDeviceName = builder.friendlyDeviceName;
    }

    /**
     * <p>
     * The access token.
     * </p>
     * 
     * @return The access token.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The session which should be passed both ways in challenge-response calls to the service.
     * </p>
     * 
     * @return The session which should be passed both ways in challenge-response calls to the service.
     */
    public final String session() {
        return session;
    }

    /**
     * <p>
     * The one time password computed using the secret code returned by <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html"
     * >AssociateSoftwareToken"</a>.
     * </p>
     * 
     * @return The one time password computed using the secret code returned by <a href=
     *         "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html"
     *         >AssociateSoftwareToken"</a>.
     */
    public final String userCode() {
        return userCode;
    }

    /**
     * <p>
     * The friendly device name.
     * </p>
     * 
     * @return The friendly device name.
     */
    public final String friendlyDeviceName() {
        return friendlyDeviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        hashCode = 31 * hashCode + Objects.hashCode(userCode());
        hashCode = 31 * hashCode + Objects.hashCode(friendlyDeviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifySoftwareTokenRequest)) {
            return false;
        }
        VerifySoftwareTokenRequest other = (VerifySoftwareTokenRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(session(), other.session())
                && Objects.equals(userCode(), other.userCode())
                && Objects.equals(friendlyDeviceName(), other.friendlyDeviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifySoftwareTokenRequest")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").add("Session", session())
                .add("UserCode", userCode()).add("FriendlyDeviceName", friendlyDeviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "Session":
            return Optional.ofNullable(clazz.cast(session()));
        case "UserCode":
            return Optional.ofNullable(clazz.cast(userCode()));
        case "FriendlyDeviceName":
            return Optional.ofNullable(clazz.cast(friendlyDeviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifySoftwareTokenRequest, T> g) {
        return obj -> g.apply((VerifySoftwareTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifySoftwareTokenRequest> {
        /**
         * <p>
         * The access token.
         * </p>
         * 
         * @param accessToken
         *        The access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The session which should be passed both ways in challenge-response calls to the service.
         * </p>
         * 
         * @param session
         *        The session which should be passed both ways in challenge-response calls to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(String session);

        /**
         * <p>
         * The one time password computed using the secret code returned by <a href=
         * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html"
         * >AssociateSoftwareToken"</a>.
         * </p>
         * 
         * @param userCode
         *        The one time password computed using the secret code returned by <a href=
         *        "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html"
         *        >AssociateSoftwareToken"</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCode(String userCode);

        /**
         * <p>
         * The friendly device name.
         * </p>
         * 
         * @param friendlyDeviceName
         *        The friendly device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyDeviceName(String friendlyDeviceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String session;

        private String userCode;

        private String friendlyDeviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifySoftwareTokenRequest model) {
            super(model);
            accessToken(model.accessToken);
            session(model.session);
            userCode(model.userCode);
            friendlyDeviceName(model.friendlyDeviceName);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        @Transient
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getSession() {
            return session;
        }

        public final void setSession(String session) {
            this.session = session;
        }

        @Override
        @Transient
        public final Builder session(String session) {
            this.session = session;
            return this;
        }

        public final String getUserCode() {
            return userCode;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        @Override
        @Transient
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final String getFriendlyDeviceName() {
            return friendlyDeviceName;
        }

        public final void setFriendlyDeviceName(String friendlyDeviceName) {
            this.friendlyDeviceName = friendlyDeviceName;
        }

        @Override
        @Transient
        public final Builder friendlyDeviceName(String friendlyDeviceName) {
            this.friendlyDeviceName = friendlyDeviceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifySoftwareTokenRequest build() {
            return new VerifySoftwareTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
