/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceType implements SdkPojo, Serializable, ToCopyableBuilder<DeviceType.Builder, DeviceType> {
    private static final SdkField<String> DEVICE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceKey").getter(getter(DeviceType::deviceKey)).setter(setter(Builder::deviceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceKey").build()).build();

    private static final SdkField<List<AttributeType>> DEVICE_ATTRIBUTES_FIELD = SdkField
            .<List<AttributeType>> builder(MarshallingType.LIST)
            .memberName("DeviceAttributes")
            .getter(getter(DeviceType::deviceAttributes))
            .setter(setter(Builder::deviceAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> DEVICE_CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeviceCreateDate").getter(getter(DeviceType::deviceCreateDate))
            .setter(setter(Builder::deviceCreateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCreateDate").build()).build();

    private static final SdkField<Instant> DEVICE_LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeviceLastModifiedDate").getter(getter(DeviceType::deviceLastModifiedDate))
            .setter(setter(Builder::deviceLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceLastModifiedDate").build())
            .build();

    private static final SdkField<Instant> DEVICE_LAST_AUTHENTICATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeviceLastAuthenticatedDate")
            .getter(getter(DeviceType::deviceLastAuthenticatedDate))
            .setter(setter(Builder::deviceLastAuthenticatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceLastAuthenticatedDate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_KEY_FIELD,
            DEVICE_ATTRIBUTES_FIELD, DEVICE_CREATE_DATE_FIELD, DEVICE_LAST_MODIFIED_DATE_FIELD,
            DEVICE_LAST_AUTHENTICATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceKey;

    private final List<AttributeType> deviceAttributes;

    private final Instant deviceCreateDate;

    private final Instant deviceLastModifiedDate;

    private final Instant deviceLastAuthenticatedDate;

    private DeviceType(BuilderImpl builder) {
        this.deviceKey = builder.deviceKey;
        this.deviceAttributes = builder.deviceAttributes;
        this.deviceCreateDate = builder.deviceCreateDate;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
        this.deviceLastAuthenticatedDate = builder.deviceLastAuthenticatedDate;
    }

    /**
     * <p>
     * The device key.
     * </p>
     * 
     * @return The device key.
     */
    public final String deviceKey() {
        return deviceKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceAttributes() {
        return deviceAttributes != null && !(deviceAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceAttributes} method.
     * </p>
     * 
     * @return The device attributes.
     */
    public final List<AttributeType> deviceAttributes() {
        return deviceAttributes;
    }

    /**
     * <p>
     * The creation date of the device.
     * </p>
     * 
     * @return The creation date of the device.
     */
    public final Instant deviceCreateDate() {
        return deviceCreateDate;
    }

    /**
     * <p>
     * The last modified date of the device.
     * </p>
     * 
     * @return The last modified date of the device.
     */
    public final Instant deviceLastModifiedDate() {
        return deviceLastModifiedDate;
    }

    /**
     * <p>
     * The date when the device was last authenticated.
     * </p>
     * 
     * @return The date when the device was last authenticated.
     */
    public final Instant deviceLastAuthenticatedDate() {
        return deviceLastAuthenticatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceAttributes() ? deviceAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(deviceLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(deviceLastAuthenticatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceType)) {
            return false;
        }
        DeviceType other = (DeviceType) obj;
        return Objects.equals(deviceKey(), other.deviceKey()) && hasDeviceAttributes() == other.hasDeviceAttributes()
                && Objects.equals(deviceAttributes(), other.deviceAttributes())
                && Objects.equals(deviceCreateDate(), other.deviceCreateDate())
                && Objects.equals(deviceLastModifiedDate(), other.deviceLastModifiedDate())
                && Objects.equals(deviceLastAuthenticatedDate(), other.deviceLastAuthenticatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceType").add("DeviceKey", deviceKey())
                .add("DeviceAttributes", hasDeviceAttributes() ? deviceAttributes() : null)
                .add("DeviceCreateDate", deviceCreateDate()).add("DeviceLastModifiedDate", deviceLastModifiedDate())
                .add("DeviceLastAuthenticatedDate", deviceLastAuthenticatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceKey":
            return Optional.ofNullable(clazz.cast(deviceKey()));
        case "DeviceAttributes":
            return Optional.ofNullable(clazz.cast(deviceAttributes()));
        case "DeviceCreateDate":
            return Optional.ofNullable(clazz.cast(deviceCreateDate()));
        case "DeviceLastModifiedDate":
            return Optional.ofNullable(clazz.cast(deviceLastModifiedDate()));
        case "DeviceLastAuthenticatedDate":
            return Optional.ofNullable(clazz.cast(deviceLastAuthenticatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceType, T> g) {
        return obj -> g.apply((DeviceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceType> {
        /**
         * <p>
         * The device key.
         * </p>
         * 
         * @param deviceKey
         *        The device key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceKey(String deviceKey);

        /**
         * <p>
         * The device attributes.
         * </p>
         * 
         * @param deviceAttributes
         *        The device attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceAttributes(Collection<AttributeType> deviceAttributes);

        /**
         * <p>
         * The device attributes.
         * </p>
         * 
         * @param deviceAttributes
         *        The device attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceAttributes(AttributeType... deviceAttributes);

        /**
         * <p>
         * The device attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttributeType>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #deviceAttributes(List<AttributeType>)}.
         * 
         * @param deviceAttributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceAttributes(List<AttributeType>)
         */
        Builder deviceAttributes(Consumer<AttributeType.Builder>... deviceAttributes);

        /**
         * <p>
         * The creation date of the device.
         * </p>
         * 
         * @param deviceCreateDate
         *        The creation date of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreateDate(Instant deviceCreateDate);

        /**
         * <p>
         * The last modified date of the device.
         * </p>
         * 
         * @param deviceLastModifiedDate
         *        The last modified date of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceLastModifiedDate(Instant deviceLastModifiedDate);

        /**
         * <p>
         * The date when the device was last authenticated.
         * </p>
         * 
         * @param deviceLastAuthenticatedDate
         *        The date when the device was last authenticated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String deviceKey;

        private List<AttributeType> deviceAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant deviceCreateDate;

        private Instant deviceLastModifiedDate;

        private Instant deviceLastAuthenticatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceType model) {
            deviceKey(model.deviceKey);
            deviceAttributes(model.deviceAttributes);
            deviceCreateDate(model.deviceCreateDate);
            deviceLastModifiedDate(model.deviceLastModifiedDate);
            deviceLastAuthenticatedDate(model.deviceLastAuthenticatedDate);
        }

        public final String getDeviceKey() {
            return deviceKey;
        }

        public final void setDeviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
        }

        @Override
        public final Builder deviceKey(String deviceKey) {
            this.deviceKey = deviceKey;
            return this;
        }

        public final List<AttributeType.Builder> getDeviceAttributes() {
            List<AttributeType.Builder> result = AttributeListTypeCopier.copyToBuilder(this.deviceAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceAttributes(Collection<AttributeType.BuilderImpl> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copyFromBuilder(deviceAttributes);
        }

        @Override
        public final Builder deviceAttributes(Collection<AttributeType> deviceAttributes) {
            this.deviceAttributes = AttributeListTypeCopier.copy(deviceAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(AttributeType... deviceAttributes) {
            deviceAttributes(Arrays.asList(deviceAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceAttributes(Consumer<AttributeType.Builder>... deviceAttributes) {
            deviceAttributes(Stream.of(deviceAttributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getDeviceCreateDate() {
            return deviceCreateDate;
        }

        public final void setDeviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
        }

        @Override
        public final Builder deviceCreateDate(Instant deviceCreateDate) {
            this.deviceCreateDate = deviceCreateDate;
            return this;
        }

        public final Instant getDeviceLastModifiedDate() {
            return deviceLastModifiedDate;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final Instant getDeviceLastAuthenticatedDate() {
            return deviceLastAuthenticatedDate;
        }

        public final void setDeviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
        }

        @Override
        public final Builder deviceLastAuthenticatedDate(Instant deviceLastAuthenticatedDate) {
            this.deviceLastAuthenticatedDate = deviceLastAuthenticatedDate;
            return this;
        }

        @Override
        public DeviceType build() {
            return new DeviceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
