/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationResultType implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationResultType.Builder, AuthenticationResultType> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(AuthenticationResultType::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiresIn").getter(getter(AuthenticationResultType::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresIn").build()).build();

    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenType").getter(getter(AuthenticationResultType::tokenType)).setter(setter(Builder::tokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshToken").getter(getter(AuthenticationResultType::refreshToken))
            .setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();

    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdToken").getter(getter(AuthenticationResultType::idToken)).setter(setter(Builder::idToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdToken").build()).build();

    private static final SdkField<NewDeviceMetadataType> NEW_DEVICE_METADATA_FIELD = SdkField
            .<NewDeviceMetadataType> builder(MarshallingType.SDK_POJO).memberName("NewDeviceMetadata")
            .getter(getter(AuthenticationResultType::newDeviceMetadata)).setter(setter(Builder::newDeviceMetadata))
            .constructor(NewDeviceMetadataType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDeviceMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            EXPIRES_IN_FIELD, TOKEN_TYPE_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD, NEW_DEVICE_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final Integer expiresIn;

    private final String tokenType;

    private final String refreshToken;

    private final String idToken;

    private final NewDeviceMetadataType newDeviceMetadata;

    private AuthenticationResultType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.newDeviceMetadata = builder.newDeviceMetadata;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user who you want to authenticate.
     * </p>
     * 
     * @return A valid access token that Amazon Cognito issued to the user who you want to authenticate.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The expiration period of the authentication result in seconds.
     * </p>
     * 
     * @return The expiration period of the authentication result in seconds.
     */
    public final Integer expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * The token type.
     * </p>
     * 
     * @return The token type.
     */
    public final String tokenType() {
        return tokenType;
    }

    /**
     * <p>
     * The refresh token.
     * </p>
     * 
     * @return The refresh token.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The ID token.
     * </p>
     * 
     * @return The ID token.
     */
    public final String idToken() {
        return idToken;
    }

    /**
     * <p>
     * The new device metadata from an authentication result.
     * </p>
     * 
     * @return The new device metadata from an authentication result.
     */
    public final NewDeviceMetadataType newDeviceMetadata() {
        return newDeviceMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(idToken());
        hashCode = 31 * hashCode + Objects.hashCode(newDeviceMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResultType)) {
            return false;
        }
        AuthenticationResultType other = (AuthenticationResultType) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(expiresIn(), other.expiresIn())
                && Objects.equals(tokenType(), other.tokenType()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(idToken(), other.idToken()) && Objects.equals(newDeviceMetadata(), other.newDeviceMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationResultType")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpiresIn", expiresIn()).add("TokenType", tokenType())
                .add("RefreshToken", refreshToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdToken", idToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewDeviceMetadata", newDeviceMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "ExpiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "TokenType":
            return Optional.ofNullable(clazz.cast(tokenType()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "IdToken":
            return Optional.ofNullable(clazz.cast(idToken()));
        case "NewDeviceMetadata":
            return Optional.ofNullable(clazz.cast(newDeviceMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationResultType, T> g) {
        return obj -> g.apply((AuthenticationResultType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationResultType> {
        /**
         * <p>
         * A valid access token that Amazon Cognito issued to the user who you want to authenticate.
         * </p>
         * 
         * @param accessToken
         *        A valid access token that Amazon Cognito issued to the user who you want to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The expiration period of the authentication result in seconds.
         * </p>
         * 
         * @param expiresIn
         *        The expiration period of the authentication result in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Integer expiresIn);

        /**
         * <p>
         * The token type.
         * </p>
         * 
         * @param tokenType
         *        The token type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * The refresh token.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The ID token.
         * </p>
         * 
         * @param idToken
         *        The ID token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idToken(String idToken);

        /**
         * <p>
         * The new device metadata from an authentication result.
         * </p>
         * 
         * @param newDeviceMetadata
         *        The new device metadata from an authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata);

        /**
         * <p>
         * The new device metadata from an authentication result.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewDeviceMetadataType.Builder} avoiding
         * the need to create one manually via {@link NewDeviceMetadataType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewDeviceMetadataType.Builder#build()} is called immediately and
         * its result is passed to {@link #newDeviceMetadata(NewDeviceMetadataType)}.
         * 
         * @param newDeviceMetadata
         *        a consumer that will call methods on {@link NewDeviceMetadataType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newDeviceMetadata(NewDeviceMetadataType)
         */
        default Builder newDeviceMetadata(Consumer<NewDeviceMetadataType.Builder> newDeviceMetadata) {
            return newDeviceMetadata(NewDeviceMetadataType.builder().applyMutation(newDeviceMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private Integer expiresIn;

        private String tokenType;

        private String refreshToken;

        private String idToken;

        private NewDeviceMetadataType newDeviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResultType model) {
            accessToken(model.accessToken);
            expiresIn(model.expiresIn);
            tokenType(model.tokenType);
            refreshToken(model.refreshToken);
            idToken(model.idToken);
            newDeviceMetadata(model.newDeviceMetadata);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Integer getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final String getTokenType() {
            return tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getIdToken() {
            return idToken;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final NewDeviceMetadataType.Builder getNewDeviceMetadata() {
            return newDeviceMetadata != null ? newDeviceMetadata.toBuilder() : null;
        }

        public final void setNewDeviceMetadata(NewDeviceMetadataType.BuilderImpl newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata != null ? newDeviceMetadata.build() : null;
        }

        @Override
        public final Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata;
            return this;
        }

        @Override
        public AuthenticationResultType build() {
            return new AuthenticationResultType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
