/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists the device's response, as an administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminListDevicesResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminListDevicesResponse.Builder, AdminListDevicesResponse> {
    private static final SdkField<List<DeviceType>> DEVICES_FIELD = SdkField
            .<List<DeviceType>> builder(MarshallingType.LIST)
            .memberName("Devices")
            .getter(getter(AdminListDevicesResponse::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(AdminListDevicesResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD,
            PAGINATION_TOKEN_FIELD));

    private final List<DeviceType> devices;

    private final String paginationToken;

    private AdminListDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.paginationToken = builder.paginationToken;
    }

    /**
     * Returns true if the Devices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The devices in the list of devices response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The devices in the list of devices response.
     */
    public final List<DeviceType> devices() {
        return devices;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListDevicesResponse)) {
            return false;
        }
        AdminListDevicesResponse other = (AdminListDevicesResponse) obj;
        return hasDevices() == other.hasDevices() && Objects.equals(devices(), other.devices())
                && Objects.equals(paginationToken(), other.paginationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminListDevicesResponse").add("Devices", hasDevices() ? devices() : null)
                .add("PaginationToken", paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminListDevicesResponse, T> g) {
        return obj -> g.apply((AdminListDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminListDevicesResponse> {
        /**
         * <p>
         * The devices in the list of devices response.
         * </p>
         * 
         * @param devices
         *        The devices in the list of devices response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceType> devices);

        /**
         * <p>
         * The devices in the list of devices response.
         * </p>
         * 
         * @param devices
         *        The devices in the list of devices response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceType... devices);

        /**
         * <p>
         * The devices in the list of devices response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceType>.Builder} avoiding the need to
         * create one manually via {@link List<DeviceType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceType>.Builder#build()} is called immediately and its
         * result is passed to {@link #devices(List<DeviceType>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<DeviceType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<DeviceType>)
         */
        Builder devices(Consumer<DeviceType.Builder>... devices);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param paginationToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<DeviceType> devices = DefaultSdkAutoConstructList.getInstance();

        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminListDevicesResponse model) {
            super(model);
            devices(model.devices);
            paginationToken(model.paginationToken);
        }

        public final List<DeviceType.Builder> getDevices() {
            List<DeviceType.Builder> result = DeviceListTypeCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder devices(Collection<DeviceType> devices) {
            this.devices = DeviceListTypeCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceType... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceType.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceType.BuilderImpl> devices) {
            this.devices = DeviceListTypeCopier.copyFromBuilder(devices);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public AdminListDevicesResponse build() {
            return new AdminListDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
