/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server to the request to get the header information for the .csv file for the user
 * import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCsvHeaderResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetCsvHeaderResponse.Builder, GetCsvHeaderResponse> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(GetCsvHeaderResponse::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<List<String>> CSV_HEADER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CSVHeader")
            .getter(getter(GetCsvHeaderResponse::csvHeader))
            .setter(setter(Builder::csvHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVHeader").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            CSV_HEADER_FIELD));

    private final String userPoolId;

    private final List<String> csvHeader;

    private GetCsvHeaderResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.csvHeader = builder.csvHeader;
    }

    /**
     * <p>
     * The user pool ID for the user pool that the users are to be imported into.
     * </p>
     * 
     * @return The user pool ID for the user pool that the users are to be imported into.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CSVHeader property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCsvHeader() {
        return csvHeader != null && !(csvHeader instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The header information for the .csv file for the user import job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCsvHeader} method.
     * </p>
     * 
     * @return The header information for the .csv file for the user import job.
     */
    public final List<String> csvHeader() {
        return csvHeader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCsvHeader() ? csvHeader() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCsvHeaderResponse)) {
            return false;
        }
        GetCsvHeaderResponse other = (GetCsvHeaderResponse) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && hasCsvHeader() == other.hasCsvHeader()
                && Objects.equals(csvHeader(), other.csvHeader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCsvHeaderResponse").add("UserPoolId", userPoolId())
                .add("CSVHeader", hasCsvHeader() ? csvHeader() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "CSVHeader":
            return Optional.ofNullable(clazz.cast(csvHeader()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCsvHeaderResponse, T> g) {
        return obj -> g.apply((GetCsvHeaderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCsvHeaderResponse> {
        /**
         * <p>
         * The user pool ID for the user pool that the users are to be imported into.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool that the users are to be imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The header information for the .csv file for the user import job.
         * </p>
         * 
         * @param csvHeader
         *        The header information for the .csv file for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvHeader(Collection<String> csvHeader);

        /**
         * <p>
         * The header information for the .csv file for the user import job.
         * </p>
         * 
         * @param csvHeader
         *        The header information for the .csv file for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvHeader(String... csvHeader);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String userPoolId;

        private List<String> csvHeader = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCsvHeaderResponse model) {
            super(model);
            userPoolId(model.userPoolId);
            csvHeader(model.csvHeader);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final Collection<String> getCsvHeader() {
            if (csvHeader instanceof SdkAutoConstructList) {
                return null;
            }
            return csvHeader;
        }

        public final void setCsvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
        }

        @Override
        @Transient
        public final Builder csvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder csvHeader(String... csvHeader) {
            csvHeader(Arrays.asList(csvHeader));
            return this;
        }

        @Override
        public GetCsvHeaderResponse build() {
            return new GetCsvHeaderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
