/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription;

public class ListIdentityProvidersIterable
implements SdkIterable<ListIdentityProvidersResponse> {
    private final CognitoIdentityProviderClient client;
    private final ListIdentityProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdentityProvidersIterable(CognitoIdentityProviderClient client, ListIdentityProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIdentityProvidersResponseFetcher();
    }

    public Iterator<ListIdentityProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProviderDescription> providers() {
        Function<ListIdentityProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.providers() != null) {
                return response.providers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdentityProvidersResponseFetcher
    implements SyncPageFetcher<ListIdentityProvidersResponse> {
        private ListIdentityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdentityProvidersResponse nextPage(ListIdentityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProvidersIterable.this.client.listIdentityProviders(ListIdentityProvidersIterable.this.firstRequest);
            }
            return ListIdentityProvidersIterable.this.client.listIdentityProviders((ListIdentityProvidersRequest)((Object)ListIdentityProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

