/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainDescriptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainDescriptionType.Builder, DomainDescriptionType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(DomainDescriptionType::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSAccountId").getter(getter(DomainDescriptionType::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DomainDescriptionType::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(DomainDescriptionType::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudFrontDistribution").getter(getter(DomainDescriptionType::cloudFrontDistribution))
            .setter(setter(Builder::cloudFrontDistribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDistribution").build())
            .build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(DomainDescriptionType::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DomainDescriptionType::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField
            .<CustomDomainConfigType> builder(MarshallingType.SDK_POJO).memberName("CustomDomainConfig")
            .getter(getter(DomainDescriptionType::customDomainConfig)).setter(setter(Builder::customDomainConfig))
            .constructor(CustomDomainConfigType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, DOMAIN_FIELD, S3_BUCKET_FIELD, CLOUD_FRONT_DISTRIBUTION_FIELD, VERSION_FIELD, STATUS_FIELD,
            CUSTOM_DOMAIN_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPoolId;

    private final String awsAccountId;

    private final String domain;

    private final String s3Bucket;

    private final String cloudFrontDistribution;

    private final String version;

    private final String status;

    private final CustomDomainConfigType customDomainConfig;

    private DomainDescriptionType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsAccountId = builder.awsAccountId;
        this.domain = builder.domain;
        this.s3Bucket = builder.s3Bucket;
        this.cloudFrontDistribution = builder.cloudFrontDistribution;
        this.version = builder.version;
        this.status = builder.status;
        this.customDomainConfig = builder.customDomainConfig;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The Amazon Web Services ID for the user pool owner.
     * </p>
     * 
     * @return The Amazon Web Services ID for the user pool owner.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The domain string. For custom domains, this is the fully-qualified domain name, such as
     * <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as
     * <code>auth</code>.
     * </p>
     * 
     * @return The domain string. For custom domains, this is the fully-qualified domain name, such as
     *         <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as
     *         <code>auth</code>.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the static files for this domain are stored.
     * </p>
     * 
     * @return The Amazon S3 bucket where the static files for this domain are stored.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
     */
    public final String cloudFrontDistribution() {
        return cloudFrontDistribution;
    }

    /**
     * <p>
     * The app version.
     * </p>
     * 
     * @return The app version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The domain status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The domain status.
     * @see DomainStatusType
     */
    public final DomainStatusType status() {
        return DomainStatusType.fromValue(status);
    }

    /**
     * <p>
     * The domain status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The domain status.
     * @see DomainStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
     * </p>
     * 
     * @return The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
     */
    public final CustomDomainConfigType customDomainConfig() {
        return customDomainConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescriptionType)) {
            return false;
        }
        DomainDescriptionType other = (DomainDescriptionType) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(domain(), other.domain()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(cloudFrontDistribution(), other.cloudFrontDistribution())
                && Objects.equals(version(), other.version()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(customDomainConfig(), other.customDomainConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainDescriptionType").add("UserPoolId", userPoolId()).add("AWSAccountId", awsAccountId())
                .add("Domain", domain()).add("S3Bucket", s3Bucket()).add("CloudFrontDistribution", cloudFrontDistribution())
                .add("Version", version()).add("Status", statusAsString()).add("CustomDomainConfig", customDomainConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "AWSAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "CloudFrontDistribution":
            return Optional.ofNullable(clazz.cast(cloudFrontDistribution()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CustomDomainConfig":
            return Optional.ofNullable(clazz.cast(customDomainConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDescriptionType, T> g) {
        return obj -> g.apply((DomainDescriptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainDescriptionType> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The Amazon Web Services ID for the user pool owner.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services ID for the user pool owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The domain string. For custom domains, this is the fully-qualified domain name, such as
         * <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as
         * <code>auth</code>.
         * </p>
         * 
         * @param domain
         *        The domain string. For custom domains, this is the fully-qualified domain name, such as
         *        <code>auth.example.com</code>. For Amazon Cognito prefix domains, this is the prefix alone, such as
         *        <code>auth</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The Amazon S3 bucket where the static files for this domain are stored.
         * </p>
         * 
         * @param s3Bucket
         *        The Amazon S3 bucket where the static files for this domain are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
         * </p>
         * 
         * @param cloudFrontDistribution
         *        The Amazon Resource Name (ARN) of the Amazon CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontDistribution(String cloudFrontDistribution);

        /**
         * <p>
         * The app version.
         * </p>
         * 
         * @param version
         *        The app version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The domain status.
         * </p>
         * 
         * @param status
         *        The domain status.
         * @see DomainStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The domain status.
         * </p>
         * 
         * @param status
         *        The domain status.
         * @see DomainStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatusType
         */
        Builder status(DomainStatusType status);

        /**
         * <p>
         * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
         * </p>
         * 
         * @param customDomainConfig
         *        The configuration for a custom domain that hosts the sign-up and sign-in webpages for your
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainConfig(CustomDomainConfigType customDomainConfig);

        /**
         * <p>
         * The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDomainConfigType.Builder} avoiding
         * the need to create one manually via {@link CustomDomainConfigType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDomainConfigType.Builder#build()} is called immediately and
         * its result is passed to {@link #customDomainConfig(CustomDomainConfigType)}.
         * 
         * @param customDomainConfig
         *        a consumer that will call methods on {@link CustomDomainConfigType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomainConfig(CustomDomainConfigType)
         */
        default Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return customDomainConfig(CustomDomainConfigType.builder().applyMutation(customDomainConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String userPoolId;

        private String awsAccountId;

        private String domain;

        private String s3Bucket;

        private String cloudFrontDistribution;

        private String version;

        private String status;

        private CustomDomainConfigType customDomainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescriptionType model) {
            userPoolId(model.userPoolId);
            awsAccountId(model.awsAccountId);
            domain(model.domain);
            s3Bucket(model.s3Bucket);
            cloudFrontDistribution(model.cloudFrontDistribution);
            version(model.version);
            status(model.status);
            customDomainConfig(model.customDomainConfig);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getCloudFrontDistribution() {
            return cloudFrontDistribution;
        }

        public final void setCloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
        }

        @Override
        public final Builder cloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return customDomainConfig != null ? customDomainConfig.toBuilder() : null;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        @Override
        public DomainDescriptionType build() {
            return new DomainDescriptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
