/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForbiddenException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersIterable;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListUserAuthEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AssociateSoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RevokeTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifySoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCognitoIdentityProviderClient
implements CognitoIdentityProviderClient {
    private static final Logger log = Logger.loggerFor(DefaultCognitoIdentityProviderClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityProviderClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "cognito-idp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddCustomAttributesResponse addCustomAttributes(AddCustomAttributesRequest addCustomAttributesRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserImportInProgressException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCustomAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, addCustomAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCustomAttributes");
            AddCustomAttributesResponse addCustomAttributesResponse = (AddCustomAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCustomAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addCustomAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddCustomAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addCustomAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$addCustomAttributes$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminAddUserToGroupResponse adminAddUserToGroup(AdminAddUserToGroupRequest adminAddUserToGroupRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminAddUserToGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminAddUserToGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminAddUserToGroup");
            AdminAddUserToGroupResponse adminAddUserToGroupResponse = (AdminAddUserToGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminAddUserToGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminAddUserToGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminAddUserToGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminAddUserToGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminAddUserToGroup$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminConfirmSignUpResponse adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException, InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminConfirmSignUpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminConfirmSignUpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminConfirmSignUp");
            AdminConfirmSignUpResponse adminConfirmSignUpResponse = (AdminConfirmSignUpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminConfirmSignUp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminConfirmSignUpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminConfirmSignUpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminConfirmSignUpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminConfirmSignUp$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminCreateUserResponse adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) throws ResourceNotFoundException, InvalidParameterException, UserNotFoundException, UsernameExistsException, InvalidPasswordException, CodeDeliveryFailureException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException, PreconditionNotMetException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, TooManyRequestsException, NotAuthorizedException, UnsupportedUserStateException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminCreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminCreateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminCreateUser");
            AdminCreateUserResponse adminCreateUserResponse = (AdminCreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminCreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminCreateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminCreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminCreateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminCreateUser$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminDeleteUserResponse adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminDeleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDeleteUser");
            AdminDeleteUserResponse adminDeleteUserResponse = (AdminDeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminDeleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminDeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminDeleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminDeleteUser$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminDeleteUserAttributesResponse adminDeleteUserAttributes(AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDeleteUserAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminDeleteUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDeleteUserAttributes");
            AdminDeleteUserAttributesResponse adminDeleteUserAttributesResponse = (AdminDeleteUserAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDeleteUserAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminDeleteUserAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminDeleteUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminDeleteUserAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminDeleteUserAttributes$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminDisableProviderForUserResponse adminDisableProviderForUser(AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, AliasExistsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDisableProviderForUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminDisableProviderForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDisableProviderForUser");
            AdminDisableProviderForUserResponse adminDisableProviderForUserResponse = (AdminDisableProviderForUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDisableProviderForUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminDisableProviderForUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminDisableProviderForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminDisableProviderForUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminDisableProviderForUser$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminDisableUserResponse adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminDisableUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminDisableUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminDisableUser");
            AdminDisableUserResponse adminDisableUserResponse = (AdminDisableUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminDisableUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminDisableUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminDisableUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminDisableUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminDisableUser$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminEnableUserResponse adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminEnableUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminEnableUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminEnableUser");
            AdminEnableUserResponse adminEnableUserResponse = (AdminEnableUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminEnableUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminEnableUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminEnableUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminEnableUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminEnableUser$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminForgetDeviceResponse adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminForgetDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminForgetDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminForgetDevice");
            AdminForgetDeviceResponse adminForgetDeviceResponse = (AdminForgetDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminForgetDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminForgetDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminForgetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminForgetDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminForgetDevice$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminGetDeviceResponse adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException, TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminGetDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminGetDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminGetDevice");
            AdminGetDeviceResponse adminGetDeviceResponse = (AdminGetDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminGetDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminGetDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminGetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminGetDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminGetDevice$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminGetUserResponse adminGetUser(AdminGetUserRequest adminGetUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminGetUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminGetUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminGetUser");
            AdminGetUserResponse adminGetUserResponse = (AdminGetUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminGetUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminGetUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminGetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminGetUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminGetUser$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminInitiateAuthResponse adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, UnexpectedLambdaException, InvalidUserPoolConfigurationException, UserLambdaValidationException, InvalidLambdaResponseException, MfaMethodNotFoundException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminInitiateAuthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminInitiateAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminInitiateAuth");
            AdminInitiateAuthResponse adminInitiateAuthResponse = (AdminInitiateAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminInitiateAuth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminInitiateAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminInitiateAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminInitiateAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminInitiateAuth$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminLinkProviderForUserResponse adminLinkProviderForUser(AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, AliasExistsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminLinkProviderForUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminLinkProviderForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminLinkProviderForUser");
            AdminLinkProviderForUserResponse adminLinkProviderForUserResponse = (AdminLinkProviderForUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminLinkProviderForUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminLinkProviderForUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminLinkProviderForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminLinkProviderForUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminLinkProviderForUser$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminListDevicesResponse adminListDevices(AdminListDevicesRequest adminListDevicesRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException, TooManyRequestsException, InternalErrorException, NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminListDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListDevices");
            AdminListDevicesResponse adminListDevicesResponse = (AdminListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminListDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminListDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminListDevices$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminListGroupsForUserResponse adminListGroupsForUser(AdminListGroupsForUserRequest adminListGroupsForUserRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListGroupsForUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminListGroupsForUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListGroupsForUser");
            AdminListGroupsForUserResponse adminListGroupsForUserResponse = (AdminListGroupsForUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListGroupsForUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminListGroupsForUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminListGroupsForUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminListGroupsForUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminListGroupsForUser$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public AdminListGroupsForUserIterable adminListGroupsForUserPaginator(AdminListGroupsForUserRequest adminListGroupsForUserRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new AdminListGroupsForUserIterable(this, this.applyPaginatorUserAgent(adminListGroupsForUserRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminListUserAuthEventsResponse adminListUserAuthEvents(AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminListUserAuthEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminListUserAuthEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminListUserAuthEvents");
            AdminListUserAuthEventsResponse adminListUserAuthEventsResponse = (AdminListUserAuthEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminListUserAuthEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminListUserAuthEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminListUserAuthEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminListUserAuthEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminListUserAuthEvents$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public AdminListUserAuthEventsIterable adminListUserAuthEventsPaginator(AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new AdminListUserAuthEventsIterable(this, this.applyPaginatorUserAgent(adminListUserAuthEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminRemoveUserFromGroupResponse adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminRemoveUserFromGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminRemoveUserFromGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminRemoveUserFromGroup");
            AdminRemoveUserFromGroupResponse adminRemoveUserFromGroupResponse = (AdminRemoveUserFromGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminRemoveUserFromGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminRemoveUserFromGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminRemoveUserFromGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminRemoveUserFromGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminRemoveUserFromGroup$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminResetUserPasswordResponse adminResetUserPassword(AdminResetUserPasswordRequest adminResetUserPasswordRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException, InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminResetUserPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminResetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminResetUserPassword");
            AdminResetUserPasswordResponse adminResetUserPasswordResponse = (AdminResetUserPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminResetUserPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminResetUserPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminResetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminResetUserPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminResetUserPassword$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminRespondToAuthChallengeResponse adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException, UnexpectedLambdaException, InvalidPasswordException, UserLambdaValidationException, InvalidLambdaResponseException, TooManyRequestsException, InvalidUserPoolConfigurationException, InternalErrorException, MfaMethodNotFoundException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AliasExistsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, SoftwareTokenMfaNotFoundException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminRespondToAuthChallengeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminRespondToAuthChallengeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminRespondToAuthChallenge");
            AdminRespondToAuthChallengeResponse adminRespondToAuthChallengeResponse = (AdminRespondToAuthChallengeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminRespondToAuthChallenge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminRespondToAuthChallengeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminRespondToAuthChallengeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminRespondToAuthChallengeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminRespondToAuthChallenge$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminSetUserMfaPreferenceResponse adminSetUserMFAPreference(AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserMfaPreferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminSetUserMfaPreferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserMFAPreference");
            AdminSetUserMfaPreferenceResponse adminSetUserMfaPreferenceResponse = (AdminSetUserMfaPreferenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserMFAPreference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminSetUserMfaPreferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminSetUserMfaPreferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminSetUserMfaPreferenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminSetUserMFAPreference$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminSetUserPasswordResponse adminSetUserPassword(AdminSetUserPasswordRequest adminSetUserPasswordRequest) throws ResourceNotFoundException, NotAuthorizedException, UserNotFoundException, InternalErrorException, TooManyRequestsException, InvalidParameterException, InvalidPasswordException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminSetUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserPassword");
            AdminSetUserPasswordResponse adminSetUserPasswordResponse = (AdminSetUserPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminSetUserPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminSetUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminSetUserPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminSetUserPassword$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminSetUserSettingsResponse adminSetUserSettings(AdminSetUserSettingsRequest adminSetUserSettingsRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminSetUserSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminSetUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminSetUserSettings");
            AdminSetUserSettingsResponse adminSetUserSettingsResponse = (AdminSetUserSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminSetUserSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminSetUserSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminSetUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminSetUserSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminSetUserSettings$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminUpdateAuthEventFeedbackResponse adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateAuthEventFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminUpdateAuthEventFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateAuthEventFeedback");
            AdminUpdateAuthEventFeedbackResponse adminUpdateAuthEventFeedbackResponse = (AdminUpdateAuthEventFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateAuthEventFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminUpdateAuthEventFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminUpdateAuthEventFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminUpdateAuthEventFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminUpdateAuthEventFeedback$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminUpdateDeviceStatusResponse adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateDeviceStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminUpdateDeviceStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateDeviceStatus");
            AdminUpdateDeviceStatusResponse adminUpdateDeviceStatusResponse = (AdminUpdateDeviceStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateDeviceStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminUpdateDeviceStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminUpdateDeviceStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminUpdateDeviceStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminUpdateDeviceStatus$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminUpdateUserAttributesResponse adminUpdateUserAttributes(AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException, AliasExistsException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidEmailRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUpdateUserAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminUpdateUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUpdateUserAttributes");
            AdminUpdateUserAttributesResponse adminUpdateUserAttributesResponse = (AdminUpdateUserAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUpdateUserAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminUpdateUserAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminUpdateUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminUpdateUserAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminUpdateUserAttributes$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminUserGlobalSignOutResponse adminUserGlobalSignOut(AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdminUserGlobalSignOutResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, adminUserGlobalSignOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdminUserGlobalSignOut");
            AdminUserGlobalSignOutResponse adminUserGlobalSignOutResponse = (AdminUserGlobalSignOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdminUserGlobalSignOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)adminUserGlobalSignOutRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdminUserGlobalSignOutRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return adminUserGlobalSignOutResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$adminUserGlobalSignOut$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateSoftwareTokenResponse associateSoftwareToken(AssociateSoftwareTokenRequest associateSoftwareTokenRequest) throws ConcurrentModificationException, InvalidParameterException, NotAuthorizedException, ResourceNotFoundException, InternalErrorException, SoftwareTokenMfaNotFoundException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSoftwareTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, associateSoftwareTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSoftwareToken");
            AssociateSoftwareTokenResponse associateSoftwareTokenResponse = (AssociateSoftwareTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSoftwareToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateSoftwareTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateSoftwareTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateSoftwareTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$associateSoftwareToken$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws ResourceNotFoundException, InvalidParameterException, InvalidPasswordException, NotAuthorizedException, TooManyRequestsException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ChangePasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, changePasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangePassword");
            ChangePasswordResponse changePasswordResponse = (ChangePasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangePassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changePasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new ChangePasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return changePasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$changePassword$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmDeviceResponse confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, InvalidPasswordException, InvalidLambdaResponseException, UsernameExistsException, InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, confirmDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmDevice");
            ConfirmDeviceResponse confirmDeviceResponse = (ConfirmDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$confirmDevice$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmForgotPasswordResponse confirmForgotPassword(ConfirmForgotPasswordRequest confirmForgotPasswordRequest) throws ResourceNotFoundException, UnexpectedLambdaException, UserLambdaValidationException, InvalidParameterException, InvalidPasswordException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException, TooManyFailedAttemptsException, InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmForgotPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, confirmForgotPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmForgotPassword");
            ConfirmForgotPasswordResponse confirmForgotPasswordResponse = (ConfirmForgotPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmForgotPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmForgotPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new ConfirmForgotPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmForgotPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$confirmForgotPassword$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmSignUpResponse confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, TooManyFailedAttemptsException, CodeMismatchException, ExpiredCodeException, InvalidLambdaResponseException, AliasExistsException, TooManyRequestsException, LimitExceededException, UserNotFoundException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmSignUpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, confirmSignUpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmSignUp");
            ConfirmSignUpResponse confirmSignUpResponse = (ConfirmSignUpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmSignUp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)confirmSignUpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new ConfirmSignUpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmSignUpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$confirmSignUp$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws InvalidParameterException, GroupExistsException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGroup");
            CreateGroupResponse createGroupResponse = (CreateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createGroup$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest) throws InvalidParameterException, DuplicateProviderException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentityProvider");
            CreateIdentityProviderResponse createIdentityProviderResponse = (CreateIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createIdentityProvider$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceServerResponse createResourceServer(CreateResourceServerRequest createResourceServerRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceServer");
            CreateResourceServerResponse createResourceServerResponse = (CreateResourceServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResourceServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createResourceServer$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserImportJobResponse createUserImportJob(CreateUserImportJobRequest createUserImportJobRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, PreconditionNotMetException, NotAuthorizedException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createUserImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserImportJob");
            CreateUserImportJobResponse createUserImportJobResponse = (CreateUserImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createUserImportJob$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserPoolResponse createUserPool(CreateUserPoolRequest createUserPoolRequest) throws InvalidParameterException, TooManyRequestsException, LimitExceededException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, NotAuthorizedException, UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createUserPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPool");
            CreateUserPoolResponse createUserPoolResponse = (CreateUserPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createUserPool$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserPoolClientResponse createUserPoolClient(CreateUserPoolClientRequest createUserPoolClientRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, LimitExceededException, NotAuthorizedException, ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createUserPoolClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPoolClient");
            CreateUserPoolClientResponse createUserPoolClientResponse = (CreateUserPoolClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPoolClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserPoolClientRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserPoolClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserPoolClientResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createUserPoolClient$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserPoolDomainResponse createUserPoolDomain(CreateUserPoolDomainRequest createUserPoolDomainRequest) throws InvalidParameterException, NotAuthorizedException, ResourceNotFoundException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserPoolDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, createUserPoolDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserPoolDomain");
            CreateUserPoolDomainResponse createUserPoolDomainResponse = (CreateUserPoolDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserPoolDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserPoolDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserPoolDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserPoolDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$createUserPoolDomain$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGroup");
            DeleteGroupResponse deleteGroupResponse = (DeleteGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest) throws InvalidParameterException, UnsupportedIdentityProviderException, ConcurrentModificationException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityProvider");
            DeleteIdentityProviderResponse deleteIdentityProviderResponse = (DeleteIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteIdentityProvider$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceServerResponse deleteResourceServer(DeleteResourceServerRequest deleteResourceServerRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceServer");
            DeleteResourceServerResponse deleteResourceServerResponse = (DeleteResourceServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteResourceServer$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteUser$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserAttributesResponse deleteUserAttributes(DeleteUserAttributesRequest deleteUserAttributesRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserAttributes");
            DeleteUserAttributesResponse deleteUserAttributesResponse = (DeleteUserAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new DeleteUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteUserAttributes$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserPoolResponse deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserImportInProgressException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteUserPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserPool");
            DeleteUserPoolResponse deleteUserPoolResponse = (DeleteUserPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteUserPool$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserPoolClientResponse deleteUserPoolClient(DeleteUserPoolClientRequest deleteUserPoolClientRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, ConcurrentModificationException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserPoolClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteUserPoolClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserPoolClient");
            DeleteUserPoolClientResponse deleteUserPoolClientResponse = (DeleteUserPoolClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserPoolClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserPoolClientRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserPoolClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserPoolClientResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteUserPoolClient$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserPoolDomainResponse deleteUserPoolDomain(DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserPoolDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, deleteUserPoolDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserPoolDomain");
            DeleteUserPoolDomainResponse deleteUserPoolDomainResponse = (DeleteUserPoolDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserPoolDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserPoolDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserPoolDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserPoolDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$deleteUserPoolDomain$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityProviderResponse describeIdentityProvider(DescribeIdentityProviderRequest describeIdentityProviderRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityProvider");
            DescribeIdentityProviderResponse describeIdentityProviderResponse = (DescribeIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeIdentityProvider$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceServerResponse describeResourceServer(DescribeResourceServerRequest describeResourceServerRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourceServer");
            DescribeResourceServerResponse describeResourceServerResponse = (DescribeResourceServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourceServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourceServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourceServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeResourceServer$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRiskConfigurationResponse describeRiskConfiguration(DescribeRiskConfigurationRequest describeRiskConfigurationRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRiskConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeRiskConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRiskConfiguration");
            DescribeRiskConfigurationResponse describeRiskConfigurationResponse = (DescribeRiskConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRiskConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRiskConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRiskConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRiskConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeRiskConfiguration$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserImportJobResponse describeUserImportJob(DescribeUserImportJobRequest describeUserImportJobRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeUserImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUserImportJob");
            DescribeUserImportJobResponse describeUserImportJobResponse = (DescribeUserImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeUserImportJob$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserPoolResponse describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserPoolTaggingException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeUserPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUserPool");
            DescribeUserPoolResponse describeUserPoolResponse = (DescribeUserPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeUserPool$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserPoolClientResponse describeUserPoolClient(DescribeUserPoolClientRequest describeUserPoolClientRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserPoolClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeUserPoolClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUserPoolClient");
            DescribeUserPoolClientResponse describeUserPoolClientResponse = (DescribeUserPoolClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserPoolClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserPoolClientRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserPoolClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserPoolClientResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeUserPoolClient$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserPoolDomainResponse describeUserPoolDomain(DescribeUserPoolDomainRequest describeUserPoolDomainRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserPoolDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, describeUserPoolDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUserPoolDomain");
            DescribeUserPoolDomainResponse describeUserPoolDomainResponse = (DescribeUserPoolDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserPoolDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserPoolDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserPoolDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserPoolDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$describeUserPoolDomain$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForgetDeviceResponse forgetDevice(ForgetDeviceRequest forgetDeviceRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InvalidUserPoolConfigurationException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ForgetDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, forgetDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ForgetDevice");
            ForgetDeviceResponse forgetDeviceResponse = (ForgetDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ForgetDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)forgetDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ForgetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return forgetDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$forgetDevice$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForgotPasswordResponse forgotPassword(ForgotPasswordRequest forgotPasswordRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, UserNotFoundException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ForgotPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, forgotPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ForgotPassword");
            ForgotPasswordResponse forgotPasswordResponse = (ForgotPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ForgotPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)forgotPasswordRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new ForgotPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return forgotPasswordResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$forgotPassword$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCsvHeaderResponse getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCsvHeaderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getCsvHeaderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCSVHeader");
            GetCsvHeaderResponse getCsvHeaderResponse = (GetCsvHeaderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCSVHeader").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCsvHeaderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCsvHeaderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCsvHeaderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getCSVHeader$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ResourceNotFoundException, InvalidParameterException, InvalidUserPoolConfigurationException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevice");
            GetDeviceResponse getDeviceResponse = (GetDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getDevice$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGroup");
            GetGroupResponse getGroupResponse = (GetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getGroup$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityProviderByIdentifierResponse getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityProviderByIdentifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getIdentityProviderByIdentifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityProviderByIdentifier");
            GetIdentityProviderByIdentifierResponse getIdentityProviderByIdentifierResponse = (GetIdentityProviderByIdentifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityProviderByIdentifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityProviderByIdentifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityProviderByIdentifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdentityProviderByIdentifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getIdentityProviderByIdentifier$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSigningCertificateResponse getSigningCertificate(GetSigningCertificateRequest getSigningCertificateRequest) throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSigningCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getSigningCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSigningCertificate");
            GetSigningCertificateResponse getSigningCertificateResponse = (GetSigningCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSigningCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSigningCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSigningCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSigningCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getSigningCertificate$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUiCustomizationResponse getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUiCustomizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getUiCustomizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUICustomization");
            GetUiCustomizationResponse getUiCustomizationResponse = (GetUiCustomizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUICustomization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUiCustomizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUiCustomizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUiCustomizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getUICustomization$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserResponse getUser(GetUserRequest getUserRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUser");
            GetUserResponse getUserResponse = (GetUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new GetUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getUser$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserAttributeVerificationCodeResponse getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserAttributeVerificationCodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getUserAttributeVerificationCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserAttributeVerificationCode");
            GetUserAttributeVerificationCodeResponse getUserAttributeVerificationCodeResponse = (GetUserAttributeVerificationCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserAttributeVerificationCode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUserAttributeVerificationCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new GetUserAttributeVerificationCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserAttributeVerificationCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getUserAttributeVerificationCode$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUserPoolMfaConfigResponse getUserPoolMfaConfig(GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest) throws InvalidParameterException, TooManyRequestsException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserPoolMfaConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, getUserPoolMfaConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserPoolMfaConfig");
            GetUserPoolMfaConfigResponse getUserPoolMfaConfigResponse = (GetUserPoolMfaConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserPoolMfaConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUserPoolMfaConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUserPoolMfaConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUserPoolMfaConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$getUserPoolMfaConfig$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalSignOutResponse globalSignOut(GlobalSignOutRequest globalSignOutRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GlobalSignOutResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, globalSignOutRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GlobalSignOut");
            GlobalSignOutResponse globalSignOutResponse = (GlobalSignOutResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GlobalSignOut").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)globalSignOutRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GlobalSignOutRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return globalSignOutResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$globalSignOut$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateAuthResponse initiateAuth(InitiateAuthRequest initiateAuthRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, TooManyRequestsException, UnexpectedLambdaException, InvalidUserPoolConfigurationException, UserLambdaValidationException, InvalidLambdaResponseException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateAuthResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, initiateAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateAuth");
            InitiateAuthResponse initiateAuthResponse = (InitiateAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateAuth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new InitiateAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return initiateAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$initiateAuth$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevices");
            ListDevicesResponse listDevicesResponse = (ListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listDevices$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGroups");
            ListGroupsResponse listGroupsResponse = (ListGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listGroups$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListGroupsIterable(this, this.applyPaginatorUserAgent(listGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityProvidersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listIdentityProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityProviders");
            ListIdentityProvidersResponse listIdentityProvidersResponse = (ListIdentityProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityProviders").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityProvidersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityProvidersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listIdentityProviders$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListIdentityProvidersIterable(this, this.applyPaginatorUserAgent(listIdentityProvidersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceServersResponse listResourceServers(ListResourceServersRequest listResourceServersRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listResourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceServers");
            ListResourceServersResponse listResourceServersResponse = (ListResourceServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listResourceServers$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourceServersIterable listResourceServersPaginator(ListResourceServersRequest listResourceServersRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListResourceServersIterable(this, this.applyPaginatorUserAgent(listResourceServersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listTagsForResource$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUserImportJobsResponse listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listUserImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUserImportJobs");
            ListUserImportJobsResponse listUserImportJobsResponse = (ListUserImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUserImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUserImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listUserImportJobs$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUserPoolClientsResponse listUserPoolClients(ListUserPoolClientsRequest listUserPoolClientsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserPoolClientsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listUserPoolClientsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUserPoolClients");
            ListUserPoolClientsResponse listUserPoolClientsResponse = (ListUserPoolClientsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserPoolClients").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserPoolClientsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUserPoolClientsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUserPoolClientsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listUserPoolClients$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUserPoolClientsIterable listUserPoolClientsPaginator(ListUserPoolClientsRequest listUserPoolClientsRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListUserPoolClientsIterable(this, this.applyPaginatorUserAgent(listUserPoolClientsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUserPoolsResponse listUserPools(ListUserPoolsRequest listUserPoolsRequest) throws InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserPoolsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listUserPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUserPools");
            ListUserPoolsResponse listUserPoolsResponse = (ListUserPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserPools").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserPoolsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUserPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUserPoolsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listUserPools$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUserPoolsIterable listUserPoolsPaginator(ListUserPoolsRequest listUserPoolsRequest) throws InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListUserPoolsIterable(this, this.applyPaginatorUserAgent(listUserPoolsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listUsers$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListUsersIterable(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersInGroupResponse listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersInGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, listUsersInGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsersInGroup");
            ListUsersInGroupResponse listUsersInGroupResponse = (ListUsersInGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsersInGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersInGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersInGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersInGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$listUsersInGroup$76((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListUsersInGroupIterable listUsersInGroupPaginator(ListUsersInGroupRequest listUsersInGroupRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        return new ListUsersInGroupIterable(this, this.applyPaginatorUserAgent(listUsersInGroupRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResendConfirmationCodeResponse resendConfirmationCode(ResendConfirmationCodeRequest resendConfirmationCodeRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, InvalidLambdaResponseException, TooManyRequestsException, LimitExceededException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, UserNotFoundException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResendConfirmationCodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, resendConfirmationCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResendConfirmationCode");
            ResendConfirmationCodeResponse resendConfirmationCodeResponse = (ResendConfirmationCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResendConfirmationCode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resendConfirmationCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new ResendConfirmationCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resendConfirmationCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$resendConfirmationCode$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RespondToAuthChallengeResponse respondToAuthChallenge(RespondToAuthChallengeRequest respondToAuthChallengeRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, CodeMismatchException, ExpiredCodeException, UnexpectedLambdaException, UserLambdaValidationException, InvalidPasswordException, InvalidLambdaResponseException, TooManyRequestsException, InvalidUserPoolConfigurationException, MfaMethodNotFoundException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, AliasExistsException, InternalErrorException, SoftwareTokenMfaNotFoundException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RespondToAuthChallengeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, respondToAuthChallengeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RespondToAuthChallenge");
            RespondToAuthChallengeResponse respondToAuthChallengeResponse = (RespondToAuthChallengeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RespondToAuthChallenge").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)respondToAuthChallengeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new RespondToAuthChallengeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return respondToAuthChallengeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$respondToAuthChallenge$78((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeTokenResponse revokeToken(RevokeTokenRequest revokeTokenRequest) throws TooManyRequestsException, InternalErrorException, UnauthorizedException, InvalidParameterException, UnsupportedOperationException, UnsupportedTokenTypeException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, revokeTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeToken");
            RevokeTokenResponse revokeTokenResponse = (RevokeTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$revokeToken$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetRiskConfigurationResponse setRiskConfiguration(SetRiskConfigurationRequest setRiskConfigurationRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, UserPoolAddOnNotEnabledException, CodeDeliveryFailureException, InvalidEmailRoleAccessPolicyException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetRiskConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, setRiskConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetRiskConfiguration");
            SetRiskConfigurationResponse setRiskConfigurationResponse = (SetRiskConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRiskConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setRiskConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetRiskConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setRiskConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$setRiskConfiguration$80((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetUiCustomizationResponse setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetUiCustomizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, setUiCustomizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetUICustomization");
            SetUiCustomizationResponse setUiCustomizationResponse = (SetUiCustomizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetUICustomization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setUiCustomizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetUiCustomizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setUiCustomizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$setUICustomization$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetUserMfaPreferenceResponse setUserMFAPreference(SetUserMfaPreferenceRequest setUserMfaPreferenceRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetUserMfaPreferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, setUserMfaPreferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetUserMFAPreference");
            SetUserMfaPreferenceResponse setUserMfaPreferenceResponse = (SetUserMfaPreferenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetUserMFAPreference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setUserMfaPreferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetUserMfaPreferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setUserMfaPreferenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$setUserMFAPreference$82((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetUserPoolMfaConfigResponse setUserPoolMfaConfig(SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) throws InvalidParameterException, TooManyRequestsException, ResourceNotFoundException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetUserPoolMfaConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, setUserPoolMfaConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetUserPoolMfaConfig");
            SetUserPoolMfaConfigResponse setUserPoolMfaConfigResponse = (SetUserPoolMfaConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetUserPoolMfaConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setUserPoolMfaConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetUserPoolMfaConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setUserPoolMfaConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$setUserPoolMfaConfig$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetUserSettingsResponse setUserSettings(SetUserSettingsRequest setUserSettingsRequest) throws ResourceNotFoundException, InvalidParameterException, NotAuthorizedException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetUserSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, setUserSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetUserSettings");
            SetUserSettingsResponse setUserSettingsResponse = (SetUserSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetUserSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setUserSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new SetUserSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setUserSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$setUserSettings$84((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignUpResponse signUp(SignUpRequest signUpRequest) throws ResourceNotFoundException, InvalidParameterException, UnexpectedLambdaException, UserLambdaValidationException, NotAuthorizedException, InvalidPasswordException, InvalidLambdaResponseException, UsernameExistsException, TooManyRequestsException, InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignUpResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, signUpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SignUp");
            SignUpResponse signUpResponse = (SignUpResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignUp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)signUpRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new SignUpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return signUpResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$signUp$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartUserImportJobResponse startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException, PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartUserImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, startUserImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartUserImportJob");
            StartUserImportJobResponse startUserImportJobResponse = (StartUserImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartUserImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startUserImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartUserImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startUserImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$startUserImportJob$86((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopUserImportJobResponse stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, InternalErrorException, PreconditionNotMetException, NotAuthorizedException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopUserImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, stopUserImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopUserImportJob");
            StopUserImportJobResponse stopUserImportJobResponse = (StopUserImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopUserImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopUserImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopUserImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopUserImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$stopUserImportJob$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$tagResource$88((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InvalidParameterException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$untagResource$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAuthEventFeedbackResponse updateAuthEventFeedback(UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest) throws InvalidParameterException, ResourceNotFoundException, TooManyRequestsException, NotAuthorizedException, UserNotFoundException, UserPoolAddOnNotEnabledException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAuthEventFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateAuthEventFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAuthEventFeedback");
            UpdateAuthEventFeedbackResponse updateAuthEventFeedbackResponse = (UpdateAuthEventFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAuthEventFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAuthEventFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAuthEventFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAuthEventFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateAuthEventFeedback$90((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDeviceStatusResponse updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InvalidUserPoolConfigurationException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDeviceStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateDeviceStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDeviceStatus");
            UpdateDeviceStatusResponse updateDeviceStatusResponse = (UpdateDeviceStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDeviceStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDeviceStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDeviceStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDeviceStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateDeviceStatus$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws ResourceNotFoundException, InvalidParameterException, TooManyRequestsException, NotAuthorizedException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGroup");
            UpdateGroupResponse updateGroupResponse = (UpdateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateGroup$92((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest updateIdentityProviderRequest) throws InvalidParameterException, UnsupportedIdentityProviderException, ResourceNotFoundException, ConcurrentModificationException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateIdentityProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityProvider");
            UpdateIdentityProviderResponse updateIdentityProviderResponse = (UpdateIdentityProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIdentityProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIdentityProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIdentityProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateIdentityProvider$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceServerResponse updateResourceServer(UpdateResourceServerRequest updateResourceServerRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateResourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceServer");
            UpdateResourceServerResponse updateResourceServerResponse = (UpdateResourceServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateResourceServer$94((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserAttributesResponse updateUserAttributes(UpdateUserAttributesRequest updateUserAttributesRequest) throws ResourceNotFoundException, InvalidParameterException, CodeMismatchException, ExpiredCodeException, NotAuthorizedException, UnexpectedLambdaException, UserLambdaValidationException, InvalidLambdaResponseException, TooManyRequestsException, AliasExistsException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, InvalidEmailRoleAccessPolicyException, CodeDeliveryFailureException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateUserAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserAttributes");
            UpdateUserAttributesResponse updateUserAttributesResponse = (UpdateUserAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new UpdateUserAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateUserAttributes$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserPoolResponse updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) throws ResourceNotFoundException, InvalidParameterException, ConcurrentModificationException, TooManyRequestsException, NotAuthorizedException, UserImportInProgressException, InternalErrorException, InvalidSmsRoleAccessPolicyException, InvalidSmsRoleTrustRelationshipException, UserPoolTaggingException, InvalidEmailRoleAccessPolicyException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateUserPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserPool");
            UpdateUserPoolResponse updateUserPoolResponse = (UpdateUserPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateUserPool$96((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserPoolClientResponse updateUserPoolClient(UpdateUserPoolClientRequest updateUserPoolClientRequest) throws ResourceNotFoundException, InvalidParameterException, ConcurrentModificationException, TooManyRequestsException, NotAuthorizedException, ScopeDoesNotExistException, InvalidOAuthFlowException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserPoolClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateUserPoolClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserPoolClient");
            UpdateUserPoolClientResponse updateUserPoolClientResponse = (UpdateUserPoolClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserPoolClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserPoolClientRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserPoolClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserPoolClientResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateUserPoolClient$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserPoolDomainResponse updateUserPoolDomain(UpdateUserPoolDomainRequest updateUserPoolDomainRequest) throws InvalidParameterException, NotAuthorizedException, ResourceNotFoundException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserPoolDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, updateUserPoolDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserPoolDomain");
            UpdateUserPoolDomainResponse updateUserPoolDomainResponse = (UpdateUserPoolDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserPoolDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserPoolDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserPoolDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserPoolDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$updateUserPoolDomain$98((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifySoftwareTokenResponse verifySoftwareToken(VerifySoftwareTokenRequest verifySoftwareTokenRequest) throws InvalidParameterException, ResourceNotFoundException, InvalidUserPoolConfigurationException, NotAuthorizedException, TooManyRequestsException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, EnableSoftwareTokenMfaException, SoftwareTokenMfaNotFoundException, CodeMismatchException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifySoftwareTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, verifySoftwareTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifySoftwareToken");
            VerifySoftwareTokenResponse verifySoftwareTokenResponse = (VerifySoftwareTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifySoftwareToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifySoftwareTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifySoftwareTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifySoftwareTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$verifySoftwareToken$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyUserAttributeResponse verifyUserAttribute(VerifyUserAttributeRequest verifyUserAttributeRequest) throws ResourceNotFoundException, InvalidParameterException, CodeMismatchException, ExpiredCodeException, NotAuthorizedException, TooManyRequestsException, LimitExceededException, PasswordResetRequiredException, UserNotFoundException, UserNotConfirmedException, InternalErrorException, AliasExistsException, ForbiddenException, AwsServiceException, SdkClientException, CognitoIdentityProviderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyUserAttributeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityProviderClient.resolveMetricPublishers(this.clientConfiguration, verifyUserAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyUserAttribute");
            VerifyUserAttributeResponse verifyUserAttributeResponse = (VerifyUserAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyUserAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyUserAttributeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST, (Object)false).withMarshaller((Marshaller)new VerifyUserAttributeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyUserAttributeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityProviderClient.lambda$verifyUserAttribute$100((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoIdentityProviderException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException").exceptionBuilderSupplier(InvalidLambdaResponseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException").exceptionBuilderSupplier(InvalidOAuthFlowException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException").exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UsernameExistsException").exceptionBuilderSupplier(UsernameExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserImportInProgressException").exceptionBuilderSupplier(UserImportInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException").exceptionBuilderSupplier(MfaMethodNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException").exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredCodeException").exceptionBuilderSupplier(ExpiredCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException").exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserNotFoundException").exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPasswordException").exceptionBuilderSupplier(InvalidPasswordException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AliasExistsException").exceptionBuilderSupplier(AliasExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedUserStateException").exceptionBuilderSupplier(UnsupportedUserStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException").exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserNotConfirmedException").exceptionBuilderSupplier(UserNotConfirmedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PasswordResetRequiredException").exceptionBuilderSupplier(PasswordResetRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnexpectedLambdaException").exceptionBuilderSupplier(UnexpectedLambdaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateProviderException").exceptionBuilderSupplier(DuplicateProviderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserLambdaValidationException").exceptionBuilderSupplier(UserLambdaValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException").exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException").exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException").exceptionBuilderSupplier(CodeDeliveryFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException").exceptionBuilderSupplier(ScopeDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalErrorException").exceptionBuilderSupplier(InternalErrorException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException").exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GroupExistsException").exceptionBuilderSupplier(GroupExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserPoolTaggingException").exceptionBuilderSupplier(UserPoolTaggingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException").exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException").exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException").exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeMismatchException").exceptionBuilderSupplier(CodeMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CognitoIdentityProviderRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CognitoIdentityProviderRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$verifyUserAttribute$100(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifySoftwareToken$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserPoolDomain$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserPoolClient$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserPool$96(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserAttributes$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResourceServer$94(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIdentityProvider$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGroup$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDeviceStatus$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAuthEventFeedback$90(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$88(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopUserImportJob$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startUserImportJob$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$signUp$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setUserSettings$84(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setUserPoolMfaConfig$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setUserMFAPreference$82(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setUICustomization$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setRiskConfiguration$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeToken$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$respondToAuthChallenge$78(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resendConfirmationCode$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsersInGroup$76(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUserPools$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUserPoolClients$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUserImportJobs$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceServers$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityProviders$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGroups$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevices$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateAuth$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$globalSignOut$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserPoolMfaConfig$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserAttributeVerificationCode$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUser$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUICustomization$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSigningCertificate$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityProviderByIdentifier$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGroup$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevice$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCSVHeader$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$forgotPassword$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$forgetDevice$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUserPoolDomain$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUserPoolClient$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUserPool$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUserImportJob$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRiskConfiguration$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourceServer$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityProvider$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserPoolDomain$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserPoolClient$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserPool$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserAttributes$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceServer$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentityProvider$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUserPoolDomain$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUserPoolClient$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUserPool$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUserImportJob$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceServer$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIdentityProvider$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGroup$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmSignUp$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmForgotPassword$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmDevice$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changePassword$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSoftwareToken$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminUserGlobalSignOut$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminUpdateUserAttributes$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminUpdateDeviceStatus$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminUpdateAuthEventFeedback$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminSetUserSettings$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminSetUserPassword$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminSetUserMFAPreference$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminRespondToAuthChallenge$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminResetUserPassword$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminRemoveUserFromGroup$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminListUserAuthEvents$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminListGroupsForUser$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminListDevices$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminLinkProviderForUser$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminInitiateAuth$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminGetUser$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminGetDevice$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminForgetDevice$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminEnableUser$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminDisableUser$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminDisableProviderForUser$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminDeleteUserAttributes$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminDeleteUser$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminCreateUser$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminConfirmSignUp$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$adminAddUserToGroup$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCustomAttributes$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

