/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The email configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailConfigurationType.Builder, EmailConfigurationType> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailConfigurationType::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> REPLY_TO_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailConfigurationType::replyToEmailAddress)).setter(setter(Builder::replyToEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToEmailAddress").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            REPLY_TO_EMAIL_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final String replyToEmailAddress;

    private EmailConfigurationType(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.replyToEmailAddress = builder.replyToEmailAddress;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the email source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the email source.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The destination to which the receiver of the email should reply to.
     * </p>
     * 
     * @return The destination to which the receiver of the email should reply to.
     */
    public String replyToEmailAddress() {
        return replyToEmailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replyToEmailAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfigurationType)) {
            return false;
        }
        EmailConfigurationType other = (EmailConfigurationType) obj;
        return Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(replyToEmailAddress(), other.replyToEmailAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("EmailConfigurationType").add("SourceArn", sourceArn())
                .add("ReplyToEmailAddress", replyToEmailAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "ReplyToEmailAddress":
            return Optional.ofNullable(clazz.cast(replyToEmailAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailConfigurationType, T> g) {
        return obj -> g.apply((EmailConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the email source.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the email source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The destination to which the receiver of the email should reply to.
         * </p>
         * 
         * @param replyToEmailAddress
         *        The destination to which the receiver of the email should reply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToEmailAddress(String replyToEmailAddress);
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private String replyToEmailAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfigurationType model) {
            sourceArn(model.sourceArn);
            replyToEmailAddress(model.replyToEmailAddress);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReplyToEmailAddress() {
            return replyToEmailAddress;
        }

        @Override
        public final Builder replyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
            return this;
        }

        public final void setReplyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
        }

        @Override
        public EmailConfigurationType build() {
            return new EmailConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
