/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClientBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.DefaultCognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.DefaultCognitoIdentityProviderBaseClientBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.endpoints.CognitoIdentityProviderEndpointProvider;

@SdkInternalApi
final class DefaultCognitoIdentityProviderAsyncClientBuilder
extends DefaultCognitoIdentityProviderBaseClientBuilder<CognitoIdentityProviderAsyncClientBuilder, CognitoIdentityProviderAsyncClient>
implements CognitoIdentityProviderAsyncClientBuilder {
    DefaultCognitoIdentityProviderAsyncClientBuilder() {
    }

    @Override
    public DefaultCognitoIdentityProviderAsyncClientBuilder endpointProvider(CognitoIdentityProviderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CognitoIdentityProviderAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCognitoIdentityProviderAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CognitoIdentityProviderServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCognitoIdentityProviderAsyncClient client = new DefaultCognitoIdentityProviderAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CognitoIdentityProviderServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CognitoIdentityProviderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

