/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClientBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.DefaultCognitoIdentityProviderBaseClientBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.DefaultCognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.endpoints.CognitoIdentityProviderEndpointProvider;

@SdkInternalApi
final class DefaultCognitoIdentityProviderClientBuilder
extends DefaultCognitoIdentityProviderBaseClientBuilder<CognitoIdentityProviderClientBuilder, CognitoIdentityProviderClient>
implements CognitoIdentityProviderClientBuilder {
    DefaultCognitoIdentityProviderClientBuilder() {
    }

    @Override
    public DefaultCognitoIdentityProviderClientBuilder endpointProvider(CognitoIdentityProviderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CognitoIdentityProviderClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCognitoIdentityProviderClientBuilder.validateClientOptions(clientConfiguration);
        CognitoIdentityProviderServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCognitoIdentityProviderClient client = new DefaultCognitoIdentityProviderClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CognitoIdentityProviderServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CognitoIdentityProviderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

