/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CloudWatch logging destination of a user pool detailed activity logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsConfigurationType.Builder, CloudWatchLogsConfigurationType> {
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupArn").getter(getter(CloudWatchLogsConfigurationType::logGroupArn))
            .setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupArn;

    private CloudWatchLogsConfigurationType(BuilderImpl builder) {
        this.logGroupArn = builder.logGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user pool sends logs. The log group must
     * not be encrypted with Key Management Service and must be in the same Amazon Web Services account as your user
     * pool.
     * </p>
     * <p>
     * To send logs to log groups with a resource policy of a size greater than 5120 characters, configure a log group
     * with a path that starts with <code>/aws/vendedlogs</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from certain Amazon Web Services services</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user pool sends logs. The log
     *         group must not be encrypted with Key Management Service and must be in the same Amazon Web Services
     *         account as your user pool.</p>
     *         <p>
     *         To send logs to log groups with a resource policy of a size greater than 5120 characters, configure a log
     *         group with a path that starts with <code>/aws/vendedlogs</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html"
     *         >Enabling logging from certain Amazon Web Services services</a>.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfigurationType)) {
            return false;
        }
        CloudWatchLogsConfigurationType other = (CloudWatchLogsConfigurationType) obj;
        return Objects.equals(logGroupArn(), other.logGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogsConfigurationType").add("LogGroupArn", logGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsConfigurationType, T> g) {
        return obj -> g.apply((CloudWatchLogsConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user pool sends logs. The log group
         * must not be encrypted with Key Management Service and must be in the same Amazon Web Services account as your
         * user pool.
         * </p>
         * <p>
         * To send logs to log groups with a resource policy of a size greater than 5120 characters, configure a log
         * group with a path that starts with <code>/aws/vendedlogs</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
         * logging from certain Amazon Web Services services</a>.
         * </p>
         * 
         * @param logGroupArn
         *        The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user pool sends logs. The log
         *        group must not be encrypted with Key Management Service and must be in the same Amazon Web Services
         *        account as your user pool.</p>
         *        <p>
         *        To send logs to log groups with a resource policy of a size greater than 5120 characters, configure a
         *        log group with a path that starts with <code>/aws/vendedlogs</code>. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
         *        logging from certain Amazon Web Services services</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfigurationType model) {
            logGroupArn(model.logGroupArn);
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        @Override
        public CloudWatchLogsConfigurationType build() {
            return new CloudWatchLogsConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
