/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SMS configuration type is the settings that your Amazon Cognito user pool must use to send an SMS message from
 * your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in
 * the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management
 * (IAM) role in your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<SmsConfigurationType.Builder, SmsConfigurationType> {
    private static final SdkField<String> SNS_CALLER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsCallerArn").getter(getter(SmsConfigurationType::snsCallerArn)).setter(setter(Builder::snsCallerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsCallerArn").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(SmsConfigurationType::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> SNS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsRegion").getter(getter(SmsConfigurationType::snsRegion)).setter(setter(Builder::snsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CALLER_ARN_FIELD,
            EXTERNAL_ID_FIELD, SNS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snsCallerArn;

    private final String externalId;

    private final String snsRegion;

    private SmsConfigurationType(BuilderImpl builder) {
        this.snsCallerArn = builder.snsCallerArn;
        this.externalId = builder.externalId;
        this.snsRegion = builder.snsRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web
     * Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html"
     * >spending limit</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon
     *         Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a
     *         href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html"
     *         >spending limit</a>.
     */
    public final String snsCallerArn() {
        return snsCallerArn;
    }

    /**
     * <p>
     * The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with the
     * IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an
     * <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role. You
     * can configure the role trust policy to require that Amazon Cognito, and any principal, provide the
     * <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS multi-factor
     * authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust policy that
     * demonstrates use of the <code>ExternalId</code>.
     * </p>
     * <p>
     * For more information about the <code>ExternalId</code> of a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use an
     * external ID when granting access to your Amazon Web Services resources to a third party</a>
     * </p>
     * 
     * @return The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code>
     *         with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an
     *         <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM
     *         role. You can configure the role trust policy to require that Amazon Cognito, and any principal, provide
     *         the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS
     *         multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a
     *         trust policy that demonstrates use of the <code>ExternalId</code>.</p>
     *         <p>
     *         For more information about the <code>ExternalId</code> of a role, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to
     *         use an external ID when granting access to your Amazon Web Services resources to a third party</a>
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your user
     * pool, or a supported <b>Legacy Amazon SNS alternate Region</b>.
     * </p>
     * <p>
     * Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS
     * configuration in the Asia Pacific (Tokyo) Region. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message settings
     * for Amazon Cognito user pools</a>.
     * </p>
     * 
     * @return The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your
     *         user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
     *         <p>
     *         Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS
     *         configuration in the Asia Pacific (Tokyo) Region. For more information, see <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
     *         settings for Amazon Cognito user pools</a>.
     */
    public final String snsRegion() {
        return snsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsCallerArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(snsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsConfigurationType)) {
            return false;
        }
        SmsConfigurationType other = (SmsConfigurationType) obj;
        return Objects.equals(snsCallerArn(), other.snsCallerArn()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(snsRegion(), other.snsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsConfigurationType").add("SnsCallerArn", snsCallerArn()).add("ExternalId", externalId())
                .add("SnsRegion", snsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsCallerArn":
            return Optional.ofNullable(clazz.cast(snsCallerArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "SnsRegion":
            return Optional.ofNullable(clazz.cast(snsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmsConfigurationType, T> g) {
        return obj -> g.apply((SmsConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your Amazon Web
         * Services account that Amazon Cognito will use to send SMS messages. SMS messages are subject to a <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html"
         * >spending limit</a>.
         * </p>
         * 
         * @param snsCallerArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the IAM role in your
         *        Amazon Web Services account that Amazon Cognito will use to send SMS messages. SMS messages are
         *        subject to a <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html"
         *        >spending limit</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsCallerArn(String snsCallerArn);

        /**
         * <p>
         * The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code> with
         * the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide an
         * <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your IAM role.
         * You can configure the role trust policy to require that Amazon Cognito, and any principal, provide the
         * <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role for SMS
         * multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions and a trust
         * policy that demonstrates use of the <code>ExternalId</code>.
         * </p>
         * <p>
         * For more information about the <code>ExternalId</code> of a role, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to use
         * an external ID when granting access to your Amazon Web Services resources to a third party</a>
         * </p>
         * 
         * @param externalId
         *        The external ID provides additional security for your IAM role. You can use an <code>ExternalId</code>
         *        with the IAM role that you use with Amazon SNS to send SMS messages for your user pool. If you provide
         *        an <code>ExternalId</code>, your Amazon Cognito user pool includes it in the request to assume your
         *        IAM role. You can configure the role trust policy to require that Amazon Cognito, and any principal,
         *        provide the <code>ExternalID</code>. If you use the Amazon Cognito Management Console to create a role
         *        for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with the required permissions
         *        and a trust policy that demonstrates use of the <code>ExternalId</code>.</p>
         *        <p>
         *        For more information about the <code>ExternalId</code> of a role, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How
         *        to use an external ID when granting access to your Amazon Web Services resources to a third party</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as your
         * user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>.
         * </p>
         * <p>
         * Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon SNS
         * configuration in the Asia Pacific (Tokyo) Region. For more information, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS message
         * settings for Amazon Cognito user pools</a>.
         * </p>
         * 
         * @param snsRegion
         *        The Amazon Web Services Region to use with Amazon SNS integration. You can choose the same Region as
         *        your user pool, or a supported <b>Legacy Amazon SNS alternate Region</b>. </p>
         *        <p>
         *        Amazon Cognito resources in the Asia Pacific (Seoul) Amazon Web Services Region must use your Amazon
         *        SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html">SMS
         *        message settings for Amazon Cognito user pools</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsRegion(String snsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String snsCallerArn;

        private String externalId;

        private String snsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsConfigurationType model) {
            snsCallerArn(model.snsCallerArn);
            externalId(model.externalId);
            snsRegion(model.snsRegion);
        }

        public final String getSnsCallerArn() {
            return snsCallerArn;
        }

        public final void setSnsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
        }

        @Override
        public final Builder snsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getSnsRegion() {
            return snsRegion;
        }

        public final void setSnsRegion(String snsRegion) {
            this.snsRegion = snsRegion;
        }

        @Override
        public final Builder snsRegion(String snsRegion) {
            this.snsRegion = snsRegion;
            return this;
        }

        @Override
        public SmsConfigurationType build() {
            return new SmsConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
