/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupType;

public class AdminListGroupsForUserPublisher
implements SdkPublisher<AdminListGroupsForUserResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final AdminListGroupsForUserRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public AdminListGroupsForUserPublisher(CognitoIdentityProviderAsyncClient client, AdminListGroupsForUserRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private AdminListGroupsForUserPublisher(CognitoIdentityProviderAsyncClient client, AdminListGroupsForUserRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new AdminListGroupsForUserResponseFetcher();
    }

    public void subscribe(Subscriber<? super AdminListGroupsForUserResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupType> groups() {
        Function<AdminListGroupsForUserResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new AdminListGroupsForUserResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class AdminListGroupsForUserResponseFetcher
    implements AsyncPageFetcher<AdminListGroupsForUserResponse> {
        private AdminListGroupsForUserResponseFetcher() {
        }

        public boolean hasNextPage(AdminListGroupsForUserResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<AdminListGroupsForUserResponse> nextPage(AdminListGroupsForUserResponse previousPage) {
            if (previousPage == null) {
                return AdminListGroupsForUserPublisher.this.client.adminListGroupsForUser(AdminListGroupsForUserPublisher.this.firstRequest);
            }
            return AdminListGroupsForUserPublisher.this.client.adminListGroupsForUser((AdminListGroupsForUserRequest)((Object)AdminListGroupsForUserPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

