/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceServerRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateResourceServerRequest.Builder, CreateResourceServerRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(CreateResourceServerRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(CreateResourceServerRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateResourceServerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ResourceServerScopeType>> SCOPES_FIELD = SdkField
            .<List<ResourceServerScopeType>> builder(MarshallingType.LIST)
            .memberName("Scopes")
            .getter(getter(CreateResourceServerRequest::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceServerScopeType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceServerScopeType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            IDENTIFIER_FIELD, NAME_FIELD, SCOPES_FIELD));

    private final String userPoolId;

    private final String identifier;

    private final String name;

    private final List<ResourceServerScopeType> scopes;

    private CreateResourceServerRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.scopes = builder.scopes;
    }

    /**
     * <p>
     * The user pool ID for the user pool.
     * </p>
     * 
     * @return The user pool ID for the user pool.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * A unique resource server identifier for the resource server. The identifier can be an API friendly name like
     * <code>solar-system-data</code>. You can also set an API URL like
     * <code>https://solar-system-data-api.example.com</code> as your identifier.
     * </p>
     * <p>
     * Amazon Cognito represents scopes in the access token in the format
     * <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your access
     * tokens.
     * </p>
     * 
     * @return A unique resource server identifier for the resource server. The identifier can be an API friendly name
     *         like <code>solar-system-data</code>. You can also set an API URL like
     *         <code>https://solar-system-data-api.example.com</code> as your identifier.</p>
     *         <p>
     *         Amazon Cognito represents scopes in the access token in the format
     *         <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of
     *         your access tokens.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A friendly name for the resource server.
     * </p>
     * 
     * @return A friendly name for the resource server.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return A list of scopes. Each scope is a key-value map with the keys <code>name</code> and
     *         <code>description</code>.
     */
    public final List<ResourceServerScopeType> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceServerRequest)) {
            return false;
        }
        CreateResourceServerRequest other = (CreateResourceServerRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(name(), other.name()) && hasScopes() == other.hasScopes()
                && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceServerRequest").add("UserPoolId", userPoolId()).add("Identifier", identifier())
                .add("Name", name()).add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceServerRequest, T> g) {
        return obj -> g.apply((CreateResourceServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceServerRequest> {
        /**
         * <p>
         * The user pool ID for the user pool.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * A unique resource server identifier for the resource server. The identifier can be an API friendly name like
         * <code>solar-system-data</code>. You can also set an API URL like
         * <code>https://solar-system-data-api.example.com</code> as your identifier.
         * </p>
         * <p>
         * Amazon Cognito represents scopes in the access token in the format
         * <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of your
         * access tokens.
         * </p>
         * 
         * @param identifier
         *        A unique resource server identifier for the resource server. The identifier can be an API friendly
         *        name like <code>solar-system-data</code>. You can also set an API URL like
         *        <code>https://solar-system-data-api.example.com</code> as your identifier.</p>
         *        <p>
         *        Amazon Cognito represents scopes in the access token in the format
         *        <code>$resource-server-identifier/$scope</code>. Longer scope-identifier strings increase the size of
         *        your access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A friendly name for the resource server.
         * </p>
         * 
         * @param name
         *        A friendly name for the resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.
         * </p>
         * 
         * @param scopes
         *        A list of scopes. Each scope is a key-value map with the keys <code>name</code> and
         *        <code>description</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<ResourceServerScopeType> scopes);

        /**
         * <p>
         * A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.
         * </p>
         * 
         * @param scopes
         *        A list of scopes. Each scope is a key-value map with the keys <code>name</code> and
         *        <code>description</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(ResourceServerScopeType... scopes);

        /**
         * <p>
         * A list of scopes. Each scope is a key-value map with the keys <code>name</code> and <code>description</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType.Builder#build()}
         * is called immediately and its result is passed to {@link #scopes(List<ResourceServerScopeType>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerScopeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(java.util.Collection<ResourceServerScopeType>)
         */
        Builder scopes(Consumer<ResourceServerScopeType.Builder>... scopes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String identifier;

        private String name;

        private List<ResourceServerScopeType> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceServerRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            identifier(model.identifier);
            name(model.name);
            scopes(model.scopes);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourceServerScopeType.Builder> getScopes() {
            List<ResourceServerScopeType.Builder> result = ResourceServerScopeListTypeCopier.copyToBuilder(this.scopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScopes(Collection<ResourceServerScopeType.BuilderImpl> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copyFromBuilder(scopes);
        }

        @Override
        public final Builder scopes(Collection<ResourceServerScopeType> scopes) {
            this.scopes = ResourceServerScopeListTypeCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(ResourceServerScopeType... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<ResourceServerScopeType.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> ResourceServerScopeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceServerRequest build() {
            return new CreateResourceServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
