/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupPublisher;
import software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher;

/**
 * Service client for accessing Amazon Cognito Identity Provider asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * With the Amazon Cognito user pools API, you can configure user pools and authenticate users. To authenticate users
 * from third-party identity providers (IdPs) in this API, you can <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
 * >link IdP users to native user profiles</a>. Learn more about the authentication and authorization of federated users
 * at <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html">Adding
 * user pool sign-in through a third party</a> and in the <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-userpools-server-contract-reference.html"
 * >User pool federation endpoints and hosted UI reference</a>.
 * </p>
 * <p>
 * This API reference provides detailed information about API operations and object types in Amazon Cognito.
 * </p>
 * <p>
 * Along with resource management operations, the Amazon Cognito user pools API includes classes of operations and
 * authorization models for client-side and server-side authentication of users. You can interact with operations in the
 * Amazon Cognito user pools API as any of the following subjects.
 * </p>
 * <ol>
 * <li>
 * <p>
 * An administrator who wants to configure user pools, app clients, users, groups, or other user pool functions.
 * </p>
 * </li>
 * <li>
 * <p>
 * A server-side app, like a web application, that wants to use its Amazon Web Services privileges to manage,
 * authenticate, or authorize a user.
 * </p>
 * </li>
 * <li>
 * <p>
 * A client-side app, like a mobile app, that wants to make unauthenticated requests to manage, authenticate, or
 * authorize a user.
 * </p>
 * </li>
 * </ol>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
 * Cognito user pools API and user pool endpoints</a> in the <i>Amazon Cognito Developer Guide</i>.
 * </p>
 * <p>
 * With your Amazon Web Services SDK, you can build the logic to support operational flows in every use case for this
 * API. You can also make direct REST API requests to <a
 * href="https://docs.aws.amazon.com/general/latest/gr/cognito_identity.html#cognito_identity_your_user_pools_region"
 * >Amazon Cognito user pools service endpoints</a>. The following links can get you started with the
 * <code>CognitoIdentityProvider</code> client in other supported Amazon Web Services SDKs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/cognito-idp/index.html#cli-aws-cognito-idp">Amazon Web
 * Services Command Line Interface</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/CognitoIdentityProvider/TCognitoIdentityProviderClient.html"
 * >Amazon Web Services SDK for .NET</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://sdk.amazonaws.com/cpp/api/LATEST/aws-cpp-sdk-cognito-idp/html/class_aws_1_1_cognito_identity_provider_1_1_cognito_identity_provider_client.html"
 * >Amazon Web Services SDK for C++</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sdk-for-go/api/service/cognitoidentityprovider/#CognitoIdentityProvider">Amazon
 * Web Services SDK for Go</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/cognitoidentityprovider/CognitoIdentityProviderClient.html"
 * >Amazon Web Services SDK for Java V2</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/CognitoIdentityServiceProvider.html">Amazon Web
 * Services SDK for JavaScript</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/aws-sdk-php/v3/api/api-cognito-idp-2016-04-18.html">Amazon Web Services SDK for
 * PHP V3</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/cognito-idp.html">Amazon Web
 * Services SDK for Python</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sdk-for-ruby/v3/api/Aws/CognitoIdentityProvider/Client.html">Amazon Web Services
 * SDK for Ruby V3</a>
 * </p>
 * </li>
 * </ul>
 * <p>
 * To get started with an Amazon Web Services SDK, see <a href="http://aws.amazon.com/developer/tools/">Tools to Build
 * on Amazon Web Services</a>. For example actions and scenarios, see <a href=
 * "https://docs.aws.amazon.com/cognito/latest/developerguide/service_code_examples_cognito-identity-provider.html">Code
 * examples for Amazon Cognito Identity Provider using Amazon Web Services SDKs</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CognitoIdentityProviderAsyncClient extends AwsClient {
    String SERVICE_NAME = "cognito-idp";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cognito-idp";

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            AddCustomAttributesRequest addCustomAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddCustomAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link AddCustomAttributesRequest#builder()}
     * </p>
     *
     * @param addCustomAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest.Builder}
     *        to create a request. Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            Consumer<AddCustomAttributesRequest.Builder> addCustomAttributesRequest) {
        return addCustomAttributes(AddCustomAttributesRequest.builder().applyMutation(addCustomAttributesRequest).build());
    }

    /**
     * <p>
     * Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and
     * populates a <code>cognito:groups</code> claim to their access and identity tokens.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminAddUserToGroupRequest
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and
     * populates a <code>cognito:groups</code> claim to their access and identity tokens.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminAddUserToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AdminAddUserToGroupRequest#builder()}
     * </p>
     *
     * @param adminAddUserToGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            Consumer<AdminAddUserToGroupRequest.Builder> adminAddUserToGroupRequest) {
        return adminAddUserToGroup(AdminAddUserToGroupRequest.builder().applyMutation(adminAddUserToGroupRequest).build());
    }

    /**
     * <p>
     * This IAM-authenticated API operation provides a code that Amazon Cognito sent to your user when they signed up in
     * your user pool. After your user enters their code, they confirm ownership of the email address or phone number
     * that they provided, and their user account becomes active. Depending on your user pool configuration, your users
     * will receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * Administrator-created users confirm their accounts when they respond to their invitation email message and choose
     * a password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminConfirmSignUpRequest
     *        Confirm a user's registration as a user pool administrator.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This IAM-authenticated API operation provides a code that Amazon Cognito sent to your user when they signed up in
     * your user pool. After your user enters their code, they confirm ownership of the email address or phone number
     * that they provided, and their user account becomes active. Depending on your user pool configuration, your users
     * will receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * Administrator-created users confirm their accounts when they respond to their invitation email message and choose
     * a password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminConfirmSignUpRequest.Builder} avoiding the
     * need to create one manually via {@link AdminConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param adminConfirmSignUpRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest.Builder} to
     *        create a request. Confirm a user's registration as a user pool administrator.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(
            Consumer<AdminConfirmSignUpRequest.Builder> adminConfirmSignUpRequest) {
        return adminConfirmSignUp(AdminConfirmSignUpRequest.builder().applyMutation(adminConfirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> isn't set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the
     * <code>MessageAction</code> parameter, and Amazon Cognito won't send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminCreateUserRequest
     *        Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> isn't set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the
     * <code>MessageAction</code> parameter, and Amazon Cognito won't send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminCreateUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminCreateUserRequest#builder()}
     * </p>
     *
     * @param adminCreateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest.Builder} to
     *        create a request. Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminCreateUserResponse> adminCreateUser(
            Consumer<AdminCreateUserRequest.Builder> adminCreateUserRequest) {
        return adminCreateUser(AdminCreateUserRequest.builder().applyMutation(adminCreateUserRequest).build());
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDeleteUserRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest.Builder} to
     *        create a request. Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(
            Consumer<AdminDeleteUserRequest.Builder> adminDeleteUserRequest) {
        return adminDeleteUser(AdminDeleteUserRequest.builder().applyMutation(adminDeleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDeleteUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminDeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminDeleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest.Builder}
     *        to create a request. Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            Consumer<AdminDeleteUserAttributesRequest.Builder> adminDeleteUserAttributesRequest) {
        return adminDeleteUserAttributes(AdminDeleteUserAttributesRequest.builder()
                .applyMutation(adminDeleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the
     * user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use
     * their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user
     * and an existing user is removed. When the external user signs in again, and the user is no longer attached to the
     * previously linked <code>DestinationUser</code>, the user must create a new user account. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To deactivate a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>. The
     * <code>ProviderAttributeValue</code> must be the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The
     * <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally
     * linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set
     * to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the subject of the SAML assertion.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableProviderForUserRequest
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the
     * user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use
     * their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user
     * and an existing user is removed. When the external user signs in again, and the user is no longer attached to the
     * previously linked <code>DestinationUser</code>, the user must create a new user account. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To deactivate a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>. The
     * <code>ProviderAttributeValue</code> must be the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The
     * <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally
     * linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set
     * to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the subject of the SAML assertion.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableProviderForUserRequest.Builder}
     * avoiding the need to create one manually via {@link AdminDisableProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminDisableProviderForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            Consumer<AdminDisableProviderForUserRequest.Builder> adminDisableProviderForUserRequest) {
        return adminDisableProviderForUser(AdminDisableProviderForUserRequest.builder()
                .applyMutation(adminDisableProviderForUserRequest).build());
    }

    /**
     * <p>
     * Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still
     * appears in the responses to <code>GetUser</code> and <code>ListUsers</code> API requests.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable the user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still
     * appears in the responses to <code>GetUser</code> and <code>ListUsers</code> API requests.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminDisableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminDisableUserRequest#builder()}
     * </p>
     *
     * @param adminDisableUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest.Builder} to
     *        create a request. Represents the request to disable the user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminDisableUserResponse> adminDisableUser(
            Consumer<AdminDisableUserRequest.Builder> adminDisableUserRequest) {
        return adminDisableUser(AdminDisableUserRequest.builder().applyMutation(adminDisableUserRequest).build());
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminEnableUserRequest.Builder} avoiding the need
     * to create one manually via {@link AdminEnableUserRequest#builder()}
     * </p>
     *
     * @param adminEnableUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest.Builder} to
     *        create a request. Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminEnableUserResponse> adminEnableUser(
            Consumer<AdminEnableUserRequest.Builder> adminEnableUserRequest) {
        return adminEnableUser(AdminEnableUserRequest.builder().applyMutation(adminEnableUserRequest).build());
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminForgetDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link AdminForgetDeviceRequest#builder()}
     * </p>
     *
     * @param adminForgetDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest.Builder} to
     *        create a request. Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(
            Consumer<AdminForgetDeviceRequest.Builder> adminForgetDeviceRequest) {
        return adminForgetDevice(AdminForgetDeviceRequest.builder().applyMutation(adminForgetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetDeviceRequest#builder()}
     * </p>
     *
     * @param adminGetDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest.Builder} to
     *        create a request. Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminGetDeviceResponse> adminGetDevice(Consumer<AdminGetDeviceRequest.Builder> adminGetDeviceRequest) {
        return adminGetDevice(AdminGetDeviceRequest.builder().applyMutation(adminGetDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminGetUserRequest.Builder} avoiding the need to
     * create one manually via {@link AdminGetUserRequest#builder()}
     * </p>
     *
     * @param adminGetUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest.Builder} to
     *        create a request. Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AdminGetUserResponse> adminGetUser(Consumer<AdminGetUserRequest.Builder> adminGetUserRequest) {
        return adminGetUser(AdminGetUserRequest.builder().applyMutation(adminGetUserRequest).build());
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminInitiateAuthRequest.Builder} avoiding the need
     * to create one manually via {@link AdminInitiateAuthRequest#builder()}
     * </p>
     *
     * @param adminInitiateAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest.Builder} to
     *        create a request. Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(
            Consumer<AdminInitiateAuthRequest.Builder> adminInitiateAuthRequest) {
        return adminInitiateAuth(AdminInitiateAuthRequest.builder().applyMutation(adminInitiateAuthRequest).build());
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external IdP
     * (<code>SourceUser</code>) based on a specified attribute name and value from the external IdP. This allows you to
     * create a link from the existing user account to an external federated user identity that has not yet been used to
     * sign in. You can then use the federated user identity to sign in as the existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is five.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by
     * the application owner.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminLinkProviderForUserRequest
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external IdP
     * (<code>SourceUser</code>) based on a specified attribute name and value from the external IdP. This allows you to
     * create a link from the existing user account to an external federated user identity that has not yet been used to
     * sign in. You can then use the federated user identity to sign in as the existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is five.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by
     * the application owner.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminLinkProviderForUserRequest.Builder} avoiding
     * the need to create one manually via {@link AdminLinkProviderForUserRequest#builder()}
     * </p>
     *
     * @param adminLinkProviderForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            Consumer<AdminLinkProviderForUserRequest.Builder> adminLinkProviderForUserRequest) {
        return adminLinkProviderForUser(AdminLinkProviderForUserRequest.builder().applyMutation(adminLinkProviderForUserRequest)
                .build());
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link AdminListDevicesRequest#builder()}
     * </p>
     *
     * @param adminListDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest.Builder} to
     *        create a request. Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AdminListDevicesResponse> adminListDevices(
            Consumer<AdminListDevicesRequest.Builder> adminListDevicesRequest) {
        return adminListDevices(AdminListDevicesRequest.builder().applyMutation(adminListDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups that a user belongs to.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListGroupsForUserRequest
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups that a user belongs to.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListGroupsForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AdminListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param adminListGroupsForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            Consumer<AdminListGroupsForUserRequest.Builder> adminListGroupsForUserRequest) {
        return adminListGroupsForUser(AdminListGroupsForUserRequest.builder().applyMutation(adminListGroupsForUserRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserPublisher publisher = client.adminListGroupsForUserPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserPublisher publisher = client.adminListGroupsForUserPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation.</b>
     * </p>
     *
     * @param adminListGroupsForUserRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserPublisher adminListGroupsForUserPaginator(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        return new AdminListGroupsForUserPublisher(this, adminListGroupsForUserRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserPublisher publisher = client.adminListGroupsForUserPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListGroupsForUserPublisher publisher = client.adminListGroupsForUserPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListGroupsForUser(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListGroupsForUserRequest.Builder} avoiding the
     * need to create one manually via {@link AdminListGroupsForUserRequest#builder()}
     * </p>
     *
     * @param adminListGroupsForUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListGroupsForUserPublisher adminListGroupsForUserPaginator(
            Consumer<AdminListGroupsForUserRequest.Builder> adminListGroupsForUserRequest) {
        return adminListGroupsForUserPaginator(AdminListGroupsForUserRequest.builder()
                .applyMutation(adminListGroupsForUserRequest).build());
    }

    /**
     * <p>
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListUserAuthEventsRequest
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListUserAuthEventsRequest.Builder} avoiding
     * the need to create one manually via {@link AdminListUserAuthEventsRequest#builder()}
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            Consumer<AdminListUserAuthEventsRequest.Builder> adminListUserAuthEventsRequest) {
        return adminListUserAuthEvents(AdminListUserAuthEventsRequest.builder().applyMutation(adminListUserAuthEventsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsPublisher publisher = client.adminListUserAuthEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsPublisher publisher = client.adminListUserAuthEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsPublisher adminListUserAuthEventsPaginator(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        return new AdminListUserAuthEventsPublisher(this, adminListUserAuthEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsPublisher publisher = client.adminListUserAuthEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.AdminListUserAuthEventsPublisher publisher = client.adminListUserAuthEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #adminListUserAuthEvents(software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminListUserAuthEventsRequest.Builder} avoiding
     * the need to create one manually via {@link AdminListUserAuthEventsRequest#builder()}
     * </p>
     *
     * @param adminListUserAuthEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default AdminListUserAuthEventsPublisher adminListUserAuthEventsPaginator(
            Consumer<AdminListUserAuthEventsRequest.Builder> adminListUserAuthEventsRequest) {
        return adminListUserAuthEventsPaginator(AdminListUserAuthEventsRequest.builder()
                .applyMutation(adminListUserAuthEventsRequest).build());
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRemoveUserFromGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AdminRemoveUserFromGroupRequest#builder()}
     * </p>
     *
     * @param adminRemoveUserFromGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            Consumer<AdminRemoveUserFromGroupRequest.Builder> adminRemoveUserFromGroupRequest) {
        return adminRemoveUserFromGroup(AdminRemoveUserFromGroupRequest.builder().applyMutation(adminRemoveUserFromGroupRequest)
                .build());
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Deactivates a user's password, requiring them to change it. If a user tries to sign in after the API is called,
     * Amazon Cognito responds with a <code>PasswordResetRequiredException</code> error. Your app must then perform the
     * actions that reset your user's password: the forgot-password flow. In addition, if the user pool has phone
     * verification selected and a verified phone number exists for the user, or if email verification is selected and a
     * verified email exists for the user, calling this API will also result in sending a message to the end user with
     * the code to change their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Deactivates a user's password, requiring them to change it. If a user tries to sign in after the API is called,
     * Amazon Cognito responds with a <code>PasswordResetRequiredException</code> error. Your app must then perform the
     * actions that reset your user's password: the forgot-password flow. In addition, if the user pool has phone
     * verification selected and a verified phone number exists for the user, or if email verification is selected and a
     * verified email exists for the user, calling this API will also result in sending a message to the end user with
     * the code to change their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminResetUserPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link AdminResetUserPasswordRequest#builder()}
     * </p>
     *
     * @param adminResetUserPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest.Builder}
     *        to create a request. Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            Consumer<AdminResetUserPasswordRequest.Builder> adminResetUserPasswordRequest) {
        return adminResetUserPassword(AdminResetUserPasswordRequest.builder().applyMutation(adminResetUserPasswordRequest)
                .build());
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API
     * request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API
     * request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminRespondToAuthChallengeRequest.Builder}
     * avoiding the need to create one manually via {@link AdminRespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param adminRespondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest.Builder}
     *        to create a request. The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            Consumer<AdminRespondToAuthChallengeRequest.Builder> adminRespondToAuthChallengeRequest) {
        return adminRespondToAuthChallenge(AdminRespondToAuthChallengeRequest.builder()
                .applyMutation(adminRespondToAuthChallengeRequest).build());
    }

    /**
     * <p>
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any
     * are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a
     * user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge
     * to choose an MFA option will be returned during sign-in.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any
     * are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a
     * user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge
     * to choose an MFA option will be returned during sign-in.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserMfaPreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link AdminSetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param adminSetUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            Consumer<AdminSetUserMfaPreferenceRequest.Builder> adminSetUserMfaPreferenceRequest) {
        return adminSetUserMFAPreference(AdminSetUserMfaPreferenceRequest.builder()
                .applyMutation(adminSetUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * The password can be temporary or permanent. If it is temporary, the user status enters the
     * <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth
     * response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn't sign in before it
     * expires, the user won't be able to sign in, and an administrator must reset their password.
     * </p>
     * <p>
     * Once the user has set a new password, or the password is permanent, the user status is set to
     * <code>Confirmed</code>.
     * </p>
     * <p>
     * <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for
     * third-party federated users. When you set a password, the federated user's status changes from
     * <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user,
     * and initiate authentication flows in the API like a linked native user. They can also modify their password and
     * attributes in token-authenticated API requests like <code>ChangePassword</code> and
     * <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP,
     * don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked
     * native user, refer to <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users to an existing user profile</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserPasswordRequest
     * @return A Java Future containing the result of the AdminSetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserPasswordResponse> adminSetUserPassword(
            AdminSetUserPasswordRequest adminSetUserPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * The password can be temporary or permanent. If it is temporary, the user status enters the
     * <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth
     * response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn't sign in before it
     * expires, the user won't be able to sign in, and an administrator must reset their password.
     * </p>
     * <p>
     * Once the user has set a new password, or the password is permanent, the user status is set to
     * <code>Confirmed</code>.
     * </p>
     * <p>
     * <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for
     * third-party federated users. When you set a password, the federated user's status changes from
     * <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user,
     * and initiate authentication flows in the API like a linked native user. They can also modify their password and
     * attributes in token-authenticated API requests like <code>ChangePassword</code> and
     * <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP,
     * don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked
     * native user, refer to <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users to an existing user profile</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link AdminSetUserPasswordRequest#builder()}
     * </p>
     *
     * @param adminSetUserPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminSetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserPasswordResponse> adminSetUserPassword(
            Consumer<AdminSetUserPasswordRequest.Builder> adminSetUserPasswordRequest) {
        return adminSetUserPassword(AdminSetUserPasswordRequest.builder().applyMutation(adminSetUserPasswordRequest).build());
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html"
     * >AdminSetUserMFAPreference</a> instead.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserSettingsRequest
     *        You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html"
     * >AdminSetUserMFAPreference</a> instead.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminSetUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link AdminSetUserSettingsRequest#builder()}
     * </p>
     *
     * @param adminSetUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest.Builder}
     *        to create a request. You can use this parameter to set an MFA configuration that uses the SMS delivery
     *        medium.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            Consumer<AdminSetUserSettingsRequest.Builder> adminSetUserSettingsRequest) {
        return adminSetUserSettings(AdminSetUserSettingsRequest.builder().applyMutation(adminSetUserSettingsRequest).build());
    }

    /**
     * <p>
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateAuthEventFeedbackRequest.Builder}
     * avoiding the need to create one manually via {@link AdminUpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            Consumer<AdminUpdateAuthEventFeedbackRequest.Builder> adminUpdateAuthEventFeedbackRequest) {
        return adminUpdateAuthEventFeedback(AdminUpdateAuthEventFeedbackRequest.builder()
                .applyMutation(adminUpdateAuthEventFeedbackRequest).build());
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateDeviceStatusRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param adminUpdateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest.Builder}
     *        to create a request. The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            Consumer<AdminUpdateDeviceStatusRequest.Builder> adminUpdateDeviceStatusRequest) {
        return adminUpdateDeviceStatus(AdminUpdateDeviceStatusRequest.builder().applyMutation(adminUpdateDeviceStatusRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * To delete an attribute from your user, submit the attribute in your API request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * To delete an attribute from your user, submit the attribute in your API request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUpdateUserAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link AdminUpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param adminUpdateUserAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest.Builder}
     *        to create a request. Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            Consumer<AdminUpdateUserAttributesRequest.Builder> adminUpdateUserAttributesRequest) {
        return adminUpdateUserAttributes(AdminUpdateUserAttributesRequest.builder()
                .applyMutation(adminUpdateUserAttributesRequest).build());
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * with your administrative credentials when your user signs out of your app. This results in the following
     * behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * with your administrative credentials when your user signs out of your app. This results in the following
     * behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdminUserGlobalSignOutRequest.Builder} avoiding the
     * need to create one manually via {@link AdminUserGlobalSignOutRequest#builder()}
     * </p>
     *
     * @param adminUserGlobalSignOutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest.Builder}
     *        to create a request. The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            Consumer<AdminUserGlobalSignOutRequest.Builder> adminUserGlobalSignOutRequest) {
        return adminUserGlobalSignOut(AdminUserGlobalSignOutRequest.builder().applyMutation(adminUserGlobalSignOutRequest)
                .build());
    }

    /**
     * <p>
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique
     * private key that Amazon Cognito generates and returns in the API response. You can authorize an
     * <code>AssociateSoftwareToken</code> request with either the user's access token, or a session string from a
     * challenge response that you received from Amazon Cognito.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito disassociates an existing software token when you verify the new token in a <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html">
     * VerifySoftwareToken</a> API request. If you don't verify the software token and your user pool doesn't require
     * MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires
     * TOTP MFA, Amazon Cognito generates an <code>MFA_SETUP</code> or <code>SOFTWARE_TOKEN_SETUP</code> challenge each
     * time your user signs. Complete setup with <code>AssociateSoftwareToken</code> and
     * <code>VerifySoftwareToken</code>.
     * </p>
     * <p>
     * After you set up software token MFA for your user, Amazon Cognito generates a <code>SOFTWARE_TOKEN_MFA</code>
     * challenge when they authenticate. Respond to this challenge with your user's TOTP.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param associateSoftwareTokenRequest
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            AssociateSoftwareTokenRequest associateSoftwareTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique
     * private key that Amazon Cognito generates and returns in the API response. You can authorize an
     * <code>AssociateSoftwareToken</code> request with either the user's access token, or a session string from a
     * challenge response that you received from Amazon Cognito.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito disassociates an existing software token when you verify the new token in a <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html">
     * VerifySoftwareToken</a> API request. If you don't verify the software token and your user pool doesn't require
     * MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires
     * TOTP MFA, Amazon Cognito generates an <code>MFA_SETUP</code> or <code>SOFTWARE_TOKEN_SETUP</code> challenge each
     * time your user signs. Complete setup with <code>AssociateSoftwareToken</code> and
     * <code>VerifySoftwareToken</code>.
     * </p>
     * <p>
     * After you set up software token MFA for your user, Amazon Cognito generates a <code>SOFTWARE_TOKEN_MFA</code>
     * challenge when they authenticate. Respond to this challenge with your user's TOTP.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSoftwareTokenRequest#builder()}
     * </p>
     *
     * @param associateSoftwareTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            Consumer<AssociateSoftwareTokenRequest.Builder> associateSoftwareTokenRequest) {
        return associateSoftwareToken(AssociateSoftwareTokenRequest.builder().applyMutation(associateSoftwareTokenRequest)
                .build());
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangePasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ChangePasswordRequest#builder()}
     * </p>
     *
     * @param changePasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest.Builder} to
     *        create a request. Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ChangePasswordResponse> changePassword(Consumer<ChangePasswordRequest.Builder> changePasswordRequest) {
        return changePassword(ChangePasswordRequest.builder().applyMutation(changePasswordRequest).build());
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking. For more information
     * about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmDeviceRequest
     *        Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking. For more information
     * about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmDeviceRequest#builder()}
     * </p>
     *
     * @param confirmDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest.Builder} to
     *        create a request. Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmDeviceResponse> confirmDevice(Consumer<ConfirmDeviceRequest.Builder> confirmDeviceRequest) {
        return confirmDevice(ConfirmDeviceRequest.builder().applyMutation(confirmDeviceRequest).build());
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmForgotPasswordRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmForgotPasswordRequest#builder()}
     * </p>
     *
     * @param confirmForgotPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest.Builder}
     *        to create a request. The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            Consumer<ConfirmForgotPasswordRequest.Builder> confirmForgotPasswordRequest) {
        return confirmForgotPassword(ConfirmForgotPasswordRequest.builder().applyMutation(confirmForgotPasswordRequest).build());
    }

    /**
     * <p>
     * This public API operation provides a code that Amazon Cognito sent to your user when they signed up in your user
     * pool via the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html">SignUp</a> API
     * operation. After your user enters their code, they confirm ownership of the email address or phone number that
     * they provided, and their user account becomes active. Depending on your user pool configuration, your users will
     * receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * Administrator-created users, users created with the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
     * >AdminCreateUser</a> API operation, confirm their accounts when they respond to their invitation email message
     * and choose a password. They do not receive a confirmation code. Instead, they receive a temporary password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This public API operation provides a code that Amazon Cognito sent to your user when they signed up in your user
     * pool via the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html">SignUp</a> API
     * operation. After your user enters their code, they confirm ownership of the email address or phone number that
     * they provided, and their user account becomes active. Depending on your user pool configuration, your users will
     * receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * Administrator-created users, users created with the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
     * >AdminCreateUser</a> API operation, confirm their accounts when they respond to their invitation email message
     * and choose a password. They do not receive a confirmation code. Instead, they receive a temporary password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmSignUpRequest.Builder} avoiding the need to
     * create one manually via {@link ConfirmSignUpRequest#builder()}
     * </p>
     *
     * @param confirmSignUpRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest.Builder} to
     *        create a request. Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ConfirmSignUpResponse> confirmSignUp(Consumer<ConfirmSignUpRequest.Builder> confirmSignUpRequest) {
        return confirmSignUp(ConfirmSignUpRequest.builder().applyMutation(confirmSignUpRequest).build());
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param createIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            Consumer<CreateIdentityProviderRequest.Builder> createIdentityProviderRequest) {
        return createIdentityProvider(CreateIdentityProviderRequest.builder().applyMutation(createIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createResourceServerRequest
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceServerResponse> createResourceServer(
            CreateResourceServerRequest createResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceServerRequest#builder()}
     * </p>
     *
     * @param createResourceServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceServerResponse> createResourceServer(
            Consumer<CreateResourceServerRequest.Builder> createResourceServerRequest) {
        return createResourceServer(CreateResourceServerRequest.builder().applyMutation(createResourceServerRequest).build());
    }

    /**
     * <p>
     * Creates a user import job.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            CreateUserImportJobRequest createUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user import job.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserImportJobRequest#builder()}
     * </p>
     *
     * @param createUserImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest.Builder}
     *        to create a request. Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            Consumer<CreateUserImportJobRequest.Builder> createUserImportJobRequest) {
        return createUserImportJob(CreateUserImportJobRequest.builder().applyMutation(createUserImportJobRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserPoolRequest#builder()}
     * </p>
     *
     * @param createUserPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest.Builder} to
     *        create a request. Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolResponse> createUserPool(Consumer<CreateUserPoolRequest.Builder> createUserPoolRequest) {
        return createUserPool(CreateUserPoolRequest.builder().applyMutation(createUserPoolRequest).build());
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <p>
     * When you create a new user pool client, token revocation is automatically activated. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            CreateUserPoolClientRequest createUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <p>
     * When you create a new user pool client, token revocation is automatically activated. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param createUserPoolClientRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest.Builder}
     *        to create a request. Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            Consumer<CreateUserPoolClientRequest.Builder> createUserPoolClientRequest) {
        return createUserPoolClient(CreateUserPoolClientRequest.builder().applyMutation(createUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolDomainRequest
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param createUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            Consumer<CreateUserPoolDomainRequest.Builder> createUserPoolDomainRequest) {
        return createUserPoolDomain(CreateUserPoolDomainRequest.builder().applyMutation(createUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an IdP for a user pool.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an IdP for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deleteIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            Consumer<DeleteIdentityProviderRequest.Builder> deleteIdentityProviderRequest) {
        return deleteIdentityProvider(DeleteIdentityProviderRequest.builder().applyMutation(deleteIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     *
     * @param deleteResourceServerRequest
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            DeleteResourceServerRequest deleteResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceServerRequest#builder()}
     * </p>
     *
     * @param deleteResourceServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            Consumer<DeleteResourceServerRequest.Builder> deleteResourceServerRequest) {
        return deleteResourceServer(DeleteResourceServerRequest.builder().applyMutation(deleteResourceServerRequest).build());
    }

    /**
     * <p>
     * Allows a user to delete their own user profile.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a user to delete their own user profile.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest.Builder} to create
     *        a request. Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            DeleteUserAttributesRequest deleteUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserAttributesRequest#builder()}
     * </p>
     *
     * @param deleteUserAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest.Builder}
     *        to create a request. Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            Consumer<DeleteUserAttributesRequest.Builder> deleteUserAttributesRequest) {
        return deleteUserAttributes(DeleteUserAttributesRequest.builder().applyMutation(deleteUserAttributesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolResponse> deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserPoolRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest.Builder} to
     *        create a request. Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolResponse> deleteUserPool(Consumer<DeleteUserPoolRequest.Builder> deleteUserPoolRequest) {
        return deleteUserPool(DeleteUserPoolRequest.builder().applyMutation(deleteUserPoolRequest).build());
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            DeleteUserPoolClientRequest deleteUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolClientRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest.Builder}
     *        to create a request. Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            Consumer<DeleteUserPoolClientRequest.Builder> deleteUserPoolClientRequest) {
        return deleteUserPoolClient(DeleteUserPoolClientRequest.builder().applyMutation(deleteUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            Consumer<DeleteUserPoolDomainRequest.Builder> deleteUserPoolDomainRequest) {
        return deleteUserPoolDomain(DeleteUserPoolDomainRequest.builder().applyMutation(deleteUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific IdP.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific IdP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeIdentityProviderRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            Consumer<DescribeIdentityProviderRequest.Builder> describeIdentityProviderRequest) {
        return describeIdentityProvider(DescribeIdentityProviderRequest.builder().applyMutation(describeIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            DescribeResourceServerRequest describeResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceServerRequest#builder()}
     * </p>
     *
     * @param describeResourceServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            Consumer<DescribeResourceServerRequest.Builder> describeResourceServerRequest) {
        return describeResourceServer(DescribeResourceServerRequest.builder().applyMutation(describeResourceServerRequest)
                .build());
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     *
     * @param describeRiskConfigurationRequest
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            DescribeRiskConfigurationRequest describeRiskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRiskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            Consumer<DescribeRiskConfigurationRequest.Builder> describeRiskConfigurationRequest) {
        return describeRiskConfiguration(DescribeRiskConfigurationRequest.builder()
                .applyMutation(describeRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            DescribeUserImportJobRequest describeUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserImportJobRequest#builder()}
     * </p>
     *
     * @param describeUserImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest.Builder}
     *        to create a request. Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            Consumer<DescribeUserImportJobRequest.Builder> describeUserImportJobRequest) {
        return describeUserImportJob(DescribeUserImportJobRequest.builder().applyMutation(describeUserImportJobRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolResponse> describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeUserPoolRequest#builder()}
     * </p>
     *
     * @param describeUserPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest.Builder} to
     *        create a request. Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolResponse> describeUserPool(
            Consumer<DescribeUserPoolRequest.Builder> describeUserPoolRequest) {
        return describeUserPool(DescribeUserPoolRequest.builder().applyMutation(describeUserPoolRequest).build());
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            DescribeUserPoolClientRequest describeUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolClientRequest#builder()}
     * </p>
     *
     * @param describeUserPoolClientRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest.Builder}
     *        to create a request. Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            Consumer<DescribeUserPoolClientRequest.Builder> describeUserPoolClientRequest) {
        return describeUserPoolClient(DescribeUserPoolClientRequest.builder().applyMutation(describeUserPoolClientRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     *
     * @param describeUserPoolDomainRequest
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            DescribeUserPoolDomainRequest describeUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param describeUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            Consumer<DescribeUserPoolDomainRequest.Builder> describeUserPoolDomainRequest) {
        return describeUserPoolDomain(DescribeUserPoolDomainRequest.builder().applyMutation(describeUserPoolDomainRequest)
                .build());
    }

    /**
     * <p>
     * Forgets the specified device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgetDeviceResponse> forgetDevice(ForgetDeviceRequest forgetDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets the specified device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link ForgetDeviceRequest#builder()}
     * </p>
     *
     * @param forgetDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest.Builder} to
     *        create a request. Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ForgetDeviceResponse> forgetDevice(Consumer<ForgetDeviceRequest.Builder> forgetDeviceRequest) {
        return forgetDevice(ForgetDeviceRequest.builder().applyMutation(forgetDeviceRequest).build());
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method
     * used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering
     * User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. To use the confirmation code for resetting the
     * password, call <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html"
     * >ConfirmForgotPassword</a>.
     * </p>
     * <p>
     * If neither a verified phone number nor a verified email exists, this API returns
     * <code>InvalidParameterException</code>. If your app client has a client secret and you don't provide a
     * <code>SECRET_HASH</code> parameter, this API returns <code>NotAuthorizedException</code>.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ForgotPasswordResponse> forgotPassword(ForgotPasswordRequest forgotPasswordRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method
     * used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering
     * User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. To use the confirmation code for resetting the
     * password, call <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html"
     * >ConfirmForgotPassword</a>.
     * </p>
     * <p>
     * If neither a verified phone number nor a verified email exists, this API returns
     * <code>InvalidParameterException</code>. If your app client has a client secret and you don't provide a
     * <code>SECRET_HASH</code> parameter, this API returns <code>NotAuthorizedException</code>.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgotPasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ForgotPasswordRequest#builder()}
     * </p>
     *
     * @param forgotPasswordRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest.Builder} to
     *        create a request. Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ForgotPasswordResponse> forgotPassword(Consumer<ForgotPasswordRequest.Builder> forgotPasswordRequest) {
        return forgotPassword(ForgotPasswordRequest.builder().applyMutation(forgotPasswordRequest).build());
    }

    /**
     * <p>
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     * </p>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information of the CSV file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCsvHeaderResponse> getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCsvHeaderRequest.Builder} avoiding the need to
     * create one manually via {@link GetCsvHeaderRequest#builder()}
     * </p>
     *
     * @param getCsvHeaderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest.Builder} to
     *        create a request. Represents the request to get the header information of the CSV file for the user import
     *        job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCsvHeaderResponse> getCSVHeader(Consumer<GetCsvHeaderRequest.Builder> getCsvHeaderRequest) {
        return getCSVHeader(GetCsvHeaderRequest.builder().applyMutation(getCsvHeaderRequest).build());
    }

    /**
     * <p>
     * Gets the device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest.Builder} to create a
     *        request. Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Gets the specified IdP.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified IdP.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityProviderByIdentifierRequest.Builder}
     * avoiding the need to create one manually via {@link GetIdentityProviderByIdentifierRequest#builder()}
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            Consumer<GetIdentityProviderByIdentifierRequest.Builder> getIdentityProviderByIdentifierRequest) {
        return getIdentityProviderByIdentifier(GetIdentityProviderByIdentifierRequest.builder()
                .applyMutation(getIdentityProviderByIdentifierRequest).build());
    }

    /**
     * <p>
     * Gets the detailed activity logging configuration for a user pool.
     * </p>
     *
     * @param getLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the GetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLogDeliveryConfigurationResponse> getLogDeliveryConfiguration(
            GetLogDeliveryConfigurationRequest getLogDeliveryConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the detailed activity logging configuration for a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLogDeliveryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetLogDeliveryConfigurationRequest#builder()}
     * </p>
     *
     * @param getLogDeliveryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetLogDeliveryConfigurationResponse> getLogDeliveryConfiguration(
            Consumer<GetLogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurationRequest) {
        return getLogDeliveryConfiguration(GetLogDeliveryConfigurationRequest.builder()
                .applyMutation(getLogDeliveryConfigurationRequest).build());
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10
     * years from the date of issue.
     * </p>
     * <p>
     * Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the
     * response to <code>GetSigningCertificate</code>, but doesn't invalidate the original certificate.
     * </p>
     *
     * @param getSigningCertificateRequest
     *        Request to get a signing certificate from Amazon Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            GetSigningCertificateRequest getSigningCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10
     * years from the date of issue.
     * </p>
     * <p>
     * Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the
     * response to <code>GetSigningCertificate</code>, but doesn't invalidate the original certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSigningCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSigningCertificateRequest#builder()}
     * </p>
     *
     * @param getSigningCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest.Builder}
     *        to create a request. Request to get a signing certificate from Amazon Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            Consumer<GetSigningCertificateRequest.Builder> getSigningCertificateRequest) {
        return getSigningCertificate(GetSigningCertificateRequest.builder().applyMutation(getSigningCertificateRequest).build());
    }

    /**
     * <p>
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such
     * information exists for the client. If nothing is set for the particular client, but there is an existing pool
     * level customization (the app <code>clientId</code> is <code>ALL</code>), then that information is returned. If
     * nothing is present, then an empty shape is returned.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUiCustomizationResponse> getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such
     * information exists for the client. If nothing is set for the particular client, but there is an existing pool
     * level customization (the app <code>clientId</code> is <code>ALL</code>), then that information is returned. If
     * nothing is present, then an empty shape is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link GetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param getUiCustomizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUiCustomizationResponse> getUICustomization(
            Consumer<GetUiCustomizationRequest.Builder> getUiCustomizationRequest) {
        return getUICustomization(GetUiCustomizationRequest.builder().applyMutation(getUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest.Builder} to create a
     *        request. Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(Consumer<GetUserRequest.Builder> getUserRequest) {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a
     * code that they must return in a VerifyUserAttribute request.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a
     * code that they must return in a VerifyUserAttribute request.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserAttributeVerificationCodeRequest.Builder}
     * avoiding the need to create one manually via {@link GetUserAttributeVerificationCodeRequest#builder()}
     * </p>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest.Builder}
     *        to create a request. Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            Consumer<GetUserAttributeVerificationCodeRequest.Builder> getUserAttributeVerificationCodeRequest) {
        return getUserAttributeVerificationCode(GetUserAttributeVerificationCodeRequest.builder()
                .applyMutation(getUserAttributeVerificationCodeRequest).build());
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            Consumer<GetUserPoolMfaConfigRequest.Builder> getUserPoolMfaConfigRequest) {
        return getUserPoolMfaConfig(GetUserPoolMfaConfigRequest.builder().applyMutation(getUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * when your user signs out of your app. This results in the following behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GlobalSignOutResponse> globalSignOut(GlobalSignOutRequest globalSignOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * when your user signs out of your app. This results in the following behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GlobalSignOutRequest.Builder} avoiding the need to
     * create one manually via {@link GlobalSignOutRequest#builder()}
     * </p>
     *
     * @param globalSignOutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest.Builder} to
     *        create a request. Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GlobalSignOutResponse> globalSignOut(Consumer<GlobalSignOutRequest.Builder> globalSignOutRequest) {
        return globalSignOut(GlobalSignOutRequest.builder().applyMutation(globalSignOutRequest).build());
    }

    /**
     * <p>
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP
     * with <code>InitiateAuth</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html">
     * Adding user pool sign-in through a third party</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateAuthResponse> initiateAuth(InitiateAuthRequest initiateAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP
     * with <code>InitiateAuth</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html">
     * Adding user pool sign-in through a third party</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateAuthRequest.Builder} avoiding the need to
     * create one manually via {@link InitiateAuthRequest#builder()}
     * </p>
     *
     * @param initiateAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest.Builder} to
     *        create a request. Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateAuthResponse> initiateAuth(Consumer<InitiateAuthRequest.Builder> initiateAuthRequest) {
        return initiateAuth(InitiateAuthRequest.builder().applyMutation(initiateAuthRequest).build());
    }

    /**
     * <p>
     * Lists the sign-in devices that Amazon Cognito has registered to the current user. For more information about
     * device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the sign-in devices that Amazon Cognito has registered to the current user. For more information about
     * device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest.Builder} to create
     *        a request. Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists information about all IdPs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about all IdPs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        return new ListIdentityProvidersPublisher(this, listIdentityProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listResourceServersRequest
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceServersResponse> listResourceServers(
            ListResourceServersRequest listResourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceServersRequest#builder()}
     * </p>
     *
     * @param listResourceServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceServersResponse> listResourceServers(
            Consumer<ListResourceServersRequest.Builder> listResourceServersRequest) {
        return listResourceServers(ListResourceServersRequest.builder().applyMutation(listResourceServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersPublisher publisher = client.listResourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersPublisher publisher = client.listResourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersPublisher listResourceServersPaginator(ListResourceServersRequest listResourceServersRequest) {
        return new ListResourceServersPublisher(this, listResourceServersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersPublisher publisher = client.listResourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListResourceServersPublisher publisher = client.listResourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceServers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceServersRequest#builder()}
     * </p>
     *
     * @param listResourceServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceServersPublisher listResourceServersPaginator(
            Consumer<ListResourceServersRequest.Builder> listResourceServersRequest) {
        return listResourceServersPaginator(ListResourceServersRequest.builder().applyMutation(listResourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists user import jobs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists user import jobs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserImportJobsRequest#builder()}
     * </p>
     *
     * @param listUserImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest.Builder} to
     *        create a request. Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(
            Consumer<ListUserImportJobsRequest.Builder> listUserImportJobsRequest) {
        return listUserImportJobs(ListUserImportJobsRequest.builder().applyMutation(listUserImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            ListUserPoolClientsRequest listUserPoolClientsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolClientsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserPoolClientsRequest#builder()}
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest.Builder}
     *        to create a request. Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            Consumer<ListUserPoolClientsRequest.Builder> listUserPoolClientsRequest) {
        return listUserPoolClients(ListUserPoolClientsRequest.builder().applyMutation(listUserPoolClientsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsPublisher publisher = client.listUserPoolClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsPublisher publisher = client.listUserPoolClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsPublisher listUserPoolClientsPaginator(ListUserPoolClientsRequest listUserPoolClientsRequest) {
        return new ListUserPoolClientsPublisher(this, listUserPoolClientsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsPublisher publisher = client.listUserPoolClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolClientsPublisher publisher = client.listUserPoolClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPoolClients(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolClientsRequest.Builder} avoiding the
     * need to create one manually via {@link ListUserPoolClientsRequest#builder()}
     * </p>
     *
     * @param listUserPoolClientsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest.Builder}
     *        to create a request. Represents the request to list the user pool clients.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserPoolClientsPublisher listUserPoolClientsPaginator(
            Consumer<ListUserPoolClientsRequest.Builder> listUserPoolClientsRequest) {
        return listUserPoolClientsPaginator(ListUserPoolClientsRequest.builder().applyMutation(listUserPoolClientsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the user pools associated with an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserPoolsResponse> listUserPools(ListUserPoolsRequest listUserPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the user pools associated with an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserPoolsRequest#builder()}
     * </p>
     *
     * @param listUserPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest.Builder} to
     *        create a request. Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserPoolsResponse> listUserPools(Consumer<ListUserPoolsRequest.Builder> listUserPoolsRequest) {
        return listUserPools(ListUserPoolsRequest.builder().applyMutation(listUserPoolsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsPublisher publisher = client.listUserPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsPublisher publisher = client.listUserPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsPublisher listUserPoolsPaginator(ListUserPoolsRequest listUserPoolsRequest) {
        return new ListUserPoolsPublisher(this, listUserPoolsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsPublisher publisher = client.listUserPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUserPoolsPublisher publisher = client.listUserPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPools(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserPoolsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserPoolsRequest#builder()}
     * </p>
     *
     * @param listUserPoolsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest.Builder} to
     *        create a request. Represents the request to list user pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUserPoolsPublisher listUserPoolsPaginator(Consumer<ListUserPoolsRequest.Builder> listUserPoolsRequest) {
        return listUserPoolsPaginator(ListUserPoolsRequest.builder().applyMutation(listUserPoolsRequest).build());
    }

    /**
     * <p>
     * Lists users and their basic details in a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists users and their basic details in a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest.Builder} to create a
     *        request. Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersInGroupRequest
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersInGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsersInGroupRequest#builder()}
     * </p>
     *
     * @param listUsersInGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(
            Consumer<ListUsersInGroupRequest.Builder> listUsersInGroupRequest) {
        return listUsersInGroup(ListUsersInGroupRequest.builder().applyMutation(listUsersInGroupRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupPublisher publisher = client.listUsersInGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupPublisher publisher = client.listUsersInGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUsersInGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupPublisher listUsersInGroupPaginator(ListUsersInGroupRequest listUsersInGroupRequest) {
        return new ListUsersInGroupPublisher(this, listUsersInGroupRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupPublisher publisher = client.listUsersInGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersInGroupPublisher publisher = client.listUsersInGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsersInGroup(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersInGroupRequest.Builder} avoiding the need
     * to create one manually via {@link ListUsersInGroupRequest#builder()}
     * </p>
     *
     * @param listUsersInGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ListUsersInGroupPublisher listUsersInGroupPaginator(Consumer<ListUsersInGroupRequest.Builder> listUsersInGroupRequest) {
        return listUsersInGroupPaginator(ListUsersInGroupRequest.builder().applyMutation(listUsersInGroupRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, listUsersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cognitoidentityprovider.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest.Builder} to create a
     *        request. Represents the request to list users.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResendConfirmationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link ResendConfirmationCodeRequest#builder()}
     * </p>
     *
     * @param resendConfirmationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest.Builder}
     *        to create a request. Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            Consumer<ResendConfirmationCodeRequest.Builder> resendConfirmationCodeRequest) {
        return resendConfirmationCode(ResendConfirmationCodeRequest.builder().applyMutation(resendConfirmationCodeRequest)
                .build());
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. A <code>RespondToAuthChallenge</code> API request
     * provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. A <code>RespondToAuthChallenge</code> API request
     * provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RespondToAuthChallengeRequest.Builder} avoiding the
     * need to create one manually via {@link RespondToAuthChallengeRequest#builder()}
     * </p>
     *
     * @param respondToAuthChallengeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest.Builder}
     *        to create a request. The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            Consumer<RespondToAuthChallengeRequest.Builder> respondToAuthChallengeRequest) {
        return respondToAuthChallenge(RespondToAuthChallengeRequest.builder().applyMutation(respondToAuthChallengeRequest)
                .build());
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a
     * token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to
     * your resource server.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param revokeTokenRequest
     * @return A Java Future containing the result of the RevokeToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnauthorizedException Exception that is thrown when the request isn't authorized. This can happen due
     *         to an invalid access token in the request.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>UnsupportedTokenTypeException Exception that is thrown when an unsupported token is passed to an
     *         operation.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RevokeTokenResponse> revokeToken(RevokeTokenRequest revokeTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a
     * token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to
     * your resource server.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeTokenRequest.Builder} avoiding the need to
     * create one manually via {@link RevokeTokenRequest#builder()}
     * </p>
     *
     * @param revokeTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RevokeToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnauthorizedException Exception that is thrown when the request isn't authorized. This can happen due
     *         to an invalid access token in the request.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>UnsupportedTokenTypeException Exception that is thrown when an unsupported token is passed to an
     *         operation.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RevokeTokenResponse> revokeToken(Consumer<RevokeTokenRequest.Builder> revokeTokenRequest) {
        return revokeToken(RevokeTokenRequest.builder().applyMutation(revokeTokenRequest).build());
    }

    /**
     * <p>
     * Sets up or modifies the detailed activity logging configuration of a user pool.
     * </p>
     *
     * @param setLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the SetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetLogDeliveryConfigurationResponse> setLogDeliveryConfiguration(
            SetLogDeliveryConfigurationRequest setLogDeliveryConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets up or modifies the detailed activity logging configuration of a user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetLogDeliveryConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link SetLogDeliveryConfigurationRequest#builder()}
     * </p>
     *
     * @param setLogDeliveryConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetLogDeliveryConfigurationResponse> setLogDeliveryConfiguration(
            Consumer<SetLogDeliveryConfigurationRequest.Builder> setLogDeliveryConfigurationRequest) {
        return setLogDeliveryConfiguration(SetLogDeliveryConfigurationRequest.builder()
                .applyMutation(setLogDeliveryConfigurationRequest).build());
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To activate Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     *
     * @param setRiskConfigurationRequest
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            SetRiskConfigurationRequest setRiskConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To activate Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRiskConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link SetRiskConfigurationRequest#builder()}
     * </p>
     *
     * @param setRiskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            Consumer<SetRiskConfigurationRequest.Builder> setRiskConfigurationRequest) {
        return setRiskConfiguration(SetRiskConfigurationRequest.builder().applyMutation(setRiskConfigurationRequest).build());
    }

    /**
     * <p>
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration is used for every client that has no previously set UI customization. If you specify UI
     * customization settings for a particular client, it will no longer return to the <code>ALL</code> configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUiCustomizationResponse> setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration is used for every client that has no previously set UI customization. If you specify UI
     * customization settings for a particular client, it will no longer return to the <code>ALL</code> configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUiCustomizationRequest.Builder} avoiding the
     * need to create one manually via {@link SetUiCustomizationRequest#builder()}
     * </p>
     *
     * @param setUiCustomizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUiCustomizationResponse> setUICustomization(
            Consumer<SetUiCustomizationRequest.Builder> setUiCustomizationRequest) {
        return setUICustomization(SetUiCustomizationRequest.builder().applyMutation(setUiCustomizationRequest).build());
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are activated. If multiple options are activated and no preference is
     * set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user,
     * the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device
     * has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts,
     * deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserMfaPreferenceRequest
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            SetUserMfaPreferenceRequest setUserMfaPreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are activated. If multiple options are activated and no preference is
     * set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user,
     * the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device
     * has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts,
     * deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserMfaPreferenceRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserMfaPreferenceRequest#builder()}
     * </p>
     *
     * @param setUserMfaPreferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            Consumer<SetUserMfaPreferenceRequest.Builder> setUserMfaPreferenceRequest) {
        return setUserMFAPreference(SetUserMfaPreferenceRequest.builder().applyMutation(setUserMfaPreferenceRequest).build());
    }

    /**
     * <p>
     * Sets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param setUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserPoolMfaConfigRequest.Builder} avoiding the
     * need to create one manually via {@link SetUserPoolMfaConfigRequest#builder()}
     * </p>
     *
     * @param setUserPoolMfaConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            Consumer<SetUserPoolMfaConfigRequest.Builder> setUserPoolMfaConfigRequest) {
        return setUserPoolMfaConfig(SetUserPoolMfaConfigRequest.builder().applyMutation(setUserPoolMfaConfigRequest).build());
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html"
     * >SetUserMFAPreference</a> instead.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUserSettingsResponse> setUserSettings(SetUserSettingsRequest setUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html"
     * >SetUserMFAPreference</a> instead.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link SetUserSettingsRequest#builder()}
     * </p>
     *
     * @param setUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest.Builder} to
     *        create a request. Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetUserSettingsResponse> setUserSettings(
            Consumer<SetUserSettingsRequest.Builder> setUserSettingsRequest) {
        return setUserSettings(SetUserSettingsRequest.builder().applyMutation(setUserSettingsRequest).build());
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SignUpResponse> signUp(SignUpRequest signUpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignUpRequest.Builder} avoiding the need to create
     * one manually via {@link SignUpRequest#builder()}
     * </p>
     *
     * @param signUpRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest.Builder} to create a
     *        request. Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SignUpResponse> signUp(Consumer<SignUpRequest.Builder> signUpRequest) {
        return signUp(SignUpRequest.builder().applyMutation(signUpRequest).build());
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUserImportJobResponse> startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUserImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartUserImportJobRequest#builder()}
     * </p>
     *
     * @param startUserImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest.Builder} to
     *        create a request. Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartUserImportJobResponse> startUserImportJob(
            Consumer<StartUserImportJobRequest.Builder> startUserImportJobRequest) {
        return startUserImportJob(StartUserImportJobRequest.builder().applyMutation(startUserImportJobRequest).build());
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopUserImportJobResponse> stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopUserImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopUserImportJobRequest#builder()}
     * </p>
     *
     * @param stopUserImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest.Builder} to
     *        create a request. Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopUserImportJobResponse> stopUserImportJob(
            Consumer<StopUserImportJobRequest.Builder> stopUserImportJobRequest) {
        return stopUserImportJob(StopUserImportJobRequest.builder().applyMutation(stopUserImportJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool, and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an
     * Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag
     * values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool, and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an
     * Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag
     * values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthEventFeedbackRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAuthEventFeedbackRequest#builder()}
     * </p>
     *
     * @param updateAuthEventFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            Consumer<UpdateAuthEventFeedbackRequest.Builder> updateAuthEventFeedbackRequest) {
        return updateAuthEventFeedback(UpdateAuthEventFeedbackRequest.builder().applyMutation(updateAuthEventFeedbackRequest)
                .build());
    }

    /**
     * <p>
     * Updates the device status. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device status. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDeviceStatusRequest#builder()}
     * </p>
     *
     * @param updateDeviceStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest.Builder} to
     *        create a request. Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(
            Consumer<UpdateDeviceStatusRequest.Builder> updateDeviceStatusRequest) {
        return updateDeviceStatus(UpdateDeviceStatusRequest.builder().applyMutation(updateDeviceStatusRequest).build());
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates IdP information for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates IdP information for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            Consumer<UpdateIdentityProviderRequest.Builder> updateIdentityProviderRequest) {
        return updateIdentityProvider(UpdateIdentityProviderRequest.builder().applyMutation(updateIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it is set to the default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateResourceServerRequest
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            UpdateResourceServerRequest updateResourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it is set to the default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceServerRequest#builder()}
     * </p>
     *
     * @param updateResourceServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            Consumer<UpdateResourceServerRequest.Builder> updateResourceServerRequest) {
        return updateResourceServer(UpdateResourceServerRequest.builder().applyMutation(updateResourceServerRequest).build());
    }

    /**
     * <p>
     * With this operation, your users can update one or more of their attributes with their own credentials. You
     * authorize this API request with the user's access token. To delete an attribute from your user, submit the
     * attribute in your API request with a blank value. Custom attribute values in this request must include the
     * <code>custom:</code> prefix.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            UpdateUserAttributesRequest updateUserAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * With this operation, your users can update one or more of their attributes with their own credentials. You
     * authorize this API request with the user's access token. To delete an attribute from your user, submit the
     * attribute in your API request with a blank value. Custom attribute values in this request must include the
     * <code>custom:</code> prefix.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserAttributesRequest#builder()}
     * </p>
     *
     * @param updateUserAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest.Builder}
     *        to create a request. Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            Consumer<UpdateUserAttributesRequest.Builder> updateUserAttributesRequest) {
        return updateUserAttributes(UpdateUserAttributesRequest.builder().applyMutation(updateUserAttributesRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool
     * settings using <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolResponse> updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool
     * settings using <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserPoolRequest#builder()}
     * </p>
     *
     * @param updateUserPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest.Builder} to
     *        create a request. Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolResponse> updateUserPool(Consumer<UpdateUserPoolRequest.Builder> updateUserPoolRequest) {
        return updateUserPool(UpdateUserPoolRequest.builder().applyMutation(updateUserPoolRequest).build());
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user
     * pool app client settings using <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html"
     * >DescribeUserPoolClient</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important>
     * <p>
     * You can also use this operation to enable token revocation for user pool clients. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user
     * pool app client settings using <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html"
     * >DescribeUserPoolClient</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important>
     * <p>
     * You can also use this operation to enable token revocation for user pool clients. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolClientRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolClientRequest#builder()}
     * </p>
     *
     * @param updateUserPoolClientRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest.Builder}
     *        to create a request. Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            Consumer<UpdateUserPoolClientRequest.Builder> updateUserPoolClientRequest) {
        return updateUserPoolClient(UpdateUserPoolClientRequest.builder().applyMutation(updateUserPoolClientRequest).build());
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * can't use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager
     * (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom
     * domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services
     * Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolDomainRequest
     *        The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            UpdateUserPoolDomainRequest updateUserPoolDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * can't use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager
     * (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom
     * domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services
     * Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserPoolDomainRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserPoolDomainRequest#builder()}
     * </p>
     *
     * @param updateUserPoolDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest.Builder}
     *        to create a request. The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            Consumer<UpdateUserPoolDomainRequest.Builder> updateUserPoolDomainRequest) {
        return updateUserPoolDomain(UpdateUserPoolDomainRequest.builder().applyMutation(updateUserPoolDomainRequest).build());
    }

    /**
     * <p>
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software
     * token MFA status as "verified" if successful. The request takes an access token or a session string, but not
     * both.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifySoftwareTokenRequest
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            VerifySoftwareTokenRequest verifySoftwareTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software
     * token MFA status as "verified" if successful. The request takes an access token or a session string, but not
     * both.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifySoftwareTokenRequest.Builder} avoiding the
     * need to create one manually via {@link VerifySoftwareTokenRequest#builder()}
     * </p>
     *
     * @param verifySoftwareTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            Consumer<VerifySoftwareTokenRequest.Builder> verifySoftwareTokenRequest) {
        return verifySoftwareToken(VerifySoftwareTokenRequest.builder().applyMutation(verifySoftwareTokenRequest).build());
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     * <p>
     * If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute
     * updates the affected attribute to its pending value. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html"
     * > UserAttributeUpdateSettingsType</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            VerifyUserAttributeRequest verifyUserAttributeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     * <p>
     * If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute
     * updates the affected attribute to its pending value. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html"
     * > UserAttributeUpdateSettingsType</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifyUserAttributeRequest.Builder} avoiding the
     * need to create one manually via {@link VerifyUserAttributeRequest#builder()}
     * </p>
     *
     * @param verifyUserAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest.Builder}
     *        to create a request. Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            Consumer<VerifyUserAttributeRequest.Builder> verifyUserAttributeRequest) {
        return verifyUserAttribute(VerifyUserAttributeRequest.builder().applyMutation(verifyUserAttributeRequest).build());
    }

    @Override
    default CognitoIdentityProviderServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CognitoIdentityProviderAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CognitoIdentityProviderAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CognitoIdentityProviderAsyncClient}.
     */
    static CognitoIdentityProviderAsyncClientBuilder builder() {
        return new DefaultCognitoIdentityProviderAsyncClientBuilder();
    }
}
