/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.CognitoIdentityProviderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminAddUserToGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminDisableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminEnableUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminLinkProviderForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListGroupsForUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRemoveUserFromGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminResetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminSetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminUserGlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AssociateSoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChangePasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeMismatchException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmSignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeleteUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DuplicateProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EnableSoftwareTokenMfaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExpiredCodeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForbiddenException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ForgotPasswordResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetCsvHeaderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetDeviceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetIdentityProviderByIdentifierResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetSigningCertificateResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GetUserResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GroupExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InitiateAuthResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidEmailRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidLambdaResponseException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidOAuthFlowException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidPasswordException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleAccessPolicyException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidSmsRoleTrustRelationshipException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListDevicesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListGroupsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserImportJobsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MfaMethodNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordHistoryPolicyViolationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.PreconditionNotMetException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResendConfirmationCodeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.RevokeTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeDoesNotExistException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetLogDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetRiskConfigurationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUiCustomizationResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserMfaPreferenceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserPoolMfaConfigResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SetUserSettingsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SignUpResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StartUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StopUserImportJobResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnauthorizedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnexpectedLambdaException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedIdentityProviderException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedTokenTypeException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UnsupportedUserStateException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateAuthEventFeedbackResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateDeviceStatusResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserAttributesResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolDomainResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportInProgressException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserLambdaValidationException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotConfirmedException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserNotFoundException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnNotEnabledException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTaggingException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameExistsException;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifySoftwareTokenResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifyUserAttributeResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AddCustomAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminAddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminCreateUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminDisableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminEnableUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminInitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminLinkProviderForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminListUserAuthEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminRespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminSetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminUserGlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AssociateSoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ConfirmSignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.CreateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ForgotPasswordRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetCsvHeaderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetIdentityProviderByIdentifierRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserAttributeVerificationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.GlobalSignOutRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.InitiateAuthRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListResourceServersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserImportJobsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolClientsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUserPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersInGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ResendConfirmationCodeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RespondToAuthChallengeRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.RevokeTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetLogDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetRiskConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUiCustomizationRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserMfaPreferenceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserPoolMfaConfigRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SignUpRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StartUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StopUserImportJobRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateAuthEventFeedbackRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateDeviceStatusRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserAttributesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolClientRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolDomainRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateUserPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifySoftwareTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.VerifyUserAttributeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CognitoIdentityProviderAsyncClient}.
 *
 * @see CognitoIdentityProviderAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCognitoIdentityProviderAsyncClient implements CognitoIdentityProviderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoIdentityProviderAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityProviderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds additional user attributes to the user pool schema.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param addCustomAttributesRequest
     *        Represents the request to add custom attributes.
     * @return A Java Future containing the result of the AddCustomAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AddCustomAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AddCustomAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddCustomAttributesResponse> addCustomAttributes(
            AddCustomAttributesRequest addCustomAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addCustomAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCustomAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCustomAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddCustomAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddCustomAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddCustomAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddCustomAttributesRequest, AddCustomAttributesResponse>()
                            .withOperationName("AddCustomAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddCustomAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addCustomAttributesRequest));
            CompletableFuture<AddCustomAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a user to a group. A user who is in a group can present a preferred-role claim to an identity pool, and
     * populates a <code>cognito:groups</code> claim to their access and identity tokens.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminAddUserToGroupRequest
     * @return A Java Future containing the result of the AdminAddUserToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminAddUserToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminAddUserToGroupResponse> adminAddUserToGroup(
            AdminAddUserToGroupRequest adminAddUserToGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminAddUserToGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminAddUserToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminAddUserToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminAddUserToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminAddUserToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminAddUserToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminAddUserToGroupRequest, AdminAddUserToGroupResponse>()
                            .withOperationName("AdminAddUserToGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminAddUserToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminAddUserToGroupRequest));
            CompletableFuture<AdminAddUserToGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This IAM-authenticated API operation confirms user sign-up as an administrator. Unlike <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmSignUp.html"
     * >ConfirmSignUp</a>, your IAM credentials authorize user account confirmation. No confirmation code is required.
     * </p>
     * <p>
     * This request sets a user account active in a user pool that <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#signing-up-users-in-your-app-and-confirming-them-as-admin"
     * >requires confirmation of new user accounts</a> before they can sign in. You can configure your user pool to not
     * send confirmation codes to new users and instead confirm them with this API operation on the back end.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminConfirmSignUpRequest
     *        Confirm a user's registration as a user pool administrator.
     * @return A Java Future containing the result of the AdminConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminConfirmSignUp"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminConfirmSignUpResponse> adminConfirmSignUp(AdminConfirmSignUpRequest adminConfirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminConfirmSignUpRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminConfirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminConfirmSignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminConfirmSignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminConfirmSignUpRequest, AdminConfirmSignUpResponse>()
                            .withOperationName("AdminConfirmSignUp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminConfirmSignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminConfirmSignUpRequest));
            CompletableFuture<AdminConfirmSignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new user in the specified user pool.
     * </p>
     * <p>
     * If <code>MessageAction</code> isn't set, the default is to send a welcome message via email or phone (SMS).
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * This message is based on a template that you configured in your call to create or update a user pool. This
     * template includes your custom sign-up instructions and placeholders for user name and temporary password.
     * </p>
     * <p>
     * Alternatively, you can call <code>AdminCreateUser</code> with <code>SUPPRESS</code> for the
     * <code>MessageAction</code> parameter, and Amazon Cognito won't send any email.
     * </p>
     * <p>
     * In either case, the user will be in the <code>FORCE_CHANGE_PASSWORD</code> state until they sign in and change
     * their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminCreateUserRequest
     *        Represents the request to create a user in the specified user pool.
     * @return A Java Future containing the result of the AdminCreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnsupportedUserStateException The request failed because the user is in an unsupported state.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminCreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminCreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminCreateUserResponse> adminCreateUser(AdminCreateUserRequest adminCreateUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminCreateUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminCreateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminCreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminCreateUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminCreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminCreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminCreateUserRequest, AdminCreateUserResponse>()
                            .withOperationName("AdminCreateUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminCreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminCreateUserRequest));
            CompletableFuture<AdminCreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserRequest
     *        Represents the request to delete a user as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserResponse> adminDeleteUser(AdminDeleteUserRequest adminDeleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserRequest, AdminDeleteUserResponse>()
                            .withOperationName("AdminDeleteUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDeleteUserRequest));
            CompletableFuture<AdminDeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDeleteUserAttributesRequest
     *        Represents the request to delete user attributes as an administrator.
     * @return A Java Future containing the result of the AdminDeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDeleteUserAttributesResponse> adminDeleteUserAttributes(
            AdminDeleteUserAttributesRequest adminDeleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDeleteUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDeleteUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDeleteUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDeleteUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResponse>()
                            .withOperationName("AdminDeleteUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDeleteUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDeleteUserAttributesRequest));
            CompletableFuture<AdminDeleteUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the
     * user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use
     * their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user
     * and an existing user is removed. When the external user signs in again, and the user is no longer attached to the
     * previously linked <code>DestinationUser</code>, the user must create a new user account. See <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html"
     * >AdminLinkProviderForUser</a>.
     * </p>
     * <p>
     * The <code>ProviderName</code> must match the value specified when creating an IdP for the pool.
     * </p>
     * <p>
     * To deactivate a native username + password user, the <code>ProviderName</code> value must be <code>Cognito</code>
     * and the <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code>. The
     * <code>ProviderAttributeValue</code> must be the name that is used in the user pool for the user.
     * </p>
     * <p>
     * The <code>ProviderAttributeName</code> must always be <code>Cognito_Subject</code> for social IdPs. The
     * <code>ProviderAttributeValue</code> must always be the exact subject that was used when the user was originally
     * linked as a source user.
     * </p>
     * <p>
     * For de-linking a SAML identity, there are two scenarios. If the linked identity has not yet been used to sign in,
     * the <code>ProviderAttributeName</code> and <code>ProviderAttributeValue</code> must be the same values that were
     * used for the <code>SourceUser</code> when the identities were originally linked using
     * <code> AdminLinkProviderForUser</code> call. (If the linking was done with <code>ProviderAttributeName</code> set
     * to <code>Cognito_Subject</code>, the same applies here). However, if the user has already signed in, the
     * <code>ProviderAttributeName</code> must be <code>Cognito_Subject</code> and <code>ProviderAttributeValue</code>
     * must be the subject of the SAML assertion.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableProviderForUserRequest
     * @return A Java Future containing the result of the AdminDisableProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableProviderForUserResponse> adminDisableProviderForUser(
            AdminDisableProviderForUserRequest adminDisableProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDisableProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDisableProviderForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDisableProviderForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDisableProviderForUserRequest, AdminDisableProviderForUserResponse>()
                            .withOperationName("AdminDisableProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDisableProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDisableProviderForUserRequest));
            CompletableFuture<AdminDisableProviderForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still
     * appears in the responses to <code>GetUser</code> and <code>ListUsers</code> API requests.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminDisableUserRequest
     *        Represents the request to disable the user as an administrator.
     * @return A Java Future containing the result of the AdminDisableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminDisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminDisableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminDisableUserResponse> adminDisableUser(AdminDisableUserRequest adminDisableUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminDisableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminDisableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminDisableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminDisableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminDisableUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminDisableUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminDisableUserRequest, AdminDisableUserResponse>()
                            .withOperationName("AdminDisableUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminDisableUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminDisableUserRequest));
            CompletableFuture<AdminDisableUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the specified user as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminEnableUserRequest
     *        Represents the request that enables the user as an administrator.
     * @return A Java Future containing the result of the AdminEnableUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminEnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminEnableUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminEnableUserResponse> adminEnableUser(AdminEnableUserRequest adminEnableUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminEnableUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminEnableUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminEnableUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminEnableUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminEnableUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminEnableUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminEnableUserRequest, AdminEnableUserResponse>()
                            .withOperationName("AdminEnableUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminEnableUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminEnableUserRequest));
            CompletableFuture<AdminEnableUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminForgetDeviceRequest
     *        Sends the forgot device request, as an administrator.
     * @return A Java Future containing the result of the AdminForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminForgetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminForgetDeviceResponse> adminForgetDevice(AdminForgetDeviceRequest adminForgetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminForgetDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminForgetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminForgetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminForgetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminForgetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminForgetDeviceRequest, AdminForgetDeviceResponse>()
                            .withOperationName("AdminForgetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminForgetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminForgetDeviceRequest));
            CompletableFuture<AdminForgetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the device, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetDeviceRequest
     *        Represents the request to get the device, as an administrator.
     * @return A Java Future containing the result of the AdminGetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetDeviceResponse> adminGetDevice(AdminGetDeviceRequest adminGetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminGetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminGetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminGetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminGetDeviceRequest, AdminGetDeviceResponse>()
                            .withOperationName("AdminGetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminGetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminGetDeviceRequest));
            CompletableFuture<AdminGetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminGetUserRequest
     *        Represents the request to get the specified user as an administrator.
     * @return A Java Future containing the result of the AdminGetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminGetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminGetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdminGetUserResponse> adminGetUser(AdminGetUserRequest adminGetUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminGetUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminGetUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminGetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminGetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AdminGetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminGetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminGetUserRequest, AdminGetUserResponse>()
                            .withOperationName("AdminGetUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminGetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminGetUserRequest));
            CompletableFuture<AdminGetUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the authentication flow, as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminInitiateAuthRequest
     *        Initiates the authorization request, as an administrator.
     * @return A Java Future containing the result of the AdminInitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminInitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminInitiateAuth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminInitiateAuthResponse> adminInitiateAuth(AdminInitiateAuthRequest adminInitiateAuthRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminInitiateAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminInitiateAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminInitiateAuth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminInitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminInitiateAuthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminInitiateAuthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminInitiateAuthRequest, AdminInitiateAuthResponse>()
                            .withOperationName("AdminInitiateAuth").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminInitiateAuthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminInitiateAuthRequest));
            CompletableFuture<AdminInitiateAuthResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Links an existing user account in a user pool (<code>DestinationUser</code>) to an identity from an external IdP
     * (<code>SourceUser</code>) based on a specified attribute name and value from the external IdP. This allows you to
     * create a link from the existing user account to an external federated user identity that has not yet been used to
     * sign in. You can then use the federated user identity to sign in as the existing user account.
     * </p>
     * <p>
     * For example, if there is an existing user with a username and password, this API links that user to a federated
     * user identity. When the user signs in with a federated user identity, they sign in as the existing user account.
     * </p>
     * <note>
     * <p>
     * The maximum number of federated identities linked to a user is five.
     * </p>
     * </note> <important>
     * <p>
     * Because this API allows a user with an external federated identity to sign in as an existing user in the user
     * pool, it is critical that it only be used with external IdPs and provider attributes that have been trusted by
     * the application owner.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminLinkProviderForUserRequest
     * @return A Java Future containing the result of the AdminLinkProviderForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminLinkProviderForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminLinkProviderForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminLinkProviderForUserResponse> adminLinkProviderForUser(
            AdminLinkProviderForUserRequest adminLinkProviderForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminLinkProviderForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminLinkProviderForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminLinkProviderForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminLinkProviderForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminLinkProviderForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminLinkProviderForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminLinkProviderForUserRequest, AdminLinkProviderForUserResponse>()
                            .withOperationName("AdminLinkProviderForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminLinkProviderForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminLinkProviderForUserRequest));
            CompletableFuture<AdminLinkProviderForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists devices, as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListDevicesRequest
     *        Represents the request to list devices, as an administrator.
     * @return A Java Future containing the result of the AdminListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListDevicesResponse> adminListDevices(AdminListDevicesRequest adminListDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListDevicesRequest, AdminListDevicesResponse>()
                            .withOperationName("AdminListDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListDevicesRequest));
            CompletableFuture<AdminListDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the groups that a user belongs to.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListGroupsForUserRequest
     * @return A Java Future containing the result of the AdminListGroupsForUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListGroupsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListGroupsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListGroupsForUserResponse> adminListGroupsForUser(
            AdminListGroupsForUserRequest adminListGroupsForUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListGroupsForUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListGroupsForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListGroupsForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListGroupsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListGroupsForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListGroupsForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListGroupsForUserRequest, AdminListGroupsForUserResponse>()
                            .withOperationName("AdminListGroupsForUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListGroupsForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListGroupsForUserRequest));
            CompletableFuture<AdminListGroupsForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A history of user activity and any risks detected as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminListUserAuthEventsRequest
     * @return A Java Future containing the result of the AdminListUserAuthEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminListUserAuthEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListUserAuthEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminListUserAuthEventsResponse> adminListUserAuthEvents(
            AdminListUserAuthEventsRequest adminListUserAuthEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminListUserAuthEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminListUserAuthEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminListUserAuthEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminListUserAuthEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminListUserAuthEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminListUserAuthEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminListUserAuthEventsRequest, AdminListUserAuthEventsResponse>()
                            .withOperationName("AdminListUserAuthEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminListUserAuthEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminListUserAuthEventsRequest));
            CompletableFuture<AdminListUserAuthEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRemoveUserFromGroupRequest
     * @return A Java Future containing the result of the AdminRemoveUserFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRemoveUserFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRemoveUserFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRemoveUserFromGroupResponse> adminRemoveUserFromGroup(
            AdminRemoveUserFromGroupRequest adminRemoveUserFromGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRemoveUserFromGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRemoveUserFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRemoveUserFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminRemoveUserFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminRemoveUserFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminRemoveUserFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminRemoveUserFromGroupRequest, AdminRemoveUserFromGroupResponse>()
                            .withOperationName("AdminRemoveUserFromGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminRemoveUserFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminRemoveUserFromGroupRequest));
            CompletableFuture<AdminRemoveUserFromGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Deactivates a user's password, requiring them to change it. If a user tries to sign in after the API is called,
     * Amazon Cognito responds with a <code>PasswordResetRequiredException</code> error. Your app must then perform the
     * actions that reset your user's password: the forgot-password flow. In addition, if the user pool has phone
     * verification selected and a verified phone number exists for the user, or if email verification is selected and a
     * verified email exists for the user, calling this API will also result in sending a message to the end user with
     * the code to change their password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminResetUserPasswordRequest
     *        Represents the request to reset a user's password as an administrator.
     * @return A Java Future containing the result of the AdminResetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminResetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminResetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminResetUserPasswordResponse> adminResetUserPassword(
            AdminResetUserPasswordRequest adminResetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminResetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminResetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminResetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminResetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminResetUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminResetUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminResetUserPasswordRequest, AdminResetUserPasswordResponse>()
                            .withOperationName("AdminResetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminResetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminResetUserPasswordRequest));
            CompletableFuture<AdminResetUserPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. An <code>AdminRespondToAuthChallenge</code> API
     * request provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminRespondToAuthChallengeRequest
     *        The request to respond to the authentication challenge, as an administrator.
     * @return A Java Future containing the result of the AdminRespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminRespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminRespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminRespondToAuthChallengeResponse> adminRespondToAuthChallenge(
            AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminRespondToAuthChallengeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminRespondToAuthChallengeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminRespondToAuthChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminRespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminRespondToAuthChallengeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminRespondToAuthChallengeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminRespondToAuthChallengeRequest, AdminRespondToAuthChallengeResponse>()
                            .withOperationName("AdminRespondToAuthChallenge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminRespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminRespondToAuthChallengeRequest));
            CompletableFuture<AdminRespondToAuthChallengeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any
     * are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a
     * user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge
     * to choose an MFA option will be returned during sign-in.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserMfaPreferenceRequest
     * @return A Java Future containing the result of the AdminSetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserMfaPreferenceResponse> adminSetUserMFAPreference(
            AdminSetUserMfaPreferenceRequest adminSetUserMfaPreferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserMfaPreferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserMfaPreferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserMFAPreference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserMfaPreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserMfaPreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserMfaPreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserMfaPreferenceRequest, AdminSetUserMfaPreferenceResponse>()
                            .withOperationName("AdminSetUserMFAPreference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserMfaPreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserMfaPreferenceRequest));
            CompletableFuture<AdminSetUserMfaPreferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     * </p>
     * <p>
     * The password can be temporary or permanent. If it is temporary, the user status enters the
     * <code>FORCE_CHANGE_PASSWORD</code> state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth
     * response will contain the <code>NEW_PASSWORD_REQUIRED</code> challenge. If the user doesn't sign in before it
     * expires, the user won't be able to sign in, and an administrator must reset their password.
     * </p>
     * <p>
     * Once the user has set a new password, or the password is permanent, the user status is set to
     * <code>Confirmed</code>.
     * </p>
     * <p>
     * <code>AdminSetUserPassword</code> can set a password for the user profile that Amazon Cognito creates for
     * third-party federated users. When you set a password, the federated user's status changes from
     * <code>EXTERNAL_PROVIDER</code> to <code>CONFIRMED</code>. A user in this state can sign in as a federated user,
     * and initiate authentication flows in the API like a linked native user. They can also modify their password and
     * attributes in token-authenticated API requests like <code>ChangePassword</code> and
     * <code>UpdateUserAttributes</code>. As a best security practice and to keep users in sync with your external IdP,
     * don't set passwords on federated user profiles. To set up a federated user for native sign-in with a linked
     * native user, refer to <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html"
     * >Linking federated users to an existing user profile</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserPasswordRequest
     * @return A Java Future containing the result of the AdminSetUserPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserPasswordResponse> adminSetUserPassword(
            AdminSetUserPasswordRequest adminSetUserPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserPasswordRequest, AdminSetUserPasswordResponse>()
                            .withOperationName("AdminSetUserPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserPasswordRequest));
            CompletableFuture<AdminSetUserPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html"
     * >AdminSetUserMFAPreference</a> instead.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminSetUserSettingsRequest
     *        You can use this parameter to set an MFA configuration that uses the SMS delivery medium.
     * @return A Java Future containing the result of the AdminSetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminSetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminSetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminSetUserSettingsResponse> adminSetUserSettings(
            AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminSetUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminSetUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminSetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminSetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminSetUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminSetUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminSetUserSettingsRequest, AdminSetUserSettingsResponse>()
                            .withOperationName("AdminSetUserSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminSetUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminSetUserSettingsRequest));
            CompletableFuture<AdminSetUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for
     * improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the AdminUpdateAuthEventFeedback operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateAuthEventFeedbackResponse> adminUpdateAuthEventFeedback(
            AdminUpdateAuthEventFeedbackRequest adminUpdateAuthEventFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateAuthEventFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateAuthEventFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateAuthEventFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateAuthEventFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateAuthEventFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateAuthEventFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateAuthEventFeedbackRequest, AdminUpdateAuthEventFeedbackResponse>()
                            .withOperationName("AdminUpdateAuthEventFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateAuthEventFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateAuthEventFeedbackRequest));
            CompletableFuture<AdminUpdateAuthEventFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the device status as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateDeviceStatusRequest
     *        The request to update the device status, as an administrator.
     * @return A Java Future containing the result of the AdminUpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateDeviceStatusResponse> adminUpdateDeviceStatus(
            AdminUpdateDeviceStatusRequest adminUpdateDeviceStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateDeviceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateDeviceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateDeviceStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateDeviceStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateDeviceStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateDeviceStatusRequest, AdminUpdateDeviceStatusResponse>()
                            .withOperationName("AdminUpdateDeviceStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateDeviceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateDeviceStatusRequest));
            CompletableFuture<AdminUpdateDeviceStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
     * To delete an attribute from your user, submit the attribute in your API request with a blank value.
     * </p>
     * <p>
     * For custom attributes, you must prepend the <code>custom:</code> prefix to the attribute name.
     * </p>
     * <p>
     * In addition to updating user attributes, this API can also be used to mark phone and email as verified.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUpdateUserAttributesRequest
     *        Represents the request to update the user's attributes as an administrator.
     * @return A Java Future containing the result of the AdminUpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUpdateUserAttributesResponse> adminUpdateUserAttributes(
            AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUpdateUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUpdateUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUpdateUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUpdateUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUpdateUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResponse>()
                            .withOperationName("AdminUpdateUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUpdateUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUpdateUserAttributesRequest));
            CompletableFuture<AdminUpdateUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * with your administrative credentials when your user signs out of your app. This results in the following
     * behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param adminUserGlobalSignOutRequest
     *        The request to sign out of all devices, as an administrator.
     * @return A Java Future containing the result of the AdminUserGlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AdminUserGlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminUserGlobalSignOut"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AdminUserGlobalSignOutResponse> adminUserGlobalSignOut(
            AdminUserGlobalSignOutRequest adminUserGlobalSignOutRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(adminUserGlobalSignOutRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, adminUserGlobalSignOutRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdminUserGlobalSignOut");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AdminUserGlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AdminUserGlobalSignOutResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AdminUserGlobalSignOutResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdminUserGlobalSignOutRequest, AdminUserGlobalSignOutResponse>()
                            .withOperationName("AdminUserGlobalSignOut").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AdminUserGlobalSignOutRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(adminUserGlobalSignOutRequest));
            CompletableFuture<AdminUserGlobalSignOutResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique
     * private key that Amazon Cognito generates and returns in the API response. You can authorize an
     * <code>AssociateSoftwareToken</code> request with either the user's access token, or a session string from a
     * challenge response that you received from Amazon Cognito.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito disassociates an existing software token when you verify the new token in a <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html">
     * VerifySoftwareToken</a> API request. If you don't verify the software token and your user pool doesn't require
     * MFA, the user can then authenticate with user name and password credentials alone. If your user pool requires
     * TOTP MFA, Amazon Cognito generates an <code>MFA_SETUP</code> or <code>SOFTWARE_TOKEN_SETUP</code> challenge each
     * time your user signs in. Complete setup with <code>AssociateSoftwareToken</code> and
     * <code>VerifySoftwareToken</code>.
     * </p>
     * <p>
     * After you set up software token MFA for your user, Amazon Cognito generates a <code>SOFTWARE_TOKEN_MFA</code>
     * challenge when they authenticate. Respond to this challenge with your user's TOTP.
     * </p>
     * </note> <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param associateSoftwareTokenRequest
     * @return A Java Future containing the result of the AssociateSoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.AssociateSoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AssociateSoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSoftwareTokenResponse> associateSoftwareToken(
            AssociateSoftwareTokenRequest associateSoftwareTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSoftwareTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSoftwareTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSoftwareToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSoftwareTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSoftwareTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateSoftwareTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSoftwareTokenRequest, AssociateSoftwareTokenResponse>()
                            .withOperationName("AssociateSoftwareToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateSoftwareTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateSoftwareTokenRequest));
            CompletableFuture<AssociateSoftwareTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the password for a specified user in a user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param changePasswordRequest
     *        Represents the request to change a user password.
     * @return A Java Future containing the result of the ChangePassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ChangePassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ChangePassword" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangePasswordResponse> changePassword(ChangePasswordRequest changePasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(changePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangePassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ChangePasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ChangePasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                            .withOperationName("ChangePassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(changePasswordRequest));
            CompletableFuture<ChangePasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms tracking of the device. This API call is the call that begins device tracking. For more information
     * about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmDeviceRequest
     *        Confirms the device request.
     * @return A Java Future containing the result of the ConfirmDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmDeviceResponse> confirmDevice(ConfirmDeviceRequest confirmDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ConfirmDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmDeviceRequest, ConfirmDeviceResponse>()
                            .withOperationName("ConfirmDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmDeviceRequest));
            CompletableFuture<ConfirmDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to enter a confirmation code to reset a forgotten password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmForgotPasswordRequest
     *        The request representing the confirmation for a password reset.
     * @return A Java Future containing the result of the ConfirmForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmForgotPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmForgotPasswordResponse> confirmForgotPassword(
            ConfirmForgotPasswordRequest confirmForgotPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmForgotPasswordRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmForgotPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmForgotPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmForgotPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmForgotPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResponse>()
                            .withOperationName("ConfirmForgotPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmForgotPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmForgotPasswordRequest));
            CompletableFuture<ConfirmForgotPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This public API operation provides a code that Amazon Cognito sent to your user when they signed up in your user
     * pool via the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html">SignUp</a> API
     * operation. After your user enters their code, they confirm ownership of the email address or phone number that
     * they provided, and their user account becomes active. Depending on your user pool configuration, your users will
     * receive their confirmation code in an email or SMS message.
     * </p>
     * <p>
     * Local users who signed up in your user pool are the only type of user who can confirm sign-up with a code. Users
     * who federate through an external identity provider (IdP) have already been confirmed by their IdP.
     * Administrator-created users, users created with the <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html"
     * >AdminCreateUser</a> API operation, confirm their accounts when they respond to their invitation email message
     * and choose a password. They do not receive a confirmation code. Instead, they receive a temporary password.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param confirmSignUpRequest
     *        Represents the request to confirm registration of a user.
     * @return A Java Future containing the result of the ConfirmSignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyFailedAttemptsException This exception is thrown when the user has made too many failed
     *         attempts for a given action, such as sign-in.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ConfirmSignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ConfirmSignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmSignUpResponse> confirmSignUp(ConfirmSignUpRequest confirmSignUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmSignUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmSignUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmSignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmSignUpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ConfirmSignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmSignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmSignUpRequest, ConfirmSignUpResponse>()
                            .withOperationName("ConfirmSignUp").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmSignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmSignUpRequest));
            CompletableFuture<ConfirmSignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new group in the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>GroupExistsException This exception is thrown when Amazon Cognito encounters a group that already
     *         exists in the user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>DuplicateProviderException This exception is thrown when the provider is already supported by the
     *         user pool.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdentityProviderRequest));
            CompletableFuture<CreateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new OAuth2.0 resource server and defines custom scopes within it.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createResourceServerRequest
     * @return A Java Future containing the result of the CreateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceServerResponse> createResourceServer(
            CreateResourceServerRequest createResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceServerRequest, CreateResourceServerResponse>()
                            .withOperationName("CreateResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceServerRequest));
            CompletableFuture<CreateResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user import job.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserImportJobRequest
     *        Represents the request to create the user import job.
     * @return A Java Future containing the result of the CreateUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserImportJobResponse> createUserImportJob(
            CreateUserImportJobRequest createUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserImportJobRequest, CreateUserImportJobResponse>()
                            .withOperationName("CreateUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserImportJobRequest));
            CompletableFuture<CreateUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolRequest
     *        Represents the request to create a user pool.
     * @return A Java Future containing the result of the CreateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolResponse> createUserPool(CreateUserPoolRequest createUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolRequest, CreateUserPoolResponse>()
                            .withOperationName("CreateUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolRequest));
            CompletableFuture<CreateUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the user pool client.
     * </p>
     * <p>
     * When you create a new user pool client, token revocation is automatically activated. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolClientRequest
     *        Represents the request to create a user pool client.
     * @return A Java Future containing the result of the CreateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolClientResponse> createUserPoolClient(
            CreateUserPoolClientRequest createUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolClientRequest, CreateUserPoolClientResponse>()
                            .withOperationName("CreateUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolClientRequest));
            CompletableFuture<CreateUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new domain for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUserPoolDomainRequest
     * @return A Java Future containing the result of the CreateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.CreateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/CreateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserPoolDomainResponse> createUserPoolDomain(
            CreateUserPoolDomainRequest createUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserPoolDomainRequest, CreateUserPoolDomainResponse>()
                            .withOperationName("CreateUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserPoolDomainRequest));
            CompletableFuture<CreateUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an IdP for a user pool.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdentityProviderRequest));
            CompletableFuture<DeleteIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource server.
     * </p>
     *
     * @param deleteResourceServerRequest
     * @return A Java Future containing the result of the DeleteResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceServerResponse> deleteResourceServer(
            DeleteResourceServerRequest deleteResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceServerRequest, DeleteResourceServerResponse>()
                            .withOperationName("DeleteResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceServerRequest));
            CompletableFuture<DeleteResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows a user to delete their own user profile.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserRequest
     *        Represents the request to delete a user.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the attributes for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param deleteUserAttributesRequest
     *        Represents the request to delete user attributes.
     * @return A Java Future containing the result of the DeleteUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserAttributesResponse> deleteUserAttributes(
            DeleteUserAttributesRequest deleteUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserAttributesRequest, DeleteUserAttributesResponse>()
                            .withOperationName("DeleteUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserAttributesRequest));
            CompletableFuture<DeleteUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon Cognito user pool.
     * </p>
     *
     * @param deleteUserPoolRequest
     *        Represents the request to delete a user pool.
     * @return A Java Future containing the result of the DeleteUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolResponse> deleteUserPool(DeleteUserPoolRequest deleteUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolRequest, DeleteUserPoolResponse>()
                            .withOperationName("DeleteUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolRequest));
            CompletableFuture<DeleteUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the developer to delete the user pool client.
     * </p>
     *
     * @param deleteUserPoolClientRequest
     *        Represents the request to delete a user pool client.
     * @return A Java Future containing the result of the DeleteUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolClientResponse> deleteUserPoolClient(
            DeleteUserPoolClientRequest deleteUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolClientRequest, DeleteUserPoolClientResponse>()
                            .withOperationName("DeleteUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolClientRequest));
            CompletableFuture<DeleteUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a domain for a user pool.
     * </p>
     *
     * @param deleteUserPoolDomainRequest
     * @return A Java Future containing the result of the DeleteUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DeleteUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DeleteUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserPoolDomainResponse> deleteUserPoolDomain(
            DeleteUserPoolDomainRequest deleteUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPoolDomainRequest, DeleteUserPoolDomainResponse>()
                            .withOperationName("DeleteUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserPoolDomainRequest));
            CompletableFuture<DeleteUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific IdP.
     * </p>
     *
     * @param describeIdentityProviderRequest
     * @return A Java Future containing the result of the DescribeIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityProviderResponse> describeIdentityProvider(
            DescribeIdentityProviderRequest describeIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIdentityProviderRequest, DescribeIdentityProviderResponse>()
                            .withOperationName("DescribeIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeIdentityProviderRequest));
            CompletableFuture<DescribeIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a resource server.
     * </p>
     *
     * @param describeResourceServerRequest
     * @return A Java Future containing the result of the DescribeResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceServerResponse> describeResourceServer(
            DescribeResourceServerRequest describeResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceServerRequest, DescribeResourceServerResponse>()
                            .withOperationName("DescribeResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourceServerRequest));
            CompletableFuture<DescribeResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the risk configuration.
     * </p>
     *
     * @param describeRiskConfigurationRequest
     * @return A Java Future containing the result of the DescribeRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRiskConfigurationResponse> describeRiskConfiguration(
            DescribeRiskConfigurationRequest describeRiskConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRiskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRiskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRiskConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRiskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRiskConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRiskConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRiskConfigurationRequest, DescribeRiskConfigurationResponse>()
                            .withOperationName("DescribeRiskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRiskConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRiskConfigurationRequest));
            CompletableFuture<DescribeRiskConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the user import job.
     * </p>
     *
     * @param describeUserImportJobRequest
     *        Represents the request to describe the user import job.
     * @return A Java Future containing the result of the DescribeUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserImportJobResponse> describeUserImportJob(
            DescribeUserImportJobRequest describeUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserImportJobRequest, DescribeUserImportJobResponse>()
                            .withOperationName("DescribeUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserImportJobRequest));
            CompletableFuture<DescribeUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the configuration information and metadata of the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolRequest
     *        Represents the request to describe the user pool.
     * @return A Java Future containing the result of the DescribeUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolResponse> describeUserPool(DescribeUserPoolRequest describeUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolRequest, DescribeUserPoolResponse>()
                            .withOperationName("DescribeUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolRequest));
            CompletableFuture<DescribeUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Client method for returning the configuration information and metadata of the specified user pool app client.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param describeUserPoolClientRequest
     *        Represents the request to describe a user pool client.
     * @return A Java Future containing the result of the DescribeUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolClientResponse> describeUserPoolClient(
            DescribeUserPoolClientRequest describeUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolClientRequest, DescribeUserPoolClientResponse>()
                            .withOperationName("DescribeUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolClientRequest));
            CompletableFuture<DescribeUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a domain.
     * </p>
     *
     * @param describeUserPoolDomainRequest
     * @return A Java Future containing the result of the DescribeUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.DescribeUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserPoolDomainResponse> describeUserPoolDomain(
            DescribeUserPoolDomainRequest describeUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserPoolDomainRequest, DescribeUserPoolDomainResponse>()
                            .withOperationName("DescribeUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserPoolDomainRequest));
            CompletableFuture<DescribeUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets the specified device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param forgetDeviceRequest
     *        Represents the request to forget the device.
     * @return A Java Future containing the result of the ForgetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ForgetDeviceResponse> forgetDevice(ForgetDeviceRequest forgetDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(forgetDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, forgetDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ForgetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ForgetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ForgetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ForgetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ForgetDeviceRequest, ForgetDeviceResponse>()
                            .withOperationName("ForgetDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ForgetDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(forgetDeviceRequest));
            CompletableFuture<ForgetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change
     * the user's password. For the <code>Username</code> parameter, you can use the username or user alias. The method
     * used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html">Recovering
     * User Accounts</a> in the <i>Amazon Cognito Developer Guide</i>. To use the confirmation code for resetting the
     * password, call <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html"
     * >ConfirmForgotPassword</a>.
     * </p>
     * <p>
     * If neither a verified phone number nor a verified email exists, this API returns
     * <code>InvalidParameterException</code>. If your app client has a client secret and you don't provide a
     * <code>SECRET_HASH</code> parameter, this API returns <code>NotAuthorizedException</code>.
     * </p>
     * <p>
     * To use this API operation, your user pool must have self-service account recovery configured. Use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html"
     * >AdminSetUserPassword</a> if you manage passwords as an administrator.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param forgotPasswordRequest
     *        Represents the request to reset a user's password.
     * @return A Java Future containing the result of the ForgotPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ForgotPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ForgotPasswordResponse> forgotPassword(ForgotPasswordRequest forgotPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(forgotPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, forgotPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ForgotPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ForgotPasswordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ForgotPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ForgotPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ForgotPasswordRequest, ForgotPasswordResponse>()
                            .withOperationName("ForgotPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ForgotPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(forgotPasswordRequest));
            CompletableFuture<ForgotPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
     * </p>
     *
     * @param getCsvHeaderRequest
     *        Represents the request to get the header information of the CSV file for the user import job.
     * @return A Java Future containing the result of the GetCSVHeader operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetCSVHeader
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetCSVHeader" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCsvHeaderResponse> getCSVHeader(GetCsvHeaderRequest getCsvHeaderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCsvHeaderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCsvHeaderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCSVHeader");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCsvHeaderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCsvHeaderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCsvHeaderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCsvHeaderRequest, GetCsvHeaderResponse>()
                            .withOperationName("GetCSVHeader").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCsvHeaderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCsvHeaderRequest));
            CompletableFuture<GetCsvHeaderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the device. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getDeviceRequest
     *        Represents the request to get the device.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>().withOperationName("GetDevice")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceRequest));
            CompletableFuture<GetDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a group.
     * </p>
     * <p>
     * Calling this action requires developer credentials.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>().withOperationName("GetGroup")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupRequest));
            CompletableFuture<GetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the specified IdP.
     * </p>
     *
     * @param getIdentityProviderByIdentifierRequest
     * @return A Java Future containing the result of the GetIdentityProviderByIdentifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetIdentityProviderByIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetIdentityProviderByIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdentityProviderByIdentifierResponse> getIdentityProviderByIdentifier(
            GetIdentityProviderByIdentifierRequest getIdentityProviderByIdentifierRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdentityProviderByIdentifierRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getIdentityProviderByIdentifierRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityProviderByIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdentityProviderByIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdentityProviderByIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdentityProviderByIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdentityProviderByIdentifierRequest, GetIdentityProviderByIdentifierResponse>()
                            .withOperationName("GetIdentityProviderByIdentifier").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIdentityProviderByIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIdentityProviderByIdentifierRequest));
            CompletableFuture<GetIdentityProviderByIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the logging configuration of a user pool.
     * </p>
     *
     * @param getLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the GetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLogDeliveryConfigurationResponse> getLogDeliveryConfiguration(
            GetLogDeliveryConfigurationRequest getLogDeliveryConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogDeliveryConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogDeliveryConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogDeliveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLogDeliveryConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLogDeliveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLogDeliveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLogDeliveryConfigurationRequest, GetLogDeliveryConfigurationResponse>()
                            .withOperationName("GetLogDeliveryConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLogDeliveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLogDeliveryConfigurationRequest));
            CompletableFuture<GetLogDeliveryConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10
     * years from the date of issue.
     * </p>
     * <p>
     * Amazon Cognito issues and assigns a new signing certificate annually. This process returns a new value in the
     * response to <code>GetSigningCertificate</code>, but doesn't invalidate the original certificate.
     * </p>
     *
     * @param getSigningCertificateRequest
     *        Request to get a signing certificate from Amazon Cognito.
     * @return A Java Future containing the result of the GetSigningCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetSigningCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetSigningCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSigningCertificateResponse> getSigningCertificate(
            GetSigningCertificateRequest getSigningCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSigningCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSigningCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSigningCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSigningCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSigningCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSigningCertificateRequest, GetSigningCertificateResponse>()
                            .withOperationName("GetSigningCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSigningCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSigningCertificateRequest));
            CompletableFuture<GetSigningCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the user interface (UI) Customization information for a particular app client's app UI, if any such
     * information exists for the client. If nothing is set for the particular client, but there is an existing pool
     * level customization (the app <code>clientId</code> is <code>ALL</code>), then that information is returned. If
     * nothing is present, then an empty shape is returned.
     * </p>
     *
     * @param getUiCustomizationRequest
     * @return A Java Future containing the result of the GetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUiCustomizationResponse> getUICustomization(GetUiCustomizationRequest getUiCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUiCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUiCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUICustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUiCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUiCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUiCustomizationRequest, GetUiCustomizationResponse>()
                            .withOperationName("GetUICustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUiCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUiCustomizationRequest));
            CompletableFuture<GetUiCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the user attributes and metadata for a user.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param getUserRequest
     *        Represents the request to get information about the user.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>().withOperationName("GetUser")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserRequest));
            CompletableFuture<GetUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a
     * code that they must return in a VerifyUserAttribute request.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param getUserAttributeVerificationCodeRequest
     *        Represents the request to get user attribute verification.
     * @return A Java Future containing the result of the GetUserAttributeVerificationCode operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserAttributeVerificationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserAttributeVerificationCodeResponse> getUserAttributeVerificationCode(
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserAttributeVerificationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getUserAttributeVerificationCodeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserAttributeVerificationCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserAttributeVerificationCodeResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetUserAttributeVerificationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserAttributeVerificationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResponse>()
                            .withOperationName("GetUserAttributeVerificationCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserAttributeVerificationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserAttributeVerificationCodeRequest));
            CompletableFuture<GetUserAttributeVerificationCodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     *
     * @param getUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the GetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserPoolMfaConfigResponse> getUserPoolMfaConfig(
            GetUserPoolMfaConfigRequest getUserPoolMfaConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserPoolMfaConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserPoolMfaConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserPoolMfaConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserPoolMfaConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserPoolMfaConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserPoolMfaConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserPoolMfaConfigRequest, GetUserPoolMfaConfigResponse>()
                            .withOperationName("GetUserPoolMfaConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserPoolMfaConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserPoolMfaConfigRequest));
            CompletableFuture<GetUserPoolMfaConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user. Call this operation
     * when your user signs out of your app. This results in the following behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts <i>token-authorized</i> user operations that you authorize with a signed-out
     * user's access tokens. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * <p>
     * Amazon Cognito returns an <code>Access Token has been revoked</code> error when your app attempts to authorize a
     * user pools API request with a revoked access token that contains the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's ID token in a <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetId.html">GetId </a> request to an
     * identity pool with <code>ServerSideTokenCheck</code> enabled for its user pool IdP configuration in <a
     * href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_CognitoIdentityProvider.html"
     * >CognitoIdentityProvider</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Cognito no longer accepts a signed-out user's refresh tokens in refresh requests.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other requests might be valid until your user's token expires.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param globalSignOutRequest
     *        Represents the request to sign out all devices.
     * @return A Java Future containing the result of the GlobalSignOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.GlobalSignOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GlobalSignOut" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GlobalSignOutResponse> globalSignOut(GlobalSignOutRequest globalSignOutRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(globalSignOutRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, globalSignOutRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GlobalSignOut");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GlobalSignOutResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GlobalSignOutResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GlobalSignOutResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GlobalSignOutRequest, GlobalSignOutResponse>()
                            .withOperationName("GlobalSignOut").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GlobalSignOutRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(globalSignOutRequest));
            CompletableFuture<GlobalSignOutResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP
     * with <code>InitiateAuth</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html">
     * Adding user pool sign-in through a third party</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param initiateAuthRequest
     *        Initiates the authentication request.
     * @return A Java Future containing the result of the InitiateAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.InitiateAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/InitiateAuth" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InitiateAuthResponse> initiateAuth(InitiateAuthRequest initiateAuthRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(initiateAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, initiateAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InitiateAuth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<InitiateAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    InitiateAuthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<InitiateAuthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<InitiateAuthRequest, InitiateAuthResponse>()
                            .withOperationName("InitiateAuth").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new InitiateAuthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(initiateAuthRequest));
            CompletableFuture<InitiateAuthResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the sign-in devices that Amazon Cognito has registered to the current user. For more information about
     * device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param listDevicesRequest
     *        Represents the request to list the devices.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDevicesRequest, ListDevicesResponse>()
                            .withOperationName("ListDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDevicesRequest));
            CompletableFuture<ListDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the groups associated with a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about all IdPs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdentityProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdentityProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdentityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdentityProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdentityProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                            .withOperationName("ListIdentityProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIdentityProvidersRequest));
            CompletableFuture<ListIdentityProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resource servers for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listResourceServersRequest
     * @return A Java Future containing the result of the ListResourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListResourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListResourceServers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceServersResponse> listResourceServers(
            ListResourceServersRequest listResourceServersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceServersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceServersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceServersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceServersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceServersRequest, ListResourceServersResponse>()
                            .withOperationName("ListResourceServers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceServersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceServersRequest));
            CompletableFuture<ListResourceServersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     * </p>
     * <p>
     * A tag is a label that you can apply to user pools to categorize and manage them in different ways, such as by
     * purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * You can use this action up to 10 times per second, per account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists user import jobs for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserImportJobsRequest
     *        Represents the request to list the user import jobs.
     * @return A Java Future containing the result of the ListUserImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserImportJobsResponse> listUserImportJobs(ListUserImportJobsRequest listUserImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserImportJobsRequest, ListUserImportJobsResponse>()
                            .withOperationName("ListUserImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserImportJobsRequest));
            CompletableFuture<ListUserImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the clients that have been created for the specified user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolClientsRequest
     *        Represents the request to list the user pool clients.
     * @return A Java Future containing the result of the ListUserPoolClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPoolClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPoolClients"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolClientsResponse> listUserPoolClients(
            ListUserPoolClientsRequest listUserPoolClientsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserPoolClientsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoolClientsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPoolClients");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserPoolClientsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserPoolClientsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserPoolClientsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserPoolClientsRequest, ListUserPoolClientsResponse>()
                            .withOperationName("ListUserPoolClients").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserPoolClientsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserPoolClientsRequest));
            CompletableFuture<ListUserPoolClientsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the user pools associated with an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUserPoolsRequest
     *        Represents the request to list user pools.
     * @return A Java Future containing the result of the ListUserPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUserPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserPoolsResponse> listUserPools(ListUserPoolsRequest listUserPoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserPoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUserPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserPoolsRequest, ListUserPoolsResponse>()
                            .withOperationName("ListUserPools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUserPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUserPoolsRequest));
            CompletableFuture<ListUserPoolsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists users and their basic details in a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersRequest
     *        Represents the request to list users.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the users in the specified group.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listUsersInGroupRequest
     * @return A Java Future containing the result of the ListUsersInGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ListUsersInGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUsersInGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersInGroupResponse> listUsersInGroup(ListUsersInGroupRequest listUsersInGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersInGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersInGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsersInGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersInGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUsersInGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersInGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersInGroupRequest, ListUsersInGroupResponse>()
                            .withOperationName("ListUsersInGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersInGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsersInGroupRequest));
            CompletableFuture<ListUsersInGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param resendConfirmationCodeRequest
     *        Represents the request to resend the confirmation code.
     * @return A Java Future containing the result of the ResendConfirmationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.ResendConfirmationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ResendConfirmationCode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResendConfirmationCodeResponse> resendConfirmationCode(
            ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resendConfirmationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resendConfirmationCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResendConfirmationCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResendConfirmationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResendConfirmationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResendConfirmationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResendConfirmationCodeRequest, ResendConfirmationCodeResponse>()
                            .withOperationName("ResendConfirmationCode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResendConfirmationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resendConfirmationCodeRequest));
            CompletableFuture<ResendConfirmationCodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication
     * that bypasses MFA, or for a custom authentication challenge. A <code>RespondToAuthChallenge</code> API request
     * provides the answer to that challenge, like a code or a secure remote password (SRP). The parameters of a
     * response to an authentication challenge vary with the type of challenge.
     * </p>
     * <p>
     * For more information about custom authentication challenges, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-challenge.html">Custom
     * authentication challenge Lambda triggers</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param respondToAuthChallengeRequest
     *        The request to respond to an authentication challenge.
     * @return A Java Future containing the result of the RespondToAuthChallenge operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>PasswordHistoryPolicyViolationException The message returned when a user's new password matches a
     *         previous password and doesn't comply with the password-history policy.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>MfaMethodNotFoundException This exception is thrown when Amazon Cognito can't find a multi-factor
     *         authentication (MFA) method.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RespondToAuthChallenge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RespondToAuthChallengeResponse> respondToAuthChallenge(
            RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(respondToAuthChallengeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, respondToAuthChallengeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RespondToAuthChallenge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RespondToAuthChallengeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RespondToAuthChallengeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RespondToAuthChallengeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RespondToAuthChallengeRequest, RespondToAuthChallengeResponse>()
                            .withOperationName("RespondToAuthChallenge").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RespondToAuthChallengeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(respondToAuthChallengeRequest));
            CompletableFuture<RespondToAuthChallengeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a
     * token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to
     * your resource server.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param revokeTokenRequest
     * @return A Java Future containing the result of the RevokeToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>UnauthorizedException Exception that is thrown when the request isn't authorized. This can happen due
     *         to an invalid access token in the request.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedOperationException Exception that is thrown when you attempt to perform an operation that
     *         isn't enabled for the user pool client.</li>
     *         <li>UnsupportedTokenTypeException Exception that is thrown when an unsupported token is passed to an
     *         operation.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.RevokeToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RevokeToken" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeTokenResponse> revokeToken(RevokeTokenRequest revokeTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RevokeTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RevokeTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RevokeTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeTokenRequest, RevokeTokenResponse>()
                            .withOperationName("RevokeToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeTokenRequest));
            CompletableFuture<RevokeTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets up or modifies the logging configuration of a user pool. User pools can export user notification logs and
     * advanced security features user activity logs.
     * </p>
     *
     * @param setLogDeliveryConfigurationRequest
     * @return A Java Future containing the result of the SetLogDeliveryConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetLogDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetLogDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetLogDeliveryConfigurationResponse> setLogDeliveryConfiguration(
            SetLogDeliveryConfigurationRequest setLogDeliveryConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setLogDeliveryConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setLogDeliveryConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetLogDeliveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetLogDeliveryConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetLogDeliveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetLogDeliveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetLogDeliveryConfigurationRequest, SetLogDeliveryConfigurationResponse>()
                            .withOperationName("SetLogDeliveryConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetLogDeliveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setLogDeliveryConfigurationRequest));
            CompletableFuture<SetLogDeliveryConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures actions on detected risks. To delete the risk configuration for <code>UserPoolId</code> or
     * <code>ClientId</code>, pass null values for all four configuration types.
     * </p>
     * <p>
     * To activate Amazon Cognito advanced security features, update the user pool to include the
     * <code>UserPoolAddOns</code> key<code>AdvancedSecurityMode</code>.
     * </p>
     *
     * @param setRiskConfigurationRequest
     * @return A Java Future containing the result of the SetRiskConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetRiskConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetRiskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetRiskConfigurationResponse> setRiskConfiguration(
            SetRiskConfigurationRequest setRiskConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setRiskConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setRiskConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetRiskConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetRiskConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetRiskConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetRiskConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetRiskConfigurationRequest, SetRiskConfigurationResponse>()
                            .withOperationName("SetRiskConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetRiskConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setRiskConfigurationRequest));
            CompletableFuture<SetRiskConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the user interface (UI) customization information for a user pool's built-in app UI.
     * </p>
     * <p>
     * You can specify app UI customization settings for a single client (with a specific <code>clientId</code>) or for
     * all clients (by setting the <code>clientId</code> to <code>ALL</code>). If you specify <code>ALL</code>, the
     * default configuration is used for every client that has no previously set UI customization. If you specify UI
     * customization settings for a particular client, it will no longer return to the <code>ALL</code> configuration.
     * </p>
     * <note>
     * <p>
     * To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the
     * app's pages, and the service will throw an error.
     * </p>
     * </note>
     *
     * @param setUiCustomizationRequest
     * @return A Java Future containing the result of the SetUICustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUICustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUICustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUiCustomizationResponse> setUICustomization(SetUiCustomizationRequest setUiCustomizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUiCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUiCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUICustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUiCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUiCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUiCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUiCustomizationRequest, SetUiCustomizationResponse>()
                            .withOperationName("SetUICustomization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUiCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUiCustomizationRequest));
            CompletableFuture<SetUiCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and
     * if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to
     * authenticate a user if multiple factors are activated. If multiple options are activated and no preference is
     * set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user,
     * the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device
     * has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts,
     * deactivate MFA for users and turn on Adaptive Authentication for the user pool.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserMfaPreferenceRequest
     * @return A Java Future containing the result of the SetUserMFAPreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserMFAPreference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserMfaPreferenceResponse> setUserMFAPreference(
            SetUserMfaPreferenceRequest setUserMfaPreferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserMfaPreferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserMfaPreferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserMFAPreference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserMfaPreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserMfaPreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserMfaPreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserMfaPreferenceRequest, SetUserMfaPreferenceResponse>()
                            .withOperationName("SetUserMFAPreference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserMfaPreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserMfaPreferenceRequest));
            CompletableFuture<SetUserMfaPreferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the user pool multi-factor authentication (MFA) configuration.
     * </p>
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param setUserPoolMfaConfigRequest
     * @return A Java Future containing the result of the SetUserPoolMfaConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserPoolMfaConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserPoolMfaConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserPoolMfaConfigResponse> setUserPoolMfaConfig(
            SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserPoolMfaConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserPoolMfaConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserPoolMfaConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserPoolMfaConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserPoolMfaConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserPoolMfaConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserPoolMfaConfigRequest, SetUserPoolMfaConfigResponse>()
                            .withOperationName("SetUserPoolMfaConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserPoolMfaConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserPoolMfaConfigRequest));
            CompletableFuture<SetUserPoolMfaConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <i>This action is no longer supported.</i> You can use it to configure only SMS MFA. You can't use it to
     * configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html"
     * >SetUserMFAPreference</a> instead.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param setUserSettingsRequest
     *        Represents the request to set user settings.
     * @return A Java Future containing the result of the SetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetUserSettingsResponse> setUserSettings(SetUserSettingsRequest setUserSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetUserSettingsRequest, SetUserSettingsResponse>()
                            .withOperationName("SetUserSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SetUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(setUserSettingsRequest));
            CompletableFuture<SetUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param signUpRequest
     *        Represents the request to register a user.
     * @return A Java Future containing the result of the SignUp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidPasswordException This exception is thrown when Amazon Cognito encounters an invalid password.
     *         </li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>UsernameExistsException This exception is thrown when Amazon Cognito encounters a user name that
     *         already exists in the user pool.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.SignUp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SignUp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SignUpResponse> signUp(SignUpRequest signUpRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(signUpRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, signUpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SignUp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SignUpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SignUpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SignUpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SignUpRequest, SignUpResponse>().withOperationName("SignUp")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new SignUpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(signUpRequest));
            CompletableFuture<SignUpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the user import.
     * </p>
     *
     * @param startUserImportJobRequest
     *        Represents the request to start the user import job.
     * @return A Java Future containing the result of the StartUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StartUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StartUserImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartUserImportJobResponse> startUserImportJob(StartUserImportJobRequest startUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartUserImportJobRequest, StartUserImportJobResponse>()
                            .withOperationName("StartUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startUserImportJobRequest));
            CompletableFuture<StartUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the user import job.
     * </p>
     *
     * @param stopUserImportJobRequest
     *        Represents the request to stop the user import job.
     * @return A Java Future containing the result of the StopUserImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>PreconditionNotMetException This exception is thrown when a precondition is not met.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.StopUserImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/StopUserImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopUserImportJobResponse> stopUserImportJob(StopUserImportJobRequest stopUserImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopUserImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopUserImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopUserImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopUserImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopUserImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopUserImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopUserImportJobRequest, StopUserImportJobResponse>()
                            .withOperationName("StopUserImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopUserImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopUserImportJobRequest));
            CompletableFuture<StopUserImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage
     * user pools in different ways, such as by purpose, owner, environment, or other criteria.
     * </p>
     * <p>
     * Each tag consists of a key and value, both of which you define. A key is a general category for more specific
     * values. For example, if you have two versions of a user pool, one for testing and another for production, you
     * might assign an <code>Environment</code> tag key to both user pools. The value of this key might be
     * <code>Test</code> for one user pool, and <code>Production</code> for the other.
     * </p>
     * <p>
     * Tags are useful for cost tracking and access control. You can activate your tags so that they appear on the
     * Billing and Cost Management console, where you can track the costs associated with your user pools. In an
     * Identity and Access Management policy, you can constrain permissions for user pools based on specific tags or tag
     * values.
     * </p>
     * <p>
     * You can use this action up to 5 times per second, per account. A user pool can have as many as 50 tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second,
     * per account.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used
     * for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateAuthEventFeedbackRequest
     * @return A Java Future containing the result of the UpdateAuthEventFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserPoolAddOnNotEnabledException This exception is thrown when user pool add-ons aren't enabled.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateAuthEventFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateAuthEventFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAuthEventFeedbackResponse> updateAuthEventFeedback(
            UpdateAuthEventFeedbackRequest updateAuthEventFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAuthEventFeedbackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthEventFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthEventFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAuthEventFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAuthEventFeedbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAuthEventFeedbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAuthEventFeedbackRequest, UpdateAuthEventFeedbackResponse>()
                            .withOperationName("UpdateAuthEventFeedback").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAuthEventFeedbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAuthEventFeedbackRequest));
            CompletableFuture<UpdateAuthEventFeedbackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the device status. For more information about device authentication, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html"
     * >Working with user devices in your user pool</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param updateDeviceStatusRequest
     *        Represents the request to update the device status.
     * @return A Java Future containing the result of the UpdateDeviceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateDeviceStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceStatusResponse> updateDeviceStatus(UpdateDeviceStatusRequest updateDeviceStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDeviceStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeviceStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeviceStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeviceStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeviceStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeviceStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeviceStatusRequest, UpdateDeviceStatusResponse>()
                            .withOperationName("UpdateDeviceStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDeviceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDeviceStatusRequest));
            CompletableFuture<UpdateDeviceStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified group with the specified attributes.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                            .withOperationName("UpdateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGroupRequest));
            CompletableFuture<UpdateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates IdP information for a user pool.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>UnsupportedIdentityProviderException This exception is thrown when the specified identifier isn't
     *         supported.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withOperationName("UpdateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIdentityProviderRequest));
            CompletableFuture<UpdateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name and scopes of resource server. All other fields are read-only.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, it is set to the default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateResourceServerRequest
     * @return A Java Future containing the result of the UpdateResourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateResourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateResourceServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceServerResponse> updateResourceServer(
            UpdateResourceServerRequest updateResourceServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourceServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceServerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceServerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceServerRequest, UpdateResourceServerResponse>()
                            .withOperationName("UpdateResourceServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResourceServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResourceServerRequest));
            CompletableFuture<UpdateResourceServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * With this operation, your users can update one or more of their attributes with their own credentials. You
     * authorize this API request with the user's access token. To delete an attribute from your user, submit the
     * attribute in your API request with a blank value. Custom attribute values in this request must include the
     * <code>custom:</code> prefix.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note> <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param updateUserAttributesRequest
     *        Represents the request to update user attributes.
     * @return A Java Future containing the result of the UpdateUserAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UnexpectedLambdaException This exception is thrown when Amazon Cognito encounters an unexpected
     *         exception with Lambda.</li>
     *         <li>UserLambdaValidationException This exception is thrown when the Amazon Cognito service encounters a
     *         user validation exception with the Lambda service.</li>
     *         <li>InvalidLambdaResponseException This exception is thrown when Amazon Cognito encounters an invalid
     *         Lambda response.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>CodeDeliveryFailureException This exception is thrown when a verification code fails to deliver
     *         successfully.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserAttributesResponse> updateUserAttributes(
            UpdateUserAttributesRequest updateUserAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserAttributesRequest, UpdateUserAttributesResponse>()
                            .withOperationName("UpdateUserAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserAttributesRequest));
            CompletableFuture<UpdateUserAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
     * register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text
     * messages in Amazon Cognito, you must register a phone number with <a
     * href="https://console.aws.amazon.com/pinpoint/home/">Amazon Pinpoint</a>. Amazon Cognito uses the registered
     * number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
     * activate their accounts, or sign in.
     * </p>
     * <p>
     * If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
     * Notification Service might place your account in the SMS sandbox. In <i> <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">sandbox mode</a> </i>, you can send
     * messages only to verified phone numbers. After you test your app while in the sandbox environment, you can move
     * out of the sandbox and into production. For more information, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html"> SMS message
     * settings for Amazon Cognito user pools</a> in the <i>Amazon Cognito Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * Updates the specified user pool with the specified attributes. You can get a list of the current user pool
     * settings using <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html"
     * >DescribeUserPool</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important> <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolRequest
     *        Represents the request to update the user pool.
     * @return A Java Future containing the result of the UpdateUserPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>UserImportInProgressException This exception is thrown when you're trying to modify a user pool while
     *         a user import job is in progress for that pool.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>InvalidSmsRoleAccessPolicyException This exception is returned when the role provided for SMS
     *         configuration doesn't have permission to publish using Amazon SNS.</li>
     *         <li>InvalidSmsRoleTrustRelationshipException This exception is thrown when the trust relationship is not
     *         valid for the role provided for SMS configuration. This can happen if you don't trust
     *         <code>cognito-idp.amazonaws.com</code> or the external ID provided in the role does not match what is
     *         provided in the SMS configuration for the user pool.</li>
     *         <li>UserPoolTaggingException This exception is thrown when a user pool tag can't be set or updated.</li>
     *         <li>InvalidEmailRoleAccessPolicyException This exception is thrown when Amazon Cognito isn't allowed to
     *         use your email identity. HTTP status code: 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolResponse> updateUserPool(UpdateUserPoolRequest updateUserPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolRequest, UpdateUserPoolResponse>()
                            .withOperationName("UpdateUserPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolRequest));
            CompletableFuture<UpdateUserPoolResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified user pool app client with the specified attributes. You can get a list of the current user
     * pool app client settings using <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html"
     * >DescribeUserPoolClient</a>.
     * </p>
     * <important>
     * <p>
     * If you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
     * </p>
     * </important>
     * <p>
     * You can also use this operation to enable token revocation for user pool clients. For more information about
     * revoking tokens, see <a
     * href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html"
     * >RevokeToken</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolClientRequest
     *        Represents the request to update the user pool client.
     * @return A Java Future containing the result of the UpdateUserPoolClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ConcurrentModificationException This exception is thrown if two or more modifications are happening
     *         concurrently.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ScopeDoesNotExistException This exception is thrown when the specified scope doesn't exist.</li>
     *         <li>InvalidOAuthFlowException This exception is thrown when the specified OAuth flow is not valid.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolClient"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolClientResponse> updateUserPoolClient(
            UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolClientRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolClientRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPoolClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolClientResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolClientResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolClientResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolClientRequest, UpdateUserPoolClientResponse>()
                            .withOperationName("UpdateUserPoolClient").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolClientRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolClientRequest));
            CompletableFuture<UpdateUserPoolClientResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     * </p>
     * <p>
     * You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You
     * can't use it to change the domain for a user pool.
     * </p>
     * <p>
     * A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your
     * application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager
     * (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom
     * domain.
     * </p>
     * <p>
     * Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing
     * certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new
     * certificate automatically.
     * </p>
     * <p>
     * However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To
     * apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito.
     * </p>
     * <p>
     * When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web Services
     * Region.
     * </p>
     * <p>
     * After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your
     * custom domain.
     * </p>
     * <p>
     * For more information about adding a custom domain to your user pool, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html">Using
     * Your Own Domain for the Hosted UI</a>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this API operation. For
     * this operation, you must use IAM credentials to authorize requests, and you must grant yourself the corresponding
     * IAM permission in a policy.
     * </p>
     * <p class="title">
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html">Signing Amazon Web Services
     * API Requests</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the
     * Amazon Cognito user pools API and user pool endpoints</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateUserPoolDomainRequest
     *        The UpdateUserPoolDomain request input.
     * @return A Java Future containing the result of the UpdateUserPoolDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.UpdateUserPoolDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateUserPoolDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserPoolDomainResponse> updateUserPoolDomain(
            UpdateUserPoolDomainRequest updateUserPoolDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserPoolDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserPoolDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserPoolDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserPoolDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserPoolDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserPoolDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserPoolDomainRequest, UpdateUserPoolDomainResponse>()
                            .withOperationName("UpdateUserPoolDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUserPoolDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUserPoolDomainRequest));
            CompletableFuture<UpdateUserPoolDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software
     * token MFA status as "verified" if successful. The request takes an access token or a session string, but not
     * both.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifySoftwareTokenRequest
     * @return A Java Future containing the result of the VerifySoftwareToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidUserPoolConfigurationException This exception is thrown when the user pool configuration is
     *         not valid.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>EnableSoftwareTokenMfaException This exception is thrown when there is a code mismatch and the
     *         service fails to configure the software token TOTP multi-factor authentication (MFA).</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>SoftwareTokenMfaNotFoundException This exception is thrown when the software token time-based
     *         one-time password (TOTP) multi-factor authentication (MFA) isn't activated for the user pool.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifySoftwareToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifySoftwareToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifySoftwareTokenResponse> verifySoftwareToken(
            VerifySoftwareTokenRequest verifySoftwareTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifySoftwareTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifySoftwareTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifySoftwareToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifySoftwareTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifySoftwareTokenResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifySoftwareTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifySoftwareTokenRequest, VerifySoftwareTokenResponse>()
                            .withOperationName("VerifySoftwareToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifySoftwareTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifySoftwareTokenRequest));
            CompletableFuture<VerifySoftwareTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Verifies the specified user attributes in the user pool.
     * </p>
     * <p>
     * If your user pool requires verification before Amazon Cognito updates the attribute value, VerifyUserAttribute
     * updates the affected attribute to its pending value. For more information, see <a href=
     * "https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserAttributeUpdateSettingsType.html"
     * > UserAttributeUpdateSettingsType</a>.
     * </p>
     * <p>
     * Authorize this action with a signed-in user's access token. It must include the scope
     * <code>aws.cognito.signin.user.admin</code>.
     * </p>
     * <note>
     * <p>
     * Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this API operation.
     * For this operation, you can't use IAM credentials to authorize requests, and you can't grant IAM permissions in
     * policies. For more information about authorization models in Amazon Cognito, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html">Using the Amazon
     * Cognito user pools API and user pool endpoints</a>.
     * </p>
     * </note>
     *
     * @param verifyUserAttributeRequest
     *        Represents the request to verify user attributes.
     * @return A Java Future containing the result of the VerifyUserAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the Amazon Cognito service can't find the
     *         requested resource.</li>
     *         <li>InvalidParameterException This exception is thrown when the Amazon Cognito service encounters an
     *         invalid parameter.</li>
     *         <li>CodeMismatchException This exception is thrown if the provided code doesn't match what the server was
     *         expecting.</li>
     *         <li>ExpiredCodeException This exception is thrown if a code has expired.</li>
     *         <li>NotAuthorizedException This exception is thrown when a user isn't authorized.</li>
     *         <li>TooManyRequestsException This exception is thrown when the user has made too many requests for a
     *         given operation.</li>
     *         <li>LimitExceededException This exception is thrown when a user exceeds the limit for a requested Amazon
     *         Web Services resource.</li>
     *         <li>PasswordResetRequiredException This exception is thrown when a password reset is required.</li>
     *         <li>UserNotFoundException This exception is thrown when a user isn't found.</li>
     *         <li>UserNotConfirmedException This exception is thrown when a user isn't confirmed successfully.</li>
     *         <li>InternalErrorException This exception is thrown when Amazon Cognito encounters an internal error.</li>
     *         <li>AliasExistsException This exception is thrown when a user tries to confirm the account with an email
     *         address or phone number that has already been supplied as an alias for a different user profile. This
     *         exception indicates that an account with this email address or phone already exists in a user pool that
     *         you've configured to use email address or phone number as a sign-in alias.</li>
     *         <li>ForbiddenException This exception is thrown when WAF doesn't allow your request based on a web ACL
     *         that's associated with your user pool.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CognitoIdentityProviderException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CognitoIdentityProviderAsyncClient.VerifyUserAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/VerifyUserAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyUserAttributeResponse> verifyUserAttribute(
            VerifyUserAttributeRequest verifyUserAttributeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyUserAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyUserAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Cognito Identity Provider");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyUserAttribute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifyUserAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifyUserAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifyUserAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifyUserAttributeRequest, VerifyUserAttributeResponse>()
                            .withOperationName("VerifyUserAttribute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifyUserAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifyUserAttributeRequest));
            CompletableFuture<VerifyUserAttributeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CognitoIdentityProviderServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoIdentityProviderServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CognitoIdentityProviderException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLambdaResponseException")
                                .exceptionBuilderSupplier(InvalidLambdaResponseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordHistoryPolicyViolationException")
                                .exceptionBuilderSupplier(PasswordHistoryPolicyViolationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOAuthFlowException")
                                .exceptionBuilderSupplier(InvalidOAuthFlowException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSmsRoleAccessPolicyException")
                                .exceptionBuilderSupplier(InvalidSmsRoleAccessPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UsernameExistsException")
                                .exceptionBuilderSupplier(UsernameExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserImportInProgressException")
                                .exceptionBuilderSupplier(UserImportInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MFAMethodNotFoundException")
                                .exceptionBuilderSupplier(MfaMethodNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SoftwareTokenMFANotFoundException")
                                .exceptionBuilderSupplier(SoftwareTokenMfaNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ExpiredCodeException")
                                .exceptionBuilderSupplier(ExpiredCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedTokenTypeException")
                                .exceptionBuilderSupplier(UnsupportedTokenTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotFoundException")
                                .exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AliasExistsException")
                                .exceptionBuilderSupplier(AliasExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedUserStateException")
                                .exceptionBuilderSupplier(UnsupportedUserStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotAuthorizedException")
                                .exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedIdentityProviderException")
                                .exceptionBuilderSupplier(UnsupportedIdentityProviderException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotConfirmedException")
                                .exceptionBuilderSupplier(UserNotConfirmedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordResetRequiredException")
                                .exceptionBuilderSupplier(PasswordResetRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnexpectedLambdaException")
                                .exceptionBuilderSupplier(UnexpectedLambdaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateProviderException")
                                .exceptionBuilderSupplier(DuplicateProviderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserLambdaValidationException")
                                .exceptionBuilderSupplier(UserLambdaValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSmsRoleTrustRelationshipException")
                                .exceptionBuilderSupplier(InvalidSmsRoleTrustRelationshipException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFailedAttemptsException")
                                .exceptionBuilderSupplier(TooManyFailedAttemptsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeDeliveryFailureException")
                                .exceptionBuilderSupplier(CodeDeliveryFailureException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScopeDoesNotExistException")
                                .exceptionBuilderSupplier(ScopeDoesNotExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalErrorException")
                                .exceptionBuilderSupplier(InternalErrorException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEmailRoleAccessPolicyException")
                                .exceptionBuilderSupplier(InvalidEmailRoleAccessPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionNotMetException")
                                .exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GroupExistsException")
                                .exceptionBuilderSupplier(GroupExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserPoolTaggingException")
                                .exceptionBuilderSupplier(UserPoolTaggingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EnableSoftwareTokenMFAException")
                                .exceptionBuilderSupplier(EnableSoftwareTokenMfaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserPoolAddOnNotEnabledException")
                                .exceptionBuilderSupplier(UserPoolAddOnNotEnabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserPoolConfigurationException")
                                .exceptionBuilderSupplier(InvalidUserPoolConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeMismatchException")
                                .exceptionBuilderSupplier(CodeMismatchException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CognitoIdentityProviderServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoIdentityProviderServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
