/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType;

public class ListUserPoolsIterable
implements SdkIterable<ListUserPoolsResponse> {
    private final CognitoIdentityProviderClient client;
    private final ListUserPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserPoolsIterable(CognitoIdentityProviderClient client, ListUserPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUserPoolsResponseFetcher();
    }

    public Iterator<ListUserPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserPoolDescriptionType> userPools() {
        Function<ListUserPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userPools() != null) {
                return response.userPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserPoolsResponseFetcher
    implements SyncPageFetcher<ListUserPoolsResponse> {
        private ListUserPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserPoolsResponse nextPage(ListUserPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoolsIterable.this.client.listUserPools(ListUserPoolsIterable.this.firstRequest);
            }
            return ListUserPoolsIterable.this.client.listUserPools((ListUserPoolsRequest)((Object)ListUserPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

