/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminSetUserMfaPreferenceRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<AdminSetUserMfaPreferenceRequest.Builder, AdminSetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField
            .<SMSMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("SMSMfaSettings")
            .getter(getter(AdminSetUserMfaPreferenceRequest::smsMfaSettings)).setter(setter(Builder::smsMfaSettings))
            .constructor(SMSMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()).build();

    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField
            .<SoftwareTokenMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("SoftwareTokenMfaSettings")
            .getter(getter(AdminSetUserMfaPreferenceRequest::softwareTokenMfaSettings))
            .setter(setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build())
            .build();

    private static final SdkField<EmailMfaSettingsType> EMAIL_MFA_SETTINGS_FIELD = SdkField
            .<EmailMfaSettingsType> builder(MarshallingType.SDK_POJO).memberName("EmailMfaSettings")
            .getter(getter(AdminSetUserMfaPreferenceRequest::emailMfaSettings)).setter(setter(Builder::emailMfaSettings))
            .constructor(EmailMfaSettingsType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMfaSettings").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(AdminSetUserMfaPreferenceRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(AdminSetUserMfaPreferenceRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD,
            SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, EMAIL_MFA_SETTINGS_FIELD, USERNAME_FIELD, USER_POOL_ID_FIELD));

    private final SMSMfaSettingsType smsMfaSettings;

    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

    private final EmailMfaSettingsType emailMfaSettings;

    private final String username;

    private final String userPoolId;

    private AdminSetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.emailMfaSettings = builder.emailMfaSettings;
        this.username = builder.username;
        this.userPoolId = builder.userPoolId;
    }

    /**
     * <p>
     * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA method
     * when multiple methods are available.
     * </p>
     * 
     * @return User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
     *         method when multiple methods are available.
     */
    public final SMSMfaSettingsType smsMfaSettings() {
        return smsMfaSettings;
    }

    /**
     * <p>
     * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it as
     * the preferred MFA method when multiple methods are available.
     * </p>
     * 
     * @return User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets
     *         it as the preferred MFA method when multiple methods are available.
     */
    public final SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return softwareTokenMfaSettings;
    }

    /**
     * <p>
     * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
     * method when multiple methods are available. To activate this setting, <a href=
     * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html">
     * advanced security features</a> must be active in your user pool.
     * </p>
     * 
     * @return User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred
     *         MFA method when multiple methods are available. To activate this setting, <a href=
     *         "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
     *         > advanced security features</a> must be active in your user pool.
     */
    public final EmailMfaSettingsType emailMfaSettings() {
        return emailMfaSettings;
    }

    /**
     * <p>
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's
     * username, but it can be any of their alias attributes. If <code>username</code> isn't an alias attribute in your
     * user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party
     * IdP.
     * </p>
     * 
     * @return The username of the user that you want to query or modify. The value of this parameter is typically your
     *         user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
     *         attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
     *         user from a third-party IdP.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The ID of the user pool where you want to set a user's MFA preferences.
     * </p>
     * 
     * @return The ID of the user pool where you want to set a user's MFA preferences.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(emailMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminSetUserMfaPreferenceRequest)) {
            return false;
        }
        AdminSetUserMfaPreferenceRequest other = (AdminSetUserMfaPreferenceRequest) obj;
        return Objects.equals(smsMfaSettings(), other.smsMfaSettings())
                && Objects.equals(softwareTokenMfaSettings(), other.softwareTokenMfaSettings())
                && Objects.equals(emailMfaSettings(), other.emailMfaSettings()) && Objects.equals(username(), other.username())
                && Objects.equals(userPoolId(), other.userPoolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminSetUserMfaPreferenceRequest").add("SMSMfaSettings", smsMfaSettings())
                .add("SoftwareTokenMfaSettings", softwareTokenMfaSettings()).add("EmailMfaSettings", emailMfaSettings())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").add("UserPoolId", userPoolId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSMfaSettings":
            return Optional.ofNullable(clazz.cast(smsMfaSettings()));
        case "SoftwareTokenMfaSettings":
            return Optional.ofNullable(clazz.cast(softwareTokenMfaSettings()));
        case "EmailMfaSettings":
            return Optional.ofNullable(clazz.cast(emailMfaSettings()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminSetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((AdminSetUserMfaPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AdminSetUserMfaPreferenceRequest> {
        /**
         * <p>
         * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
         * method when multiple methods are available.
         * </p>
         * 
         * @param smsMfaSettings
         *        User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred
         *        MFA method when multiple methods are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings);

        /**
         * <p>
         * User preferences for SMS message MFA. Activates or deactivates SMS MFA and sets it as the preferred MFA
         * method when multiple methods are available.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMSMfaSettingsType.Builder} avoiding the
         * need to create one manually via {@link SMSMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMSMfaSettingsType.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMfaSettings(SMSMfaSettingsType)}.
         * 
         * @param smsMfaSettings
         *        a consumer that will call methods on {@link SMSMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMfaSettings(SMSMfaSettingsType)
         */
        default Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return smsMfaSettings(SMSMfaSettingsType.builder().applyMutation(smsMfaSettings).build());
        }

        /**
         * <p>
         * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it
         * as the preferred MFA method when multiple methods are available.
         * </p>
         * 
         * @param softwareTokenMfaSettings
         *        User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and
         *        sets it as the preferred MFA method when multiple methods are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings);

        /**
         * <p>
         * User preferences for time-based one-time password (TOTP) MFA. Activates or deactivates TOTP MFA and sets it
         * as the preferred MFA method when multiple methods are available.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareTokenMfaSettingsType.Builder}
         * avoiding the need to create one manually via {@link SoftwareTokenMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareTokenMfaSettingsType.Builder#build()} is called
         * immediately and its result is passed to {@link #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)}.
         * 
         * @param softwareTokenMfaSettings
         *        a consumer that will call methods on {@link SoftwareTokenMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareTokenMfaSettings(SoftwareTokenMfaSettingsType)
         */
        default Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return softwareTokenMfaSettings(SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)
                    .build());
        }

        /**
         * <p>
         * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
         * method when multiple methods are available. To activate this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * 
         * @param emailMfaSettings
         *        User preferences for email message MFA. Activates or deactivates email MFA and sets it as the
         *        preferred MFA method when multiple methods are available. To activate this setting, <a href=
         *        "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         *        > advanced security features</a> must be active in your user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMfaSettings(EmailMfaSettingsType emailMfaSettings);

        /**
         * <p>
         * User preferences for email message MFA. Activates or deactivates email MFA and sets it as the preferred MFA
         * method when multiple methods are available. To activate this setting, <a href=
         * "https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
         * > advanced security features</a> must be active in your user pool.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailMfaSettingsType.Builder} avoiding
         * the need to create one manually via {@link EmailMfaSettingsType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailMfaSettingsType.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMfaSettings(EmailMfaSettingsType)}.
         * 
         * @param emailMfaSettings
         *        a consumer that will call methods on {@link EmailMfaSettingsType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMfaSettings(EmailMfaSettingsType)
         */
        default Builder emailMfaSettings(Consumer<EmailMfaSettingsType.Builder> emailMfaSettings) {
            return emailMfaSettings(EmailMfaSettingsType.builder().applyMutation(emailMfaSettings).build());
        }

        /**
         * <p>
         * The username of the user that you want to query or modify. The value of this parameter is typically your
         * user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
         * attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
         * user from a third-party IdP.
         * </p>
         * 
         * @param username
         *        The username of the user that you want to query or modify. The value of this parameter is typically
         *        your user's username, but it can be any of their alias attributes. If <code>username</code> isn't an
         *        alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the
         *        username of a user from a third-party IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The ID of the user pool where you want to set a user's MFA preferences.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the user pool where you want to set a user's MFA preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private SMSMfaSettingsType smsMfaSettings;

        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;

        private EmailMfaSettingsType emailMfaSettings;

        private String username;

        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminSetUserMfaPreferenceRequest model) {
            super(model);
            smsMfaSettings(model.smsMfaSettings);
            softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            emailMfaSettings(model.emailMfaSettings);
            username(model.username);
            userPoolId(model.userPoolId);
        }

        public final SMSMfaSettingsType.Builder getSmsMfaSettings() {
            return smsMfaSettings != null ? smsMfaSettings.toBuilder() : null;
        }

        public final void setSmsMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return softwareTokenMfaSettings != null ? softwareTokenMfaSettings.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final EmailMfaSettingsType.Builder getEmailMfaSettings() {
            return emailMfaSettings != null ? emailMfaSettings.toBuilder() : null;
        }

        public final void setEmailMfaSettings(EmailMfaSettingsType.BuilderImpl emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings != null ? emailMfaSettings.build() : null;
        }

        @Override
        public final Builder emailMfaSettings(EmailMfaSettingsType emailMfaSettings) {
            this.emailMfaSettings = emailMfaSettings;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminSetUserMfaPreferenceRequest build() {
            return new AdminSetUserMfaPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
